//LabPlot : ListPlotDialog.cc

#include <stdlib.h>
#include <stdio.h>
#include <iostream>
#include <math.h>
#include <qlabel.h>
#include <qhbox.h>
#include <qfontdialog.h>
#include <klocale.h>
#include <kmessagebox.h>
#include "ListPlotDialog.h"

ListPlotDialog::ListPlotDialog(MainWin *mw, const char *name)
	: PlotDialog(mw, name)
{
	setCaption(i18n("Plot List"));
	
	QGroupBox *gb = new QGroupBox(1,QGroupBox::Horizontal,i18n("Manipulation"),vbox);
	
	QHBox *hb = new QHBox(gb);
	KPushButton *deleteplot = new KPushButton(i18n("Delete"),hb);
	deleteplot->setMaximumWidth(150);
	QObject::connect(deleteplot,SIGNAL(clicked()),SLOT(deletePlot()));
	KPushButton *cloneplot = new KPushButton(i18n("Clone"),hb);
	QObject::connect(cloneplot,SIGNAL(clicked()),SLOT(clonePlot()));
	cloneplot->setMaximumWidth(150);

	QObject::connect(ok,SIGNAL(clicked()),SLOT(accept()));
	apply->hide();
	save->hide();
	cancel->hide();

	setMinimumWidth(vbox->minimumSizeHint().width());
	setMinimumHeight(gbox->minimumSizeHint().height()+vbox->minimumSizeHint().height());
	resize(minimumSize());
}
