//LabPlot : LegendDialog.h

#ifndef LEGENDDIALOG_H
#define LEGENDDIALOG_H

#include <qfont.h>
#include <qcheckbox.h>
#include "Worksheet.h"
#include "Dialog.h"

class LegendDialog: public Dialog
{
	Q_OBJECT
public:
	LegendDialog(MainWin *mw, const char *name);
	void updateDialog(Worksheet *ws=0);
public slots:
	void selectFont();
	void Enable(bool e=true) { enabledcb->setChecked(e); }
	void setEnabled(bool e=true) { Enable(e); }
	bool Enabled() { return enabledcb->isChecked(); }
	void enableBorder(bool e=true) { bordercb->setChecked(e); }
	bool borderEnabled() { return bordercb->isChecked(); }
	void setPosition(double x, double y) 
		{ xle->setText(QString::number(x)); yle->setText(QString::number(y)); }
	void setXPosition(double x) { xle->setText(QString::number(x)); }
	void setYPosition(double y) { yle->setText(QString::number(y)); }
	Point Position() { return Point(xle->text().toDouble(),yle->text().toDouble()); }
	double XPosition() { return xle->text().toDouble(); }
	double YPosition() { return yle->text().toDouble(); }
	void setFont(QFont f) { lf=f; }
	QFont Font() { return lf; }
	void setTransparent(bool e=true) { transcb->setChecked(e); }
	bool Transparent() { return transcb->isChecked(); }
	void setOrientation(int o=0) { orientcb->setCurrentItem(o); }
	int Orientation() { return orientcb->currentItem(); }
	void setColor(QColor c) { colorcb->setColor(c); }
	void setBackgroundColor(QColor c) { setColor(c); }
	QColor Color() { return colorcb->color(); }	
	QColor BackgroundColor() { return Color(); }	
	int Apply() { return apply_clicked(); }
private:
	QCheckBox *enabledcb, *bordercb, *transcb;
	KLineEdit *xle, *yle, *fontle;
	QFont lf;
	KComboBox *orientcb;
	KColorButton *colorcb;
	Legend *legend;
private slots:
	void ok_clicked() { apply_clicked(); accept(); }
	int apply_clicked();
};

#endif //LEGENDDIALOG_H
