/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */
/*
  satlist.h: Graphical visualization module for Gnome Predict showing
             selected satellites in a list.


  Copyright (C)  2001-2003  Alexandru Csete.

  Authors:  Alexandru Csete <csete@users.sourceforge.net>

  Comments, questions and bugreports should be submitted via
  http://sourceforge.net/projects/groundstation/
  More details can be found at http://groundstation.sourceforge.net/
 
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the
          Free Software Foundation, Inc.,
	  59 Temple Place, Suite 330,
	  Boston, MA  02111-1307
	  USA
*/

#ifndef SATLIST_H
#define SATLIST_H


#define SATLIST_DEF_TIMER       300     /* satlist updates */
#define SATLIST_DEF_HIGH_RED    0xFFFF  /* Satlist highlight color (red) */
#define SATLIST_DEF_HIGH_GREEN  0x0000
#define SATLIST_DEF_HIGH_BLUE   0x0000
#define SATLIST_DEF_NORM_RED    0x0000  /* Satlist normal color (black) */
#define SATLIST_DEF_NORM_GREEN  0x0000
#define SATLIST_DEF_NORM_BLUE   0x0000

/* GConf paths */
#define SATLIST_ROOT_PATH       "/apps/gpredict/satlist"
#define SATLIST_TIMER_PATH      "/apps/gpredict/satlist/timer"
#define SATLIST_HRGB_PATH       "/apps/gpredict/satlist/highcol"  /* path to color for sats within range */
#define SATLIST_NRGB_PATH       "/apps/gpredict/satlist/normcol"  /* path to color for sats out of range */
#define SATLIST_GHRGB_PATH      "/apps/gpredict/satlist/geohcol"  /* path to color for geostationary sats above hor */
#define SATLIST_GNRGB_PATH      "/apps/gpredict/satlist/geoncol"  /* path to color for geostationary sats below hor */
#define SATLIST_DRGB_PATH       "/apps/gpredict/satlist/deccol"   /* path to color for decayed satellites */
#define SATLIST_NARGB_PATH      "/apps/gpredict/satlist/noaoscol" /* path to color for sats with no AOS */



/* Paths to config values */
#define SATLIST_SAT_LIST_PATH "/misc/satellites"

void satlist_open_cb (GtkWidget *, gpointer);
gint satlist_open    (gchar *, gboolean);

#endif
