using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

#region Google Calendar specific imports
using Google.YouTube;
using Google.GData.Tools;
using Google.GData.Client;
using Google.GData.YouTube;

#endregion

namespace Google_YouTubeApplication
{
    public partial class Form1 : Form
    {

        private YouTubeRequest request = null;

        public Form1()
        {
            InitializeComponent();
            GoogleClientLogin loginDialog = new GoogleClientLogin("TemplateApplication", "youremailhere@gmail.com");
            loginDialog.ShowDialog();

            if (loginDialog.Settings != null)
            {
                request = new YouTubeRequest(loginDialog.Settings);
                Feed<Video> f = null;

                try
                {
                    this.Cursor = Cursors.WaitCursor;
                    if (loginDialog.Settings.Credentials != null)
                    {
                        this.Text = "Showing the favorite videos for: " + loginDialog.User;
                        f = request.GetFavoriteFeed(null);
                    }
                    else
                    {
                        this.Text = "Showing the most popular videos";
                        f = request.GetStandardFeed(YouTubeQuery.MostPopular);
                    }
                }
                catch (GDataForbiddenException e)
                {
                    MessageBox.Show("Access forbidden");
                }
                catch (AuthenticationException e)
                {
                    MessageBox.Show("Authentication denied, probably invalid credentials");
                }
                finally
                {
                    this.Cursor = Cursors.Default;
                }

                if (f != null)
                {
                    this.dataGridView1.AutoGenerateColumns = true;
                    this.bindingSource1.DataSource = f.Entries;
                }
            }
        }
    }
}