/*
The DsTool program is the property of:
 
                             Cornell University 
                        Center of Applied Mathematics 
                              Ithaca, NY 14853
                      dstool_bugs@macomb.tn.cornell.edu
 
and may be used, modified and distributed freely, subject to the following
restrictions:
 
       Any product which incorporates source code from the DsTool
       program or utilities, in whole or in part, is distributed
       with a copy of that source code, including this notice. You
       must give the recipients all the rights that you have with
       respect to the use of this software. Modifications of the
       software must carry prominent notices stating who changed
       the files and the date of any change.
 
DsTool is distributed in the hope that it will be useful, but WITHOUT ANY 
WARRANTY; without even the implied warranty of FITNESS FOR A PARTICULAR PURPOSE.
The software is provided as is without any obligation on the part of Cornell 
faculty, staff or students to assist in its use, correction, modification or
enhancement.
*/

/*
 * pm_utils.c
 *
 * Procedures:
 *   pm_type()
 */

#include <stdio.h>
#include <string.h>

#include <pm.h>
#include "pm_hash.h"
#include <constants.h>

/*
 * Execs one routine (if it exists) for each object in the postmaster
 * This routine name is specified by element.
 */
int
pm_exec_all(char *element)
{
  struct pm_list   *current;
  char *pc;
  int i, status = NO_ERROR;
  
  for( i=0; i<HASHSIZE; i++)
    {
      current = hashtab[i];
      while ( current != NULL )
	{    
	  if( (current->category == PM_ELEMENT) && (current->type == FNCT) )
	    {
	      if ( (pc = strchr(current->label,'.')) != (char *) NULL)
		{
		  pc++;
		  if ((strcmp(pc,element) == 0) &&
		      (current->data.fnct_ptr != NULL))
		    (current->data.fnct_ptr)();
		}
	    }
	  current = current->next_in_hash;
	}
    }
  return status;
}

/*
 * returns the type of a postmaster element, and how
 * many (if a list type).
 *
 */
int
pm_type(char *element, int *n, int *len)
{
  struct pm_list *element_ptr;

  element_ptr = pm_hash_lookup(element);
  if (element_ptr == NULL) return 0;
  
  if (n != NULL) *n = element_ptr->list_size;
  if (len != NULL) *len = element_ptr->string_max_len;
  return(element_ptr->type);
}


struct Key
{
  char      *word;
  int       index;
};

struct Key pm_type_key[] = {
  {"INT", INT},
  {"INT_LIST", INT_LIST},
  {"DBL", DBL},
  {"DBL_LIST", DBL_LIST},
  {"STRNG", STRNG},
  {"STRNG_LIST", STRNG_LIST},
  {"ADDRS", ADDRS},
  {"MEMRY", MEMRY},
  {"FNCT", FNCT},
  {"PM_OBJECT", PM_OBJECT},
  {"PM_ELEMENT", PM_ELEMENT},
  {"LIST_SIZE", LIST_SIZE},
  {"STRNG_LENGTH", STRNG_LENGTH}
};

int N_PMTYPES = sizeof(pm_type_key)/sizeof(struct Key);

struct  Key pm_key[] = {
  {"EXEC", EXEC},
  {"PUT", PUT},
  {"GET", GET},
  {"PUT_LIST", PUT_LIST},
  {"GET_LIST", GET_LIST},
  {"CLEAR", CLEAR},
  {"INIT", INIT},
  {"CREATE_OBJ", CREATE_OBJ},
  {"CREATE_ELEM", CREATE_ELEM},
  {"QUERY", QUERY}
};

int N_PMKEY = sizeof(pm_key)/sizeof(struct Key);


int
pm_typekeyword(char *word)
{
  int i;
  
  for (i=0; i< N_PMTYPES; i++)
    if (!strcmp(word,pm_type_key[i].word))
      return(pm_type_key[i].index);
  return(NO_KEY);
}


int
pm_keyword(char *word)
{
  int i;
  
  for (i=0; i< N_PMKEY; i++)
    if (!strcmp(word,pm_key[i].word))
      return(pm_key[i].index);
  return(NO_KEY);
}
