/*
The DsTool program is the property of:
 
                             Cornell University 
                        Center of Applied Mathematics 
                              Ithaca, NY 14853
                      dstool_bugs@macomb.tn.cornell.edu
 
and may be used, modified and distributed freely, subject to the following
restrictions:
 
       Any product which incorporates source code from the DsTool
       program or utilities, in whole or in part, is distributed
       with a copy of that source code, including this notice. You
       must give the recipients all the rights that you have with
       respect to the use of this software. Modifications of the
       software must carry prominent notices stating who changed
       the files and the date of any change.
 
DsTool is distributed in the hope that it will be useful, but WITHOUT ANY 
WARRANTY; without even the implied warranty of FITNESS FOR A PARTICULAR PURPOSE.
The software is provided as is without any obligation on the part of Cornell 
faculty, staff or students to assist in its use, correction, modification or
enhancement.
*/

/*
 * tkPlot.h --
 *
 *	Declarations shared among all the files that implement
 *	plot widgets.
 *
 * Copyright (c) 1991-1994 The Regents of the University of California.
 * Copyright (c) 1994-1995 Sun Microsystems, Inc.
 *
 * See the file "license.terms" for information on usage and redistribution
 * of this file, and for a DISCLAIMER OF ALL WARRANTIES.
 *
 * @(#) tkPlot.h 1.36 95/03/18 16:47:07
 */

#ifndef _TKPLOT
#define _TKPLOT

#ifndef _TK
#include "tk.h"
#endif

#include <limits.h>

/*
 * The record below describes a plot widget.  It is made available
 * to the item procedures so they can access certain shared fields such
 * as the overall displacement and scale factor for the plot.
 */
typedef struct TkPlot {
    Tk_Window tkwin;		/* Window that embodies the plot.  NULL
				 * means that the window has been destroyed
				 * but the data structures haven't yet been
				 * cleaned up.*/
    Display *display;		/* Display containing widget;  needed, among
				 * other things, to release resources after
				 * tkwin has already gone away. */
    Tcl_Interp *interp;		/* Interpreter associated with plot. */
    Tcl_Command widgetCmd;	/* Token for plot's widget command. */
    Tk_Item *firstItemPtr;	/* First in list of all items in plot,
				 * or NULL if plot empty. */
    Tk_Item *lastItemPtr;	/* Last in list of all items in plot,
				 * or NULL if plot empty. */

    /*
     * Information used when displaying widget:
     */

    GC plotGC;
    int borderWidth;		/* Width of 3-D border around window. */
    Tk_3DBorder bgBorder;	/* Used for plot background. */
    int relief;			/* Indicates whether window as a whole is
				 * raised, sunken, or flat. */
    int highlightWidth;		/* Width in pixels of highlight to draw
				 * around widget when it has the focus.
				 * <= 0 means don't draw a highlight. */
    XColor *highlightBgColorPtr;
				/* Color for drawing traversal highlight
				 * area when highlight is off. */
    XColor *highlightColorPtr;	/* Color for drawing traversal highlight. */
    int inset;			/* Total width of all borders, including
				 * traversal highlight and 3-D border.
				 * Indicates how much interior stuff must
				 * be offset from outside edges to leave
				 * room for borders. */
    GC pixmapGC;		/* Used to copy bits from a pixmap to the
				 * screen and also to clear the pixmap. */
    int width, height;		/* Dimensions to request for plot window,
				 * specified in pixels. */
    int redrawX1, redrawY1;	/* Upper left corner of area to redraw,
				 * in pixel coordinates.  Border pixels
				 * are included.  Only valid if
				 * REDRAW_PENDING flag is set. */
    int redrawX2, redrawY2;	/* Lower right corner of area to redraw,
				 * in pixel coordinates.  Border pixels
				 * will *not* be redrawn. */
    int confine;		/* Non-zero means constrain view to keep
				 * as much of plot visible as possible. */
    Pixmap pixmap;              /* pixmap for redrawing */
    int highlightx;		/* x coordinate for highlight */
    int highlighty;		/* y coordinate for hightlight */
    int highlighton;		/* flag to tell if highlight is on or not */

    /*
     * Information used to manage the selection and insertion cursor:
     */

/*    Tk_PlotTextInfo textInfo;*/ /* Contains lots of fields;  see tk.h for
				 * details.  This structure is shared with
				 * the code that implements individual items. */
/*    int insertOnTime;*/		/* Number of milliseconds cursor should spend
				 * in "on" state for each blink. */
/*    int insertOffTime;*/		/* Number of milliseconds cursor should spend
				 * in "off" state for each blink. */
/*    Tk_TimerToken insertBlinkHandler; */
				/* Timer handler used to blink cursor on and
				 * off. */

    /*
     * Transformation applied to plot as a whole:  to compute screen
     * coordinates (X,Y) from plot coordinates (x,y), do the following:
     *
     * X = x - xOrigin;
     * Y = y - yOrigin;
     */

    int xOrigin, yOrigin;	/* Plot coordinates corresponding to
				 * upper-left corner of window, given in
				 * plot pixel units. */
    int drawableXOrigin, drawableYOrigin;
				/* During redisplay, these fields give the
				 * plot coordinates corresponding to
				 * the upper-left corner of the drawable
				 * where items are actually being drawn
				 * (typically a pixmap smaller than the
				 * whole window). */

    /*
     * Information used for event bindings associated with items.
     */

    Tk_BindingTable bindingTable;
				/* Table of all bindings currently defined
				 * for this plot.  NULL means that no
				 * bindings exist, so the table hasn't been
				 * created.  Each "object" used for this
				 * table is either a Tk_Uid for a tag or
				 * the address of an item named by id. */
    Tk_Item *currentItemPtr;	/* The item currently containing the mouse
				 * pointer, or NULL if none. */
    double closeEnough;		/* The mouse is assumed to be inside an
				 * item if it is this close to it. */
    XEvent pickEvent;		/* The event upon which the current choice
				 * of currentItem is based.  Must be saved
				 * so that if the currentItem is deleted,
				 * can pick another. */
    int state;			/* Last known modifier state.  Used to
				 * defer picking a new current object
				 * while buttons are down. */

    /*
     * Information used for managing scrollbars:
     */

    char *xScrollCmd;		/* Command prefix for communicating with
				 * horizontal scrollbar.  NULL means no
				 * horizontal scrollbar.  Malloc'ed*/
    char *yScrollCmd;		/* Command prefix for communicating with
				 * vertical scrollbar.  NULL means no
				 * vertical scrollbar.  Malloc'ed*/
    int scrollX1, scrollY1, scrollX2, scrollY2;
				/* These four coordinates define the region
				 * that is the 100% area for scrolling (i.e.
				 * these numbers determine the size and
				 * location of the sliders on scrollbars).
				 * Units are pixels in plot coords. */
    char *regionString;		/* The option string from which scrollX1
				 * etc. are derived.  Malloc'ed. */
    int xScrollIncrement;	/* If >0, defines a grid for horizontal
				 * scrolling.  This is the size of the "unit",
				 * and the left edge of the screen will always
				 * lie on an even unit boundary. */
    int yScrollIncrement;	/* If >0, defines a grid for horizontal
				 * scrolling.  This is the size of the "unit",
				 * and the left edge of the screen will always
				 * lie on an even unit boundary. */

    /*
     * Information used for scanning:
     */

    int scanX;			/* X-position at which scan started (e.g.
				 * button was pressed here). */
    int scanXOrigin;		/* Value of xOrigin field when scan started. */
    int scanY;			/* Y-position at which scan started (e.g.
				 * button was pressed here). */
    int scanYOrigin;		/* Value of yOrigin field when scan started. */

    /*
     * Information used to speed up searches by remembering the last item
     * created or found with an item id search.
     */

    Tk_Item *hotPtr;		/* Pointer to "hot" item (one that's been
				 * recently used.  NULL means there's no
				 * hot item. */
    Tk_Item *hotPrevPtr;	/* Pointer to predecessor to hotPtr (NULL
				 * means item is first in list).  This is
				 * only a hint and may not really be hotPtr's
				 * predecessor. */

    /*
     * Miscellaneous information:
     */

    Cursor cursor;		/* Current cursor for window, or None. */
    char *takeFocus;		/* Value of -takefocus option;  not used in
				 * the C code, but used by keyboard traversal
				 * scripts.  Malloc'ed, but may be NULL. */
    double pixelsPerMM;		/* Scale factor between MM and pixels;
				 * used when converting coordinates. */
    int flags;			/* Various flags;  see below for
				 * definitions. */
    int nextId;			/* Number to use as id for next item
				 * created in widget. */
    struct TkPostscriptInfo *psInfoPtr;
				/* Pointer to information used for generating
				 * Postscript for the plot.  NULL means
				 * no Postscript is currently being
				 * generated. */
} TkPlot;

/*
 * Flag bits for plotes:
 *
 * REDRAW_PENDING -		1 means a DoWhenIdle handler has already
 *				been created to redraw some or all of the
 *				plot.
 * REDRAW_BORDERS - 		1 means that the borders need to be redrawn
 *				during the next redisplay operation.
 * REPICK_NEEDED -		1 means DisplayPlot should pick a new
 *				current item before redrawing the plot.
 * GOT_FOCUS -			1 means the focus is currently in this
 *				widget, so should draw the insertion cursor
 *				and traversal highlight.
 * CURSOR_ON -			1 means the insertion cursor is in the "on"
 *				phase of its blink cycle.  0 means either
 *				we don't have the focus or the cursor is in
 *				the "off" phase of its cycle.
 * UPDATE_SCROLLBARS -		1 means the scrollbars should get updated
 *				as part of the next display operation.
 * LEFT_GRABBED_ITEM -		1 means that the mouse left the current
 *				item while a grab was in effect, so we
 *				didn't change plotPtr->currentItemPtr.
 * REPICK_IN_PROGRESS -		1 means PickCurrentItem is currently
 *				executing.  If it should be called recursively,
 *				it should simply return immediately.
 */

#define REDRAW_PENDING		1
#define REDRAW_BORDERS		2
#define REPICK_NEEDED		4
#define GOT_FOCUS		8
#define CURSOR_ON		0x10
#define UPDATE_SCROLLBARS	0x20
#define LEFT_GRABBED_ITEM	0x40
#define REPICK_IN_PROGRESS	0x100

/*
 * Plot-related procedures that are shared among Tk modules but not
 * exported to the outside world:
 */

/*
extern int		TkCanvPostscriptCmd _ANSI_ARGS_((TkPlot *plotPtr,
			    Tcl_Interp *interp, int argc, char **argv));
*/

/*
 * Defaults for plots:
 */

#define DEF_PLOT_BG_COLOR		"#d9d9d9"
#define DEF_PLOT_BG_MONO		"White"
#define DEF_PLOT_BORDER_WIDTH		"0"
#define DEF_PLOT_CLOSE_ENOUGH		"1"
#define DEF_PLOT_CONFINE		"1"
#define DEF_PLOT_CURSOR			""
#define DEF_PLOT_HEIGHT			"7c"
#define DEF_PLOT_HIGHLIGHT_BG		"#d9d9d9"
#define DEF_PLOT_HIGHLIGHT		"Black"
#define DEF_PLOT_HIGHLIGHT_WIDTH	"2"
#define DEF_PLOT_INSERT_BG		"Black"
#define DEF_PLOT_INSERT_BD_COLOR	"0"
#define DEF_PLOT_INSERT_BD_MONO		"0"
#define DEF_PLOT_INSERT_OFF_TIME	"300"
#define DEF_PLOT_INSERT_ON_TIME		"600"
#define DEF_PLOT_INSERT_WIDTH		"2"
#define DEF_PLOT_RELIEF			"flat"
#define DEF_PLOT_SCROLL_REGION		""
/*
#define DEF_PLOT_SELECT_COLOR		SELECT_BG
#define DEF_PLOT_SELECT_MONO		BLACK
#define DEF_PLOT_SELECT_BD_COLOR	"1"
#define DEF_PLOT_SELECT_BD_MONO	"0"
#define DEF_PLOT_SELECT_FG_COLOR	BLACK
#define DEF_PLOT_SELECT_FG_MONO	WHITE
*/
#define DEF_PLOT_TAKE_FOCUS		(char *) NULL
#define DEF_PLOT_WIDTH			"7c"
#define DEF_PLOT_X_SCROLL_CMD		""
#define DEF_PLOT_X_SCROLL_INCREMENT	"0"
#define DEF_PLOT_Y_SCROLL_CMD		""
#define DEF_PLOT_Y_SCROLL_INCREMENT	"0"

#define TEST_SYMBOL -1

typedef enum {
  POINT=0,
  CROSS,
  BOX, 
  TRIANGLE,
  CROSSHAIR,
  CIRCLE,
  DISK,
  NUM_SYMBOL_TYPES
} SYMBOL_TYPES;

typedef enum {
  SMALL=0,
  MEDIUM,
  LARGE, 
  NUM_SYMBOL_SIZES
} SYMBOL_SIZES;


/* declarations from tkPlot.c */
int Plot_Init(Tcl_Interp *interp);
void Tk_PlotClear(TkPlot *plotPtr);
void Tk_PlotSavePPM(TkPlot* plotPtr, 
                    char*   file, 
                    int     type,
                    int     width,
                    int     height,
                    int     xoff,
                    int     yoff);
void Tk_PlotQueueRefresh(TkPlot *plotPtr);
void Tk_PlotSymbol(TkPlot *plotPtr, 
                   int     x, 
                   int     y, 
                   int     color, 
                   int     psymbol,
                   unsigned int     psize );
void Tk_PlotLine(TkPlot *plotPtr, 
                   int     x1, 
                   int     y1, 
		   int     x2,
		   int     y2,
                   int     color);
void Tk_PlotRubberBox( TkPlot *plotPtr,
                       int     x, 
                       int     y, 
                       int     w, 
                       int     h ); 
void Tk_PlotHighlight( TkPlot *plotPtr,
			int    x,
			int    y );
XColor *Tk_PlotGetColor(int i);
XColor *Tk_PlotGetRGB(int i);
int Tk_PlotGetNColors(void);

/* Patch for tcl7.4 */
#if (defined(VARARGS))
void Tcl_AppendResult (Tcl_Interp *interp, char*, char*, char*, char* );
#endif


#endif /* _TKPLOT */



