<?xml version="1.0" encoding="ISO-8859-1" ?>
<!DOCTYPE manualpage SYSTEM "./style/manualpage.dtd">
<?xml-stylesheet type="text/xsl" href="./style/manual.fr.xsl"?>
<!-- English Revision: 151405 -->
<!-- French Translation by Vincent Deffontaines, review by alain B -->

<!--
 Copyright 2005 The Apache Software Foundation or its licensors, as
 applicable.

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at

     http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
-->

<manualpage metafile="env.xml.meta">

  <title>Apache et les variables d'environnement</title>

  <summary>
    <p>Le serveur HTTP Apache permet de conserver et d'utiliser 
    certaines informations dans des variables appeles <em>variables 
    d'environnement</em>. Ces informations peuvent servir  contrler 
    divers paramtres tels que la journalisation ou le contrle d'accs. 
    Ces variables sont galement utilises pour communiquer avec d'autres 
    programmes, comme les scripts CGI. Ce document traite des manires 
    de manipuler et de tirer parti de ces variables.</p>

    <p>Bien qu'elles soient appeles <em>variables d'environnement</em>, 
    il ne s'agit pas de variables d'environnement contrles par le 
    systme d'exploitation. Ces variables sont conserves, et manipules 
    suivant des mcanismes internes  Apache. Elles sont transformes 
    en vritables variables d'environnement (au sens systme) seulement 
    quand elles doivent tre passes  des scripts CGI ou  des scripts 
    'Server Side Includes'. Pour manipuler l'environnement du systme 
    d'exploitation sur lequel tourne un serveur Apache, il suffit 
    d'utiliser les mthodes standard fournies par l'interprteur de 
    commandes du systme d'exploitation.</p>
  </summary>

  <section id="setting">
    <title>Dfinir les variables d'environnement</title>
    <related>
      <modulelist>
        <module>mod_env</module>
        <module>mod_rewrite</module>
        <module>mod_setenvif</module>
        <module>mod_unique_id</module>
      </modulelist>
      <directivelist>
        <directive module="mod_setenvif">BrowserMatch</directive>
        <directive module="mod_setenvif">BrowserMatchNoCase</directive>
        <directive module="mod_env">PassEnv</directive>
        <directive module="mod_rewrite">RewriteRule</directive>
        <directive module="mod_env">SetEnv</directive>
        <directive module="mod_setenvif">SetEnvIf</directive>
        <directive module="mod_setenvif">SetEnvIfNoCase</directive>
        <directive module="mod_env">UnsetEnv</directive>
      </directivelist>
    </related>

    <section id="basic-manipulation">
        <title>Manipulations simples de l'environnement</title>

        <p>La mthode la plus simple pour dfinir une variable 
        d'environnement dans Apache est d'utiliser la directive 
        <directive module="mod_env" >SetEnv</directive>. Les variables 
        peuvent galement tre charges depuis l'interprteur de 
        commandes  partir duquel le serveur a t dmarr, au moyen 
        de la directive <directive module="mod_env">PassEnv</directive>.</p>
        
    </section>
    <section id="conditional">
        <title>Paramtrage selon les requtes</title>

        <p>Dans un but de souplesse, les directives que mod_setenvif 
        permet d'utiliser sont ajustables en fonction de certaines 
        caractristiques des requtes parvenant au serveur. Par exemple, 
        il est possible de dfinir une variable seulement si la requte 
        provient d'un certain type de navigateur (User-Agent), ou bien 
        si un champ Referer bien prcis est trouv. Une souplesse encore 
        plus grande est offerte par la directive 
        <directive module="mod_rewrite">RewriteRule</directive> du 
        module mod_rewrite qui accepte le paramtre <code>[E=...]
        </code> pour dfinir des variables d'environnement.</p>

    </section>
    <section id="unique-identifiers">
        <title>Identifiants uniques</title>

        <p>Enfin, la variable d'environnement <code>UNIQUE_ID</code> 
        est cre par mod_unique_id pour chaque requte, de manire  
        tre unique et donc reprsentative de chaque requte.</p>

    </section>
    <section id="standard-cgi">
        <title>Variables CGI standard</title>

        <p>En plus de toutes les variables d'environnement dfinies dans 
        la configuration d'Apache et celles du systme d'exploitation, 
        les <a href="http://cgi-spec.golux.com/">spcifications 
        CGI</a> demandent que certaines variables d'environnement 
        contenant des informations propres  la requte soient toujours 
        passes aux scripts CGI et aux pages SSI.</p>

    </section>
    <section id="caveats">
        <title>Problmes possibles</title>

        <ul>
          <li>Il n'est pas possible de remplacer la valeur des variables 
          CGI standard au moyen des directives qui manipulent les 
          variables d'environnement.</li>

          <li>Dans les cas o les scripts CGI sont lancs au moyen de 
          <a href="suexec.html">suexec</a>, l'environnement est nettoy et 
          les variables sont initialises avec des valeurs <em>sres</em>, 
          dfinies lors de la compilation de <code>suexec.c</code>.</li>

          <li>Pour des raisons d'interoprabilit, les noms des variables 
          d'environnement ne peuvent tre constitus que de lettres, de 
          chiffres et du caractre de soulignement '_'. De plus, le 
          premier caractre du nom ne peut pas tre un chiffre. Les 
          caractres en contradiction avec ces rgles sont remplacs par 
          des caractres de soulignement avant que les variables ne 
          soient transmises aux scripts CGI ou aux pages SSI.</li>
        </ul>
    </section>
  </section>
  <section id="using">
    <title>Utilisation des variables d'environnement</title>

    <related>
      <modulelist>
        <module>mod_access</module>
        <module>mod_cgi</module>
        <module>mod_ext_filter</module>
        <module>mod_headers</module>
        <module>mod_include</module>
        <module>mod_log_config</module>
        <module>mod_rewrite</module>
      </modulelist>
      <directivelist>
        <directive module="mod_access">Allow</directive>
        <directive module="mod_log_config">CustomLog</directive>
        <directive module="mod_access">Deny</directive>
        <directive module="mod_ext_filter">ExtFilterDefine</directive>
        <directive module="mod_headers">Header</directive>
        <directive module="mod_log_config">LogFormat</directive>
        <directive module="mod_rewrite">RewriteCond</directive>
        <directive module="mod_rewrite">RewriteRule</directive>
      </directivelist>
    </related>

    <section id="cgi-scripts">
        <title>Scripts CGI</title>

        <p>Une des principales utilisations des variables d'environnement 
        est l'envoi d'informations aux scripts CGI. Comme prcis ci-
        avant, l'environnement pass aux scripts CGI contient des 
        informations standard au sujet de la requte en plus de toutes 
        les variables initialises au travers de la configuration 
        d'Apache. Pour plus de dtails, consultez le 
        <a href="howto/cgi.html">tutorial CGI</a>.</p>

    </section>
    <section id="ssi-pages">
        <title>Pages SSI</title>

        <p>Les documents analyss par le serveur (documents SSI), grs 
        par le filtre <code>INCLUDES</code> de mod_include, peuvent 
        demander l'affichage de variables d'environnement au moyen de 
        l'lment <code>echo</code>, et peuvent les utiliser pour 
        personnaliser des pages en fonctions de certaines caractristiques 
        de la requte. Apache permet aussi l'utilisation de pages SSI avec 
        les variables d'environnement standard CGI comme discut ci-avant. 
        Consultez le <a href="howto/ssi.html">tutorial SSI</a> 
        pour plus d'informations.</p>
	
    </section>
    <section id="access-control">
        <title>Contrle d'accs</title>

        <p>Les droits d'accs au serveur peuvent tre contrls au moyen 
        de variables d'environnement en utilisant les directives 
        <code>allow from env=</code> et <code>deny from env=</code>. 
        Celles ci, utilises avec <directive module="mod_setenvif"
        >SetEnvIf</directive>, permettent un contrle d'accs au serveur 
        trs souple en fonction de caractristiques propres au client. Par 
        exemple, il est possible d'utiliser ces directives pour refuser 
        l'accs au serveur  certains navigateurs (User-Agent).</p>

    </section>
    <section id="logging">
        <title>Journalisation sous certaines conditions</title>

        <p>Les variables d'environnement peuvent tre enregistres dans 
        le journal des accs ('access log') au moyen de l'option 
        <code>%e</code> de <directive module="mod_log_config"
        >LogFormat</directive>. De plus, la dcision d'enregistrer ou 
        non certaines requtes peut tre prise en fonction des variables 
        d'environnement au moyen de la directive 
        <directive module="mod_log_config">CustomLog</directive>. Cette 
        mthode, utilise avec la directive <directive module="mod_setenvif"
        >SetEnvIf</directive>, permet un contrle trs souple de 
        l'enregistrement des requtes. Par exemple, il est possible de 
        ne pas garder de trace des requtes demandant des noms de fichiers 
        se terminant par <code>gif</code>, ou de n'enregistrer que les 
        requtes des clients situs hors du sous-rseau auquel appartient 
        le serveur.</p>

    </section>
    <section id="response-headers">
        <title>Personnaliser les en-ttes des rponses HTTP</title>

        <p>La directive <directive module="mod_headers">Header</directive> 
        peut tirer parti de l'existence ou non d'une variable 
        d'environnement afin de choisir d'inclure certains en-ttes 
        HTTP dans la rponse retourne au client. Ceci permet, par 
        exemple, d'envoyer un certain en-tte de rponse seulement si un 
        en-tte similaire a t positionn dans la requte manant du 
        client.</p>

    </section>

    <section id="external-filter">
        <title>Activation des filtres externes</title>

        <p>Il est possible d'utiliser une variable d'environnement pour 
        activer les filtres externes (grs par 
        <module>mod_ext_filter</module> au moyen de la directive 
        <directive module="mod_ext_filter">ExtFilterDefine</directive>) 
        grce aux options <code>disableenv=</code> et 
        <code>enableenv=</code>.</p>
    </section>

    <section id="url-rewriting">
        <title>Rcriture d'URL</title>

        <p>La forme <code>%{ENV:...}</code> de <em>TestString</em>, dans 
        la directive <directive module="mod_rewrite"
        >RewriteCond</directive>, permet au moteur de rcriture de 
        mod_rewrite d'utiliser les variables d'environnement pour 
        contrler les rcritures. Notez que toutes les variables 
        internes  mod_rewrite, accessibles sans le prfixe 
        <code>ENV:</code>, ne sont pas des variables d'environnement 
        d'Apache. Elles sont uniquement propres  mod_rewrite et ne 
        peuvent pas tre utilises par d'autres modules.</p>
    </section>
  </section>

  <section id="special">
    <title>Variables d'environnement spciales</title>

        <p>Certains problmes lis  l'interoprabilit ont conduit  la 
        mise en place de mcanismes spciaux, qui modifient le 
        fonctionnement d'Apache selon le type des clients auxquels il 
        rpond. Afin de garantir la plus grande souplesse possible, ces 
        mcanismes sont contrls par des variables d'environnement 
        spciales, telles que <directive module="mod_setenvif"
        >BrowserMatch</directive>, bien qu'on puisse galement utiliser 
        <directive module="mod_env">SetEnv</directive> et 
        <directive module="mod_env">PassEnv</directive> par exemple.</p>
	
    <section id="downgrade">
        <title>downgrade-1.0</title>

        <p>Ceci oblige Apache  traiter la requte comme du HTTP/1.0 mme 
        si elle a t construite sur une norme plus rcente.</p>

    </section>
    <section id="force-no-vary">
        <title>force-no-vary</title>

        <p>Ceci provoque l'effacement de tous les champs <code>Vary</code> 
        de l'en-tte de rponse avant qu'il ne soit envoy au client. 
        Certains clients interprtent mal ce champ (voir 
        <a href="misc/known_client_problems.html">les problmes avec 
        certains clients</a>), et initialiser cette variable peut 
        permettre de rsoudre ce problme. Cette variable requiert 
        galement l'utilisation de <strong>force-response-1.0</strong>.</p>

    </section>
    <section id="force-response">
        <title>force-response-1.0</title>

      <p>Ceci oblige Apache  n'envoyer que des rponses en HTTP/1.0 aux 
      clients ralisant une requte en HTTP/1.0. Cette fonction a t 
      implmente au dpart pour rsoudre un problme avec les serveurs 
      mandataires d'AOL. Certains clients HTTP/1.0 ragissent mal quand 
      ils reoivent une rponse en HTTP/1.1, ce qui peut poser des 
      problmes d'interoprabilit avec eux.</p>

    </section>

    <section id="gzip-only-text-html">
        <title>gzip-only-text/html</title>

        <p>Si cette variable est positionne avec une valeur de "1", le 
        filtre de sortie DEFLATE du module <module>mod_deflate</module> 
        se retrouve dsactiv pour les documents dont le type mime n'est 
        pas <code>text/html</code>.</p>
	
    </section>

    <section id="no-gzip"><title>no-gzip</title>

        <p>Si cette variable est initialise, le filtre <code>DEFLATE</code> 
        du module <module>mod_deflate</module> est totalement dsactiv.</p>

    </section>

    <section id="nokeepalive">
        <title>nokeepalive</title>

        <p>Si cette variable est initialise, les fonctions 
        <directive module="core">KeepAlive</directive> sont dsactives.</p>

    </section>

    <section id="prefer-language"><title>prefer-language</title>

        <p>Cette variable modifie le fonctionnement de 
        <module>mod_negotiation</module>. Si la variable contient un 
        marqueur de langue (comme <code>en</code>, <code>ja</code> ou 
        <code>x-klingon</code>), le module <module>mod_negotiation</module> 
        va tenter de fournir une rponse dans cette langue parmi les 
        variantes possibles. Si aucune de ces variantes n'existe, une 
        <a href="content-negotiation.html">ngociation</a> normale aura 
        lieu.</p>

    </section>

    <section id="redirect-carefully">
        <title>redirect-carefully</title>

        <p>Cette variable rend le serveur plus attentif quand il doit 
        envoyer une redirection au client. Cette variable est 
        habituellement utilise quand un client a un problme connu 
        pour grer les redirections. Cette variable a t implmente 
        pour pallier  un problme du logiciel WebFolders de Microsoft 
        qui ne sait pas grer correctement les redirections vers les 
        rpertoires via les mthodes DAV.</p>

    </section>

   <section id="suppress-error-charset">
       <title>suppress-error-charset</title>

    <p><em>Existe depuis la version 2.0.40</em></p>

    <p>Quand Apache envoie une redirection en rponse  une requte, la 
    rponse contient un message  afficher par le client, au cas o il 
    ne peut suivre automatiquement la redirection. Le fonctionnement 
    par dfaut d'Apache est d'crire ce texte avec le jeu de caractre 
    qu'il utilise, c'est  dire ISO-8859-1.</p>
    <p>Cependant, si la redirection pointe vers une page prsentant un jeu 
    de caractres diffrent, certains navigateurs buggs utilisent le jeu 
    de caractres du texte de la redirection, au lieu de celui de la page 
    qu'ils affichaient. De ce fait, un texte en grec serait mal affich.</p>
    <p>Si cette variable d'environnement est utilise, Apache n'indiquera 
    pas le jeu de caractre dans le texte de la redirection, ce qui permet 
     ces navigateurs d'afficher correctement la page de destination.</p>

   </section>

  </section>

  <section id="examples">
    <title>Exemples</title>

    <section id="misbehaving">
        <title>Modifier le fonctionnement d'un protocole pour les clients 
        qui le grent mal</title>

        <p>Il est conseill de placer les lignes suivantes dans httpd.conf 
        afin de grer des problmes connus de certains clients.</p>
<example><pre>
#
# Les directives ci-aprs modifient le fonctionnement standard de HTTP.
# La premire directive dsactive les fonctions keepalive pour les 
# navigateurs disant s'appeler 'Netscape 2.x'
# Il existe des problmes connus avec ces navigateurs.
# La deuxime directive gre Internet Explorer 4.0b2 de Microsoft qui
# n'implmente pas correctement HTTP/1.1 et qui ne supporte pas les 
# fonctions keepalive quand la rponse du serveur contient des codes 301 
# ou 302 (redirections)
#
BrowserMatch "Mozilla/2" nokeepalive
BrowserMatch "MSIE 4\.0b2;" nokeepalive downgrade-1.0 force-response-1.0

#
# Les directives ci-dessous dsactivent HTTP/1.1 pour les navigateurs qui 
# violent les spcifications HTTP/1.0, en ne sachant pas analyser des 
# rponses basiques en HTTP/1.1.
#
BrowserMatch "RealPlayer 4\.0" force-response-1.0
BrowserMatch "Java/1\.0" force-response-1.0
BrowserMatch "JDK/1\.0" force-response-1.0</pre></example>

    </section>
    <section id="no-img-log">
        <title>Ne pas enregistrer les requtes pour des images dans le 
        journal des accs</title>

        <p>Cet exemple montre comment ne pas enregistrer les requtes  
        destination d'images dans le journal des accs. Il est facile 
        de le modifier, pour limiter l'enregistrement  certains 
        rpertoires, ou pour des requtes venant de machines prcises.</p>
    <example><pre>
SetEnvIf Request_URI \.gif image-request
SetEnvIf Request_URI \.jpg image-request
SetEnvIf Request_URI \.png image-request
CustomLog logs/access_log common env=!image-request</pre></example>

    </section>
    <section id="image-theft">
        <title>Empcher le &nbsp;vol d'images&nbsp;</title>

        <p>Cet exemple montre comment empcher le chargement d'images de 
        votre serveur depuis des pages qui ne sont pas hberges sur 
        celui-ci. Cette configuration n'est pas conseille, mais elle 
        peut tre utile dans certaines circonstances. Il est suppos ici 
        que toutes les images sont stockes dans le rpertoire 
        /web/images.</p>
    <example><pre>
SetEnvIf Referer "^http://www.example.com/" local_referal
# Autorise les navigateurs qui n'envoient pas de champ Referer
SetEnvIf Referer "^$" local_referal
&lt;Directory /web/images&gt;
   Order Deny,Allow
   Deny from all
   Allow from env=local_referal
&lt;/Directory&gt;</pre></example>

        <p>Pour plus d'informations sur cette technique, consultez le 
        tutorial ApacheToday &nbsp;<a 
        href="http://apachetoday.com/news_story.php3?ltsn=2000-06-14-002-01-PS"
        >Keeping Your Images from Adorning Other Sites</a>&nbsp;.</p>
    </section>
  </section>
</manualpage>
