/*
 *  utils.h - Utility functions
 *
 *  nspluginwrapper (C) 2005-2007 Gwenole Beauchesne
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef UTILS_H
#define UTILS_H

// Hashes
extern bool id_init(void) attribute_hidden;
extern void id_kill(void) attribute_hidden;
extern void id_link(int id, void *ptr) attribute_hidden;
extern int id_create(void *ptr) attribute_hidden;
extern bool id_remove(int id) attribute_hidden;
extern void *id_lookup(int id) attribute_hidden;
extern int id_lookup_value(void *ptr) attribute_hidden;

// String expansions
extern const char *string_of_NPError(int error) attribute_hidden;
extern const char *string_of_NPReason(int reason) attribute_hidden;
extern const char *string_of_NPStreamType(int stype) attribute_hidden;

// Misc utility functions
extern void npw_perror(const char *prefix, int error) attribute_hidden;
extern const char *npw_strerror(int error) attribute_hidden;

#endif /* UTILS_H */
