/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts.validator;

import java.util.Locale;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.validator.Arg;
import org.apache.commons.validator.Field;
import org.apache.commons.validator.Validator;
import org.apache.commons.validator.ValidatorAction;
import org.apache.commons.validator.ValidatorResources;
import org.apache.struts.action.ActionError;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;
import org.apache.struts.util.MessageResources;
import org.apache.struts.util.ModuleUtils;
import org.apache.struts.util.RequestUtils;

public class Resources {
    private static String SERVLET_CONTEXT_PARAM;
    public static String SERVLET_CONTEXT_KEY;
    private static String HTTP_SERVLET_REQUEST_PARAM;
    public static String HTTP_SERVLET_REQUEST_KEY;
    private static String ACTION_MESSAGES_PARAM;
    public static String ACTION_ERRORS_KEY;

    public static ValidatorResources getValidatorResources(ServletContext application, HttpServletRequest request) {
        String prefix = ModuleUtils.getInstance().getModuleConfig(request, application).getPrefix();
        return (ValidatorResources)application.getAttribute("org.apache.commons.validator.VALIDATOR_RESOURCES" + prefix);
    }

    public static MessageResources getMessageResources(HttpServletRequest request) {
        return (MessageResources)request.getAttribute("org.apache.struts.action.MESSAGE");
    }

    public static Locale getLocale(HttpServletRequest request) {
        return RequestUtils.getUserLocale(request, null);
    }

    public static String getMessage(MessageResources messages, Locale locale, String key) {
        String message = null;
        if (messages != null) {
            message = messages.getMessage(locale, key);
        }
        return message == null ? "" : message;
    }

    public static String getMessage(HttpServletRequest request, String key) {
        MessageResources messages = Resources.getMessageResources(request);
        return Resources.getMessage(messages, RequestUtils.getUserLocale(request, null), key);
    }

    public static String getMessage(MessageResources messages, Locale locale, ValidatorAction va, Field field) {
        Object[] args = Resources.getArgs(va.getName(), messages, locale, field);
        String msg = field.getMsg(va.getName()) != null ? field.getMsg(va.getName()) : va.getMsg();
        return messages.getMessage(locale, msg, args);
    }

    public static ActionError getActionError(HttpServletRequest request, ValidatorAction va, Field field) {
        Object[] args = Resources.getArgs(va.getName(), Resources.getMessageResources(request), RequestUtils.getUserLocale(request, null), field);
        String msg = field.getMsg(va.getName()) != null ? field.getMsg(va.getName()) : va.getMsg();
        return new ActionError(msg, args);
    }

    public static ActionMessage getActionMessage(HttpServletRequest request, ValidatorAction va, Field field) {
        Object[] args = Resources.getArgs(va.getName(), Resources.getMessageResources(request), RequestUtils.getUserLocale(request, null), field);
        String msg = field.getMsg(va.getName()) != null ? field.getMsg(va.getName()) : va.getMsg();
        return new ActionMessage(msg, args);
    }

    public static String[] getArgs(String actionName, MessageResources messages, Locale locale, Field field) {
        String[] argMessages = new String[4];
        Arg[] args = new Arg[]{field.getArg(actionName, 0), field.getArg(actionName, 1), field.getArg(actionName, 2), field.getArg(actionName, 3)};
        for (int i = 0; i < args.length; ++i) {
            if (args[i] == null) continue;
            argMessages[i] = args[i].isResource() ? Resources.getMessage(messages, locale, args[i].getKey()) : args[i].getKey();
        }
        return argMessages;
    }

    public static Validator initValidator(String key, Object bean, ServletContext application, HttpServletRequest request, ActionMessages errors, int page) {
        ValidatorResources resources = Resources.getValidatorResources(application, request);
        Locale locale = RequestUtils.getUserLocale(request, null);
        Validator validator = new Validator(resources, key);
        validator.setUseContextClassLoader(true);
        validator.setPage(page);
        validator.setParameter(SERVLET_CONTEXT_PARAM, (Object)application);
        validator.setParameter(HTTP_SERVLET_REQUEST_PARAM, (Object)request);
        validator.setParameter("java.util.Locale", (Object)locale);
        validator.setParameter(ACTION_MESSAGES_PARAM, (Object)errors);
        validator.setParameter("java.lang.Object", bean);
        return validator;
    }

    static {
        SERVLET_CONTEXT_KEY = SERVLET_CONTEXT_PARAM = "javax.servlet.ServletContext";
        HTTP_SERVLET_REQUEST_KEY = HTTP_SERVLET_REQUEST_PARAM = "javax.servlet.http.HttpServletRequest";
        ACTION_ERRORS_KEY = ACTION_MESSAGES_PARAM = "org.apache.struts.action.ActionMessages";
    }
}

