/*
 * Decompiled with CFR 0.152.
 */
package spin.demo.complex;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.TreeNode;
import spin.Spin;
import spin.demo.complex.Directory;
import spin.demo.complex.DirectoryService;
import spin.demo.complex.DirectoryServiceException;
import spin.demo.complex.FileService;
import spin.demo.complex.LatencyService;
import spin.demo.complex.UnreliableService;

public class DirectoryServiceGUI
extends JPanel {
    private JTree tree = new JTree();
    private JLabel label = new JLabel("", 4);
    private DirectoryService service;
    private DefaultTreeModel model;

    public DirectoryServiceGUI(DirectoryService service) {
        this.service = service;
        this.setLayout(new BorderLayout());
        this.add((Component)this.label, "North");
        DirectoryServiceNode root = new DirectoryServiceNode(null, service.getRoot());
        this.model = new DefaultTreeModel(root);
        this.tree.addTreeWillExpandListener(new Listener());
        this.tree.setModel(this.model);
        this.add((Component)new JScrollPane(this.tree), "Center");
    }

    public static void main(String[] args) {
        UnreliableService service = new UnreliableService(new LatencyService(new FileService()));
        DirectoryServiceGUI serviceGUI = new DirectoryServiceGUI((DirectoryService)Spin.off(service));
        JFrame frame = new JFrame("Directory Service");
        frame.setDefaultCloseOperation(3);
        frame.getContentPane().add(serviceGUI);
        frame.pack();
        frame.setVisible(true);
    }

    private class Listener
    implements TreeWillExpandListener {
        private Listener() {
        }

        public void treeWillExpand(TreeExpansionEvent event) throws ExpandVetoException {
            DirectoryServiceNode node = (DirectoryServiceNode)event.getPath().getLastPathComponent();
            if (!node.childrenLoaded()) {
                try {
                    DirectoryServiceGUI.this.tree.setCursor(Cursor.getPredefinedCursor(3));
                    DirectoryServiceGUI.this.tree.setEnabled(false);
                    node.loadChildren();
                    DirectoryServiceGUI.this.model.nodeStructureChanged(node);
                }
                catch (DirectoryServiceException ex) {
                    JOptionPane.showMessageDialog(DirectoryServiceGUI.this, ex.getMessage());
                    throw new ExpandVetoException(event);
                }
                finally {
                    DirectoryServiceGUI.this.tree.setEnabled(true);
                    DirectoryServiceGUI.this.tree.setCursor(Cursor.getDefaultCursor());
                }
            }
        }

        public void treeWillCollapse(TreeExpansionEvent event) throws ExpandVetoException {
        }
    }

    private class DirectoryServiceNode
    implements TreeNode {
        private Directory directory;
        private DirectoryServiceNode parent;
        private DirectoryServiceNode[] children = null;

        public DirectoryServiceNode(DirectoryServiceNode parent, Directory directory) {
            this.parent = parent;
            this.directory = directory;
        }

        public String toString() {
            return this.directory.getName();
        }

        public boolean childrenLoaded() {
            return this.children != null;
        }

        public void loadChildren() throws DirectoryServiceException {
            try {
                Directory[] directories = DirectoryServiceGUI.this.service.getChildren(this.directory);
                this.children = new DirectoryServiceNode[directories.length];
                for (int d = 0; d < directories.length; ++d) {
                    this.children[d] = new DirectoryServiceNode(this, directories[d]);
                }
            }
            catch (DirectoryServiceException ex) {
                this.children = null;
                throw ex;
            }
        }

        public TreeNode getChildAt(int childIndex) {
            return this.children[childIndex];
        }

        public int getChildCount() {
            if (this.children == null) {
                return 0;
            }
            return this.children.length;
        }

        public TreeNode getParent() {
            return this.parent;
        }

        public int getIndex(TreeNode node) {
            return Arrays.binarySearch(this.children, node);
        }

        public boolean getAllowsChildren() {
            return !this.isLeaf();
        }

        public boolean isLeaf() {
            return this.directory.isLeaf();
        }

        public Enumeration children() {
            return Collections.enumeration(Arrays.asList(this.children));
        }
    }
}

