/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */

package org.jboss.test.remoting.transport.multiplex.config;

import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;

import org.jboss.jrunit.extensions.ServerTestCase;
import org.jboss.logging.Logger;
import org.jboss.remoting.transport.Connector;


/**
 * 
 * @author <a href="mailto:ron.sigal@jboss.com">Ron Sigal</a>
 * @version $Revision$
 * <p>
 * Copyright (c) May 19, 2006
 * </p>
 */
public class ClientConfigurationTestServer extends ServerTestCase
{
   public static final String syncHost      = "localhost";
   public static final int    syncPort      = 3265;
   public static final String connectorURI  = "multiplex://localhost:3266";
   public static final String connectorHost = "localhost";
   public static final int    connectorPort = 3266;
   
   protected static Logger log = Logger.getLogger(ClientConfigurationTestServer.class);
   
   public void setUp()
   {
      new Thread()
      {
         public void run()
         {
            try
            {
               // Create synchronizing socket.
               ServerSocket ss = new ServerSocket();
               ss.bind(new InetSocketAddress(syncHost, syncPort));
               Socket syncSocket = ss.accept();
               InputStream is = syncSocket.getInputStream();
               OutputStream os = syncSocket.getOutputStream();
               log.info("got sync socket");
               
               // Create Connector.
               Connector connector = new Connector(connectorURI);
               connector.create();
               connector.start();
               os.write(7);
               log.info("started Connector on: " + connector.getInvokerLocator());
               
               // Wait for end of test signal.
               is.read();
               connector.stop();
            }
            catch (Exception e)
            {
               log.error(e);
               e.printStackTrace();
            }
         }
      }.start();
   }
   
   
   public static void main(String[] args)
   {
      ClientConfigurationTestServer tester = new ClientConfigurationTestServer();
      tester.setUp();
   }
}
