/* Ruari Diff, a program to compare a Packages file and /var/lib/dpkg/status */
/* Copyright (C) 1997, James Troup <jjtroup@comp.brad.ac.uk> */

/* This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <stdio.h>
#include "version.h"
#include "common.h"
#include "error.h"
#include "getopt.h"
#include "init.h"

int 
parse_opt (int argc, char **argv)
{
  int c;

  while (1)
    {
      int option_index = 0;
      static struct option long_options[] =
      {
	{"help", no_argument, NULL, 'h'},
	{"version", no_argument, NULL, 'V'},
	{"warn-duplicates", no_argument, &warn_duplicates, 1},
	{"warn-missing-lines", no_argument, &warn_missing_lines, 1},
	{"warn-older", no_argument, &warn_older, 1},
	{0, 0, 0, 0}
      };

      c = getopt_long (argc, argv, "hV",
		       long_options, &option_index);
      if (c == EOF)
	break;

      switch (c)
	{
	case 'h':
	  usage (0);
	  break;

	case 'V':
	  fprintf (stderr, "Ruari Diff version %0.2f\n", VERSION);
	  exit (0);
	  break;

	case '?':
	  break;

	default:
	  break;
	}
    }

  if (optind == (argc - 2)) 
    return optind;

  if (optind < (argc -2))
    error (WARNING, "%s: please specify only a Packages file and status",program_name); 
  else
    error (WARNING, "%s: please specify a Packages file and status",program_name); 
  usage (1);

  return (0); /* Dummy: should never get here */

}

void
usage (int status)
{
  fprintf (status ? stderr : stdout, "Usage: %s [-hV] PACKAGES_FILE STATUS_FILE\n\
-h --help                give this help\n\
-V --version             display version number\n\
   --warn-missing-lines  warn about missing lines, e.g. Section: or Priority:\n\
   --warn-duplicates     warn about duplicate packages in the Packages file\n\
   --warn-older          warn about packages older on the ftp site than installed\n", program_name);

  exit (status);

}
