""" Demonstration of the Pmw NoteBook megawidget.
"""

# Import Pmw from the sibling directory.
import sys
sys.path[:0] = ['../../..']

import Tkinter
import Pmw

class Demo:
    def __init__(self, parent):

	# Create a frame to put the notebook in.
        frame = Tkinter.Frame(parent, background = 'grey90')
        frame.pack(fill = 'both', expand = 1)

        # Create and pack the NoteBook.
	nb = Pmw.NoteBookR(frame)
	nb.add('hello', label='Hello')
	nb.add('world', label='World')
	nb.add('bye', label='Bye now!')

	# Fill in some pages
	self.makeHelloPage( nb.page('hello').interior() )
	self.makeWorldPage( nb.page('world').interior() )
	self.makeByePage( nb.page('bye').interior() )

	#p = nb.page('hello')
	
	nb.pack()
	#nb._makereqsize()
	nb.update_idletasks()
	

    def makeHelloPage(self,page):
	l = Tkinter.Label(page,text='Hello,...',fg='red')
	l.pack() 

    def makeWorldPage(self,page):
	l = Tkinter.Canvas(page,background='black')
	w = l.winfo_reqwidth()
	h = l.winfo_reqheight()
	l.create_oval(10,10,w-10,h-10,fill='blue')
	l.create_text(
	    w/2,h/2,text='World!', fill='white',
	    font='-*-fixed-bold-*-*-*-24-*-*-*-*-*-iso8859-*'
	    )
	l.pack() 

    def makeByePage(self,page):
	l = Tkinter.Text(page,width=40,height=10)
	l.tag_configure('foo',justify='center')
	l.insert('end','Goodbye, cruel world!')
	l.tag_add('foo','0.0','end')
	l.pack() 

######################################################################

# Create demo in root window for testing.
if __name__ == '__main__':
    root = Tkinter.Tk()
    Pmw.initialise(root, fontScheme = 'pmw1')
    root.title('Pmw NoteBook demonstration') 

    widget = Demo(root)
    exitButton = Tkinter.Button(root, text = 'Exit', command = root.destroy)
    exitButton.pack()
    root.mainloop()


