.\"
.\" Copyright (c) 1983 Regents of the University of California.
.\" All rights reserved.
.\"
.\" Redistribution and use in source and binary forms, with or without
.\" modification, are permitted provided that the following conditions
.\" are met:
.\" 1. Redistributions of source code must retain the above copyright
.\"    notice, this list of conditions and the following disclaimer.
.\" 2. Redistributions in binary form must reproduce the above copyright
.\"    notice, this list of conditions and the following disclaimer in the
.\"    documentation and/or other materials provided with the distribution.
.\" 3. All advertising materials mentioning features or use of this software
.\"    must display the following acknowledgement:
.\"	This product includes software developed by the University of
.\"	California, Berkeley and its contributors.
.\" 4. Neither the name of the University nor the names of its contributors
.\"    may be used to endorse or promote products derived from this software
.\"    without specific prior written permission.
.\"
.\" THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
.\" ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
.\" IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
.\" ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
.\" FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
.\" DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
.\" OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
.\" HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
.\" LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
.\" OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
.\" SUCH DAMAGE.
.\"
.\"	$Id: rdist.man,v 6.33 1994/04/26 16:55:07 mcooper Exp $
.\"	@(#)rdist.1	6.6 (Berkeley) 5/13/86
.\"
.TH RDIST 1 "March 14, 1994"
.UC 6
.SH NAME
rdist \- remote file distribution client program
.SH SYNOPSIS
.B rdist
[ 
.B \-DFn
]
[ 
.B \-A 
.I num
] 
[ 
.B \-a 
.I num 
]
[ 
.B \-d 
.I var=value 
] 
[ 
.B \-l
.I <local logopts>
] 
[ 
.B \-L
.I <remote logopts>
] 
[ 
.B \-f 
.I distfile 
] 
[ 
.B \-M 
.I maxproc
] 
[ 
.B \-m 
.I host 
]
[ 
.B \-o
.I distopts
]
[ 
.B \-t 
.I timeout 
] 
[
.B \-p
.I <rdistd-path>
]
[
.B \-P
.I <rsh-path>
]
[ 
.I name ...
]
.PP
.B rdist
.B \-DFn
.B -c 
.I name ... 
.I [login@]host[:dest]
.PP
.B rdist
.B \-Server
.PP
.B rdist
.B \-V
.SH DESCRIPTION
.I Rdist
is a program to maintain identical copies of files over multiple hosts. 
It preserves the owner, group, mode, and mtime of files if possible and
can update programs that are executing.
.I Rdist
reads commands from
.I distfile
to direct the updating of files and/or directories.
If
.I distfile
is `\-', the standard input is used.
If no
.B \-f
option is present, the program looks first for `distfile',
then `Distfile' to use as the input.
If no names are specified on the command line,
.I rdist
will update all of the files and directories listed in
.IR distfile .
Otherwise, the argument is taken to be the name of a file to be updated
or the label of a command to execute. If label and file names conflict,
it is assumed to be a label.
These may be used together to update specific files
using specific commands.
.PP
The
.B \-c
option forces
.I rdist
to interpret the remaining arguments as a small
.IR distfile .
The equivalent distfile is as follows.
.nf

.ti +.5i
( \fIname\fP ... ) -> [\fIlogin\fP@]\fIhost\fP
.ti +1i
install	[\fIdest\fP] ;

.fi
.PP
The
.B \-Server
option is recognized to provide partial backward compatible support
for older versions of
.I rdist
which used this option to put
.I rdist
into server mode.
If
.I rdist
is started with the 
.B \-Server
command line option, it will attempt to exec (run) the old version of
.I rdist.
This option will only work if 
.I rdist
was compiled with the location of the old rdist
(usually either
.I /usr/bin/oldrdist
or
.I /usr/old/rdist)
and that program is available at run time.
.PP
.I Rdist
can use either the
.I rcmd(3)
function call or the 
.I rsh(1c),
remote shell, command to access each target host.
The method used is selected at compile-time.
If the
.I rsh(1c)
method is used and
the target host is the string
.B localhost
and 
the remote user name is the same as the local user name,
.I rdist
will run the command
.nf
.sp
.RS
.B "/bin/sh -c rdistd -S"
.RE
.sp
.fi
Otherwise
.I rdist
run will run the command
.nf
.sp
.RS
\fBrsh \fIhost\fB -l \fIremuser \fBrdistd -S\fR
.RE
.sp
.fi
where 
.I host
is the name of the target host,
.I remuser
is the name of the user to make the connection as and,
.I rdistd
is the rdist server command on the target host as shown below.
.PP
If the
.I rcmd(3) 
method is used, then
.I rdist
makes the connection to the target host itself and runs
the 
.I rdistd
server program as shown below.
The default, and preferred method, is to use
.I rsh(1c)
to make the connection to target hosts.  This allows 
.I rdist
to be run without being setuid to ``root''.
.PP
On each target host
.I Rdist
will attempt to run the command
.nf
.sp
.RS
.I "rdistd -S"
.RE
.sp
.fi
or
.nf
.sp
.RS
.I "<rdistd path> -S"
.RE
.sp
.fi
if the
.I \-p
option was specified.
If no
.B \-p 
option is included,
or the
.I <rdistd path>
is a simple filename,
.I rdistd
or
.I <rdistd path>
must be somewhere in the 
.B $PATH
of the user running
.B rdist
on the remote (target) host.
.SH OPTIONS
.TP
.B "\-A \fInum\fR"
Set the minimum number of free files (inodes) on a filesystem that must exist
for 
.I rdist
to update or install a file.
.TP
.B "\-a \fInum\fR"
Set the minimum amount of free space (in bytes) on a filesystem that must exist
for 
.I rdist
to update or install a file.
.TP
.B \-D
Enable copious debugging messages.
.TP
.B "\-d \fIvar=value\fR"
Define
.I var
to have
.IR value .
This
option is used to define or override variable definitions in the
.IR distfile .
.I Value
can be the empty string, one name, or a list of names surrounded by
parentheses and separated by tabs and/or spaces.
.TP
.B \-F
Do not fork any child 
.I rdist
processes.
All clients are updated sequentially.
.TP
.B "\-f \fIdistfile\fR"
Set the name of the distfile to use to be
.I distfile .
If 
.I distfile
is specified as
``\-'' (dash)
then read from standard input (stdin).
.TP
.B "\-l \fIlogopts\fR"
Set local logging options.
See the section 
.B "MESSAGE LOGGING"
for details on the syntax for
.I logopts.
.TP
.B "\-L \fIlogopts\fR"
Set remote logging options.
.I logopts
is the same as for local logging
except the values are passed to the remote
server (\fIrdistd\fR).
See the section 
.B "MESSAGE LOGGING"
for details on the syntax for
.I logopts.
.TP
.B "\-M \fInum\fR"
Set the maximum number of simultaneously
running child
.I rdist
processes to
.I num.
The default is 4.
.TP
.B "\-m \fImachine\fR"
Limit which machines are to be updated. Multiple
.B \-m
arguments can be given to limit updates to a subset of the hosts listed in the
.IR distfile .
.TP
.B \-n
Print the commands without executing them. This option is
useful for debugging
.IR distfile .
.TP
.B "\-o\fIdistopts\fR"
Specify the dist options to enable.
.I distopts
is a comma separated list of options which are listed below.
The valid values for
.I distopts
are:
.RS
.IP \fBverify\fR
Verify that the files are up to date on all the hosts. Any files
that are out of date will be displayed but no files will be changed
nor any mail sent.
.IP \fBwhole\fR
Whole mode. The whole file name is appended to the destination directory
name.  Normally, only the last component of a name is used when renaming files.
This will preserve the directory structure of the files being
copied instead of flattening the directory structure. For example,
rdisting a list of files such as
.I /path/dir1/f1 
and
.I /path/dir2/f2 
to 
.I /tmp/dir 
would create
files 
.I /tmp/dir/path/dir1/f1 
and 
.I /tmp/dir/path/dir2/f2 
instead of 
.I /tmp/dir/dir1/f1 
and 
.I /tmp/dir/dir2/f2.
.IP \fBnoexec\fR
Automatically exclude executable files that are in 
.I a.out(5)
format from being checked or updated. 
.IP \fByounger\fR
Younger mode. Files are normally updated if their
.I mtime
and
.I size
(see
.IR stat (2))
disagree. This
option causes
.I rdist
not to update files that are younger than the master copy.
This can be used
to prevent newer copies on other hosts from being replaced.
A warning message is printed for files which are newer than the master copy.
.IP \fBcompare\fR
Binary comparison. Perform a binary comparison and update files if they differ
rather than comparing dates and sizes.
.IP \fBfollow\fR
Follow symbolic links. Copy the file that the link points to rather than the
link itself.
.IP \fBignlnks\fR
Ignore unresolved links.
.I Rdist
will normally try to maintain the link structure of files being transferred
and warn the user if all the links cannot be found.
.IP \fBchknfs\fR
Do not check or update files on target host that
reside on NFS filesystems.
.IP \fBchkreadonly\fR
Enable check on target host
to see if a file resides on a read-only filesystem.
If a file does, then no checking or updating of the file is attempted.
.IP \fBchksym\fR
If the target on the remote host is a symbolic link, but is not on the
master host, the remote target will be left a symbolic link.
This behavior is generally considered a bug in the original version of
.I rdist,
but is present to allow compatibility with older versions.
.IP \fBquiet\fR
Quiet mode. Files that are being modified are normally
printed on standard output. This
option suppresses this.
.IP \fBremove\fR
Remove extraneous files. If a directory is being updated, any files that exist
on the remote host that do not exist in the master directory are removed.
This is useful for maintaining truly identical copies of directories.
.IP \fBnochkowner\fR
Do not check user ownership of files that already exist.
The file ownership is only set when the file is updated.
.IP \fBnochkgroup\fR
Do not check group ownership of files that already exist.
The file ownership is only set when the file is updated.
.IP \fBnochkmode\fR
Do not check file and directory permission modes.
The permission mode is only set when the file is updated.
.IP \fBnodescend\fR
Do not descend into a directory.
Normally 
.I rdist
will recursively check directories.
If this option is enabled, then any files listed in the
file list in the distfile that are directories are not recursively scanned.
Only the existence, ownership, and mode of the directory are checked.
.IP \fBnumchkgroup\fR
Use the numeric group id (gid) to check group ownership instead of
the group name.
.IP \fBnumchkowner\fR
Use the numeric user id (uid) to check user ownership instead of
the user name.
.IP \fBsavetargets\fR
Save files that are updated instead of removing them.
Any target file that is updates is first rename from
.B file
to
.B file.OLD.
.RE
.TP
.B "\-p \fI<rdistd-path>\fR"
Set the path where the rdistd server is searched for on the target host.
.TP
.B "\-P \fI<rsh-path>\fR"
Set the path to the 
.I rsh(1c)
command.
The
.I rsh-path
may be a colon seperated list of possible pathnames.
In this case, the first component of the path to exist is used.
i.e. 
.B "/usr/bin/rsh:/usr/bin/remsh",
.B /usr/bsd/rsh.
.TP
.B "\-t \fItimeout\fR"
Set the timeout period (in seconds) for waiting for responses from the remote 
.I rdist
server.
The default is 900 seconds.
.TP
.B \-V
Print version information and exit.
.SH "MESSAGE LOGGING"
.I Rdist
uses a collection of predefined message
.B facilities
that each contain a list of message
.B types
specifying which types of messages to send to that 
.I facility.
The local client (\fIrdist\fR) and the remote server (\fIrdistd\fR) each
maintain
their own copy of what types of messages to log to what facilities.
.LP
The 
.B \-l
.I logopts
option to
.I rdist
tells
.I rdist
what logging options to use locally.
The 
.B \-L
.I logopts
option to
.I rdist
tells
.I rdist
what logging options to pass to the remote
.I rdistd
server.
.LP
The form of
.I logopts
should be of form
.sp
.RS
\fIfacility\fB=\fItypes\fB:\fIfacility\fB=\fItypes...
.RE
.sp
The valid facility names are:
.RS
.IP \fBstdout\fR
Messages to standard output.
.IP \fBfile\fR
Log to a file.  To specify the file name, use the format 
``\fBfile=\fIfilename\fB=\fItypes\fR''.
e.g.
.B "``file=/tmp/rdist.log=all,debug''.
.IP \fBsyslog\fR
Use the 
.I syslogd(8)
facility.
.IP \fBnotify\fR
Use the internal
.I rdist
.B notify
facility.
This facility is used in conjunction with the
.B notify
keyword in a 
.I distfile
to specify what messages are mailed to the
.B notify
address.
.RE
.LP
.I types
should be a comma separated list of message types.  Each message type 
specified enables that message level.  This is unlike the
.I syslog(3)
system facility which uses an ascending order scheme.
The following
are the valid 
.I types:
.RS
.IP \fBchange\fR
Things that change.
This includes files that are installed or updated in some way.
.IP \fBinfo\fR
General information.
.IP \fBnotice\fR
General info about things that change.
This includes things like making directories which are needed in order
to install a specific target, but which are not explicitly specified in
the
.I distfile.
.IP \fBnerror\fR
Normal errors that are not fatal.
.IP \fBferror\fR
Fatal errors.
.IP \fBwarning\fR
Warnings about errors which are not as serious as
.B nerror
type messages.
.IP \fBdebug\fR
Debugging information.
.IP \fBall\fR
All but debug messages.
.RE
.LP
Here is a sample command line option:
.nf
.sp
.RS
\-l stdout=all:syslog=change,notice:file=/tmp/rdist.log=all
.RE
.sp
.fi
This entry will set local message logging to have all but debug
messages sent to standard output, change and notice messages will
be sent to 
.I syslog(3),
and all messages will be written to the file
.B /tmp/rdist.log.
.SH DISTFILES
.PP
The
.I distfile
contains a sequence of entries that specify the files
to be copied, the destination hosts, and what operations to perform
to do the updating. Each entry has one of the following formats.
.nf

.RS
<variable name> `=' <name list>
[ label: ] <source list> `\->' <destination list> <command list>
[ label: ] <source list> `::' <time_stamp file> <command list>
.RE

.fi
The first format is used for defining variables.
The second format is used for distributing files to other hosts.
The third format is used for making lists of files that have been changed
since some given date.
The \fIsource list\fP specifies a
list of files and/or directories on the local host which are to be used
as the master copy for distribution.
The \fIdestination list\fP is the list of hosts to which these files are to be
copied.  Each file in the source list is added to a list of changes
if the file is out of date on the host which is being updated (second format) or
the file is newer than the time stamp file (third format).
.PP
Labels are optional. They are used to identify a command for partial updates.
.PP
Newlines, tabs, and blanks are only used as separators and are
otherwise ignored. Comments begin with `#' and end with a newline.
.PP
Variables to be expanded begin with `$' followed by one character or
a name enclosed in curly braces (see the examples at the end).
.PP
The source and destination lists have the following format:
.nf

.ti +.5i
<name>
or
.ti +.5i
`(' <zero or more names separated by white-space> `)'

.fi
These simple lists can be modified by using one level of set addition,
subtraction, or intersection like this:
.nf

.ti +.5i
list '-' list
or
.ti +.5i
list '+' list
or
.ti +.5i
list '&' list

.fi
If additional modifications are needed (e.g., ``all servers and client
machines except for the OSF/1 machines'') then the list will have
to be explicitly constructed in steps using "temporary" variables.
.PP
The shell meta-characters `[', `]', `{', `}', `*', and `?'
are recognized and expanded (on the local host only) in the same way as
.IR csh (1).
They can be escaped with a backslash.
The `~' character is also expanded in the same way as
.IR csh
but is expanded separately on the local and destination hosts.
When the
.B \-o\fIwhole\fR
option is used with a file name that begins with `~', everything except the
home directory is appended to the destination name.
File names which do not begin with `/' or `~' use the destination user's
home directory as the root directory for the rest of the file name.
.PP
The command list consists of zero or more commands of the following
format.
.nf

.RS
.ta \w'cmdspecial    'u +\w'name list    'u
`install'	<options>	opt_dest_name `;'
`notify'	<name list>	`;'
`except'	<name list>	`;'
`except_pat'	<pattern list>	`;'
`special'	<name list>	string `;'
`cmdspecial'	<name list>	string `;'
.RE

.fi
.PP
The
.I install
command is used to copy out of date files and/or directories.
Each source file is copied to each host in the destination list.
Directories are recursively copied in the same way.
.I Opt_dest_name
is an optional parameter to rename files.
If no
.I install
command appears in the command list or
the destination name is not specified,
the source file name is used.
Directories in the path name will be created if they
do not exist on the remote host.
The
\fB\-o \fIdistopts\fR
option
as specified above under
.B OPTIONS,
has the same semantics as
on the command line except they only apply to the files
in the source list.
The login name used on the destination host is the same as the local host
unless the destination name is of the format ``login@host".
.PP
The
.I notify
command is used to mail the list of files updated (and any errors
that may have occurred) to the listed names.
If no `@' appears in the name, the destination host is appended to
the name
(e.g., name1@host, name2@host, ...).
.PP
The
.I except
command is used to update all of the files in the source list
.B except
for the files listed in \fIname list\fP.
This is usually used to copy everything in a directory except certain files.
.PP
The
.I except_pat
command is like the
.I except
command except that \fIpattern list\fP is a list of regular expressions
(see
.IR ed (1)
for details).
If one of the patterns matches some string within a file name, that file will
be ignored.
Note that since `\e' is a quote character, it must be doubled to become
part of the regular expression.  Variables are expanded in \fIpattern list\fP
but not shell file pattern matching characters.  To include a `$', it
must be escaped with `\e'.
.PP
The
.I special
command is used to specify
.IR sh (1)
commands that are to be executed on the
remote host after the file in \fIname list\fP is updated or installed.
If the \fIname list\fP is omitted then the shell commands will be executed
for every file updated or installed.  
.I String
starts and ends with `"' and can cross multiple lines in
.I distfile.
Multiple commands to the shell should be separated by `;'.
Commands are executed in the user's home directory on the host
being updated.
The
.I special
command can be used to rebuild private databases, etc.
after a program has been updated.
The following environment variables are set for each 
.I special
command:
.IP \fBFILE\fR
The full pathname of the local file that was just updated.
.IP \fBREMFILE\fR
The full pathname of the remote file that was just updated.
.IP \fBBASEFILE\fR
The basename of the remote file that was just updated.
.PP
The
.I cmdspecial
command is similar to the
.I special
command, except it is executed only when the entire command is completed
instead of after each file is updated.
The list of files is placed in the environment variable 
.B $FILES.
Each file name in
.B $FILES
is separated by a `:' (colon).
.PP
If a hostname ends in a ``+'' (plus sign), then the plus
is stripped off and NFS checks are disabled.
This is equivalent to disabling the
.B \-o\fIchknfs\fR
option just for this one host.
.PP
The following is a small example.
.nf

.RS
HOSTS = ( matisse root@arpa)

FILES = ( /bin /lib /usr/bin /usr/games
	/usr/include/{*.h,{stand,sys,vax*,pascal,machine}/*.h}
	/usr/lib /usr/man/man? /usr/ucb /usr/local/rdist )

EXLIB = ( Mail.rc aliases aliases.dir aliases.pag crontab dshrc
	sendmail.cf sendmail.fc sendmail.hf sendmail.st uucp vfont )

${FILES} -> ${HOSTS}
	install -oremove,chknfs ;
	except /usr/lib/${EXLIB} ;
	except /usr/games/lib ;
	special /usr/lib/sendmail "/usr/lib/sendmail -bz" ;

srcs:
/usr/src/bin -> arpa
	except_pat ( \e\e.o\e$ /SCCS\e$ ) ;

IMAGEN = (ips dviimp catdvi)

imagen:
/usr/local/${IMAGEN} -> arpa
	install /usr/local/lib ;
	notify ralph ;

${FILES} :: stamp.cory
	notify root@cory ;
.RE

.fi
.SH ENVIRONMENT
.IP TMPDIR
Name of temporary directory to use.  Default is 
.B /tmp.
.SH FILES
.nf
.ta \w'/tmp/rdist*    'u
distfile	\- input command file
$TMPDIR/rdist*	\- temporary file for update lists
.fi
.SH "SEE ALSO"
.B sh(1),
.B csh(1),
.B stat(2),
.B rsh(1c),
.B rcmd(3)
.SH DIAGNOSTICS
.SH NOTES
.LP
If the basename of a file  (the last component in the pathname)
is ".", then 
.B rdist 
assumes the remote (destination) name is a directory.
i.e.
.B /tmp/.
means that
.B /tmp
should be a directory on the remote host.
.LP
The following options are still recognized for backwards compatibility:
.sp
.RS
\-v \-N \-O \-q \-b \-r \-R \-s \-w \-y \-h \-i \-x
.RE
.sp
.SH BUGS
Source files must reside on the local host where rdist is executed.
.PP
Variable expansion only works for name lists; there should be a general macro
facility.
.PP
.I Rdist
aborts on files which have a negative mtime (before Jan 1, 1970).
.PP
If a hardlinked file is listed more than once in the same target,
then 
.I rdist 
will report missing links.
Only one instance of a link should be listed in each target.
