<?xml version="1.0" encoding="ISO-8859-1"?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" lang="fr" xml:lang="fr"><head>
<meta content="text/html; charset=ISO-8859-1" http-equiv="Content-Type" />
<!--
        XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
              This file is generated from xml source: DO NOT EDIT
        XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
      -->
<title>Sections de configuration - Serveur Apache HTTP Version 2.4</title>
<link href="./style/css/manual.css" rel="stylesheet" media="all" type="text/css" title="Main stylesheet" />
<link href="./style/css/manual-loose-100pc.css" rel="alternate stylesheet" media="all" type="text/css" title="No Sidebar - Default font size" />
<link href="./style/css/manual-print.css" rel="stylesheet" media="print" type="text/css" /><link rel="stylesheet" type="text/css" href="./style/css/prettify.css" />
<script src="./style/scripts/prettify.min.js" type="text/javascript">
</script>

<link href="./images/favicon.ico" rel="shortcut icon" /></head>
<body id="manual-page"><div id="page-header">
<p class="menu"><a href="./mod/">Modules</a> | <a href="./mod/directives.html">Directives</a> | <a href="http://wiki.apache.org/httpd/FAQ">FAQ</a> | <a href="./glossary.html">Glossaire</a> | <a href="./sitemap.html">Plan du site</a></p>
<p class="apache">Serveur Apache HTTP Version 2.4</p>
<img alt="" src="./images/feather.png" /></div>
<div class="up"><a href="./"><img title="&lt;-" alt="&lt;-" src="./images/left.gif" /></a></div>
<div id="path">
<a href="http://www.apache.org/">Apache</a> &gt; <a href="http://httpd.apache.org/">Serveur HTTP</a> &gt; <a href="http://httpd.apache.org/docs/">Documentation</a> &gt; <a href="./">Version 2.4</a></div><div id="page-content"><div id="preamble"><h1>Sections de configuration</h1>
<div class="toplang">
<p><span>Langues Disponibles: </span><a href="./en/sections.html" hreflang="en" rel="alternate" title="English">&nbsp;en&nbsp;</a> |
<a href="./fr/sections.html" title="Franais">&nbsp;fr&nbsp;</a> |
<a href="./ja/sections.html" hreflang="ja" rel="alternate" title="Japanese">&nbsp;ja&nbsp;</a> |
<a href="./ko/sections.html" hreflang="ko" rel="alternate" title="Korean">&nbsp;ko&nbsp;</a> |
<a href="./tr/sections.html" hreflang="tr" rel="alternate" title="Trke">&nbsp;tr&nbsp;</a></p>
</div>
 <p>Les directives des <a href="configuring.html">fichiers de configuration</a> peuvent s'appliquer
au serveur dans son ensemble, ou seulement  des rpertoires, fichiers, htes,
ou URLs particuliers.  Ce document dcrit comment utiliser les conteneurs de
sections de configuration ou les fichiers <code>.htaccess</code> pour
modifier la porte des directives de configuration.</p>
</div>
<div id="quickview"><ul id="toc"><li><img alt="" src="./images/down.gif" /> <a href="#types">Types de conteneurs de sections de
configuration</a></li>
<li><img alt="" src="./images/down.gif" /> <a href="#file-and-web">Systme de fichiers,
arborescence du site web et expressions boolennes</a></li>
<li><img alt="" src="./images/down.gif" /> <a href="#virtualhost">Htes virtuels</a></li>
<li><img alt="" src="./images/down.gif" /> <a href="#proxy">Mandataire</a></li>
<li><img alt="" src="./images/down.gif" /> <a href="#whatwhere">Quelles sont les directives autorises ?</a></li>
<li><img alt="" src="./images/down.gif" /> <a href="#merging">Comment les sections sont combines entre elles</a></li>
</ul><h3>Voir aussi</h3><ul class="seealso"><li><a href="#comments_section">Commentaires</a></li></ul></div>
<div class="top"><a href="#page-header"><img alt="top" src="./images/up.gif" /></a></div>
<div class="section">
<h2><a name="types" id="types">Types de conteneurs de sections de
configuration</a></h2>

<table class="related"><tr><th>Modules Apparents</th><th>Directives Apparentes</th></tr><tr><td><ul><li><code class="module"><a href="./mod/core.html">core</a></code></li><li><code class="module"><a href="./mod/mod_version.html">mod_version</a></code></li><li><code class="module"><a href="./mod/mod_proxy.html">mod_proxy</a></code></li></ul></td><td><ul><li><code class="directive"><a href="./mod/core.html#directory">&lt;Directory&gt;</a></code></li><li><code class="directive"><a href="./mod/core.html#directorymatch">&lt;DirectoryMatch&gt;</a></code></li><li><code class="directive"><a href="./mod/core.html#files">&lt;Files&gt;</a></code></li><li><code class="directive"><a href="./mod/core.html#filesmatch">&lt;FilesMatch&gt;</a></code></li><li><code class="directive"><a href="./mod/core.html#if">&lt;If&gt;</a></code></li><li><code class="directive"><a href="./mod/core.html#ifdefine">&lt;IfDefine&gt;</a></code></li><li><code class="directive"><a href="./mod/core.html#ifmodule">&lt;IfModule&gt;</a></code></li><li><code class="directive"><a href="./mod/mod_version.html#ifversion">&lt;IfVersion&gt;</a></code></li><li><code class="directive"><a href="./mod/core.html#location">&lt;Location&gt;</a></code></li><li><code class="directive"><a href="./mod/core.html#locationmatch">&lt;LocationMatch&gt;</a></code></li><li><code class="directive"><a href="./mod/mod_proxy.html#proxy">&lt;Proxy&gt;</a></code></li><li><code class="directive"><a href="./mod/mod_proxy.html#proxymatch">&lt;ProxyMatch&gt;</a></code></li><li><code class="directive"><a href="./mod/core.html#virtualhost">&lt;VirtualHost&gt;</a></code></li></ul></td></tr></table>

<p>Il existe deux grands types de conteneurs.  La plupart des conteneurs sont
valus pour chaque requte.  Les directives qu'ils contiennent s'appliquent
seulement aux requtes qui sont concernes par le conteneur.  En revanche,
les conteneurs
<code class="directive"><a href="./mod/core.html#ifdefine">&lt;IfDefine&gt;</a></code>, <code class="directive"><a href="./mod/core.html#ifmodule">&lt;IfModule&gt;</a></code>, et
<code class="directive"><a href="./mod/mod_version.html#ifversion">&lt;IfVersion&gt;</a></code> sont
valus seulement au dmarrage et au redmarrage du serveur.
Si leurs conditions sont vrifies au dmarrage, les directives qu'ils contiennent
s'appliqueront  toutes les requtes.  Si leurs conditions ne sont pas vrifies, les
directives qu'ils contiennent seront ignores.</p>

<p>Le conteneur <code class="directive"><a href="./mod/core.html#ifdefine">&lt;IfDefine&gt;</a></code>
contient des directives qui ne seront appliques que si un paramtre
appropri a t dfini dans la ligne de commande de <code class="program"><a href="./programs/httpd.html">httpd</a></code>.
Par exemple,
avec la configuration suivante, toutes les requtes seront rediriges vers
un autre site si le serveur est dmarr en utilisant la ligne de commande :
<code>httpd -DClosedForNow</code>:</p>

<pre class="prettyprint lang-config">&lt;IfDefine ClosedForNow&gt;
    Redirect "/" "http://otherserver.example.com/"
&lt;/IfDefine&gt;</pre>


<p>Le conteneur <code class="directive"><a href="./mod/core.html#ifmodule">&lt;IfModule&gt;</a></code>
est similaire; les directives qu'il contient ne s'appliqueront que si
un module particulier est disponible au niveau du serveur.
Le module doit tre soit compil statiquement dans le serveur, soit
dynamiquement et dans ce cas, la ligne <code class="directive"><a href="./mod/mod_so.html#loadmodule">LoadModule</a></code> correspondante doit apparatre
plus haut dans le fichier de configuration.  Ce conteneur ne doit tre
utilis que dans le cas o votre fichier de configuration doit fonctionner
indpendamment de la prsence ou de l'absence de certains modules.
Il ne doit pas contenir de directives que vous souhaitez voir s'appliquer
systmatiquement, car vous pouvez perdre ainsi de prcieux messages d'erreur
 propos de modules manquants.</p>

<p>Dans l'exemple suivant, la directive <code class="directive"><a href="./mod/mod_mime_magic.html#mimemagicfile">MimeMagicFile</a></code> ne s'appliquera que si le
module <code class="module"><a href="./mod/mod_mime_magic.html">mod_mime_magic</a></code> est disponible.</p>

<pre class="prettyprint lang-config">&lt;IfModule mod_mime_magic.c&gt;
    MimeMagicFile "conf/magic"
&lt;/IfModule&gt;</pre>


<p>Le conteneur
<code class="directive"><a href="./mod/mod_version.html#ifversion">&lt;IfVersion&gt;</a></code>
est similaire aux conteneurs <code class="directive"><a href="./mod/core.html#ifdefine">&lt;IfDefine&gt;</a></code> et <code class="directive"><a href="./mod/core.html#ifmodule">&lt;IfModule&gt;</a></code>; les directives qu'il contient ne
s'appliqueront que si une version particulire du serveur s'excute.  Ce
conteneur a t conu pour une utilisation dans les suites de tests
et les grands rseaux qui doivent prendre en compte diffrentes versions
et configurations de httpd.</p>

<pre class="prettyprint lang-config">&lt;IfVersion &gt;= 2.4&gt;
    # les directives situes ici ne s'appliquent que si la version <br />
    # est suprieure ou gale  2.4.0.
&lt;/IfVersion&gt;</pre>


<p><code class="directive"><a href="./mod/core.html#ifdefine">&lt;IfDefine&gt;</a></code>,
<code class="directive"><a href="./mod/core.html#ifmodule">&lt;IfModule&gt;</a></code>, et
<code class="directive"><a href="./mod/mod_version.html#ifversion">&lt;IfVersion&gt;</a></code>
peuvent inverser leur test conditionnel en le faisant prcder d'un "!".
De plus, ces sections peuvent tre imbriques afin de dfinir des restrictions
plus complexes.</p>
</div><div class="top"><a href="#page-header"><img alt="top" src="./images/up.gif" /></a></div>
<div class="section">
<h2><a name="file-and-web" id="file-and-web">Systme de fichiers,
arborescence du site web et expressions boolennes</a></h2>

<p>Les conteneurs de sections de configuration les plus couramment utiliss
sont ceux qui modifient la configuration de points particuliers du systme de
fichiers ou de l'arborescence du site web.  Tout d'abord, il est important de
comprendre la diffrence entre les deux.  Le systme de fichiers est une vue
de vos disques tels qu'ils sont perus par votre systme d'exploitation.
Par exemple, avec une installation par dfaut,
Apache httpd est situ dans <code>/usr/local/apache2</code> pour le systme de
fichiers UNIX, ou <code>"c:/Program Files/Apache Group/Apache2"</code> pour
le systme de fichiers Windows.  (Notez que des slashes directs doivent
toujours tre utiliss comme sparateur de chemin
dans les fichiers de configuration d'Apache httpd, mme sous
Windows.)  Quant 
l'arborescence du site web, il s'agit d'une vue de votre site
tel que prsent par le
serveur web et perue par le client.  Ainsi le chemin <code>/dir/</code> dans
l'arborescence du site web correspond au chemin
<code>/usr/local/apache2/htdocs/dir/</code> dans le systme de fichiers pour
une installation d'Apache httpd par dfaut sous UNIX.
En outre, l'arborescence du site web n'a pas besoin de correspondre en permanence au
systme de fichiers, car les pages web peuvent tre gnres dynamiquement
 partir de bases de donnes ou d'autres emplacements.</p>

<h3><a name="filesystem" id="filesystem">Conteneurs de systme de fichiers</a></h3>

<p>Les conteneurs <code class="directive"><a href="./mod/core.html#directory">&lt;Directory&gt;</a></code>
et <code class="directive"><a href="./mod/core.html#files">&lt;Files&gt;</a></code>,
ainsi que leurs quivalents acceptant les
<a class="glossarylink" href="./glossary.html#regex" title="voir glossaire">expressions rationnelles</a>,
appliquent des directives  certaines parties du systme de fichiers.
Les directives contenues dans une section <code class="directive"><a href="./mod/core.html#directory">&lt;Directory&gt;</a></code> s'appliquent au rpertoire
prcis, ainsi qu' tous ses sous-rpertoires et aux fichiers que ces
derniers contiennent.
Le mme effet peut tre obtenu en utilisant les <a href="howto/htaccess.html">fichiers .htaccess</a>.  Par exemple, avec la
configuration suivante, l'indexation sera active pour le rpertoire
<code>/var/web/dir1</code> et tous ses sous-rpertoires.</p>

<pre class="prettyprint lang-config">&lt;Directory "/var/web/dir1"&gt;
    Options +Indexes
&lt;/Directory&gt;</pre>


<p>Les directives contenues dans une section <code class="directive"><a href="./mod/core.html#files">&lt;Files&gt;</a></code> s'appliquent  tout fichier
avec le nom spcifi, quel que soit le rpertoire dans lequel il se trouve.
Ainsi par exemple, les directives de configuration suivantes, si elles sont
places dans la section principale du fichier de configuration, vont interdire
l'accs  tout fichier nomm <code>private.html</code> quel que soit
l'endroit o il se trouve.</p>

<pre class="prettyprint lang-config">&lt;Files "private.html"&gt;
    Require all denied
&lt;/Files&gt;</pre>


<p>Pour faire rfrence  des fichiers qui se trouvent en des points
particuliers du systme de fichiers, les sections
<code class="directive"><a href="./mod/core.html#files">&lt;Files&gt;</a></code> et
<code class="directive"><a href="./mod/core.html#directory">&lt;Directory&gt;</a></code>
peuvent tre combines.  Par exemple, la configuration suivante va interdire
l'accs  <code>/var/web/dir1/private.html</code>,
<code>/var/web/dir1/subdir2/private.html</code>,
<code>/var/web/dir1/subdir3/private.html</code>, ainsi que toute instance de
<code>private.html</code> qui se trouve dans l'arborescence
<code>/var/web/dir1/</code>.</p>

<pre class="prettyprint lang-config">&lt;Directory "/var/web/dir1"&gt;
    &lt;Files "private.html"&gt;
        Require all denied
    &lt;/Files&gt;
&lt;/Directory&gt;</pre>



<h3><a name="webspace" id="webspace">Conteneurs de l'arborescence du site web</a></h3>

<p>le conteneur <code class="directive"><a href="./mod/core.html#location">&lt;Location&gt;</a></code>
et son quivalent acceptant les
<a class="glossarylink" href="./glossary.html#regex" title="voir glossaire">expressions rationnelles</a>, modifient quant  eux la
configuration de parties de l'arborescence du site web.  Par exemple, la
configuration suivante interdit l'accs  toute URL dont la partie chemin
commence par /private.
En particulier, l'interdiction s'appliquera aux requtes pour :
<code>http://yoursite.example.com/private</code>,
<code>http://yoursite.example.com/private123</code>, et
<code>http://yoursite.example.com/private/dir/file.html</code> ainsi qu'
toute requte commenant par la chane de caractres <code>/private</code>.</p>

<pre class="prettyprint lang-config">&lt;LocationMatch "^/private"&gt;
    Require all denied
&lt;/LocationMatch&gt;</pre>


<p>Le conteneur <code class="directive"><a href="./mod/core.html#location">&lt;Location&gt;</a></code>
n'a pas besoin de faire rfrence  un lment du systme de fichiers.
Par exemple, l'exemple suivant montre comment faire rfrence  une URL
particulire vers un gestionnaire interne du serveur HTTP Apache fourni par le module
<code class="module"><a href="./mod/mod_status.html">mod_status</a></code>.
Il n'est pas ncessaire de trouver un fichier nomm <code>server-status</code>
dans le systme de fichiers.</p>

<pre class="prettyprint lang-config">&lt;Location "/server-status"&gt;
    SetHandler server-status
&lt;/Location&gt;</pre>



<h3><a name="overlapping-webspace" id="overlapping-webspace">Espace web imbriqu</a></h3>
<p>Pour contrler deux URLs imbriques, on doit tenir compte de l'ordre
dans lequel certaines sections ou directives sont values. Pour
<code class="directive"><a href="./mod/core.html#location">&lt;Location&gt;</a></code>, on doit
avoir :</p>
<pre class="prettyprint lang-config">&lt;Location "/foo"&gt;
&lt;/Location&gt;
&lt;Location "/foo/bar"&gt;
&lt;/Location&gt;</pre>

<p>Les directives <code class="directive"><a href="./mod/mod_alias.html#alias">&lt;Alias&gt;</a></code>, quant  elles, sont values vice-versa :</p>
<pre class="prettyprint lang-config">Alias "/foo/bar" "/srv/www/uncommon/bar"
Alias "/foo" "/srv/www/common/foo"</pre>

<p>Ceci est aussi vrai pour les directives <code class="directive"><a href="./mod/mod_proxy.html#proxypass">ProxyPass</a></code> :</p>
<pre class="prettyprint lang-config">ProxyPass "/special-area" "http://special.example.com" smax=5 max=10
ProxyPass "/" "balancer://mycluster/" stickysession=JSESSIONID|jsessionid nofailover=On</pre>




<h3><a name="wildcards" id="wildcards">Caractres de remplacement
et expressions rationnelles</a></h3>

<p>Les conteneurs
<code class="directive"><a href="./mod/core.html#directory">&lt;Directory&gt;</a></code>,
<code class="directive"><a href="./mod/core.html#files">&lt;Files&gt;</a></code>, et
<code class="directive"><a href="./mod/core.html#location">&lt;Location&gt;</a></code>
peuvent utiliser des caractres de remplacement de style shell comme dans
la fonction <code>fnmatch</code> de la bibliothque C standard.
Le caractre "*"
correspond  toute squence de caractres, "?"  un caractre seul,
et "[<em>seq</em>]"  tout caractre contenu dans <em>seq</em>.
Le caractre "/"
ne peut pas faire l'objet d'un remplacement;
il doit tre spcifi explicitement.</p>

<p>Si une dfinition des critres de correspondance
encore plus souple est ncessaire, chaque conteneur
possde son quivalent acceptant les expressions rationnelles : <code class="directive"><a href="./mod/core.html#directorymatch">&lt;DirectoryMatch&gt;</a></code>, <code class="directive"><a href="./mod/core.html#filesmatch">&lt;FilesMatch&gt;</a></code>, et <code class="directive"><a href="./mod/core.html#locationmatch">&lt;LocationMatch&gt;</a></code> acceptent les
<a class="glossarylink" href="./glossary.html#regex" title="voir glossaire">expressions rationnelles</a> compatibles Perl
pour dfinir les critres de correspondance.  Mais voyez plus loin la section
 propos de la combinaison des sections de configuration
pour comprendre comment l'utilisation de
conteneurs avec des expressions rationnelles va modifier la manire
dont les directives sont appliques.</p>

<p>Un conteneur qui modifie la configuration de tous les
rpertoires utilisateurs  l'aide de caractres de remplacement
mais sans utiliser
les expressions rationnelles pourrait ressembler  ceci :</p>

<pre class="prettyprint lang-config">&lt;Directory "/home/*/public_html"&gt;
    Options Indexes
&lt;/Directory&gt;</pre>


<p>Avec les conteneurs utilisant les expressions rationnelles,
on peut interdire l'accs  de nombreux types de fichiers d'images
simultanment :</p>
<pre class="prettyprint lang-config">+&lt;FilesMatch "\.(?i:gif|jpe?g|png)$"&gt;
    Require all denied
&lt;/FilesMatch&gt;</pre>


<p>Les expressions rationnelles contenant des <strong>groupes nomms et
des rfrences arrires</strong> sont ajoutes  l'environnement avec
leur nom en majuscules. Ceci permet de rfrencer des lments de
chemins de fichiers et d'URLs depuis une <a href="expr.html">expression</a> et au sein de modules comme
<code class="module"><a href="./mod/mod_rewrite.html">mod_rewrite</a></code>.</p>

<pre class="prettyprint lang-config">&lt;DirectoryMatch "^/var/www/combined/(?&lt;SITENAME&gt;[^/]+)"&gt;
    require ldap-group "cn=%{env:MATCH_SITENAME},ou=combined,o=Example"
&lt;/DirectoryMatch&gt;</pre>




<h3><a name="expressions" id="expressions">Expressions boolennes</a></h3>
<p>La directive <code class="directive"><a href="./mod/core.html#if">&lt;If&gt;</a></code>
permet de modifier la configuration en fonction d'une condition qui peut
tre dfinie sous la forme d'une expression boolenne. Dans l'exemple
suivant, l'accs est interdit si l'en-tte HTTP Referer ne commence pas
par "http://www.example.com/".</p>
<pre class="prettyprint lang-config">&lt;If "!(%{HTTP_REFERER} -strmatch 'http://www.example.com/*')"&gt;
    Require all denied
&lt;/If&gt;</pre>




<h3><a name="whichwhen" id="whichwhen">Que faut-il utiliser et quand ?</a></h3>

<p>Choisir entre des conteneurs de systme de fichiers et des conteneurs
d'arborescence du site web est vraiment trs simple.
Pour appliquer des directives  des objets qui rsident dans le systme de
fichiers, utilisez toujours un conteneur <code class="directive"><a href="./mod/core.html#directory">&lt;Directory&gt;</a></code> ou <code class="directive"><a href="./mod/core.html#files">&lt;Files&gt;</a></code>.  Pour appliquer des directives  des objets
qui ne rsident pas dans le systme de fichiers (comme une page web gnre
par une base de donnes), utilisez un conteneur <code class="directive"><a href="./mod/core.html#location">&lt;Location&gt;</a></code>.</p>

<p>Il ne faut jamais utiliser un conteneur <code class="directive"><a href="./mod/core.html#location">&lt;Location&gt;</a></code> pour restreindre l'accs  des
objets du systme de fichiers, car plusieurs localisations de
l'arborescence du site web (URLs) peuvent correspondre  la mme localisation
du systme de fichier, ce qui peut permettre de contourner vos restrictions.
Par exemple, imaginez la configuration suivante :</p>

<pre class="prettyprint lang-config">&lt;Location "/dir/"&gt;
    Require all denied
&lt;/Location&gt;</pre>


<p>Elle fonctionne correctement si la requte appelle
<code>http://yoursite.example.com/dir/</code>.  Mais que va-t-il se passer si
votre systme de fichiers est insensible  la casse ?
Votre restriction va pouvoir tre tout simplement contourne en envoyant une
requte sur
<code>http://yoursite.example.com/DIR/</code>.  Le conteneur <code class="directive"><a href="./mod/core.html#directory">&lt;Directory&gt;</a></code>, quant  lui, s'appliquera
 tout contenu servi  partir de cette localisation,
sans tenir compte de la manire dont il est appel.
(Les liens du systme de fichiers constituent une exception.
Le mme rpertoire peut tre plac dans plusieurs parties du systme de
fichiers en utilisant des liens symboliques.  Le conteneur
<code class="directive"><a href="./mod/core.html#directory">&lt;Directory&gt;</a></code> va suivre le
lien symbolique sans modifier le nom du chemin.  Par consquent, pour plus de
scurit, les liens symboliques doivent tre dsactivs  l'aide de la
directive
<code class="directive"><a href="./mod/core.html#options">Options</a></code> approprie.)</p>

<p>Si vous pensez que vous n'tes pas concern par ce problme
parceque vous utilisez un systme de fichiers sensible  la casse,
gardez  l'esprit qu'il y a de nombreuses autres manires pour faire
correspondre plusieurs localisations de l'arborescence du site web  la mme
localisation du systme de fichiers.  C'est pourquoi vous devez autant que
possible toujours utiliser les conteneurs de systme de fichiers.
Il y a cependant une exception  cette rgle.  Placer des restrictions de
configuration dans un conteneur <code>&lt;Location
"/"&gt;</code> est tout  fait sans rique car ce conteneur va s'appliquer 
toutes les requtes sans tenir compte de l'URL spcifique.</p>


<h3><a name="nesting" id="nesting">Imbrication des sections</a></h3>

<p>Certains types de sections peuvent tre imbriqus : d'une part, on
peut utiliser les sections <code class="directive"><a href="./mod/core.html#files">&lt;Files&gt;</a></code>  l'intrieur des sections <code class="directive"><a href="./mod/core.html#directory">&lt;Directory&gt;</a></code>, d'autre part, on
peut utiliser les
directives <code class="directive"><a href="./mod/core.html#if">&lt;If&gt;</a></code> 
l'intrieur des sections <code class="directive"><a href="./mod/core.html#directory">&lt;Directory&gt;</a></code>, <code class="directive"><a href="./mod/core.html#location">&lt;Location&gt;</a></code> et <code class="directive"><a href="./mod/core.html#files">&lt;Files&gt;</a></code>. Les valeurs des expressions
rationnelles correspondant aux sections nommes se comportent de manire
identique.</p>

<p>Les sections imbriques sont fusionnes aprs les sections
non-imbriques de mme type.</p>



</div><div class="top"><a href="#page-header"><img alt="top" src="./images/up.gif" /></a></div>
<div class="section">
<h2><a name="virtualhost" id="virtualhost">Htes virtuels</a></h2>

<p>Le conteneur <code class="directive"><a href="./mod/core.html#virtualhost">&lt;VirtualHost&gt;</a></code>
contient des directives qui s'appliquent  des htes spcifiques.
Ceci s'avre utile pour servir des htes multiples  partir de la mme machine,
chacun d'entre eux possdant une configuration diffrente.  Pour de plus amples
informations,
voir la <a href="vhosts/">Documentation sur les htes virtuels</a>.</p>
</div><div class="top"><a href="#page-header"><img alt="top" src="./images/up.gif" /></a></div>
<div class="section">
<h2><a name="proxy" id="proxy">Mandataire</a></h2>

<p>Les conteneurs
<code class="directive"><a href="./mod/mod_proxy.html#proxy">&lt;Proxy&gt;</a></code>
et <code class="directive"><a href="./mod/mod_proxy.html#proxymatch">&lt;ProxyMatch&gt;</a></code>
appliquent les directives de configuration qu'ils contiennent uniquement aux
sites qui correspondent  l'URL spcifie et auxquels on a
accd via le serveur mandataire du module <code class="module"><a href="./mod/mod_proxy.html">mod_proxy</a></code>.
Par exemple, la configuration suivante n'autorisera qu'un sous-ensemble de
clients  accder au site <code>www.example.com</code> en passant par le serveur
mandataire :</p>

<pre class="prettyprint lang-config">&lt;Proxy "http://www.example.com/*"&gt;
    Require host yournetwork.example.com
&lt;/Proxy&gt;</pre>

</div><div class="top"><a href="#page-header"><img alt="top" src="./images/up.gif" /></a></div>
<div class="section">
<h2><a name="whatwhere" id="whatwhere">Quelles sont les directives autorises ?</a></h2>

<p>Pour dterminer quelles sont les directives autorises pour tel type de
section de configuration, vrifiez le <a href="mod/directive-dict.html#Context">Contexte</a> de la directive.
Tout ce qui est autoris dans les sections
<code class="directive"><a href="./mod/core.html#directory">&lt;Directory&gt;</a></code>
l'est aussi d'un point de vue syntaxique dans les sections
<code class="directive"><a href="./mod/core.html#directorymatch">&lt;DirectoryMatch&gt;</a></code>,
<code class="directive"><a href="./mod/core.html#files">&lt;Files&gt;</a></code>,
<code class="directive"><a href="./mod/core.html#filesmatch">&lt;FilesMatch&gt;</a></code>,
<code class="directive"><a href="./mod/core.html#location">&lt;Location&gt;</a></code>,
<code class="directive"><a href="./mod/core.html#locationmatch">&lt;LocationMatch&gt;</a></code>,
<code class="directive"><a href="./mod/mod_proxy.html#proxy">&lt;Proxy&gt;</a></code>,
et <code class="directive"><a href="./mod/mod_proxy.html#proxymatch">&lt;ProxyMatch&gt;</a></code>.
Il y a cependant quelques exceptions :</p>

<ul>
<li>La directive <code class="directive"><a href="./mod/core.html#allowoverride">AllowOverride</a></code>
ne fonctionne que dans les sections
<code class="directive"><a href="./mod/core.html#directory">&lt;Directory&gt;</a></code>.</li>

<li>Les <code class="directive"><a href="./mod/core.html#options">Options</a></code> <code>FollowSymLinks</code> et
<code>SymLinksIfOwnerMatch</code>  ne fonctionnent que dans les sections
<code class="directive"><a href="./mod/core.html#directory">&lt;Directory&gt;</a></code> ou les fichiers
<code>.htaccess</code>.</li>

<li>La directive <code class="directive"><a href="./mod/core.html#options">Options</a></code> ne peut pas tre
utilise dans les sections
<code class="directive"><a href="./mod/core.html#files">&lt;Files&gt;</a></code>
et <code class="directive"><a href="./mod/core.html#filesmatch">&lt;FilesMatch&gt;</a></code>.</li>
</ul>
</div><div class="top"><a href="#page-header"><img alt="top" src="./images/up.gif" /></a></div>
<div class="section">
<h2><a name="merging" id="merging">Comment les sections sont combines entre elles</a></h2>

<p>Les sections de configuration sont appliques dans un ordre trs particulier.
Il est important de savoir comment cet ordre est dfini car il peut avoir
des effets importants sur la manire dont les directives de configuration
sont interprtes.</p>

    <p>L'ordre dans lequel les sections sont combines est :</p>

    <ol>
      <li> Les sections <code class="directive"><a href="./mod/core.html#directory">&lt;Directory&gt;</a></code> ( l'exception des
      expressions rationnelles)
      et les fichiers <code>.htaccess</code> sont appliqus simultanment (avec
      la possibilit pour <code>.htaccess</code>, s'il y est autoris, de
      prvaloir sur
      <code class="directive"><a href="./mod/core.html#directory">&lt;Directory&gt;</a></code>)</li>

      <li>Les sections
      <code class="directive"><a href="./mod/core.html#directorymatch">&lt;DirectoryMatch&gt;</a></code>
      (et <code>&lt;Directory "~"&gt;</code>)</li>

      <li>Les sections <code class="directive"><a href="./mod/core.html#files">&lt;Files&gt;</a></code> et <code class="directive"><a href="./mod/core.html#filesmatch">&lt;FilesMatch&gt;</a></code> sont appliques
      simultanment</li>

      <li>Les sections
      <code class="directive"><a href="./mod/core.html#location">&lt;Location&gt;</a></code>
      et <code class="directive"><a href="./mod/core.html#locationmatch">&lt;LocationMatch&gt;</a></code> sont appliques
      simultanment</li>

      <li>Les directives <code class="directive"><a href="./mod/core.html#if">&lt;If&gt;</a></code>
      </li>
    </ol>

    <p>Mises  part les sections <code class="directive"><a href="./mod/core.html#directory">&lt;Directory&gt;</a></code>, chaque groupe est trait selon
    l'ordre dans lequel il apparat dans les fichiers de configuration.
    Les sections <code class="directive"><a href="./mod/core.html#directory">&lt;Directory&gt;</a></code> (groupe 1 ci-dessus)
    sont traites dans l'ordre du rpertoire le plus court vers le plus long.
    Par exemple, <code>&lt;Directory "/var/web/dir"&gt;</code> sera
    trait avant <code>&lt;Directory
    "/var/web/dir/subdir"&gt;</code>.  Si plusieurs sections <code class="directive"><a href="./mod/core.html#directory">&lt;Directory&gt;</a></code> s'appliquent au mme
    rpertoire, elles sont traites selon l'ordre dans lequel elles
    apparaissent dans le fichier de configuration.
    Les sections de configuration incluses via la directive <code class="directive"><a href="./mod/core.html#include">Include</a></code> sont traites comme si elles se
    trouvaient rellement dans le fichier qui les inclut  la position de la
    directive
    <code class="directive"><a href="./mod/core.html#include">Include</a></code>.</p>

    <p>Les sections situes  l'intrieur de sections <code class="directive"><a href="./mod/core.html#virtualhost">&lt;VirtualHost&gt;</a></code>
    sont appliques <em>aprs</em> les sections correspondantes situes en
    dehors de la dfinition de l'hte virtuel, ce qui permet  l'hte virtuel
    de prvaloir sur la configuration du serveur principal.</p>

    <p>Quand la requte est servie par le module <code class="module"><a href="./mod/mod_proxy.html">mod_proxy</a></code>,
    le conteneur <code class="directive"><a href="./mod/mod_proxy.html#proxy">&lt;Proxy&gt;</a></code>
    prend la place du conteneur <code class="directive"><a href="./mod/core.html#directory">&lt;Directory&gt;</a></code> dans l'ordre de traitement.</p>
    
	<div class="note"><h3>Note technique</h3>
	Une squence <code>&lt;Location&gt;</code>/<code>&lt;LocationMatch&gt;</code>
	est rellement traite juste avant la phase de traduction du nom
	(o <code>Aliases</code> et <code>DocumentRoots</code>
      sont utiliss pour faire correspondre les URLs aux noms de fichiers).
      Les effets de cette squence disparaissent totalement lorsque
      la traduction est termine.
	</div>

<h3><a name="relationship-module-configuration" id="relationship-module-configuration">Interactions entre
modules et sections de configuration</a></h3>
    <p>Une question se pose souvent aprs avoir lu comment les sections de
    configuration sont fusionnes : comment et quand les directives de modules
    particuliers comme <code class="module"><a href="./mod/mod_rewrite.html">mod_rewrite</a></code> sont-elles interprtes ? La
    rponse n'est pas triviale et ncessite un approfondissement. Chaque module
    httpd gre sa propre configuration, et chacune de ses directives dans
    httpd.conf dfinit un lment de configuration dans un contexte particulier.
    httpd n'excute pas un commande au moment o elle est lue.</p>
    <p>A l'excution, le noyau de httpd parcours les sections de configuration
    dans l'ordre dcrit ci-dessus afin de dterminer lesquelles s'appliquent 
    la requte courante. Lorsqu'une premire section s'applique, elle est
    considre comme la configuration courante pour cette requte. Si une
    section suivante s'applique aussi, chaque module qui possde des directives
    dans chacune de ces sections a la possibilit de fusionner sa configuration
    entre ces deux sections. Il en rsulte une troisime configuration et le
    processus de fusion se poursuit jusqu' ce que toutes les sections de
    configuration aient t values.</p>
    <p>Aprs l'tape prcdente, le traitement proprement dit de la requte HTTP
    peut commencer : chaque module peut effectuer toute tche qui lui incombe,
    et pour dterminer de quelle manire dont il doit agir, il peut s'appuyer
    sur le noyau de httpd pour retrouver sa configuration globale issue de la
    fusion prcdente.</p>
    <p>Un exemple permet de mieux visualiser l'ensemble du processus. la
    configuration suivante utilise la directive <code class="directive"><a href="./mod/mod_headers.html#header">Header</a></code> du module
    <code class="module"><a href="./mod/mod_headers.html">mod_headers</a></code> pour dfinir un en-tte HTTP spcifique. Quelle
    valeur httpd va-t-il affecter  l'en-tte <code>CustomHeaderName</code> pour
    une requte vers <code>/example/index.html</code> ?
    </p>
    <pre class="prettyprint lang-config">&lt;Directory "/"&gt;
    Header set CustomHeaderName one
    &lt;FilesMatch ".*"&gt;
        Header set CustomHeaderName three
    &lt;/FilesMatch&gt;
&lt;/Directory&gt;

&lt;Directory "/example"&gt;
    Header set CustomHeaderName two
&lt;/Directory&gt;</pre>
    
    <ul>
        <li><code class="directive">Directory</code> "/" s'applique, et une configuration
	initiale est cre qui dfinit l'en-tte <code>CustomHeaderName</code>
	avec la valeur <code>one</code>.</li>
        <li><code class="directive">Directory</code> "/example" s'applique, et comme
	<code class="module"><a href="./mod/mod_headers.html">mod_headers</a></code> spcifie dans son code que
	la valeur d'un en-tte doit tre crase si ce dernier est dfini 
	nouveau, une nouvelle configuration est cre qui dfinit l'en-tte
	<code>CustomHeaderName</code> avec la valeur <code>two</code>.</li>
        <li><code class="directive">FilesMatch</code> ".*" s'applique, une nouvelle
	opportunit de fusion surgit, et l'en-tte <code>CustomHeaderName</code>
	est dfini  la valeur <code>three</code>.</li>
        <li>Finalement, au cours des tapes suivantes du traitement de la
	requte HTTP, <code class="module"><a href="./mod/mod_headers.html">mod_headers</a></code> sera sollicit, et il se
	basera sur la configuration qui a dfini l'en-tte
	<code>CustomHeaderName</code>  la valeur <code>three</code>.
	<code class="module"><a href="./mod/mod_headers.html">mod_headers</a></code> utilise normalement cette configuration pour
	accomplir sa tche,  savoir dfinir des en-ttes HTTP. Cela ne veut
	cependant pas dire qu'un module ne peut pas effectuer des actions plus
	complexes comme dsactiver des directives car elle ne sont pas
	ncessaires ou obsoltes, etc...</li>
    </ul>

    <p>Ceci est aussi vrai pour les fichiers .htaccess car ils possdent la mme
    priorit que les sections <code class="directive">Directory</code> dans l'ordre de
    fusion. Il faut bien comprendre que les sections de configuration comme
    <code class="directive">Directory</code> et <code class="directive">FilesMatch</code> ne
    sont pas comparables avec les directives spcifiques de modules comme
    <code class="directive"><a href="./mod/mod_headers.html#header">Header</a></code> ou <code class="directive"><a href="./mod/mod_rewrite.html#rewriterule">RewriteRule</a></code> car elles agissent  des
    niveaux diffrents.
    </p>
	

<h3><a name="merge-examples" id="merge-examples">Quelques exemples utiles</a></h3>

<p>Voici un exemple imaginaire qui montre l'ordre de combinaison des sections.
En supposant qu'elles s'appliquent toutes  la requte, les directives de
cet exemple seront appliques dans l'ordre suivant : A &gt; B &gt; C &gt; D &gt;
E.</p>

<pre class="prettyprint lang-config">&lt;Location "/"&gt;
    E
&lt;/Location&gt;

&lt;Files "f.html"&gt;
    D
&lt;/Files&gt;

&lt;VirtualHost *&gt;
&lt;Directory "/a/b"&gt;
    B
&lt;/Directory&gt;
&lt;/VirtualHost&gt;

&lt;DirectoryMatch "^.*b$"&gt;
    C
&lt;/DirectoryMatch&gt;

&lt;Directory "/a/b"&gt;
    A
&lt;/Directory&gt;</pre>


<p>Pour un exemple plus concret, considrez ce qui suit.  Sans tenir compte
de toute restriction d'accs place dans les sections <code class="directive"><a href="./mod/core.html#directory">&lt;Directory&gt;</a></code>, la section <code class="directive"><a href="./mod/core.html#location">&lt;Location&gt;</a></code> sera
value en dernier et permettra un accs au serveur sans aucune restriction.
En d'autres termes, l'ordre de la combinaison des sections est important,
soyez donc prudent !</p>

<pre class="prettyprint lang-config">&lt;Location "/"&gt;
    Require all granted
&lt;/Location&gt;

# Arrghs!  Cette section &lt;Directory&gt; n'aura aucun effet
&lt;Directory "/"&gt;
    &lt;RequireAll&gt;
        Require all granted
        Require not host badguy.example.com
    &lt;/RequireAll&gt;
&lt;/Directory&gt;</pre>




</div></div>
<div class="bottomlang">
<p><span>Langues Disponibles: </span><a href="./en/sections.html" hreflang="en" rel="alternate" title="English">&nbsp;en&nbsp;</a> |
<a href="./fr/sections.html" title="Franais">&nbsp;fr&nbsp;</a> |
<a href="./ja/sections.html" hreflang="ja" rel="alternate" title="Japanese">&nbsp;ja&nbsp;</a> |
<a href="./ko/sections.html" hreflang="ko" rel="alternate" title="Korean">&nbsp;ko&nbsp;</a> |
<a href="./tr/sections.html" hreflang="tr" rel="alternate" title="Trke">&nbsp;tr&nbsp;</a></p>
</div><div class="top"><a href="#page-header"><img src="./images/up.gif" alt="top" /></a></div><div class="section"><h2><a id="comments_section" name="comments_section">Commentaires</a></h2><div class="warning"><strong>Notice:</strong><br />This is not a Q&amp;A section. Comments placed here should be pointed towards suggestions on improving the documentation or server, and may be removed again by our moderators if they are either implemented or considered invalid/off-topic. Questions on how to manage the Apache HTTP Server should be directed at either our IRC channel, #httpd, on Freenode, or sent to our <a href="http://httpd.apache.org/lists.html">mailing lists</a>.</div>
<script type="text/javascript"><!--//--><![CDATA[//><!--
var comments_shortname = 'httpd';
var comments_identifier = 'http://httpd.apache.org/docs/2.4/sections.html';
(function(w, d) {
    if (w.location.hostname.toLowerCase() == "httpd.apache.org") {
        d.write('<div id="comments_thread"><\/div>');
        var s = d.createElement('script');
        s.type = 'text/javascript';
        s.async = true;
        s.src = 'https://comments.apache.org/show_comments.lua?site=' + comments_shortname + '&page=' + comments_identifier;
        (d.getElementsByTagName('head')[0] || d.getElementsByTagName('body')[0]).appendChild(s);
    }
    else { 
        d.write('<div id="comments_thread">Comments are disabled for this page at the moment.<\/div>');
    }
})(window, document);
//--><!]]></script></div><div id="footer">
<p class="apache">Copyright 2016 The Apache Software Foundation.<br />Autoris sous <a href="http://www.apache.org/licenses/LICENSE-2.0">Apache License, Version 2.0</a>.</p>
<p class="menu"><a href="./mod/">Modules</a> | <a href="./mod/directives.html">Directives</a> | <a href="http://wiki.apache.org/httpd/FAQ">FAQ</a> | <a href="./glossary.html">Glossaire</a> | <a href="./sitemap.html">Plan du site</a></p></div><script type="text/javascript"><!--//--><![CDATA[//><!--
if (typeof(prettyPrint) !== 'undefined') {
    prettyPrint();
}
//--><!]]></script>
</body></html>