.TH "ZIP_FDOPEN" "3" "February 13, 2012" "NiH" "Library Functions Manual"
.nh
.if n .ad l
.SH "NAME"
\fBzip_fdopen\fR
\- open zip archive using open file descriptor
.SH "LIBRARY"
libzip (-lzip)
.SH "SYNOPSIS"
\fB#include <zip.h>\fR
.sp
\fIzip_t *\fR
.PD 0
.HP 4n
\fBzip_fdopen\fR(\fIint\ fd\fR, \fIint\ flags\fR, \fIint\ *errorp\fR);
.PD
.SH "DESCRIPTION"
The zip archive specified by the open file descriptor
\fIfd\fR
is opened and a pointer to a
\fIstruct zip\fR,
used to manipulate the archive, is returned.
In contrast to
zip_open(3),
using
\fBzip_fdopen\fR
the archive can only be opened in read-only mode.
The
\fIfd\fR
argument may not be used any longer after calling
\fBzip_fdopen\fR.
The
\fIflags\fR
are specified by
\fIor\fR'ing
the following values, or 0 for none of them.
.RS 6n
.TP 15n
\fRZIP_CHECKCONS\fR
Perform additional stricter consistency checks on the archive, and
error if they fail.
.RE
.PP
If an error occurs and
\fIerrorp\fR
is
non-\fRNULL\fR,
it will be set to the corresponding error code.
.SH "RETURN VALUES"
Upon successful completion
\fBzip_fdopen\fR()
returns a
\fIstruct zip\fR
pointer, and
\fIfd\fR
should not be used any longer, nor passed to
close(2).
Otherwise,
\fRNULL\fR
is returned and
\fI*errorp\fR
is set to indicate the error.
In the error case,
\fIfd\fR
remains unchanged.
.SH "ERRORS"
The file specified by
\fIfd\fR
is prepared for use by
libzip(3)
unless:
.TP 19n
[\fRZIP_ER_INCONS\fR]
Inconsistencies were found in the file specified by
\fIpath\fR.
This error is often caused by specifying
\fRZIP_CHECKCONS\fR
but can also happen without it.
.TP 19n
[\fRZIP_ER_INVAL\fR]
The
\fIflags\fR
argument is invalid.
Not all
zip_open(3)
flags are allowed for
\fBzip_fdopen\fR,
see
\fIDESCRIPTION\fR.
.TP 19n
[\fRZIP_ER_MEMORY\fR]
Required memory could not be allocated.
.TP 19n
[\fRZIP_ER_NOZIP\fR]
The file specified by
\fIfd\fR
is not a zip archive.
.TP 19n
[\fRZIP_ER_OPEN\fR]
The file specified by
\fIfd\fR
could not be prepared for use by
libzip(3).
.TP 19n
[\fRZIP_ER_READ\fR]
A read error occurred; see
\fIerrno\fR
for details.
.TP 19n
[\fRZIP_ER_SEEK\fR]
The file specified by
\fIfd\fR
does not allow seeks.
.SH "SEE ALSO"
libzip(3),
zip_close(3),
zip_error_to_str(3),
zip_open(3)
.SH "AUTHORS"
Dieter Baron <\fIdillo@nih.at\fR>
and
Thomas Klausner <\fItk@giga.or.at\fR>
