# - Locate Iconv
# This module defines:
#
#  ICONV_INCLUDE_DIR
#  ICONV_LIBRARY
#  ICONV_FOUND
#

# Look for header file
FIND_PATH(ICONV_INCLUDE_DIR NAMES iconv.h)

# Check if library is needed
IF(ICONV_INCLUDE_DIR)
	SET(CMAKE_REQUIRED_INCLUDES ${ICONV_INCLUDE_DIR})
	TRY_COMPILE(ICONV_LIBRARY_NOT_NEEDED
		${CMAKE_BINARY_DIR}
		${CMAKE_MODULE_PATH}/iconv_test.c
		CMAKE_FLAGS "-DINCLUDE_DIRECTORIES:STRING=${ICONV_INCLUDE_DIR}"
	)

	IF(NOT ICONV_LIBRARY_NOT_NEEDED)
		# Locate library
		FIND_LIBRARY(ICONV_LIBRARY NAMES iconv libiconv)

		IF(ICONV_INCLUDE_DIR AND ICONV_LIBRARY)
			SET(ICONV_FOUND TRUE)
		ENDIF(ICONV_INCLUDE_DIR AND ICONV_LIBRARY)
	ELSE(NOT ICONV_LIBRARY_NOT_NEEDED)
		# Library not needed
		SET(ICONV_LIBRARY)

		IF(ICONV_INCLUDE_DIR)
			SET(ICONV_FOUND TRUE)
		ENDIF(ICONV_INCLUDE_DIR)
	ENDIF(NOT ICONV_LIBRARY_NOT_NEEDED)
ENDIF(ICONV_INCLUDE_DIR)

# Show status
IF(ICONV_FOUND)
	IF(NOT Iconv_FIND_QUIETLY)
		IF(ICONV_LIBRARY_NOT_NEEDED)
			MESSAGE(STATUS "Found Iconv: -I${ICONV_INCLUDE_DIR}, library not needed")
		ELSE(ICONV_LIBRARY_NOT_NEEDED)
			MESSAGE(STATUS "Found Iconv: -I${ICONV_INCLUDE_DIR}, ${ICONV_LIBRARY}")
		ENDIF(ICONV_LIBRARY_NOT_NEEDED)
	ENDIF(NOT Iconv_FIND_QUIETLY)
ELSE(ICONV_FOUND)
	IF(Iconv_FIND_REQUIRED)
		MESSAGE(FATAL_ERROR "Could not find ICONV")
	ENDIF(Iconv_FIND_REQUIRED)
ENDIF(ICONV_FOUND)

MARK_AS_ADVANCED(ICONV_INCLUDE_DIR ICONV_LIBRARY ICONV_FOUND)
