#!/usr/bin/make -f
# Sample debian/rules that uses debhelper.
# GNU copyright 1997 to 1999 by Joey Hess.
changequote(, )

PACKAGE=binutils-__TARGET_PKG__
TARGET=__TARGET__

DEB_BUILD_GNU_TYPE      := $(shell dpkg-architecture -qDEB_BUILD_GNU_TYPE)
DEB_HOST_GNU_TYPE       := $(shell dpkg-architecture -qDEB_HOST_GNU_TYPE)

CONFARGS = --prefix=/usr \
           --libdir=/usr/$(TARGET)/lib \
           --build=$(DEB_BUILD_GNU_TYPE) \
           --host=$(DEB_HOST_GNU_TYPE) \
           --disable-static \
           --target=$(TARGET) \

# Uncomment this to turn on verbose mode.
#export DH_VERBOSE=1

# This is the debhelper compatability version to use.
export DH_COMPAT=3

# the dbs rules
include /usr/share/dpatch/dpatch.make

unpack: unpack-stamp
unpack-stamp:
	tar xjf /usr/src/toolchain/binutils.tar.bz2
	mv binutils*/* .
	ln -s . src
	mkdir build

	touch unpack-stamp

configure: configure-stamp
configure-stamp: unpack-stamp 
	dh_testdir

	# Add here commands to configure the package.
	cd build && env CC="gcc" ../src/configure $(CONFARGS)
	touch configure-stamp

build: configure-stamp build-stamp
build-stamp: patch-stamp
	dh_testdir

	# Add here commands to compile the package.
	cd build && $(MAKE)
	#/usr/bin/docbook-to-man debian/$(PACKAGE).sgml > $(PACKAGE).1

	touch build-stamp

clean:
	dh_testdir
	dh_testroot

	mv debian .save.debian
	rm -rf *
	mv .save.debian debian

	# Add here commands to clean up after the build process.
	#-$(MAKE) clean

	dh_clean

install: build
	dh_testdir
	dh_testroot
	dh_clean -k
	dh_installdirs

	# Add here commands to install the package into debian/$(PACKAGE).
	cd build && $(MAKE) install prefix=$(CURDIR)/debian/$(PACKAGE)/usr libdir=$(CURDIR)/debian/$(PACKAGE)/usr/$(TARGET)/lib
	mv debian/$(PACKAGE)/usr/man  debian/$(PACKAGE)/usr/share/man 
	cp debian/gasp.1 debian/$(PACKAGE)/usr/share/man/man1/__TARGET__-linux-gasp.1

	# Files also in main binutils pkg
	cd debian/$(PACKAGE)/usr && \
	/usr/src/toolchain/scripts/tpkg-binutils-rm-common-files
	rm debian/$(PACKAGE)/usr/__TARGET__/lib/libiberty.a

# Build architecture-independent files here.
binary-indep: build install
# We have nothing to do by default.

# Build architecture-dependent files here.
binary-arch: build install
	dh_testdir
	dh_testroot
#	dh_installdebconf	
	dh_installdocs -n
#	dh_installexamples
#	dh_installmenu
#	dh_installlogrotate
#	dh_installemacsen
#	dh_installpam
#	dh_installmime
#	dh_installinit
#	dh_installcron
	dh_installman
#	dh_installinfo
	dh_undocumented
	dh_installchangelogs 
	dh_link
	dh_strip
	dh_compress
	dh_fixperms
#	dh_makeshlibs
	dh_installdeb
#	dh_perl
	dh_shlibdeps

	# Update toolchain-source version reference (won't work as it's a source dependency)
	#touch debian/substvars
	#-grep -v '^toolchain-source-version=' debian/substvars > debian/substvars.tmp
	#mv debian/substvars.tmp debian/substvars
	#echo >> debian/substvars
	#echo -n 'toolchain-source-version=' >> debian/substvars
	#dpkg -s toolchain-source | grep Version: | sed -e 's/Version: //' >> debian/substvars

	dh_gencontrol
	dh_md5sums
	dh_builddeb

binary: binary-indep binary-arch
.PHONY: build clean binary-indep binary-arch binary install configure
