// -*-objc-*-

#define DEBUG

#import "RSSArticle.h"

@implementation RSSArticle
// methods to come... FIXME
-init
{
  return [self initWithHeadline: @"no headline"
	       url: @"no URL"
	       description: @"no description"
	       time: 0 ];
}

-initWithHeadline: (NSString*) myHeadline
	      url: (NSString*) myUrl
      description: (NSString*) myDescription
	     time: (unsigned int) myTime
{
  [super init];
  
  headline =      RETAIN(myHeadline);
  url =           RETAIN(myUrl);
  description =   RETAIN(myDescription);
  time =          myTime;
  
  return self;
}

-dealloc
{
#ifdef DEBUG
  NSLog(@"RSSArticle dealloc started");
#endif
#ifdef DEBUG
  NSLog(@"RSSArticle dealloc headline has %i", [headline retainCount]);
#endif
  RELEASE(headline);
#ifdef DEBUG
  NSLog(@"RSSArticle dealloc url has %i", [url retainCount]);
#endif
  RELEASE(url);
#ifdef DEBUG
  NSLog(@"RSSArticle dealloc desc has %i", [description retainCount]);
#endif
  RELEASE(description);
#ifdef DEBUG
  NSLog(@"RSSArticle dealloc finished");
#endif
  [super dealloc];
}

-(id)initWithCoder: (NSCoder*)coder
{
#ifdef DEBUG
  NSLog(@"started decoding RSSArticle");
#endif
  
  if (self = [super init]);
  {
    [coder decodeValueOfObjCType: @encode(unsigned int) at: &time];
    
    headline =      RETAIN([coder decodeObject]);
    url =           RETAIN([coder decodeObject]);
    description =   RETAIN([coder decodeObject]);
  }
  
  NSLog(@"  url = %@, rc=%i", [url description], [url retainCount]);
#ifdef DEBUG
  if (self != nil)
    NSLog(@"finished decoding RSSArticle (rc=%i)", [self retainCount]);
  else
    NSLog(@"finished decoding RSSArticle (oh shit self is nil!)");
#endif
  
  return self;
}

-(void)encodeWithCoder: (NSCoder*)coder
{
  [coder encodeValueOfObjCType: @encode(unsigned int) at: &time];
  
  [coder encodeObject: headline];
  [coder encodeObject: url];
  [coder encodeObject: description];
}

-headline
{
  return AUTORELEASE(RETAIN(headline));
}

-url
{
  return AUTORELEASE(RETAIN(url));
}

-description
{
  return AUTORELEASE(RETAIN(description));
}

-(unsigned int) time
{
  return time;
}
@end
