%module _libplot
%{
#include <plot.h>
%}

/* allows us to pass Python file objects to pl_newpl_r */
%typemap(python,in) FILE * {
	if ( $source == Py_None )
	{
		$target = NULL;
	}
	else if ( PyFile_Check( $source ) )
	{
		$target = PyFile_AsFile( $source );
	}
	else
	{
		PyErr_SetString( PyExc_TypeError, "not a file" );
		return NULL;
	}
}

/* we assume you only pass strings to pl_setplparam */
%typemap(python,in) void *value {
	if ( !PyString_Check( $source ) )
	{
		PyErr_SetString( PyExc_TypeError, "not a string" );
		return NULL;
	}
	$target = (void *) PyString_AsString( $source );
}

/* Marker symbols */

enum 
{ M_NONE, M_DOT, M_PLUS, M_ASTERISK, M_CIRCLE, M_CROSS, 
  M_SQUARE, M_TRIANGLE, M_DIAMOND, M_STAR, M_INVERTED_TRIANGLE, 
  M_STARBURST, M_FANCY_PLUS, M_FANCY_CROSS, M_FANCY_SQUARE, 
  M_FANCY_DIAMOND, M_FILLED_CIRCLE, M_FILLED_SQUARE, M_FILLED_TRIANGLE, 
  M_FILLED_DIAMOND, M_FILLED_INVERTED_TRIANGLE, M_FILLED_FANCY_SQUARE,
  M_FILLED_FANCY_DIAMOND, M_HALF_FILLED_CIRCLE, M_HALF_FILLED_SQUARE,
  M_HALF_FILLED_TRIANGLE, M_HALF_FILLED_DIAMOND,
  M_HALF_FILLED_INVERTED_TRIANGLE, M_HALF_FILLED_FANCY_SQUARE,
  M_HALF_FILLED_FANCY_DIAMOND, M_OCTAGON, M_FILLED_OCTAGON 
};

/* PlotterParams */

extern plPlotterParams * pl_newplparams (void);
extern int pl_deleteplparams (plPlotterParams *plotter_params);
extern plPlotterParams * pl_copyplparams (const plPlotterParams *plotter_params);
extern int pl_setplparam (plPlotterParams *plotter_params, const char *parameter, void *value);

/* Plotter */

extern plPlotter * pl_newpl_r (const char *type, FILE *infile, FILE *outfile, FILE *errfile, const plPlotterParams *plotter_params);
extern int pl_deletepl_r (plPlotter *plotter);

/* Plotter member functions */
extern int pl_arc_r  (plPlotter *plotter, int xc, int yc, int x0, int y0, int x1, int y1)  ;
extern int pl_box_r  (plPlotter *plotter, int x0, int y0, int x1, int y1)  ;
extern int pl_circle_r  (plPlotter *plotter, int x, int y, int r)  ;
extern int pl_closepl_r  (plPlotter *plotter)  ;
extern int pl_cont_r  (plPlotter *plotter, int x, int y)  ;
extern int pl_erase_r  (plPlotter *plotter)  ;
extern int pl_label_r  (plPlotter *plotter, const  char *s)  ;
extern int pl_line_r  (plPlotter *plotter, int x0, int y0, int x1, int y1)  ;
extern int pl_linemod_r  (plPlotter *plotter, const  char *s)  ;
extern int pl_move_r  (plPlotter *plotter, int x, int y)  ;
extern int pl_openpl_r  (plPlotter *plotter)  ;
extern int pl_point_r  (plPlotter *plotter, int x, int y)  ;
extern int pl_space_r  (plPlotter *plotter, int x0, int y0, int x1, int y1)  ;
extern int pl_alabel_r  (plPlotter *plotter, int x_justify, int y_justify, const  char *s)  ;
extern int pl_arcrel_r  (plPlotter *plotter, int dxc, int dyc, int dx0, int dy0, int dx1, int dy1)  ;
extern int pl_bezier2_r  (plPlotter *plotter, int x0, int y0, int x1, int y1, int x2, int y2)  ;
extern int pl_bezier2rel_r  (plPlotter *plotter, int dx0, int dy0, int dx1, int dy1, int dx2, int dy2)  ;
extern int pl_bezier3_r  (plPlotter *plotter, int x0, int y0, int x1, int y1, int x2, int y2, int x3, int y3)  ;
extern int pl_bezier3rel_r  (plPlotter *plotter, int dx0, int dy0, int dx1, int dy1, int dx2, int dy2, int dx3, int dy3)  ;
extern int pl_bgcolor_r  (plPlotter *plotter, int red, int green, int blue)  ;
extern int pl_bgcolorname_r  (plPlotter *plotter, const  char *name)  ;
extern int pl_boxrel_r  (plPlotter *plotter, int dx0, int dy0, int dx1, int dy1)  ;
extern int pl_capmod_r  (plPlotter *plotter, const  char *s)  ;
extern int pl_circlerel_r  (plPlotter *plotter, int dx, int dy, int r)  ;
extern int pl_closepath_r  (plPlotter *plotter)  ;
extern int pl_color_r  (plPlotter *plotter, int red, int green, int blue)  ;
extern int pl_colorname_r  (plPlotter *plotter, const  char *name)  ;
extern int pl_contrel_r  (plPlotter *plotter, int x, int y)  ;
extern int pl_ellarc_r  (plPlotter *plotter, int xc, int yc, int x0, int y0, int x1, int y1)  ;
extern int pl_ellarcrel_r  (plPlotter *plotter, int dxc, int dyc, int dx0, int dy0, int dx1, int dy1)  ;
extern int pl_ellipse_r  (plPlotter *plotter, int x, int y, int rx, int ry, int angle)  ;
extern int pl_ellipserel_r  (plPlotter *plotter, int dx, int dy, int rx, int ry, int angle)  ;
extern int pl_endpath_r  (plPlotter *plotter)  ;
extern int pl_endsubpath_r  (plPlotter *plotter)  ;
extern int pl_fillcolor_r  (plPlotter *plotter, int red, int green, int blue)  ;
extern int pl_fillcolorname_r  (plPlotter *plotter, const  char *name)  ;
extern int pl_fillmod_r  (plPlotter *plotter, const  char *s)  ;
extern int pl_filltype_r  (plPlotter *plotter, int level)  ;
extern int pl_flushpl_r  (plPlotter *plotter)  ;
extern int pl_fontname_r  (plPlotter *plotter, const  char *s)  ;
extern int pl_fontsize_r  (plPlotter *plotter, int size)  ;
extern int pl_havecap_r  (plPlotter *plotter, const  char *s)  ;
extern int pl_joinmod_r  (plPlotter *plotter, const  char *s)  ;
extern int pl_labelwidth_r  (plPlotter *plotter, const  char *s)  ;
extern int pl_linedash_r  (plPlotter *plotter, int n, const int *dashes, int offset)  ;
extern int pl_linerel_r  (plPlotter *plotter, int dx0, int dy0, int dx1, int dy1)  ;
extern int pl_linewidth_r  (plPlotter *plotter, int size)  ;
extern int pl_marker_r  (plPlotter *plotter, int x, int y, int type, int size)  ;
extern int pl_markerrel_r  (plPlotter *plotter, int dx, int dy, int type, int size)  ;
extern int pl_moverel_r  (plPlotter *plotter, int x, int y)  ;
extern int pl_orientation_r  (plPlotter *plotter, int direction)  ;
extern int pl_pencolor_r  (plPlotter *plotter, int red, int green, int blue)  ;
extern int pl_pencolorname_r  (plPlotter *plotter, const  char *name)  ;
extern int pl_pentype_r  (plPlotter *plotter, int level)  ;
extern int pl_pointrel_r  (plPlotter *plotter, int dx, int dy)  ;
extern int pl_restorestate_r  (plPlotter *plotter)  ;
extern int pl_savestate_r  (plPlotter *plotter)  ;
extern int pl_space2_r  (plPlotter *plotter, int x0, int y0, int x1, int y1, int x2, int y2)  ;
extern int pl_textangle_r  (plPlotter *plotter, int angle)  ;
extern double pl_ffontname_r  (plPlotter *plotter, const  char *s)  ;
extern double pl_ffontsize_r  (plPlotter *plotter, double size)  ;
extern double pl_flabelwidth_r  (plPlotter *plotter, const  char *s)  ;
extern double pl_ftextangle_r  (plPlotter *plotter, double angle)  ;
extern int pl_farc_r  (plPlotter *plotter, double xc, double yc, double x0, double y0, double x1, double y1)  ;
extern int pl_farcrel_r  (plPlotter *plotter, double dxc, double dyc, double dx0, double dy0, double dx1, double dy1)  ;
extern int pl_fbezier2_r  (plPlotter *plotter, double x0, double y0, double x1, double y1, double x2, double y2)  ;
extern int pl_fbezier2rel_r  (plPlotter *plotter, double dx0, double dy0, double dx1, double dy1, double dx2, double dy2)  ;
extern int pl_fbezier3_r  (plPlotter *plotter, double x0, double y0, double x1, double y1, double x2, double y2, double x3, double y3)  ;
extern int pl_fbezier3rel_r  (plPlotter *plotter, double dx0, double dy0, double dx1, double dy1, double dx2, double dy2, double dx3, double dy3)  ;
extern int pl_fbox_r  (plPlotter *plotter, double x0, double y0, double x1, double y1)  ;
extern int pl_fboxrel_r  (plPlotter *plotter, double dx0, double dy0, double dx1, double dy1)  ;
extern int pl_fcircle_r  (plPlotter *plotter, double x, double y, double r)  ;
extern int pl_fcirclerel_r  (plPlotter *plotter, double dx, double dy, double r)  ;
extern int pl_fcont_r  (plPlotter *plotter, double x, double y)  ;
extern int pl_fcontrel_r  (plPlotter *plotter, double dx, double dy)  ;
extern int pl_fellarc_r  (plPlotter *plotter, double xc, double yc, double x0, double y0, double x1, double y1)  ;
extern int pl_fellarcrel_r  (plPlotter *plotter, double dxc, double dyc, double dx0, double dy0, double dx1, double dy1)  ;
extern int pl_fellipse_r  (plPlotter *plotter, double x, double y, double rx, double ry, double angle)  ;
extern int pl_fellipserel_r  (plPlotter *plotter, double dx, double dy, double rx, double ry, double angle)  ;
extern int pl_flinedash_r  (plPlotter *plotter, int n, const double *dashes, double offset)  ;
extern int pl_fline_r  (plPlotter *plotter, double x0, double y0, double x1, double y1)  ;
extern int pl_flinerel_r  (plPlotter *plotter, double dx0, double dy0, double dx1, double dy1)  ;
extern int pl_flinewidth_r  (plPlotter *plotter, double size)  ;
extern int pl_fmarker_r  (plPlotter *plotter, double x, double y, int type, double size)  ;
extern int pl_fmarkerrel_r  (plPlotter *plotter, double dx, double dy, int type, double size)  ;
extern int pl_fmove_r  (plPlotter *plotter, double x, double y)  ;
extern int pl_fmoverel_r  (plPlotter *plotter, double dx, double dy)  ;
extern int pl_fpoint_r  (plPlotter *plotter, double x, double y)  ;
extern int pl_fpointrel_r  (plPlotter *plotter, double dx, double dy)  ;
extern int pl_fspace_r  (plPlotter *plotter, double x0, double y0, double x1, double y1)  ;
extern int pl_fspace2_r  (plPlotter *plotter, double x0, double y0, double x1, double y1, double x2, double y2)  ;
extern int pl_fconcat_r  (plPlotter *plotter, double m0, double m1, double m2, double m3, double m4, double m5)  ;
extern int pl_fmiterlimit_r  (plPlotter *plotter, double limit)  ;
extern int pl_frotate_r  (plPlotter *plotter, double theta)  ;
extern int pl_fscale_r  (plPlotter *plotter, double x, double y)  ;
extern int pl_fsetmatrix_r  (plPlotter *plotter, double m0, double m1, double m2, double m3, double m4, double m5)  ;
extern int pl_ftranslate_r  (plPlotter *plotter, double x, double y)  ;
