from Ft import TranslateMessage as _

class Error:
    DATABASE_CLOSED = 1
    TRANSACTION_IN_PROGRESS = 2
    TRANSACTION_NOT_IN_PROGRESS = 3
    INTEGRITY_ERROR = 4
    LOCK_NOT_GRANTED = 5
    INVALID_COLLECTION_TYPE = 6
    ELEMENT_NOT_FOUND = 7
    NO_MORE_ELEMENTS = 8
    INVALID_INDEX = 9
    INVALID_SIZE = 10
    DUPLICATE_NAME = 11
    KEY_NOT_FOUND = 12
    INVALID_DATE = 13
    INVALID_TIMESTAMP = 14
    NAME_NOT_FOUND = 15
    INVALID_TYPE = 16
    INVALID_EXPRESSION = 17
    CANNOT_REMOVE = 18
    BAD_PARAMETER = 19
    BAD_RELATIONSHIP = 20
    DATABASE_OPEN = 21
    DATABASE_NOT_FOUND = 22
    OBJECT_NAME_NOT_UNIQUE = 23
    OBJECT_NAME_NOT_FOUND = 24

    OBJECT_NOT_FOUND = 50
    UNSUPPORTED_ERROR = 51
    UNKNOWN_ERROR = 52
    INVALID_CONNECTION_STRING = 53
    INVALID_PYTHON_CLASS = 54
    GENERATION_ERROR = 55
    POST_PROCESSOR_ERROR = 56
    INTERFACE_CREATION_ERROR = 57

    OPERATION_NOT_IMPLEMENTED = 75
    OPERATION_BAD_PARAM = 76
    OPERATION_BAD_DEFINITION = 77
    
g_errorMessages = {
    Error.DATABASE_CLOSED: _('Database %(dbName)s is closed.'),
    Error.TRANSACTION_IN_PROGRESS: _('Thread %(threadId)s already has a transaction in progress.'),
    Error.TRANSACTION_NOT_IN_PROGRESS: _('Thread %(threadId)s does not have a transaction in progress.'),
    Error.INTEGRITY_ERROR: _('Relationship %(relationshipName)s did not recieve the expected type.'),
    Error.LOCK_NOT_GRANTED: _('A lock on the object could not be granted.'),
    Error.INVALID_COLLECTION_TYPE: _('The specified collection type is invalid.'),
    Error.ELEMENT_NOT_FOUND: _('The element "%(element)s" was not found.'),
    Error.NO_MORE_ELEMENTS: _('There are no more elements in the iterator.'),
    Error.INVALID_INDEX: _('Index %(index)d is invalid.'),
    Error.INVALID_SIZE: _('Size %(size)d is invalid.'),
    Error.DUPLICATE_NAME: _('Name %(name)s is already present in the dictionary'),
    Error.KEY_NOT_FOUND: _('Key %(key)s is not present in the dictionary'),
    Error.INVALID_DATE: _('The specified date is invalid.'),
    Error.INVALID_TIMESTAMP: _('The date %(a_date)s and time %(a_time)s form and invalid time stamp.'),
    Error.NAME_NOT_FOUND: _('%(reason)s'),
    Error.INVALID_TYPE: _('%(reason)s'),
    Error.INVALID_EXPRESSION: _('%(reason)s'),
    Error.CANNOT_REMOVE: _('%(reason)s'),
    Error.BAD_PARAMETER: _('%(reason)s'),
    Error.BAD_RELATIONSHIP: _('%(reason)s'),
    Error.DATABASE_OPEN: _('The database %(dbName)s is already open.'),
    Error.DATABASE_NOT_FOUND: _('The database %(dbName)s could not be found.'),
    Error.OBJECT_NAME_NOT_UNIQUE: _('The name %(name)s is not unique in the database.'),
    Error.OBJECT_NAME_NOT_FOUND: _('The name %(name)s was not found in the database.'),

    Error.OBJECT_NOT_FOUND: _('The object of type %(type)s and id %(oid)d was not found.'),
    Error.UNSUPPORTED_ERROR: _('The following feature is not currently suported, but its implementation is imminent: %(feature)s'),
    Error.UNKNOWN_ERROR: _('%(msg)s'),
    Error.INVALID_CONNECTION_STRING: _('The connection string "%(connectString)s" is invalid: %(reason)s'),
    Error.INVALID_PYTHON_CLASS: _('The python class id %(classId)s is invalid.  This means your database has become out of synch with your file system.'),
    Error.GENERATION_ERROR: _('Python stub files could not be generated: %(msg)s'),
    Error.OPERATION_NOT_IMPLEMENTED: _('Operation %(name)s has no implementation registered.'),
    Error.OPERATION_BAD_PARAM: _('Operation parameter "%(name)s" has a value of "%(value)s" which is not of type %(type)s.'),
    Error.OPERATION_BAD_DEFINITION: _('Operation %(repoId)d has an invalid definition module:\n\n %(tb)s.'),

    Error.POST_PROCESSOR_ERROR: _('A Post processing error has occured: %(msg)s'),
    Error.INTERFACE_CREATION_ERROR: _('You cannot create instances of interface %(name)s.  You can only create instances of a class.'),

    }

