############################################################################
#
# File Name: 		CollectionOfPersistentObjects.py
#
# Documentation:	http://docs.ftsuite.com/4ODS/CollectionOfPersistentObjects.py.html
#
"""
Base class for all lists of persistent objects
WWW: http://4suite.org/4ODS         e-mail: support@4suite.org

Copyright (c) 1999 Fourthought, Inc., USA.   All Rights Reserved.
See  http://4suite.org/COPYRIGHT  for license and copyright information
"""


from Ft.Ods import Database
from Ft.Ods.Collections import CollectionBase
from Ft.Ods.StorageManager.Adapters import Constants

Actions = Constants.CollectionChanges

import types


class CollectionOfPersistentObjects:

    #4ODS interfaces
    def _4ods_prepareValue(self,value):
        return self._db._4ods_getPersistentObjectById(self._subType,value)

    def _4ods_unprepareValue(self,value):
        #Do a type check

        Constants.g_typeCheck[self._subType](value,self._subTypeRepoId)
        return value._4ods_getId()

    def _4ods_prepareChange(self,change):
        return change

