/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version 1.3.21
 * 
 * This file is not intended to be easily readable and contains a number of 
 * coding conventions designed to improve portability and efficiency. Do not make
 * changes to this file unless you know what you are doing--modify the SWIG 
 * interface file instead. 
 * ----------------------------------------------------------------------------- */


#if defined(__GNUC__)
    typedef long long __int64; /*For gcc on Windows */
#endif
#include <jni.h>
#include <stdlib.h>
#include <string.h>


/* Support for throwing Java exceptions */
typedef enum {
  SWIG_JavaOutOfMemoryError = 1, 
  SWIG_JavaIOException, 
  SWIG_JavaRuntimeException, 
  SWIG_JavaIndexOutOfBoundsException,
  SWIG_JavaArithmeticException,
  SWIG_JavaIllegalArgumentException,
  SWIG_JavaNullPointerException,
  SWIG_JavaDirectorPureVirtual,
  SWIG_JavaUnknownError
} SWIG_JavaExceptionCodes;

typedef struct {
  SWIG_JavaExceptionCodes code;
  const char *java_exception;
} SWIG_JavaExceptions_t;


static void SWIG_JavaThrowException(JNIEnv *jenv, SWIG_JavaExceptionCodes code, const char *msg) {
  jclass excep;
  static const SWIG_JavaExceptions_t java_exceptions[] = {
    { SWIG_JavaOutOfMemoryError, "java/lang/OutOfMemoryError" },
    { SWIG_JavaIOException, "java/io/IOException" },
    { SWIG_JavaRuntimeException, "java/lang/RuntimeException" },
    { SWIG_JavaIndexOutOfBoundsException, "java/lang/IndexOutOfBoundsException" },
    { SWIG_JavaArithmeticException, "java/lang/ArithmeticException" },
    { SWIG_JavaIllegalArgumentException, "java/lang/IllegalArgumentException" },
    { SWIG_JavaNullPointerException, "java/lang/NullPointerException" },
    { SWIG_JavaDirectorPureVirtual, "java/lang/RuntimeException" },
    { SWIG_JavaUnknownError,  "java/lang/UnknownError" },
    { (SWIG_JavaExceptionCodes)0,  "java/lang/UnknownError" } };
  const SWIG_JavaExceptions_t *except_ptr = java_exceptions;

  while (except_ptr->code != code && except_ptr->code)
    except_ptr++;

  (*jenv)->ExceptionClear(jenv);
  excep = (*jenv)->FindClass(jenv, except_ptr->java_exception);
  if (excep)
    (*jenv)->ThrowNew(jenv, excep, msg);
}


/* Contract support */

#define SWIG_contract_assert(nullreturn, expr, msg) if (!(expr)) {SWIG_JavaThrowException(jenv, SWIG_JavaIllegalArgumentException, msg); return nullreturn; } else


#include "plplotP.h"


/*---------------------------------------------------------------------------
 * Array allocation & copy helper routines.  Note because of swig limitations
 * it is necessary to release the java array memory right after calling these
 * routines.  Thus it is necessary to allocate and copy the arrays  even if
 * the java and plplot arrays are of the same type.  Note, because of this
 * change to Geoffrey's original versions, caller must always free memory
 * afterwards.  Thus, the must_free_buffers logic is gone as well.
 *---------------------------------------------------------------------------*/

/* 1d array of jints */

static void
setup_array_1d_i( PLINT **pa, jint *adat, int n )
{
   int i;
   *pa = (PLINT *) malloc( n * sizeof(PLINT) );
   for( i=0; i < n; i++ ) {
      (*pa)[i] = adat[i];
   }
}

/* 1d array of jfloats */

static void
setup_array_1d_f( PLFLT **pa, jfloat *adat, int n )
{
   int i;
   *pa = (PLFLT *) malloc( n * sizeof(PLFLT) );
   for( i=0; i < n; i++ ) {
      (*pa)[i] = adat[i];
   }
}

/* 1d array of jdoubles */

static void
setup_array_1d_d( PLFLT **pa, jdouble *adat, int n )
{
   int i;
   *pa = (PLFLT *) malloc( n * sizeof(PLFLT) );
   for( i=0; i < n; i++ ) {
      (*pa)[i] = adat[i];
   }
}

/* 2d array of floats */
/* Here caller must free(a[0]) and free(a) (in that order) afterward */

static void
setup_array_2d_f( PLFLT ***pa, jfloat **adat, int nx, int ny )
{
   int i, j;

   *pa = (PLFLT **) malloc( nx * sizeof(PLFLT *) );
   (*pa)[0] = (PLFLT *) malloc( nx * ny * sizeof(PLFLT) );

   for( i=0; i < nx; i++ )
     {
	(*pa)[i] = (*pa)[0] + i*ny;
	for( j=0; j < ny; j++ )
	  (*pa)[i][j] = adat[i][j];
     }

}

/* 2d array of doubles */
/* Here caller must free(a[0]) and free(a) (in that order) afterward */

static void
setup_array_2d_d( PLFLT ***pa, jdouble **adat, int nx, int ny )
{
   int i, j;

   *pa = (PLFLT **) malloc( nx * sizeof(PLFLT *) );
   (*pa)[0] = (PLFLT *) malloc( nx * ny * sizeof(PLFLT) );

   for( i=0; i < nx; i++ )
     {
	(*pa)[i] = (*pa)[0] + i*ny;
	for( j=0; j < ny; j++ )
	  (*pa)[i][j] = adat[i][j];
     }

}


   static PLINT Alen = 0;
   static PLINT Xlen = 0, Ylen = 0;
   static PLFLT **xg;
   static PLFLT **yg;
  

   typedef PLINT (*defined_func)(PLFLT, PLFLT);
   typedef void (*fill_func)(PLINT, PLFLT*, PLFLT*);
   typedef void (*pltr_func)(PLFLT, PLFLT, PLFLT *, PLFLT*, PLPointer);
   typedef PLFLT (*f2eval_func)(PLINT, PLINT, PLPointer);
   

#ifdef __cplusplus
extern "C" {
#endif

JNIEXPORT jstring JNICALL Java_plplot_core_plplotjavacJNI_get_1jPLFLTArray(JNIEnv *jenv, jclass jcls) {
    jstring jresult = 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    result = (char *) "jdoubleArray";
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_plplot_core_plplotjavacJNI_get_1jPLFLTbracket(JNIEnv *jenv, jclass jcls) {
    jstring jresult = 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    result = (char *) "double[]";
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_plplot_core_plplotjavacJNI_get_1jPLFLTbracket2(JNIEnv *jenv, jclass jcls) {
    jstring jresult = 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    result = (char *) "double[][]";
    
    {
        if(result) jresult = (*jenv)->NewStringUTF(jenv, result); 
    }
    return jresult;
}


JNIEXPORT jint JNICALL Java_plplot_core_plplotjavacJNI_get_1PLESC_1SET_1RGB(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 1;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_plplot_core_plplotjavacJNI_get_1PLESC_1ALLOC_1NCOL(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 2;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_plplot_core_plplotjavacJNI_get_1PLESC_1SET_1LPB(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 3;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_plplot_core_plplotjavacJNI_get_1PLESC_1EXPOSE(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 4;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_plplot_core_plplotjavacJNI_get_1PLESC_1RESIZE(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 5;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_plplot_core_plplotjavacJNI_get_1PLESC_1REDRAW(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 6;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_plplot_core_plplotjavacJNI_get_1PLESC_1TEXT(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 7;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_plplot_core_plplotjavacJNI_get_1PLESC_1GRAPH(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 8;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_plplot_core_plplotjavacJNI_get_1PLESC_1FILL(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 9;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_plplot_core_plplotjavacJNI_get_1PLESC_1DI(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 10;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_plplot_core_plplotjavacJNI_get_1PLESC_1FLUSH(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 11;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_plplot_core_plplotjavacJNI_get_1PLESC_1EH(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 12;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_plplot_core_plplotjavacJNI_get_1PLESC_1GETC(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 13;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_plplot_core_plplotjavacJNI_get_1PLESC_1SWIN(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 14;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_plplot_core_plplotjavacJNI_get_1PLESC_1PLFLTBUFFERING(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 15;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_plplot_core_plplotjavacJNI_get_1PLESC_1XORMOD(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 16;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_plplot_core_plplotjavacJNI_get_1PLESC_1SET_1COMPRESSION(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 17;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_plplot_core_plplotjavacJNI_get_1PLESC_1CLEAR(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 18;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_plplot_core_plplotjavacJNI_get_1PLESC_1DASH(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 19;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_plplot_core_plplotjavacJNI_get_1PLESC_1HAS_1TEXT(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 20;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_plplot_core_plplotjavacJNI_get_1PLESC_1IMAGE(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 21;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_plplot_core_plplotjavacJNI_get_1PLESC_1IMAGEOPS(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 22;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_plplot_core_plplotjavacJNI_get_1DRAW_1LINEX(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 0x01;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_plplot_core_plplotjavacJNI_get_1DRAW_1LINEY(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 0x02;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_plplot_core_plplotjavacJNI_get_1DRAW_1LINEXY(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 0x03;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_plplot_core_plplotjavacJNI_get_1MAG_1COLOR(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 0x04;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_plplot_core_plplotjavacJNI_get_1BASE_1CONT(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 0x08;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_plplot_core_plplotjavacJNI_get_1TOP_1CONT(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 0x10;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_plplot_core_plplotjavacJNI_get_1SURF_1CONT(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 0x20;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_plplot_core_plplotjavacJNI_get_1DRAW_1SIDES(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 0x40;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_plplot_core_plplotjavacJNI_get_1FACETED(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 0x80;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_plplot_core_plplotjavacJNI_get_1MESH(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 0x100;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_plplot_core_plplotjavacJNI_get_1PLSWIN_1DEVICE(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 1;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_plplot_core_plplotjavacJNI_get_1PLSWIN_1WORLD(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 2;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_plplot_core_plplotjavacJNI_get_1PL_1OPT_1ENABLED(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 0x0001;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_plplot_core_plplotjavacJNI_get_1PL_1OPT_1ARG(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 0x0002;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_plplot_core_plplotjavacJNI_get_1PL_1OPT_1NODELETE(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 0x0004;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_plplot_core_plplotjavacJNI_get_1PL_1OPT_1INVISIBLE(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 0x0008;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_plplot_core_plplotjavacJNI_get_1PL_1OPT_1DISABLED(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 0x0010;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_plplot_core_plplotjavacJNI_get_1PL_1OPT_1FUNC(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 0x0100;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_plplot_core_plplotjavacJNI_get_1PL_1OPT_1BOOL(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 0x0200;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_plplot_core_plplotjavacJNI_get_1PL_1OPT_1INT(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 0x0400;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_plplot_core_plplotjavacJNI_get_1PL_1OPT_1FLOAT(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 0x0800;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_plplot_core_plplotjavacJNI_get_1PL_1OPT_1STRING(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 0x1000;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_plplot_core_plplotjavacJNI_get_1PL_1PARSE_1PARTIAL(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 0x0000;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_plplot_core_plplotjavacJNI_get_1PL_1PARSE_1FULL(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 0x0001;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_plplot_core_plplotjavacJNI_get_1PL_1PARSE_1QUIET(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 0x0002;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_plplot_core_plplotjavacJNI_get_1PL_1PARSE_1NODELETE(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 0x0004;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_plplot_core_plplotjavacJNI_get_1PL_1PARSE_1SHOWALL(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 0x0008;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_plplot_core_plplotjavacJNI_get_1PL_1PARSE_1OVERRIDE(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 0x0010;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_plplot_core_plplotjavacJNI_get_1PL_1PARSE_1NOPROGRAM(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 0x0020;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_plplot_core_plplotjavacJNI_get_1PL_1PARSE_1NODASH(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 0x0040;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_plplot_core_plplotjavacJNI_get_1PL_1PARSE_1SKIP(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 0x0080;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_plplot_core_plplotjavacJNI_get_1PL_1MAXKEY(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 16;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_plplot_core_plplotjavacJNI_get_1PL_1MAXWINDOWS(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 64;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_plplot_core_plplotjavacJNI_get_1PL_1NOTSET(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) (-42);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_plplot_core_plplotjavacJNI_get_1PLESPLFLTBUFFERING_1ENABLE(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 1;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_plplot_core_plplotjavacJNI_get_1PLESPLFLTBUFFERING_1DISABLE(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 2;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_plplot_core_plplotjavacJNI_get_1PLESPLFLTBUFFERING_1QUERY(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 3;
    
    jresult = (jint)result; 
    return jresult;
}


#define _doc_pl_setcontlabelformat "Set the format of the contour labels." 
JNIEXPORT void JNICALL Java_plplot_core_plplotjavacJNI_pl_1setcontlabelformat(JNIEnv *jenv, jclass jcls, jint jarg1, jint jarg2) {
    PLINT arg1 ;
    PLINT arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = (PLINT)jarg1; 
    arg2 = (PLINT)jarg2; 
    pl_setcontlabelformat(arg1,arg2);
    
}


#define _doc_pl_setcontlabelparam "Set offset and spacing of contour labels." 
JNIEXPORT void JNICALL Java_plplot_core_plplotjavacJNI_pl_1setcontlabelparam(JNIEnv *jenv, jclass jcls, jdouble jarg1, jdouble jarg2, jdouble jarg3, jint jarg4) {
    PLFLT arg1 ;
    PLFLT arg2 ;
    PLFLT arg3 ;
    PLINT arg4 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = (PLFLT)jarg1; 
    arg2 = (PLFLT)jarg2; 
    arg3 = (PLFLT)jarg3; 
    arg4 = (PLINT)jarg4; 
    pl_setcontlabelparam(arg1,arg2,arg3,arg4);
    
}


#define _doc_pladv "Advance to subpage \"page\", or to the next one if \"page\" = 0." 
JNIEXPORT void JNICALL Java_plplot_core_plplotjavacJNI_pladv(JNIEnv *jenv, jclass jcls, jint jarg1) {
    PLINT arg1 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = (PLINT)jarg1; 
    pladv(arg1);
    
}


#define _doc_plaxes "This functions similarly to plbox() except that the origin of the axes is placed at the user-specified point (x0, y0)." 
JNIEXPORT void JNICALL Java_plplot_core_plplotjavacJNI_plaxes(JNIEnv *jenv, jclass jcls, jdouble jarg1, jdouble jarg2, jstring jarg3, jdouble jarg4, jint jarg5, jstring jarg6, jdouble jarg7, jint jarg8) {
    PLFLT arg1 ;
    PLFLT arg2 ;
    char *arg3 ;
    PLFLT arg4 ;
    PLINT arg5 ;
    char *arg6 ;
    PLFLT arg7 ;
    PLINT arg8 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = (PLFLT)jarg1; 
    arg2 = (PLFLT)jarg2; 
    {
        arg3 = 0;
        if (jarg3) {
            arg3 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg3, 0);
            if (!arg3) return ;
        }
    }
    arg4 = (PLFLT)jarg4; 
    arg5 = (PLINT)jarg5; 
    {
        arg6 = 0;
        if (jarg6) {
            arg6 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg6, 0);
            if (!arg6) return ;
        }
    }
    arg7 = (PLFLT)jarg7; 
    arg8 = (PLINT)jarg8; 
    plaxes(arg1,arg2,(char const *)arg3,arg4,arg5,(char const *)arg6,arg7,arg8);
    
    {
        if (arg3) (*jenv)->ReleaseStringUTFChars(jenv, jarg3, arg3); 
    }
    {
        if (arg6) (*jenv)->ReleaseStringUTFChars(jenv, jarg6, arg6); 
    }
}


#define _doc_plbin "Plot a histogram using x to store data values and y to store frequencies." 
JNIEXPORT void JNICALL Java_plplot_core_plplotjavacJNI_plbin(JNIEnv *jenv, jclass jcls, jdoubleArray jarg1, jdoubleArray jarg3, jint jarg4) {
    PLINT arg1 ;
    PLFLT *arg2 = (PLFLT *) 0 ;
    PLFLT *arg3 = (PLFLT *) 0 ;
    PLINT arg4 ;
    
    (void)jenv;
    (void)jcls;
    {
        jdouble *jxdata = (*jenv)->GetDoubleArrayElements( jenv, jarg1, 0 );
        arg1 = (*jenv)->GetArrayLength( jenv, jarg1);
        Alen = arg1;
        setup_array_1d_d( &arg2, jxdata, Alen );
        /* Could find no easy way to do this as part of freearg so I modified
            * the previous function so it ALWAYS mallocs and copies so that
            * the java array can be released immediately. */
        (*jenv)->ReleaseDoubleArrayElements( jenv, jarg1, jxdata, 0 );
    }
    {
        jdouble *jydata = (*jenv)->GetDoubleArrayElements( jenv, jarg3, 0 );
        if((*jenv)->GetArrayLength( jenv, jarg3 ) != Alen) {
            printf("Vectors must be same length.\n");
            return;
        }
        setup_array_1d_d( &arg3, jydata, Alen );
        (*jenv)->ReleaseDoubleArrayElements( jenv, jarg3, jydata, 0 );
    }
    arg4 = (PLINT)jarg4; 
    plbin(arg1,arg2,arg3,arg4);
    
    {
        free(arg2);
    }
    {
        free(arg3);
    }
}


#define _doc_plbop "Start new page.  Should only be used with pleop()." 
JNIEXPORT void JNICALL Java_plplot_core_plplotjavacJNI_plbop(JNIEnv *jenv, jclass jcls) {
    (void)jenv;
    (void)jcls;
    plbop();
    
}


#define _doc_plbox "Draw a box around the current viewport." 
JNIEXPORT void JNICALL Java_plplot_core_plplotjavacJNI_plbox(JNIEnv *jenv, jclass jcls, jstring jarg1, jdouble jarg2, jint jarg3, jstring jarg4, jdouble jarg5, jint jarg6) {
    char *arg1 ;
    PLFLT arg2 ;
    PLINT arg3 ;
    char *arg4 ;
    PLFLT arg5 ;
    PLINT arg6 ;
    
    (void)jenv;
    (void)jcls;
    {
        arg1 = 0;
        if (jarg1) {
            arg1 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg1, 0);
            if (!arg1) return ;
        }
    }
    arg2 = (PLFLT)jarg2; 
    arg3 = (PLINT)jarg3; 
    {
        arg4 = 0;
        if (jarg4) {
            arg4 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg4, 0);
            if (!arg4) return ;
        }
    }
    arg5 = (PLFLT)jarg5; 
    arg6 = (PLINT)jarg6; 
    plbox((char const *)arg1,arg2,arg3,(char const *)arg4,arg5,arg6);
    
    {
        if (arg1) (*jenv)->ReleaseStringUTFChars(jenv, jarg1, arg1); 
    }
    {
        if (arg4) (*jenv)->ReleaseStringUTFChars(jenv, jarg4, arg4); 
    }
}


#define _doc_plbox3 "This is the 3-d analogue of plbox()." 
JNIEXPORT void JNICALL Java_plplot_core_plplotjavacJNI_plbox3(JNIEnv *jenv, jclass jcls, jstring jarg1, jstring jarg2, jdouble jarg3, jint jarg4, jstring jarg5, jstring jarg6, jdouble jarg7, jint jarg8, jstring jarg9, jstring jarg10, jdouble jarg11, jint jarg12) {
    char *arg1 ;
    char *arg2 ;
    PLFLT arg3 ;
    PLINT arg4 ;
    char *arg5 ;
    char *arg6 ;
    PLFLT arg7 ;
    PLINT arg8 ;
    char *arg9 ;
    char *arg10 ;
    PLFLT arg11 ;
    PLINT arg12 ;
    
    (void)jenv;
    (void)jcls;
    {
        arg1 = 0;
        if (jarg1) {
            arg1 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg1, 0);
            if (!arg1) return ;
        }
    }
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
            if (!arg2) return ;
        }
    }
    arg3 = (PLFLT)jarg3; 
    arg4 = (PLINT)jarg4; 
    {
        arg5 = 0;
        if (jarg5) {
            arg5 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg5, 0);
            if (!arg5) return ;
        }
    }
    {
        arg6 = 0;
        if (jarg6) {
            arg6 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg6, 0);
            if (!arg6) return ;
        }
    }
    arg7 = (PLFLT)jarg7; 
    arg8 = (PLINT)jarg8; 
    {
        arg9 = 0;
        if (jarg9) {
            arg9 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg9, 0);
            if (!arg9) return ;
        }
    }
    {
        arg10 = 0;
        if (jarg10) {
            arg10 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg10, 0);
            if (!arg10) return ;
        }
    }
    arg11 = (PLFLT)jarg11; 
    arg12 = (PLINT)jarg12; 
    plbox3((char const *)arg1,(char const *)arg2,arg3,arg4,(char const *)arg5,(char const *)arg6,arg7,arg8,(char const *)arg9,(char const *)arg10,arg11,arg12);
    
    {
        if (arg1) (*jenv)->ReleaseStringUTFChars(jenv, jarg1, arg1); 
    }
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
    {
        if (arg5) (*jenv)->ReleaseStringUTFChars(jenv, jarg5, arg5); 
    }
    {
        if (arg6) (*jenv)->ReleaseStringUTFChars(jenv, jarg6, arg6); 
    }
    {
        if (arg9) (*jenv)->ReleaseStringUTFChars(jenv, jarg9, arg9); 
    }
    {
        if (arg10) (*jenv)->ReleaseStringUTFChars(jenv, jarg10, arg10); 
    }
}


#define _doc_plcalc_world "Calculate world coordinates and subpage from relative device coordinates." 
JNIEXPORT void JNICALL Java_plplot_core_plplotjavacJNI_plcalc_1world(JNIEnv *jenv, jclass jcls, jdouble jarg1, jdouble jarg2, jdoubleArray jarg3, jdoubleArray jarg4, jintArray jarg5) {
    PLFLT arg1 ;
    PLFLT arg2 ;
    PLFLT *arg3 = (PLFLT *) 0 ;
    PLFLT *arg4 = (PLFLT *) 0 ;
    PLINT *arg5 = (PLINT *) 0 ;
    PLFLT temp3 ;
    PLFLT temp4 ;
    PLINT temp5 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = (PLFLT)jarg1; 
    arg2 = (PLFLT)jarg2; 
    {
        if (!jarg3) {
            SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "array null");
            return ;
        }
        if ((*jenv)->GetArrayLength(jenv, jarg3) == 0) {
            SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, "Array must contain at least 1 element");
            return ;
        }
        arg3 = &temp3; 
    }
    {
        if (!jarg4) {
            SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "array null");
            return ;
        }
        if ((*jenv)->GetArrayLength(jenv, jarg4) == 0) {
            SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, "Array must contain at least 1 element");
            return ;
        }
        arg4 = &temp4; 
    }
    {
        if (!jarg5) {
            SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "array null");
            return ;
        }
        if ((*jenv)->GetArrayLength(jenv, jarg5) == 0) {
            SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, "Array must contain at least 1 element");
            return ;
        }
        arg5 = &temp5; 
    }
    plcalc_world(arg1,arg2,arg3,arg4,arg5);
    
    {
        jdouble jvalue = (jdouble)temp3;
        (*jenv)->SetDoubleArrayRegion(jenv, jarg3, 0, 1, &jvalue);
    }
    {
        jdouble jvalue = (jdouble)temp4;
        (*jenv)->SetDoubleArrayRegion(jenv, jarg4, 0, 1, &jvalue);
    }
    {
        jint jvalue = (jint)temp5;
        (*jenv)->SetIntArrayRegion(jenv, jarg5, 0, 1, &jvalue);
    }
}


#define _doc_plclear "Clear current subpage." 
JNIEXPORT void JNICALL Java_plplot_core_plplotjavacJNI_plclear(JNIEnv *jenv, jclass jcls) {
    (void)jenv;
    (void)jcls;
    plclear();
    
}


#define _doc_plcol0 "Set color, map 0.  Argument is integer between 0 and 15." 
JNIEXPORT void JNICALL Java_plplot_core_plplotjavacJNI_plcol0(JNIEnv *jenv, jclass jcls, jint jarg1) {
    PLINT arg1 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = (PLINT)jarg1; 
    plcol0(arg1);
    
}


#define _doc_plcol1 "Set color, map 1.  Argument is a float between 0. and 1." 
JNIEXPORT void JNICALL Java_plplot_core_plplotjavacJNI_plcol1(JNIEnv *jenv, jclass jcls, jdouble jarg1) {
    PLFLT arg1 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = (PLFLT)jarg1; 
    plcol1(arg1);
    
}


#define _doc_plcont "Draw a contour plot." 
JNIEXPORT void JNICALL Java_plplot_core_plplotjavacJNI_plcont(JNIEnv *jenv, jclass jcls, jobjectArray jarg1, jint jarg4, jint jarg5, jint jarg6, jint jarg7, jdoubleArray jarg8, jobjectArray jarg10, jobjectArray jarg11) {
    PLFLT **arg1 = (PLFLT **) 0 ;
    PLINT arg2 ;
    PLINT arg3 ;
    PLINT arg4 ;
    PLINT arg5 ;
    PLINT arg6 ;
    PLINT arg7 ;
    PLFLT *arg8 = (PLFLT *) 0 ;
    PLINT arg9 ;
    pltr_func arg10 ;
    PLPointer arg11 = (PLPointer) 0 ;
    
    (void)jenv;
    (void)jcls;
    {
        jdouble **adat;
        jobject *ai;
        int nx = (*jenv)->GetArrayLength( jenv, jarg1 );
        int ny = -1;
        int i, j;
        ai = (jobject *) malloc( nx * sizeof(jobject) );
        adat = (jdouble **) malloc( nx * sizeof(jdouble *) );
        
        for( i=0; i < nx; i++ )
        {
            ai[i] = (*jenv)->GetObjectArrayElement( jenv, jarg1, i );
            adat[i] = (*jenv)->GetDoubleArrayElements( jenv, ai[i], 0 );
            
            if (ny == -1)
            ny = (*jenv)->GetArrayLength( jenv, ai[i] );
            else if (ny != (*jenv)->GetArrayLength( jenv, ai[i] )) {
                printf( "Misshapen a array.\n" );
                for( j=0; j <= i; j++ )
                (*jenv)->ReleaseDoubleArrayElements( jenv, ai[j], adat[j], 0 );
                free(adat);
                free(ai);
                return;
            }
        }
        
        Xlen = nx;
        Ylen = ny;
        setup_array_2d_d( &arg1, adat, nx, ny );
        arg2 = nx;
        arg3 = ny;
        for( i=0; i < nx; i++ ) {
            (*jenv)->ReleaseDoubleArrayElements( jenv, ai[i], adat[i], 0 );
            (*jenv)->DeleteLocalRef(jenv, ai[i]);
        }
        
        free(adat);
        free(ai);
        
    }
    arg4 = (PLINT)jarg4; 
    arg5 = (PLINT)jarg5; 
    arg6 = (PLINT)jarg6; 
    arg7 = (PLINT)jarg7; 
    {
        jdouble *jxdata = (*jenv)->GetDoubleArrayElements( jenv, jarg8, 0 );
        arg9 = (*jenv)->GetArrayLength( jenv, jarg8 );
        setup_array_1d_d( &arg8, jxdata, arg9);
        (*jenv)->ReleaseDoubleArrayElements( jenv, jarg8, jxdata, 0 );
    }
    {
        jdouble **adat;
        jobject *ai;
        int nx = (*jenv)->GetArrayLength( jenv, jarg10 );
        int ny = -1;
        int i, j;
        ai = (jobject *) malloc( nx * sizeof(jobject) );
        adat = (jdouble **) malloc( nx * sizeof(jdouble *) );
        
        for( i=0; i < nx; i++ )
        {
            ai[i] = (*jenv)->GetObjectArrayElement( jenv, jarg10, i );
            adat[i] = (*jenv)->GetDoubleArrayElements( jenv, ai[i], 0 );
            
            if (ny == -1)
            ny = (*jenv)->GetArrayLength( jenv, ai[i] );
            else if (ny != (*jenv)->GetArrayLength( jenv, ai[i] )) {
                printf( "Misshapen a array.\n" );
                for( j=0; j <= i; j++ )
                (*jenv)->ReleaseDoubleArrayElements( jenv, ai[j], adat[j], 0 );
                free(adat);
                free(ai);
                return;
            }
        }
        
        if( !((nx == Xlen && ny == Ylen) || (nx == Xlen && ny == 1))) {
            printf( "Xlen = %d, nx = %d, Ylen = %d, ny = %d\n", Xlen, nx, Ylen, ny );
            printf( "X vector or matrix must match matrix dimensions.\n" );
            for( i=0; i < nx; i++ )
            (*jenv)->ReleaseDoubleArrayElements( jenv, ai[i], adat[i], 0 );
            free(adat);
            free(ai);
            return;
        }
        /* Store whether second dimension is unity. */
        Alen = ny;
        setup_array_2d_d( &xg, adat, nx, ny );
        for( i=0; i < nx; i++ ) {
            (*jenv)->ReleaseDoubleArrayElements( jenv, ai[i], adat[i], 0 );
            (*jenv)->DeleteLocalRef(jenv, ai[i]);
        }
        
        free(adat);
        free(ai);
        arg10 = pltr2;
        
    }
    {
        jdouble **adat;
        jobject *ai;
        int nx = (*jenv)->GetArrayLength( jenv, jarg11 );
        int ny = -1;
        int i, j;
        PLcGrid2 cgrid;
        ai = (jobject *) malloc( nx * sizeof(jobject) );
        adat = (jdouble **) malloc( nx * sizeof(jdouble *) );
        
        for( i=0; i < nx; i++ )
        {
            ai[i] = (*jenv)->GetObjectArrayElement( jenv, jarg11, i );
            adat[i] = (*jenv)->GetDoubleArrayElements( jenv, ai[i], 0 );
            
            if (ny == -1)
            ny = (*jenv)->GetArrayLength( jenv, ai[i] );
            else if (ny != (*jenv)->GetArrayLength( jenv, ai[i] )) {
                printf( "Misshapen a array.\n" );
                for( j=0; j <= i; j++ )
                (*jenv)->ReleaseDoubleArrayElements( jenv, ai[j], adat[j], 0 );
                free(adat);
                free(ai);
                return;
            }
        }
        
        if( !((nx == Xlen && ny == Ylen) || (nx == Ylen && ny == 1 && ny == Alen))) {
            printf( "Xlen = %d, nx = %d, Ylen = %d, Alen = %d, ny = %d\n",
            Xlen, nx, Ylen, Alen, ny );
            printf( "Y vector or matrix must match matrix dimensions.\n" );
            for( i=0; i < nx; i++ )
            (*jenv)->ReleaseDoubleArrayElements( jenv, ai[i], adat[i], 0 );
            free(adat);
            free(ai);
            return;
        }
        setup_array_2d_d( &yg, adat, nx, ny );
        for( i=0; i < nx; i++ ) {
            (*jenv)->ReleaseDoubleArrayElements( jenv, ai[i], adat[i], 0 );
            (*jenv)->DeleteLocalRef(jenv, ai[i]);
        }
        
        free(adat);
        free(ai);
        cgrid.xg = xg;
        cgrid.yg = yg;
        cgrid.nx = nx;
        cgrid.ny = ny;
        arg11 = &cgrid;
        
    }
    plcont(arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8,arg9,arg10,arg11);
    
    {
        free(arg1[0]);
        free(arg1);
    }
    {
        free(arg8);
    }
    {
        free(xg[0]);
        free(xg);
    }
    {
        free(yg[0]);
        free(yg);
    }
}


#define _doc_plcpstrm "Copy state parameters from the reference stream to the current stream." 
JNIEXPORT void JNICALL Java_plplot_core_plplotjavacJNI_plcpstrm(JNIEnv *jenv, jclass jcls, jint jarg1, jint jarg2) {
    PLINT arg1 ;
    PLINT arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = (PLINT)jarg1; 
    arg2 = (PLINT)jarg2; 
    plcpstrm(arg1,arg2);
    
}


#define _doc_plend "End a plotting session for all open streams." 
JNIEXPORT void JNICALL Java_plplot_core_plplotjavacJNI_plend(JNIEnv *jenv, jclass jcls) {
    (void)jenv;
    (void)jcls;
    plend();
    
}


#define _doc_plend1 "End a plotting session for the current stream only." 
JNIEXPORT void JNICALL Java_plplot_core_plplotjavacJNI_plend1(JNIEnv *jenv, jclass jcls) {
    (void)jenv;
    (void)jcls;
    plend1();
    
}


#define _doc_plenv "Simple interface for defining viewport and window." 
JNIEXPORT void JNICALL Java_plplot_core_plplotjavacJNI_plenv(JNIEnv *jenv, jclass jcls, jdouble jarg1, jdouble jarg2, jdouble jarg3, jdouble jarg4, jint jarg5, jint jarg6) {
    PLFLT arg1 ;
    PLFLT arg2 ;
    PLFLT arg3 ;
    PLFLT arg4 ;
    PLINT arg5 ;
    PLINT arg6 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = (PLFLT)jarg1; 
    arg2 = (PLFLT)jarg2; 
    arg3 = (PLFLT)jarg3; 
    arg4 = (PLFLT)jarg4; 
    arg5 = (PLINT)jarg5; 
    arg6 = (PLINT)jarg6; 
    plenv(arg1,arg2,arg3,arg4,arg5,arg6);
    
}


#define _doc_pleop "End current page.  Should only be used with plbop()." 
JNIEXPORT void JNICALL Java_plplot_core_plplotjavacJNI_pleop(JNIEnv *jenv, jclass jcls) {
    (void)jenv;
    (void)jcls;
    pleop();
    
}


#define _doc_plerrx "Plot horizontal error bars (xmin(i),y(i)) to (xmax(i),y(i))." 
JNIEXPORT void JNICALL Java_plplot_core_plplotjavacJNI_plerrx(JNIEnv *jenv, jclass jcls, jdoubleArray jarg1, jdoubleArray jarg3, jdoubleArray jarg4) {
    PLINT arg1 ;
    PLFLT *arg2 = (PLFLT *) 0 ;
    PLFLT *arg3 = (PLFLT *) 0 ;
    PLFLT *arg4 = (PLFLT *) 0 ;
    
    (void)jenv;
    (void)jcls;
    {
        jdouble *jxdata = (*jenv)->GetDoubleArrayElements( jenv, jarg1, 0 );
        arg1 = (*jenv)->GetArrayLength( jenv, jarg1);
        Alen = arg1;
        setup_array_1d_d( &arg2, jxdata, Alen );
        /* Could find no easy way to do this as part of freearg so I modified
            * the previous function so it ALWAYS mallocs and copies so that
            * the java array can be released immediately. */
        (*jenv)->ReleaseDoubleArrayElements( jenv, jarg1, jxdata, 0 );
    }
    {
        jdouble *jydata = (*jenv)->GetDoubleArrayElements( jenv, jarg3, 0 );
        if((*jenv)->GetArrayLength( jenv, jarg3 ) != Alen) {
            printf("Vectors must be same length.\n");
            return;
        }
        setup_array_1d_d( &arg3, jydata, Alen );
        (*jenv)->ReleaseDoubleArrayElements( jenv, jarg3, jydata, 0 );
    }
    {
        jdouble *jydata = (*jenv)->GetDoubleArrayElements( jenv, jarg4, 0 );
        if((*jenv)->GetArrayLength( jenv, jarg4 ) != Alen) {
            printf("Vectors must be same length.\n");
            return;
        }
        setup_array_1d_d( &arg4, jydata, Alen );
        (*jenv)->ReleaseDoubleArrayElements( jenv, jarg4, jydata, 0 );
    }
    plerrx(arg1,arg2,arg3,arg4);
    
    {
        free(arg2);
    }
    {
        free(arg3);
    }
    {
        free(arg4);
    }
}


#define _doc_plerry "Plot vertical error bars (x,ymin(i)) to (x(i),ymax(i))." 
JNIEXPORT void JNICALL Java_plplot_core_plplotjavacJNI_plerry(JNIEnv *jenv, jclass jcls, jdoubleArray jarg1, jdoubleArray jarg3, jdoubleArray jarg4) {
    PLINT arg1 ;
    PLFLT *arg2 = (PLFLT *) 0 ;
    PLFLT *arg3 = (PLFLT *) 0 ;
    PLFLT *arg4 = (PLFLT *) 0 ;
    
    (void)jenv;
    (void)jcls;
    {
        jdouble *jxdata = (*jenv)->GetDoubleArrayElements( jenv, jarg1, 0 );
        arg1 = (*jenv)->GetArrayLength( jenv, jarg1);
        Alen = arg1;
        setup_array_1d_d( &arg2, jxdata, Alen );
        /* Could find no easy way to do this as part of freearg so I modified
            * the previous function so it ALWAYS mallocs and copies so that
            * the java array can be released immediately. */
        (*jenv)->ReleaseDoubleArrayElements( jenv, jarg1, jxdata, 0 );
    }
    {
        jdouble *jydata = (*jenv)->GetDoubleArrayElements( jenv, jarg3, 0 );
        if((*jenv)->GetArrayLength( jenv, jarg3 ) != Alen) {
            printf("Vectors must be same length.\n");
            return;
        }
        setup_array_1d_d( &arg3, jydata, Alen );
        (*jenv)->ReleaseDoubleArrayElements( jenv, jarg3, jydata, 0 );
    }
    {
        jdouble *jydata = (*jenv)->GetDoubleArrayElements( jenv, jarg4, 0 );
        if((*jenv)->GetArrayLength( jenv, jarg4 ) != Alen) {
            printf("Vectors must be same length.\n");
            return;
        }
        setup_array_1d_d( &arg4, jydata, Alen );
        (*jenv)->ReleaseDoubleArrayElements( jenv, jarg4, jydata, 0 );
    }
    plerry(arg1,arg2,arg3,arg4);
    
    {
        free(arg2);
    }
    {
        free(arg3);
    }
    {
        free(arg4);
    }
}


#define _doc_plfamadv "Advance to the next family file on the next new page." 
JNIEXPORT void JNICALL Java_plplot_core_plplotjavacJNI_plfamadv(JNIEnv *jenv, jclass jcls) {
    (void)jenv;
    (void)jcls;
    plfamadv();
    
}


#define _doc_plfill "Pattern fills the polygon bounded by the input points." 
JNIEXPORT void JNICALL Java_plplot_core_plplotjavacJNI_plfill(JNIEnv *jenv, jclass jcls, jdoubleArray jarg1, jdoubleArray jarg3) {
    PLINT arg1 ;
    PLFLT *arg2 = (PLFLT *) 0 ;
    PLFLT *arg3 = (PLFLT *) 0 ;
    
    (void)jenv;
    (void)jcls;
    {
        jdouble *jxdata = (*jenv)->GetDoubleArrayElements( jenv, jarg1, 0 );
        arg1 = (*jenv)->GetArrayLength( jenv, jarg1);
        Alen = arg1;
        setup_array_1d_d( &arg2, jxdata, Alen );
        /* Could find no easy way to do this as part of freearg so I modified
            * the previous function so it ALWAYS mallocs and copies so that
            * the java array can be released immediately. */
        (*jenv)->ReleaseDoubleArrayElements( jenv, jarg1, jxdata, 0 );
    }
    {
        jdouble *jydata = (*jenv)->GetDoubleArrayElements( jenv, jarg3, 0 );
        if((*jenv)->GetArrayLength( jenv, jarg3 ) != Alen) {
            printf("Vectors must be same length.\n");
            return;
        }
        setup_array_1d_d( &arg3, jydata, Alen );
        (*jenv)->ReleaseDoubleArrayElements( jenv, jarg3, jydata, 0 );
    }
    plfill(arg1,arg2,arg3);
    
    {
        free(arg2);
    }
    {
        free(arg3);
    }
}


#define _doc_plfill3 "Pattern fills the 3d polygon bounded by the input points." 
JNIEXPORT void JNICALL Java_plplot_core_plplotjavacJNI_plfill3(JNIEnv *jenv, jclass jcls, jdoubleArray jarg1, jdoubleArray jarg3, jdoubleArray jarg4) {
    PLINT arg1 ;
    PLFLT *arg2 = (PLFLT *) 0 ;
    PLFLT *arg3 = (PLFLT *) 0 ;
    PLFLT *arg4 = (PLFLT *) 0 ;
    
    (void)jenv;
    (void)jcls;
    {
        jdouble *jxdata = (*jenv)->GetDoubleArrayElements( jenv, jarg1, 0 );
        arg1 = (*jenv)->GetArrayLength( jenv, jarg1);
        Alen = arg1;
        setup_array_1d_d( &arg2, jxdata, Alen );
        /* Could find no easy way to do this as part of freearg so I modified
            * the previous function so it ALWAYS mallocs and copies so that
            * the java array can be released immediately. */
        (*jenv)->ReleaseDoubleArrayElements( jenv, jarg1, jxdata, 0 );
    }
    {
        jdouble *jydata = (*jenv)->GetDoubleArrayElements( jenv, jarg3, 0 );
        if((*jenv)->GetArrayLength( jenv, jarg3 ) != Alen) {
            printf("Vectors must be same length.\n");
            return;
        }
        setup_array_1d_d( &arg3, jydata, Alen );
        (*jenv)->ReleaseDoubleArrayElements( jenv, jarg3, jydata, 0 );
    }
    {
        jdouble *jydata = (*jenv)->GetDoubleArrayElements( jenv, jarg4, 0 );
        if((*jenv)->GetArrayLength( jenv, jarg4 ) != Alen) {
            printf("Vectors must be same length.\n");
            return;
        }
        setup_array_1d_d( &arg4, jydata, Alen );
        (*jenv)->ReleaseDoubleArrayElements( jenv, jarg4, jydata, 0 );
    }
    plfill3(arg1,arg2,arg3,arg4);
    
    {
        free(arg2);
    }
    {
        free(arg3);
    }
    {
        free(arg4);
    }
}


#define _doc_plflush "Flush the output stream.  Use sparingly, if at all." 
JNIEXPORT void JNICALL Java_plplot_core_plplotjavacJNI_plflush(JNIEnv *jenv, jclass jcls) {
    (void)jenv;
    (void)jcls;
    plflush();
    
}


#define _doc_plfont "Set the global font flag to 'ifont'." 
JNIEXPORT void JNICALL Java_plplot_core_plplotjavacJNI_plfont(JNIEnv *jenv, jclass jcls, jint jarg1) {
    PLINT arg1 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = (PLINT)jarg1; 
    plfont(arg1);
    
}


#define _doc_plfontld "Load specified font set." 
JNIEXPORT void JNICALL Java_plplot_core_plplotjavacJNI_plfontld(JNIEnv *jenv, jclass jcls, jint jarg1) {
    PLINT arg1 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = (PLINT)jarg1; 
    plfontld(arg1);
    
}


#define _doc_plgchr "Get character default height and current (scaled) height." 
JNIEXPORT void JNICALL Java_plplot_core_plplotjavacJNI_plgchr(JNIEnv *jenv, jclass jcls, jdoubleArray jarg1, jdoubleArray jarg2) {
    PLFLT *arg1 = (PLFLT *) 0 ;
    PLFLT *arg2 = (PLFLT *) 0 ;
    PLFLT temp1 ;
    PLFLT temp2 ;
    
    (void)jenv;
    (void)jcls;
    {
        if (!jarg1) {
            SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "array null");
            return ;
        }
        if ((*jenv)->GetArrayLength(jenv, jarg1) == 0) {
            SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, "Array must contain at least 1 element");
            return ;
        }
        arg1 = &temp1; 
    }
    {
        if (!jarg2) {
            SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "array null");
            return ;
        }
        if ((*jenv)->GetArrayLength(jenv, jarg2) == 0) {
            SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, "Array must contain at least 1 element");
            return ;
        }
        arg2 = &temp2; 
    }
    plgchr(arg1,arg2);
    
    {
        jdouble jvalue = (jdouble)temp1;
        (*jenv)->SetDoubleArrayRegion(jenv, jarg1, 0, 1, &jvalue);
    }
    {
        jdouble jvalue = (jdouble)temp2;
        (*jenv)->SetDoubleArrayRegion(jenv, jarg2, 0, 1, &jvalue);
    }
}


#define _doc_plgcol0 "Get 8 bit RGB values for given color from color map 0." 
JNIEXPORT void JNICALL Java_plplot_core_plplotjavacJNI_plgcol0(JNIEnv *jenv, jclass jcls, jint jarg1, jintArray jarg2, jintArray jarg3, jintArray jarg4) {
    PLINT arg1 ;
    PLINT *arg2 = (PLINT *) 0 ;
    PLINT *arg3 = (PLINT *) 0 ;
    PLINT *arg4 = (PLINT *) 0 ;
    PLINT temp2 ;
    PLINT temp3 ;
    PLINT temp4 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = (PLINT)jarg1; 
    {
        if (!jarg2) {
            SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "array null");
            return ;
        }
        if ((*jenv)->GetArrayLength(jenv, jarg2) == 0) {
            SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, "Array must contain at least 1 element");
            return ;
        }
        arg2 = &temp2; 
    }
    {
        if (!jarg3) {
            SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "array null");
            return ;
        }
        if ((*jenv)->GetArrayLength(jenv, jarg3) == 0) {
            SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, "Array must contain at least 1 element");
            return ;
        }
        arg3 = &temp3; 
    }
    {
        if (!jarg4) {
            SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "array null");
            return ;
        }
        if ((*jenv)->GetArrayLength(jenv, jarg4) == 0) {
            SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, "Array must contain at least 1 element");
            return ;
        }
        arg4 = &temp4; 
    }
    plgcol0(arg1,arg2,arg3,arg4);
    
    {
        jint jvalue = (jint)temp2;
        (*jenv)->SetIntArrayRegion(jenv, jarg2, 0, 1, &jvalue);
    }
    {
        jint jvalue = (jint)temp3;
        (*jenv)->SetIntArrayRegion(jenv, jarg3, 0, 1, &jvalue);
    }
    {
        jint jvalue = (jint)temp4;
        (*jenv)->SetIntArrayRegion(jenv, jarg4, 0, 1, &jvalue);
    }
}


#define _doc_plgcolbg "Get 8-bit RGB background color." 
JNIEXPORT void JNICALL Java_plplot_core_plplotjavacJNI_plgcolbg(JNIEnv *jenv, jclass jcls, jintArray jarg1, jintArray jarg2, jintArray jarg3) {
    PLINT *arg1 = (PLINT *) 0 ;
    PLINT *arg2 = (PLINT *) 0 ;
    PLINT *arg3 = (PLINT *) 0 ;
    PLINT temp1 ;
    PLINT temp2 ;
    PLINT temp3 ;
    
    (void)jenv;
    (void)jcls;
    {
        if (!jarg1) {
            SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "array null");
            return ;
        }
        if ((*jenv)->GetArrayLength(jenv, jarg1) == 0) {
            SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, "Array must contain at least 1 element");
            return ;
        }
        arg1 = &temp1; 
    }
    {
        if (!jarg2) {
            SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "array null");
            return ;
        }
        if ((*jenv)->GetArrayLength(jenv, jarg2) == 0) {
            SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, "Array must contain at least 1 element");
            return ;
        }
        arg2 = &temp2; 
    }
    {
        if (!jarg3) {
            SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "array null");
            return ;
        }
        if ((*jenv)->GetArrayLength(jenv, jarg3) == 0) {
            SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, "Array must contain at least 1 element");
            return ;
        }
        arg3 = &temp3; 
    }
    plgcolbg(arg1,arg2,arg3);
    
    {
        jint jvalue = (jint)temp1;
        (*jenv)->SetIntArrayRegion(jenv, jarg1, 0, 1, &jvalue);
    }
    {
        jint jvalue = (jint)temp2;
        (*jenv)->SetIntArrayRegion(jenv, jarg2, 0, 1, &jvalue);
    }
    {
        jint jvalue = (jint)temp3;
        (*jenv)->SetIntArrayRegion(jenv, jarg3, 0, 1, &jvalue);
    }
}


#define _doc_plgcompression "Get the current compression setting." 
JNIEXPORT void JNICALL Java_plplot_core_plplotjavacJNI_plgcompression(JNIEnv *jenv, jclass jcls, jintArray jarg1) {
    PLINT *arg1 = (PLINT *) 0 ;
    PLINT temp1 ;
    
    (void)jenv;
    (void)jcls;
    {
        if (!jarg1) {
            SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "array null");
            return ;
        }
        if ((*jenv)->GetArrayLength(jenv, jarg1) == 0) {
            SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, "Array must contain at least 1 element");
            return ;
        }
        arg1 = &temp1; 
    }
    plgcompression(arg1);
    
    {
        jint jvalue = (jint)temp1;
        (*jenv)->SetIntArrayRegion(jenv, jarg1, 0, 1, &jvalue);
    }
}


#define _doc_plgdev "Get the current device (keyword) name." 
JNIEXPORT void JNICALL Java_plplot_core_plplotjavacJNI_plgdev(JNIEnv *jenv, jclass jcls, jobject jarg1) {
    char *arg1 ;
    
    (void)jenv;
    (void)jcls;
    {
        arg1 = NULL;
        if(jarg1 != NULL) {
            /* Get the String from the StringBuffer */
            jmethodID setLengthID;
            jclass sbufClass = (*jenv)->GetObjectClass(jenv, jarg1);
            jmethodID toStringID = (*jenv)->GetMethodID(jenv, sbufClass, "toString", "()Ljava/lang/String;");
            jstring js = (jstring) (*jenv)->CallObjectMethod(jenv, jarg1, toStringID);
            
            /* Convert the String to a C string */
            const char *pCharStr = (*jenv)->GetStringUTFChars(jenv, js, 0);
            
            /* Take a copy of the C string as the typemap is for a non const C string */
            jmethodID capacityID = (*jenv)->GetMethodID(jenv, sbufClass, "capacity", "()I");
            jint capacity = (*jenv)->CallIntMethod(jenv, jarg1, capacityID);
            arg1 = (char *) malloc(capacity+1);
            strcpy(arg1, pCharStr);
            
            /* Release the UTF string we obtained with GetStringUTFChars */
            (*jenv)->ReleaseStringUTFChars(jenv,  js, pCharStr);
            
            /* Zero the original StringBuffer, so we can replace it with the result */
            setLengthID = (*jenv)->GetMethodID(jenv, sbufClass, "setLength", "(I)V");
            (*jenv)->CallVoidMethod(jenv, jarg1, setLengthID, (jint) 0);
        }
    }
    plgdev(arg1);
    
    {
        if(arg1 != NULL) {
            /* Append the result to the empty StringBuffer */
            jstring newString = (*jenv)->NewStringUTF(jenv, arg1);
            jclass sbufClass = (*jenv)->GetObjectClass(jenv, jarg1);
            jmethodID appendStringID = (*jenv)->GetMethodID(jenv, sbufClass, "append", "(Ljava/lang/String;)Ljava/lang/StringBuffer;");
            (*jenv)->CallObjectMethod(jenv, jarg1, appendStringID, newString);
            
            /* Clean up the string object, no longer needed */
            free(arg1);
            arg1 = NULL;
        }
    }
    
}


#define _doc_plgdidev "Retrieve current window into device space." 
JNIEXPORT void JNICALL Java_plplot_core_plplotjavacJNI_plgdidev(JNIEnv *jenv, jclass jcls, jdoubleArray jarg1, jdoubleArray jarg2, jdoubleArray jarg3, jdoubleArray jarg4) {
    PLFLT *arg1 = (PLFLT *) 0 ;
    PLFLT *arg2 = (PLFLT *) 0 ;
    PLFLT *arg3 = (PLFLT *) 0 ;
    PLFLT *arg4 = (PLFLT *) 0 ;
    PLFLT temp1 ;
    PLFLT temp2 ;
    PLFLT temp3 ;
    PLFLT temp4 ;
    
    (void)jenv;
    (void)jcls;
    {
        if (!jarg1) {
            SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "array null");
            return ;
        }
        if ((*jenv)->GetArrayLength(jenv, jarg1) == 0) {
            SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, "Array must contain at least 1 element");
            return ;
        }
        arg1 = &temp1; 
    }
    {
        if (!jarg2) {
            SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "array null");
            return ;
        }
        if ((*jenv)->GetArrayLength(jenv, jarg2) == 0) {
            SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, "Array must contain at least 1 element");
            return ;
        }
        arg2 = &temp2; 
    }
    {
        if (!jarg3) {
            SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "array null");
            return ;
        }
        if ((*jenv)->GetArrayLength(jenv, jarg3) == 0) {
            SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, "Array must contain at least 1 element");
            return ;
        }
        arg3 = &temp3; 
    }
    {
        if (!jarg4) {
            SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "array null");
            return ;
        }
        if ((*jenv)->GetArrayLength(jenv, jarg4) == 0) {
            SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, "Array must contain at least 1 element");
            return ;
        }
        arg4 = &temp4; 
    }
    plgdidev(arg1,arg2,arg3,arg4);
    
    {
        jdouble jvalue = (jdouble)temp1;
        (*jenv)->SetDoubleArrayRegion(jenv, jarg1, 0, 1, &jvalue);
    }
    {
        jdouble jvalue = (jdouble)temp2;
        (*jenv)->SetDoubleArrayRegion(jenv, jarg2, 0, 1, &jvalue);
    }
    {
        jdouble jvalue = (jdouble)temp3;
        (*jenv)->SetDoubleArrayRegion(jenv, jarg3, 0, 1, &jvalue);
    }
    {
        jdouble jvalue = (jdouble)temp4;
        (*jenv)->SetDoubleArrayRegion(jenv, jarg4, 0, 1, &jvalue);
    }
}


#define _doc_plgdiori "Get plot orientation." 
JNIEXPORT void JNICALL Java_plplot_core_plplotjavacJNI_plgdiori(JNIEnv *jenv, jclass jcls, jdoubleArray jarg1) {
    PLFLT *arg1 = (PLFLT *) 0 ;
    PLFLT temp1 ;
    
    (void)jenv;
    (void)jcls;
    {
        if (!jarg1) {
            SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "array null");
            return ;
        }
        if ((*jenv)->GetArrayLength(jenv, jarg1) == 0) {
            SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, "Array must contain at least 1 element");
            return ;
        }
        arg1 = &temp1; 
    }
    plgdiori(arg1);
    
    {
        jdouble jvalue = (jdouble)temp1;
        (*jenv)->SetDoubleArrayRegion(jenv, jarg1, 0, 1, &jvalue);
    }
}


#define _doc_plgdiplt "Retrieve current window into plot space." 
JNIEXPORT void JNICALL Java_plplot_core_plplotjavacJNI_plgdiplt(JNIEnv *jenv, jclass jcls, jdoubleArray jarg1, jdoubleArray jarg2, jdoubleArray jarg3, jdoubleArray jarg4) {
    PLFLT *arg1 = (PLFLT *) 0 ;
    PLFLT *arg2 = (PLFLT *) 0 ;
    PLFLT *arg3 = (PLFLT *) 0 ;
    PLFLT *arg4 = (PLFLT *) 0 ;
    PLFLT temp1 ;
    PLFLT temp2 ;
    PLFLT temp3 ;
    PLFLT temp4 ;
    
    (void)jenv;
    (void)jcls;
    {
        if (!jarg1) {
            SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "array null");
            return ;
        }
        if ((*jenv)->GetArrayLength(jenv, jarg1) == 0) {
            SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, "Array must contain at least 1 element");
            return ;
        }
        arg1 = &temp1; 
    }
    {
        if (!jarg2) {
            SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "array null");
            return ;
        }
        if ((*jenv)->GetArrayLength(jenv, jarg2) == 0) {
            SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, "Array must contain at least 1 element");
            return ;
        }
        arg2 = &temp2; 
    }
    {
        if (!jarg3) {
            SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "array null");
            return ;
        }
        if ((*jenv)->GetArrayLength(jenv, jarg3) == 0) {
            SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, "Array must contain at least 1 element");
            return ;
        }
        arg3 = &temp3; 
    }
    {
        if (!jarg4) {
            SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "array null");
            return ;
        }
        if ((*jenv)->GetArrayLength(jenv, jarg4) == 0) {
            SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, "Array must contain at least 1 element");
            return ;
        }
        arg4 = &temp4; 
    }
    plgdiplt(arg1,arg2,arg3,arg4);
    
    {
        jdouble jvalue = (jdouble)temp1;
        (*jenv)->SetDoubleArrayRegion(jenv, jarg1, 0, 1, &jvalue);
    }
    {
        jdouble jvalue = (jdouble)temp2;
        (*jenv)->SetDoubleArrayRegion(jenv, jarg2, 0, 1, &jvalue);
    }
    {
        jdouble jvalue = (jdouble)temp3;
        (*jenv)->SetDoubleArrayRegion(jenv, jarg3, 0, 1, &jvalue);
    }
    {
        jdouble jvalue = (jdouble)temp4;
        (*jenv)->SetDoubleArrayRegion(jenv, jarg4, 0, 1, &jvalue);
    }
}


#define _doc_plgfam "Get family file parameters." 
JNIEXPORT void JNICALL Java_plplot_core_plplotjavacJNI_plgfam(JNIEnv *jenv, jclass jcls, jintArray jarg1, jintArray jarg2, jintArray jarg3) {
    PLINT *arg1 = (PLINT *) 0 ;
    PLINT *arg2 = (PLINT *) 0 ;
    PLINT *arg3 = (PLINT *) 0 ;
    PLINT temp1 ;
    PLINT temp2 ;
    PLINT temp3 ;
    
    (void)jenv;
    (void)jcls;
    {
        if (!jarg1) {
            SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "array null");
            return ;
        }
        if ((*jenv)->GetArrayLength(jenv, jarg1) == 0) {
            SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, "Array must contain at least 1 element");
            return ;
        }
        arg1 = &temp1; 
    }
    {
        if (!jarg2) {
            SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "array null");
            return ;
        }
        if ((*jenv)->GetArrayLength(jenv, jarg2) == 0) {
            SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, "Array must contain at least 1 element");
            return ;
        }
        arg2 = &temp2; 
    }
    {
        if (!jarg3) {
            SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "array null");
            return ;
        }
        if ((*jenv)->GetArrayLength(jenv, jarg3) == 0) {
            SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, "Array must contain at least 1 element");
            return ;
        }
        arg3 = &temp3; 
    }
    plgfam(arg1,arg2,arg3);
    
    {
        jint jvalue = (jint)temp1;
        (*jenv)->SetIntArrayRegion(jenv, jarg1, 0, 1, &jvalue);
    }
    {
        jint jvalue = (jint)temp2;
        (*jenv)->SetIntArrayRegion(jenv, jarg2, 0, 1, &jvalue);
    }
    {
        jint jvalue = (jint)temp3;
        (*jenv)->SetIntArrayRegion(jenv, jarg3, 0, 1, &jvalue);
    }
}


#define _doc_plgfnam "Get the (current) output file name." 
JNIEXPORT void JNICALL Java_plplot_core_plplotjavacJNI_plgfnam(JNIEnv *jenv, jclass jcls, jobject jarg1) {
    char *arg1 ;
    
    (void)jenv;
    (void)jcls;
    {
        arg1 = NULL;
        if(jarg1 != NULL) {
            /* Get the String from the StringBuffer */
            jmethodID setLengthID;
            jclass sbufClass = (*jenv)->GetObjectClass(jenv, jarg1);
            jmethodID toStringID = (*jenv)->GetMethodID(jenv, sbufClass, "toString", "()Ljava/lang/String;");
            jstring js = (jstring) (*jenv)->CallObjectMethod(jenv, jarg1, toStringID);
            
            /* Convert the String to a C string */
            const char *pCharStr = (*jenv)->GetStringUTFChars(jenv, js, 0);
            
            /* Take a copy of the C string as the typemap is for a non const C string */
            jmethodID capacityID = (*jenv)->GetMethodID(jenv, sbufClass, "capacity", "()I");
            jint capacity = (*jenv)->CallIntMethod(jenv, jarg1, capacityID);
            arg1 = (char *) malloc(capacity+1);
            strcpy(arg1, pCharStr);
            
            /* Release the UTF string we obtained with GetStringUTFChars */
            (*jenv)->ReleaseStringUTFChars(jenv,  js, pCharStr);
            
            /* Zero the original StringBuffer, so we can replace it with the result */
            setLengthID = (*jenv)->GetMethodID(jenv, sbufClass, "setLength", "(I)V");
            (*jenv)->CallVoidMethod(jenv, jarg1, setLengthID, (jint) 0);
        }
    }
    plgfnam(arg1);
    
    {
        if(arg1 != NULL) {
            /* Append the result to the empty StringBuffer */
            jstring newString = (*jenv)->NewStringUTF(jenv, arg1);
            jclass sbufClass = (*jenv)->GetObjectClass(jenv, jarg1);
            jmethodID appendStringID = (*jenv)->GetMethodID(jenv, sbufClass, "append", "(Ljava/lang/String;)Ljava/lang/StringBuffer;");
            (*jenv)->CallObjectMethod(jenv, jarg1, appendStringID, newString);
            
            /* Clean up the string object, no longer needed */
            free(arg1);
            arg1 = NULL;
        }
    }
    
}


#define _doc_plglevel "Get the (current) run level." 
JNIEXPORT void JNICALL Java_plplot_core_plplotjavacJNI_plglevel(JNIEnv *jenv, jclass jcls, jintArray jarg1) {
    PLINT *arg1 = (PLINT *) 0 ;
    PLINT temp1 ;
    
    (void)jenv;
    (void)jcls;
    {
        if (!jarg1) {
            SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "array null");
            return ;
        }
        if ((*jenv)->GetArrayLength(jenv, jarg1) == 0) {
            SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, "Array must contain at least 1 element");
            return ;
        }
        arg1 = &temp1; 
    }
    plglevel(arg1);
    
    {
        jint jvalue = (jint)temp1;
        (*jenv)->SetIntArrayRegion(jenv, jarg1, 0, 1, &jvalue);
    }
}


#define _doc_plgpage "Get output device parameters." 
JNIEXPORT void JNICALL Java_plplot_core_plplotjavacJNI_plgpage(JNIEnv *jenv, jclass jcls, jdoubleArray jarg1, jdoubleArray jarg2, jintArray jarg3, jintArray jarg4, jintArray jarg5, jintArray jarg6) {
    PLFLT *arg1 = (PLFLT *) 0 ;
    PLFLT *arg2 = (PLFLT *) 0 ;
    PLINT *arg3 = (PLINT *) 0 ;
    PLINT *arg4 = (PLINT *) 0 ;
    PLINT *arg5 = (PLINT *) 0 ;
    PLINT *arg6 = (PLINT *) 0 ;
    PLFLT temp1 ;
    PLFLT temp2 ;
    PLINT temp3 ;
    PLINT temp4 ;
    PLINT temp5 ;
    PLINT temp6 ;
    
    (void)jenv;
    (void)jcls;
    {
        if (!jarg1) {
            SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "array null");
            return ;
        }
        if ((*jenv)->GetArrayLength(jenv, jarg1) == 0) {
            SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, "Array must contain at least 1 element");
            return ;
        }
        arg1 = &temp1; 
    }
    {
        if (!jarg2) {
            SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "array null");
            return ;
        }
        if ((*jenv)->GetArrayLength(jenv, jarg2) == 0) {
            SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, "Array must contain at least 1 element");
            return ;
        }
        arg2 = &temp2; 
    }
    {
        if (!jarg3) {
            SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "array null");
            return ;
        }
        if ((*jenv)->GetArrayLength(jenv, jarg3) == 0) {
            SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, "Array must contain at least 1 element");
            return ;
        }
        arg3 = &temp3; 
    }
    {
        if (!jarg4) {
            SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "array null");
            return ;
        }
        if ((*jenv)->GetArrayLength(jenv, jarg4) == 0) {
            SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, "Array must contain at least 1 element");
            return ;
        }
        arg4 = &temp4; 
    }
    {
        if (!jarg5) {
            SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "array null");
            return ;
        }
        if ((*jenv)->GetArrayLength(jenv, jarg5) == 0) {
            SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, "Array must contain at least 1 element");
            return ;
        }
        arg5 = &temp5; 
    }
    {
        if (!jarg6) {
            SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "array null");
            return ;
        }
        if ((*jenv)->GetArrayLength(jenv, jarg6) == 0) {
            SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, "Array must contain at least 1 element");
            return ;
        }
        arg6 = &temp6; 
    }
    plgpage(arg1,arg2,arg3,arg4,arg5,arg6);
    
    {
        jdouble jvalue = (jdouble)temp1;
        (*jenv)->SetDoubleArrayRegion(jenv, jarg1, 0, 1, &jvalue);
    }
    {
        jdouble jvalue = (jdouble)temp2;
        (*jenv)->SetDoubleArrayRegion(jenv, jarg2, 0, 1, &jvalue);
    }
    {
        jint jvalue = (jint)temp3;
        (*jenv)->SetIntArrayRegion(jenv, jarg3, 0, 1, &jvalue);
    }
    {
        jint jvalue = (jint)temp4;
        (*jenv)->SetIntArrayRegion(jenv, jarg4, 0, 1, &jvalue);
    }
    {
        jint jvalue = (jint)temp5;
        (*jenv)->SetIntArrayRegion(jenv, jarg5, 0, 1, &jvalue);
    }
    {
        jint jvalue = (jint)temp6;
        (*jenv)->SetIntArrayRegion(jenv, jarg6, 0, 1, &jvalue);
    }
}


#define _doc_plgra "Switch to graphics screen." 
JNIEXPORT void JNICALL Java_plplot_core_plplotjavacJNI_plgra(JNIEnv *jenv, jclass jcls) {
    (void)jenv;
    (void)jcls;
    plgra();
    
}


#define _doc_plgspa "Get subpage boundaries in absolute coordinates." 
JNIEXPORT void JNICALL Java_plplot_core_plplotjavacJNI_plgspa(JNIEnv *jenv, jclass jcls, jdoubleArray jarg1, jdoubleArray jarg2, jdoubleArray jarg3, jdoubleArray jarg4) {
    PLFLT *arg1 = (PLFLT *) 0 ;
    PLFLT *arg2 = (PLFLT *) 0 ;
    PLFLT *arg3 = (PLFLT *) 0 ;
    PLFLT *arg4 = (PLFLT *) 0 ;
    PLFLT temp1 ;
    PLFLT temp2 ;
    PLFLT temp3 ;
    PLFLT temp4 ;
    
    (void)jenv;
    (void)jcls;
    {
        if (!jarg1) {
            SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "array null");
            return ;
        }
        if ((*jenv)->GetArrayLength(jenv, jarg1) == 0) {
            SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, "Array must contain at least 1 element");
            return ;
        }
        arg1 = &temp1; 
    }
    {
        if (!jarg2) {
            SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "array null");
            return ;
        }
        if ((*jenv)->GetArrayLength(jenv, jarg2) == 0) {
            SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, "Array must contain at least 1 element");
            return ;
        }
        arg2 = &temp2; 
    }
    {
        if (!jarg3) {
            SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "array null");
            return ;
        }
        if ((*jenv)->GetArrayLength(jenv, jarg3) == 0) {
            SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, "Array must contain at least 1 element");
            return ;
        }
        arg3 = &temp3; 
    }
    {
        if (!jarg4) {
            SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "array null");
            return ;
        }
        if ((*jenv)->GetArrayLength(jenv, jarg4) == 0) {
            SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, "Array must contain at least 1 element");
            return ;
        }
        arg4 = &temp4; 
    }
    plgspa(arg1,arg2,arg3,arg4);
    
    {
        jdouble jvalue = (jdouble)temp1;
        (*jenv)->SetDoubleArrayRegion(jenv, jarg1, 0, 1, &jvalue);
    }
    {
        jdouble jvalue = (jdouble)temp2;
        (*jenv)->SetDoubleArrayRegion(jenv, jarg2, 0, 1, &jvalue);
    }
    {
        jdouble jvalue = (jdouble)temp3;
        (*jenv)->SetDoubleArrayRegion(jenv, jarg3, 0, 1, &jvalue);
    }
    {
        jdouble jvalue = (jdouble)temp4;
        (*jenv)->SetDoubleArrayRegion(jenv, jarg4, 0, 1, &jvalue);
    }
}


#define _doc_plgstrm "Get current stream number." 
JNIEXPORT void JNICALL Java_plplot_core_plplotjavacJNI_plgstrm(JNIEnv *jenv, jclass jcls, jintArray jarg1) {
    PLINT *arg1 = (PLINT *) 0 ;
    PLINT temp1 ;
    
    (void)jenv;
    (void)jcls;
    {
        if (!jarg1) {
            SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "array null");
            return ;
        }
        if ((*jenv)->GetArrayLength(jenv, jarg1) == 0) {
            SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, "Array must contain at least 1 element");
            return ;
        }
        arg1 = &temp1; 
    }
    plgstrm(arg1);
    
    {
        jint jvalue = (jint)temp1;
        (*jenv)->SetIntArrayRegion(jenv, jarg1, 0, 1, &jvalue);
    }
}


#define _doc_plgver "Get current library version number." 
JNIEXPORT void JNICALL Java_plplot_core_plplotjavacJNI_plgver(JNIEnv *jenv, jclass jcls, jobject jarg1) {
    char *arg1 ;
    
    (void)jenv;
    (void)jcls;
    {
        arg1 = NULL;
        if(jarg1 != NULL) {
            /* Get the String from the StringBuffer */
            jmethodID setLengthID;
            jclass sbufClass = (*jenv)->GetObjectClass(jenv, jarg1);
            jmethodID toStringID = (*jenv)->GetMethodID(jenv, sbufClass, "toString", "()Ljava/lang/String;");
            jstring js = (jstring) (*jenv)->CallObjectMethod(jenv, jarg1, toStringID);
            
            /* Convert the String to a C string */
            const char *pCharStr = (*jenv)->GetStringUTFChars(jenv, js, 0);
            
            /* Take a copy of the C string as the typemap is for a non const C string */
            jmethodID capacityID = (*jenv)->GetMethodID(jenv, sbufClass, "capacity", "()I");
            jint capacity = (*jenv)->CallIntMethod(jenv, jarg1, capacityID);
            arg1 = (char *) malloc(capacity+1);
            strcpy(arg1, pCharStr);
            
            /* Release the UTF string we obtained with GetStringUTFChars */
            (*jenv)->ReleaseStringUTFChars(jenv,  js, pCharStr);
            
            /* Zero the original StringBuffer, so we can replace it with the result */
            setLengthID = (*jenv)->GetMethodID(jenv, sbufClass, "setLength", "(I)V");
            (*jenv)->CallVoidMethod(jenv, jarg1, setLengthID, (jint) 0);
        }
    }
    plgver(arg1);
    
    {
        if(arg1 != NULL) {
            /* Append the result to the empty StringBuffer */
            jstring newString = (*jenv)->NewStringUTF(jenv, arg1);
            jclass sbufClass = (*jenv)->GetObjectClass(jenv, jarg1);
            jmethodID appendStringID = (*jenv)->GetMethodID(jenv, sbufClass, "append", "(Ljava/lang/String;)Ljava/lang/StringBuffer;");
            (*jenv)->CallObjectMethod(jenv, jarg1, appendStringID, newString);
            
            /* Clean up the string object, no longer needed */
            free(arg1);
            arg1 = NULL;
        }
    }
    
}


#define _doc_plgvpd "Get viewport boundaries in normalized device coordinates." 
JNIEXPORT void JNICALL Java_plplot_core_plplotjavacJNI_plgvpd(JNIEnv *jenv, jclass jcls, jdoubleArray jarg1, jdoubleArray jarg2, jdoubleArray jarg3, jdoubleArray jarg4) {
    PLFLT *arg1 = (PLFLT *) 0 ;
    PLFLT *arg2 = (PLFLT *) 0 ;
    PLFLT *arg3 = (PLFLT *) 0 ;
    PLFLT *arg4 = (PLFLT *) 0 ;
    PLFLT temp1 ;
    PLFLT temp2 ;
    PLFLT temp3 ;
    PLFLT temp4 ;
    
    (void)jenv;
    (void)jcls;
    {
        if (!jarg1) {
            SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "array null");
            return ;
        }
        if ((*jenv)->GetArrayLength(jenv, jarg1) == 0) {
            SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, "Array must contain at least 1 element");
            return ;
        }
        arg1 = &temp1; 
    }
    {
        if (!jarg2) {
            SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "array null");
            return ;
        }
        if ((*jenv)->GetArrayLength(jenv, jarg2) == 0) {
            SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, "Array must contain at least 1 element");
            return ;
        }
        arg2 = &temp2; 
    }
    {
        if (!jarg3) {
            SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "array null");
            return ;
        }
        if ((*jenv)->GetArrayLength(jenv, jarg3) == 0) {
            SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, "Array must contain at least 1 element");
            return ;
        }
        arg3 = &temp3; 
    }
    {
        if (!jarg4) {
            SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "array null");
            return ;
        }
        if ((*jenv)->GetArrayLength(jenv, jarg4) == 0) {
            SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, "Array must contain at least 1 element");
            return ;
        }
        arg4 = &temp4; 
    }
    plgvpd(arg1,arg2,arg3,arg4);
    
    {
        jdouble jvalue = (jdouble)temp1;
        (*jenv)->SetDoubleArrayRegion(jenv, jarg1, 0, 1, &jvalue);
    }
    {
        jdouble jvalue = (jdouble)temp2;
        (*jenv)->SetDoubleArrayRegion(jenv, jarg2, 0, 1, &jvalue);
    }
    {
        jdouble jvalue = (jdouble)temp3;
        (*jenv)->SetDoubleArrayRegion(jenv, jarg3, 0, 1, &jvalue);
    }
    {
        jdouble jvalue = (jdouble)temp4;
        (*jenv)->SetDoubleArrayRegion(jenv, jarg4, 0, 1, &jvalue);
    }
}


#define _doc_plgvpw "Get viewport boundaries in world coordinates." 
JNIEXPORT void JNICALL Java_plplot_core_plplotjavacJNI_plgvpw(JNIEnv *jenv, jclass jcls, jdoubleArray jarg1, jdoubleArray jarg2, jdoubleArray jarg3, jdoubleArray jarg4) {
    PLFLT *arg1 = (PLFLT *) 0 ;
    PLFLT *arg2 = (PLFLT *) 0 ;
    PLFLT *arg3 = (PLFLT *) 0 ;
    PLFLT *arg4 = (PLFLT *) 0 ;
    PLFLT temp1 ;
    PLFLT temp2 ;
    PLFLT temp3 ;
    PLFLT temp4 ;
    
    (void)jenv;
    (void)jcls;
    {
        if (!jarg1) {
            SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "array null");
            return ;
        }
        if ((*jenv)->GetArrayLength(jenv, jarg1) == 0) {
            SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, "Array must contain at least 1 element");
            return ;
        }
        arg1 = &temp1; 
    }
    {
        if (!jarg2) {
            SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "array null");
            return ;
        }
        if ((*jenv)->GetArrayLength(jenv, jarg2) == 0) {
            SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, "Array must contain at least 1 element");
            return ;
        }
        arg2 = &temp2; 
    }
    {
        if (!jarg3) {
            SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "array null");
            return ;
        }
        if ((*jenv)->GetArrayLength(jenv, jarg3) == 0) {
            SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, "Array must contain at least 1 element");
            return ;
        }
        arg3 = &temp3; 
    }
    {
        if (!jarg4) {
            SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "array null");
            return ;
        }
        if ((*jenv)->GetArrayLength(jenv, jarg4) == 0) {
            SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, "Array must contain at least 1 element");
            return ;
        }
        arg4 = &temp4; 
    }
    plgvpw(arg1,arg2,arg3,arg4);
    
    {
        jdouble jvalue = (jdouble)temp1;
        (*jenv)->SetDoubleArrayRegion(jenv, jarg1, 0, 1, &jvalue);
    }
    {
        jdouble jvalue = (jdouble)temp2;
        (*jenv)->SetDoubleArrayRegion(jenv, jarg2, 0, 1, &jvalue);
    }
    {
        jdouble jvalue = (jdouble)temp3;
        (*jenv)->SetDoubleArrayRegion(jenv, jarg3, 0, 1, &jvalue);
    }
    {
        jdouble jvalue = (jdouble)temp4;
        (*jenv)->SetDoubleArrayRegion(jenv, jarg4, 0, 1, &jvalue);
    }
}


#define _doc_plgxax "Get x axis labeling parameters." 
JNIEXPORT void JNICALL Java_plplot_core_plplotjavacJNI_plgxax(JNIEnv *jenv, jclass jcls, jintArray jarg1, jintArray jarg2) {
    PLINT *arg1 = (PLINT *) 0 ;
    PLINT *arg2 = (PLINT *) 0 ;
    PLINT temp1 ;
    PLINT temp2 ;
    
    (void)jenv;
    (void)jcls;
    {
        if (!jarg1) {
            SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "array null");
            return ;
        }
        if ((*jenv)->GetArrayLength(jenv, jarg1) == 0) {
            SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, "Array must contain at least 1 element");
            return ;
        }
        arg1 = &temp1; 
    }
    {
        if (!jarg2) {
            SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "array null");
            return ;
        }
        if ((*jenv)->GetArrayLength(jenv, jarg2) == 0) {
            SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, "Array must contain at least 1 element");
            return ;
        }
        arg2 = &temp2; 
    }
    plgxax(arg1,arg2);
    
    {
        jint jvalue = (jint)temp1;
        (*jenv)->SetIntArrayRegion(jenv, jarg1, 0, 1, &jvalue);
    }
    {
        jint jvalue = (jint)temp2;
        (*jenv)->SetIntArrayRegion(jenv, jarg2, 0, 1, &jvalue);
    }
}


#define _doc_plgyax "Get y axis labeling parameters." 
JNIEXPORT void JNICALL Java_plplot_core_plplotjavacJNI_plgyax(JNIEnv *jenv, jclass jcls, jintArray jarg1, jintArray jarg2) {
    PLINT *arg1 = (PLINT *) 0 ;
    PLINT *arg2 = (PLINT *) 0 ;
    PLINT temp1 ;
    PLINT temp2 ;
    
    (void)jenv;
    (void)jcls;
    {
        if (!jarg1) {
            SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "array null");
            return ;
        }
        if ((*jenv)->GetArrayLength(jenv, jarg1) == 0) {
            SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, "Array must contain at least 1 element");
            return ;
        }
        arg1 = &temp1; 
    }
    {
        if (!jarg2) {
            SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "array null");
            return ;
        }
        if ((*jenv)->GetArrayLength(jenv, jarg2) == 0) {
            SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, "Array must contain at least 1 element");
            return ;
        }
        arg2 = &temp2; 
    }
    plgyax(arg1,arg2);
    
    {
        jint jvalue = (jint)temp1;
        (*jenv)->SetIntArrayRegion(jenv, jarg1, 0, 1, &jvalue);
    }
    {
        jint jvalue = (jint)temp2;
        (*jenv)->SetIntArrayRegion(jenv, jarg2, 0, 1, &jvalue);
    }
}


#define _doc_plgzax "Get z axis labeling parameters." 
JNIEXPORT void JNICALL Java_plplot_core_plplotjavacJNI_plgzax(JNIEnv *jenv, jclass jcls, jintArray jarg1, jintArray jarg2) {
    PLINT *arg1 = (PLINT *) 0 ;
    PLINT *arg2 = (PLINT *) 0 ;
    PLINT temp1 ;
    PLINT temp2 ;
    
    (void)jenv;
    (void)jcls;
    {
        if (!jarg1) {
            SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "array null");
            return ;
        }
        if ((*jenv)->GetArrayLength(jenv, jarg1) == 0) {
            SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, "Array must contain at least 1 element");
            return ;
        }
        arg1 = &temp1; 
    }
    {
        if (!jarg2) {
            SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "array null");
            return ;
        }
        if ((*jenv)->GetArrayLength(jenv, jarg2) == 0) {
            SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, "Array must contain at least 1 element");
            return ;
        }
        arg2 = &temp2; 
    }
    plgzax(arg1,arg2);
    
    {
        jint jvalue = (jint)temp1;
        (*jenv)->SetIntArrayRegion(jenv, jarg1, 0, 1, &jvalue);
    }
    {
        jint jvalue = (jint)temp2;
        (*jenv)->SetIntArrayRegion(jenv, jarg2, 0, 1, &jvalue);
    }
}


#define _doc_plhist "Draw histogram." 
JNIEXPORT void JNICALL Java_plplot_core_plplotjavacJNI_plhist(JNIEnv *jenv, jclass jcls, jdoubleArray jarg1, jdouble jarg3, jdouble jarg4, jint jarg5, jint jarg6) {
    PLINT arg1 ;
    PLFLT *arg2 = (PLFLT *) 0 ;
    PLFLT arg3 ;
    PLFLT arg4 ;
    PLINT arg5 ;
    PLINT arg6 ;
    
    (void)jenv;
    (void)jcls;
    {
        jdouble *jxdata = (*jenv)->GetDoubleArrayElements( jenv, jarg1, 0 );
        arg1 = (*jenv)->GetArrayLength( jenv, jarg1);
        Alen = arg1;
        setup_array_1d_d( &arg2, jxdata, Alen );
        /* Could find no easy way to do this as part of freearg so I modified
            * the previous function so it ALWAYS mallocs and copies so that
            * the java array can be released immediately. */
        (*jenv)->ReleaseDoubleArrayElements( jenv, jarg1, jxdata, 0 );
    }
    arg3 = (PLFLT)jarg3; 
    arg4 = (PLFLT)jarg4; 
    arg5 = (PLINT)jarg5; 
    arg6 = (PLINT)jarg6; 
    plhist(arg1,arg2,arg3,arg4,arg5,arg6);
    
    {
        free(arg2);
    }
}


#define _doc_plhls "Set current color (map 0) by hue, lightness, and saturation." 
JNIEXPORT void JNICALL Java_plplot_core_plplotjavacJNI_plhls(JNIEnv *jenv, jclass jcls, jdouble jarg1, jdouble jarg2, jdouble jarg3) {
    PLFLT arg1 ;
    PLFLT arg2 ;
    PLFLT arg3 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = (PLFLT)jarg1; 
    arg2 = (PLFLT)jarg2; 
    arg3 = (PLFLT)jarg3; 
    plhls(arg1,arg2,arg3);
    
}


#define _doc_plinit "Initialize PLplot, using preset or default options." 
JNIEXPORT void JNICALL Java_plplot_core_plplotjavacJNI_plinit(JNIEnv *jenv, jclass jcls) {
    (void)jenv;
    (void)jcls;
    plinit();
    
}


#define _doc_pljoin "Draw a line segment from (x1, y1) to (x2, y2)." 
JNIEXPORT void JNICALL Java_plplot_core_plplotjavacJNI_pljoin(JNIEnv *jenv, jclass jcls, jdouble jarg1, jdouble jarg2, jdouble jarg3, jdouble jarg4) {
    PLFLT arg1 ;
    PLFLT arg2 ;
    PLFLT arg3 ;
    PLFLT arg4 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = (PLFLT)jarg1; 
    arg2 = (PLFLT)jarg2; 
    arg3 = (PLFLT)jarg3; 
    arg4 = (PLFLT)jarg4; 
    pljoin(arg1,arg2,arg3,arg4);
    
}


#define _doc_pllab "Label graphs." 
JNIEXPORT void JNICALL Java_plplot_core_plplotjavacJNI_pllab(JNIEnv *jenv, jclass jcls, jstring jarg1, jstring jarg2, jstring jarg3) {
    char *arg1 ;
    char *arg2 ;
    char *arg3 ;
    
    (void)jenv;
    (void)jcls;
    {
        arg1 = 0;
        if (jarg1) {
            arg1 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg1, 0);
            if (!arg1) return ;
        }
    }
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
            if (!arg2) return ;
        }
    }
    {
        arg3 = 0;
        if (jarg3) {
            arg3 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg3, 0);
            if (!arg3) return ;
        }
    }
    pllab((char const *)arg1,(char const *)arg2,(char const *)arg3);
    
    {
        if (arg1) (*jenv)->ReleaseStringUTFChars(jenv, jarg1, arg1); 
    }
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
    {
        if (arg3) (*jenv)->ReleaseStringUTFChars(jenv, jarg3, arg3); 
    }
}


#define _doc_pllightsource "Set position of the light source." 
JNIEXPORT void JNICALL Java_plplot_core_plplotjavacJNI_pllightsource(JNIEnv *jenv, jclass jcls, jdouble jarg1, jdouble jarg2, jdouble jarg3) {
    PLFLT arg1 ;
    PLFLT arg2 ;
    PLFLT arg3 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = (PLFLT)jarg1; 
    arg2 = (PLFLT)jarg2; 
    arg3 = (PLFLT)jarg3; 
    pllightsource(arg1,arg2,arg3);
    
}


#define _doc_plline "Draw line segments connecting a series of points." 
JNIEXPORT void JNICALL Java_plplot_core_plplotjavacJNI_plline(JNIEnv *jenv, jclass jcls, jdoubleArray jarg1, jdoubleArray jarg3) {
    PLINT arg1 ;
    PLFLT *arg2 = (PLFLT *) 0 ;
    PLFLT *arg3 = (PLFLT *) 0 ;
    
    (void)jenv;
    (void)jcls;
    {
        jdouble *jxdata = (*jenv)->GetDoubleArrayElements( jenv, jarg1, 0 );
        arg1 = (*jenv)->GetArrayLength( jenv, jarg1);
        Alen = arg1;
        setup_array_1d_d( &arg2, jxdata, Alen );
        /* Could find no easy way to do this as part of freearg so I modified
            * the previous function so it ALWAYS mallocs and copies so that
            * the java array can be released immediately. */
        (*jenv)->ReleaseDoubleArrayElements( jenv, jarg1, jxdata, 0 );
    }
    {
        jdouble *jydata = (*jenv)->GetDoubleArrayElements( jenv, jarg3, 0 );
        if((*jenv)->GetArrayLength( jenv, jarg3 ) != Alen) {
            printf("Vectors must be same length.\n");
            return;
        }
        setup_array_1d_d( &arg3, jydata, Alen );
        (*jenv)->ReleaseDoubleArrayElements( jenv, jarg3, jydata, 0 );
    }
    plline(arg1,arg2,arg3);
    
    {
        free(arg2);
    }
    {
        free(arg3);
    }
}


#define _doc_plline3 "Draw a line in 3 space." 
JNIEXPORT void JNICALL Java_plplot_core_plplotjavacJNI_plline3(JNIEnv *jenv, jclass jcls, jdoubleArray jarg1, jdoubleArray jarg3, jdoubleArray jarg4) {
    PLINT arg1 ;
    PLFLT *arg2 = (PLFLT *) 0 ;
    PLFLT *arg3 = (PLFLT *) 0 ;
    PLFLT *arg4 = (PLFLT *) 0 ;
    
    (void)jenv;
    (void)jcls;
    {
        jdouble *jxdata = (*jenv)->GetDoubleArrayElements( jenv, jarg1, 0 );
        arg1 = (*jenv)->GetArrayLength( jenv, jarg1);
        Alen = arg1;
        setup_array_1d_d( &arg2, jxdata, Alen );
        /* Could find no easy way to do this as part of freearg so I modified
            * the previous function so it ALWAYS mallocs and copies so that
            * the java array can be released immediately. */
        (*jenv)->ReleaseDoubleArrayElements( jenv, jarg1, jxdata, 0 );
    }
    {
        jdouble *jydata = (*jenv)->GetDoubleArrayElements( jenv, jarg3, 0 );
        if((*jenv)->GetArrayLength( jenv, jarg3 ) != Alen) {
            printf("Vectors must be same length.\n");
            return;
        }
        setup_array_1d_d( &arg3, jydata, Alen );
        (*jenv)->ReleaseDoubleArrayElements( jenv, jarg3, jydata, 0 );
    }
    {
        jdouble *jydata = (*jenv)->GetDoubleArrayElements( jenv, jarg4, 0 );
        if((*jenv)->GetArrayLength( jenv, jarg4 ) != Alen) {
            printf("Vectors must be same length.\n");
            return;
        }
        setup_array_1d_d( &arg4, jydata, Alen );
        (*jenv)->ReleaseDoubleArrayElements( jenv, jarg4, jydata, 0 );
    }
    plline3(arg1,arg2,arg3,arg4);
    
    {
        free(arg2);
    }
    {
        free(arg3);
    }
    {
        free(arg4);
    }
}


#define _doc_pllsty "Set line style." 
JNIEXPORT void JNICALL Java_plplot_core_plplotjavacJNI_pllsty(JNIEnv *jenv, jclass jcls, jint jarg1) {
    PLINT arg1 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = (PLINT)jarg1; 
    pllsty(arg1);
    
}


#define _doc_plmesh "Plot a 3-d mesh representation of z[x][y]." 
JNIEXPORT void JNICALL Java_plplot_core_plplotjavacJNI_plmesh(JNIEnv *jenv, jclass jcls, jdoubleArray jarg1, jdoubleArray jarg2, jobjectArray jarg3, jint jarg6) {
    PLFLT *arg1 = (PLFLT *) 0 ;
    PLFLT *arg2 = (PLFLT *) 0 ;
    PLFLT **arg3 = (PLFLT **) 0 ;
    PLINT arg4 ;
    PLINT arg5 ;
    PLINT arg6 ;
    
    (void)jenv;
    (void)jcls;
    {
        jdouble *jxdata = (*jenv)->GetDoubleArrayElements( jenv, jarg1, 0 );
        Xlen = (*jenv)->GetArrayLength( jenv, jarg1);
        setup_array_1d_d( &arg1, jxdata, Xlen);
        (*jenv)->ReleaseDoubleArrayElements( jenv, jarg1, jxdata, 0 );
    }
    {
        jdouble *jydata = (*jenv)->GetDoubleArrayElements( jenv, jarg2, 0 );
        Ylen = (*jenv)->GetArrayLength( jenv, jarg2);
        setup_array_1d_d( &arg2, jydata, Ylen);
        (*jenv)->ReleaseDoubleArrayElements( jenv, jarg2, jydata, 0 );
    }
    {
        jdouble **adat;
        jobject *ai;
        int nx = (*jenv)->GetArrayLength( jenv, jarg3 );
        int ny = -1;
        int i, j;
        ai = (jobject *) malloc( nx * sizeof(jobject) );
        adat = (jdouble **) malloc( nx * sizeof(jdouble *) );
        
        for( i=0; i < nx; i++ )
        {
            ai[i] = (*jenv)->GetObjectArrayElement( jenv, jarg3, i );
            adat[i] = (*jenv)->GetDoubleArrayElements( jenv, ai[i], 0 );
            
            if (ny == -1)
            ny = (*jenv)->GetArrayLength( jenv, ai[i] );
            else if (ny != (*jenv)->GetArrayLength( jenv, ai[i] )) {
                printf( "Misshapen a array.\n" );
                for( j=0; j <= i; j++ )
                (*jenv)->ReleaseDoubleArrayElements( jenv, ai[j], adat[j], 0 );
                free(adat);
                free(ai);
                return;
            }
        }
        
        if( nx != Xlen || ny != Ylen ) {
            printf( "Vectors must match matrix.\n" );
            for( i=0; i < nx; i++ )
            (*jenv)->ReleaseDoubleArrayElements( jenv, ai[i], adat[i], 0 );
            free(adat);
            free(ai);
            return;
        }
        setup_array_2d_d( &arg3, adat, nx, ny );
        arg4 = nx;
        arg5 = ny;
        for( i=0; i < nx; i++ ) {
            (*jenv)->ReleaseDoubleArrayElements( jenv, ai[i], adat[i], 0 );
            (*jenv)->DeleteLocalRef(jenv, ai[i]);
        }
        
        
        free(adat);
        free(ai);
        
    }
    arg6 = (PLINT)jarg6; 
    plmesh(arg1,arg2,arg3,arg4,arg5,arg6);
    
    {
        free(arg1);
    }
    {
        free(arg2);
    }
    {
        free(arg3[0]);
        free(arg3);
    }
}


#define _doc_plmeshc "Plot a 3-d contoured mesh representation of the function z[x][y]." 
JNIEXPORT void JNICALL Java_plplot_core_plplotjavacJNI_plmeshc(JNIEnv *jenv, jclass jcls, jdoubleArray jarg1, jdoubleArray jarg2, jobjectArray jarg3, jint jarg6, jdoubleArray jarg7) {
    PLFLT *arg1 = (PLFLT *) 0 ;
    PLFLT *arg2 = (PLFLT *) 0 ;
    PLFLT **arg3 = (PLFLT **) 0 ;
    PLINT arg4 ;
    PLINT arg5 ;
    PLINT arg6 ;
    PLFLT *arg7 = (PLFLT *) 0 ;
    PLINT arg8 ;
    
    (void)jenv;
    (void)jcls;
    {
        jdouble *jxdata = (*jenv)->GetDoubleArrayElements( jenv, jarg1, 0 );
        Xlen = (*jenv)->GetArrayLength( jenv, jarg1);
        setup_array_1d_d( &arg1, jxdata, Xlen);
        (*jenv)->ReleaseDoubleArrayElements( jenv, jarg1, jxdata, 0 );
    }
    {
        jdouble *jydata = (*jenv)->GetDoubleArrayElements( jenv, jarg2, 0 );
        Ylen = (*jenv)->GetArrayLength( jenv, jarg2);
        setup_array_1d_d( &arg2, jydata, Ylen);
        (*jenv)->ReleaseDoubleArrayElements( jenv, jarg2, jydata, 0 );
    }
    {
        jdouble **adat;
        jobject *ai;
        int nx = (*jenv)->GetArrayLength( jenv, jarg3 );
        int ny = -1;
        int i, j;
        ai = (jobject *) malloc( nx * sizeof(jobject) );
        adat = (jdouble **) malloc( nx * sizeof(jdouble *) );
        
        for( i=0; i < nx; i++ )
        {
            ai[i] = (*jenv)->GetObjectArrayElement( jenv, jarg3, i );
            adat[i] = (*jenv)->GetDoubleArrayElements( jenv, ai[i], 0 );
            
            if (ny == -1)
            ny = (*jenv)->GetArrayLength( jenv, ai[i] );
            else if (ny != (*jenv)->GetArrayLength( jenv, ai[i] )) {
                printf( "Misshapen a array.\n" );
                for( j=0; j <= i; j++ )
                (*jenv)->ReleaseDoubleArrayElements( jenv, ai[j], adat[j], 0 );
                free(adat);
                free(ai);
                return;
            }
        }
        
        if( nx != Xlen || ny != Ylen ) {
            printf( "Vectors must match matrix.\n" );
            for( i=0; i < nx; i++ )
            (*jenv)->ReleaseDoubleArrayElements( jenv, ai[i], adat[i], 0 );
            free(adat);
            free(ai);
            return;
        }
        setup_array_2d_d( &arg3, adat, nx, ny );
        arg4 = nx;
        arg5 = ny;
        for( i=0; i < nx; i++ ) {
            (*jenv)->ReleaseDoubleArrayElements( jenv, ai[i], adat[i], 0 );
            (*jenv)->DeleteLocalRef(jenv, ai[i]);
        }
        
        
        free(adat);
        free(ai);
        
    }
    arg6 = (PLINT)jarg6; 
    {
        jdouble *jxdata = (*jenv)->GetDoubleArrayElements( jenv, jarg7, 0 );
        arg8 = (*jenv)->GetArrayLength( jenv, jarg7 );
        setup_array_1d_d( &arg7, jxdata, arg8);
        (*jenv)->ReleaseDoubleArrayElements( jenv, jarg7, jxdata, 0 );
    }
    plmeshc(arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8);
    
    {
        free(arg1);
    }
    {
        free(arg2);
    }
    {
        free(arg3[0]);
        free(arg3);
    }
    {
        free(arg7);
    }
}


#define _doc_plmkstrm "Create a new stream and makes it the default." 
JNIEXPORT void JNICALL Java_plplot_core_plplotjavacJNI_plmkstrm(JNIEnv *jenv, jclass jcls, jintArray jarg1) {
    PLINT *arg1 = (PLINT *) 0 ;
    PLINT temp1 ;
    
    (void)jenv;
    (void)jcls;
    {
        if (!jarg1) {
            SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "array null");
            return ;
        }
        if ((*jenv)->GetArrayLength(jenv, jarg1) == 0) {
            SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, "Array must contain at least 1 element");
            return ;
        }
        arg1 = &temp1; 
    }
    plmkstrm(arg1);
    
    {
        jint jvalue = (jint)temp1;
        (*jenv)->SetIntArrayRegion(jenv, jarg1, 0, 1, &jvalue);
    }
}


#define _doc_plmtex "Print \"text\" at specified position relative to viewport." 
JNIEXPORT void JNICALL Java_plplot_core_plplotjavacJNI_plmtex(JNIEnv *jenv, jclass jcls, jstring jarg1, jdouble jarg2, jdouble jarg3, jdouble jarg4, jstring jarg5) {
    char *arg1 ;
    PLFLT arg2 ;
    PLFLT arg3 ;
    PLFLT arg4 ;
    char *arg5 ;
    
    (void)jenv;
    (void)jcls;
    {
        arg1 = 0;
        if (jarg1) {
            arg1 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg1, 0);
            if (!arg1) return ;
        }
    }
    arg2 = (PLFLT)jarg2; 
    arg3 = (PLFLT)jarg3; 
    arg4 = (PLFLT)jarg4; 
    {
        arg5 = 0;
        if (jarg5) {
            arg5 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg5, 0);
            if (!arg5) return ;
        }
    }
    plmtex((char const *)arg1,arg2,arg3,arg4,(char const *)arg5);
    
    {
        if (arg1) (*jenv)->ReleaseStringUTFChars(jenv, jarg1, arg1); 
    }
    {
        if (arg5) (*jenv)->ReleaseStringUTFChars(jenv, jarg5, arg5); 
    }
}


#define _doc_plot3d "Plot a 3-d representation of the function z[x][y]." 
JNIEXPORT void JNICALL Java_plplot_core_plplotjavacJNI_plot3d(JNIEnv *jenv, jclass jcls, jdoubleArray jarg1, jdoubleArray jarg2, jobjectArray jarg3, jint jarg6, jint jarg7) {
    PLFLT *arg1 = (PLFLT *) 0 ;
    PLFLT *arg2 = (PLFLT *) 0 ;
    PLFLT **arg3 = (PLFLT **) 0 ;
    PLINT arg4 ;
    PLINT arg5 ;
    PLINT arg6 ;
    PLINT arg7 ;
    
    (void)jenv;
    (void)jcls;
    {
        jdouble *jxdata = (*jenv)->GetDoubleArrayElements( jenv, jarg1, 0 );
        Xlen = (*jenv)->GetArrayLength( jenv, jarg1);
        setup_array_1d_d( &arg1, jxdata, Xlen);
        (*jenv)->ReleaseDoubleArrayElements( jenv, jarg1, jxdata, 0 );
    }
    {
        jdouble *jydata = (*jenv)->GetDoubleArrayElements( jenv, jarg2, 0 );
        Ylen = (*jenv)->GetArrayLength( jenv, jarg2);
        setup_array_1d_d( &arg2, jydata, Ylen);
        (*jenv)->ReleaseDoubleArrayElements( jenv, jarg2, jydata, 0 );
    }
    {
        jdouble **adat;
        jobject *ai;
        int nx = (*jenv)->GetArrayLength( jenv, jarg3 );
        int ny = -1;
        int i, j;
        ai = (jobject *) malloc( nx * sizeof(jobject) );
        adat = (jdouble **) malloc( nx * sizeof(jdouble *) );
        
        for( i=0; i < nx; i++ )
        {
            ai[i] = (*jenv)->GetObjectArrayElement( jenv, jarg3, i );
            adat[i] = (*jenv)->GetDoubleArrayElements( jenv, ai[i], 0 );
            
            if (ny == -1)
            ny = (*jenv)->GetArrayLength( jenv, ai[i] );
            else if (ny != (*jenv)->GetArrayLength( jenv, ai[i] )) {
                printf( "Misshapen a array.\n" );
                for( j=0; j <= i; j++ )
                (*jenv)->ReleaseDoubleArrayElements( jenv, ai[j], adat[j], 0 );
                free(adat);
                free(ai);
                return;
            }
        }
        
        if( nx != Xlen || ny != Ylen ) {
            printf( "Vectors must match matrix.\n" );
            for( i=0; i < nx; i++ )
            (*jenv)->ReleaseDoubleArrayElements( jenv, ai[i], adat[i], 0 );
            free(adat);
            free(ai);
            return;
        }
        setup_array_2d_d( &arg3, adat, nx, ny );
        arg4 = nx;
        arg5 = ny;
        for( i=0; i < nx; i++ ) {
            (*jenv)->ReleaseDoubleArrayElements( jenv, ai[i], adat[i], 0 );
            (*jenv)->DeleteLocalRef(jenv, ai[i]);
        }
        
        
        free(adat);
        free(ai);
        
    }
    arg6 = (PLINT)jarg6; 
    arg7 = (PLINT)jarg7; 
    plot3d(arg1,arg2,arg3,arg4,arg5,arg6,arg7);
    
    {
        free(arg1);
    }
    {
        free(arg2);
    }
    {
        free(arg3[0]);
        free(arg3);
    }
}


#define _doc_plot3dc "Plot a 3-d contoured representation of the function z[x][y]." 
JNIEXPORT void JNICALL Java_plplot_core_plplotjavacJNI_plot3dc(JNIEnv *jenv, jclass jcls, jdoubleArray jarg1, jdoubleArray jarg2, jobjectArray jarg3, jint jarg6, jdoubleArray jarg7) {
    PLFLT *arg1 = (PLFLT *) 0 ;
    PLFLT *arg2 = (PLFLT *) 0 ;
    PLFLT **arg3 = (PLFLT **) 0 ;
    PLINT arg4 ;
    PLINT arg5 ;
    PLINT arg6 ;
    PLFLT *arg7 = (PLFLT *) 0 ;
    PLINT arg8 ;
    
    (void)jenv;
    (void)jcls;
    {
        jdouble *jxdata = (*jenv)->GetDoubleArrayElements( jenv, jarg1, 0 );
        Xlen = (*jenv)->GetArrayLength( jenv, jarg1);
        setup_array_1d_d( &arg1, jxdata, Xlen);
        (*jenv)->ReleaseDoubleArrayElements( jenv, jarg1, jxdata, 0 );
    }
    {
        jdouble *jydata = (*jenv)->GetDoubleArrayElements( jenv, jarg2, 0 );
        Ylen = (*jenv)->GetArrayLength( jenv, jarg2);
        setup_array_1d_d( &arg2, jydata, Ylen);
        (*jenv)->ReleaseDoubleArrayElements( jenv, jarg2, jydata, 0 );
    }
    {
        jdouble **adat;
        jobject *ai;
        int nx = (*jenv)->GetArrayLength( jenv, jarg3 );
        int ny = -1;
        int i, j;
        ai = (jobject *) malloc( nx * sizeof(jobject) );
        adat = (jdouble **) malloc( nx * sizeof(jdouble *) );
        
        for( i=0; i < nx; i++ )
        {
            ai[i] = (*jenv)->GetObjectArrayElement( jenv, jarg3, i );
            adat[i] = (*jenv)->GetDoubleArrayElements( jenv, ai[i], 0 );
            
            if (ny == -1)
            ny = (*jenv)->GetArrayLength( jenv, ai[i] );
            else if (ny != (*jenv)->GetArrayLength( jenv, ai[i] )) {
                printf( "Misshapen a array.\n" );
                for( j=0; j <= i; j++ )
                (*jenv)->ReleaseDoubleArrayElements( jenv, ai[j], adat[j], 0 );
                free(adat);
                free(ai);
                return;
            }
        }
        
        if( nx != Xlen || ny != Ylen ) {
            printf( "Vectors must match matrix.\n" );
            for( i=0; i < nx; i++ )
            (*jenv)->ReleaseDoubleArrayElements( jenv, ai[i], adat[i], 0 );
            free(adat);
            free(ai);
            return;
        }
        setup_array_2d_d( &arg3, adat, nx, ny );
        arg4 = nx;
        arg5 = ny;
        for( i=0; i < nx; i++ ) {
            (*jenv)->ReleaseDoubleArrayElements( jenv, ai[i], adat[i], 0 );
            (*jenv)->DeleteLocalRef(jenv, ai[i]);
        }
        
        
        free(adat);
        free(ai);
        
    }
    arg6 = (PLINT)jarg6; 
    {
        jdouble *jxdata = (*jenv)->GetDoubleArrayElements( jenv, jarg7, 0 );
        arg8 = (*jenv)->GetArrayLength( jenv, jarg7 );
        setup_array_1d_d( &arg7, jxdata, arg8);
        (*jenv)->ReleaseDoubleArrayElements( jenv, jarg7, jxdata, 0 );
    }
    plot3dc(arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8);
    
    {
        free(arg1);
    }
    {
        free(arg2);
    }
    {
        free(arg3[0]);
        free(arg3);
    }
    {
        free(arg7);
    }
}


#define _doc_plot3dcl "Plot a 3-d contoured representation of the function z[x][y] with limits on the y index." 
JNIEXPORT void JNICALL Java_plplot_core_plplotjavacJNI_plot3dcl(JNIEnv *jenv, jclass jcls, jdoubleArray jarg1, jdoubleArray jarg2, jobjectArray jarg3, jint jarg6, jdoubleArray jarg7, jint jarg9, jintArray jarg10, jintArray jarg12) {
    PLFLT *arg1 = (PLFLT *) 0 ;
    PLFLT *arg2 = (PLFLT *) 0 ;
    PLFLT **arg3 = (PLFLT **) 0 ;
    PLINT arg4 ;
    PLINT arg5 ;
    PLINT arg6 ;
    PLFLT *arg7 = (PLFLT *) 0 ;
    PLINT arg8 ;
    PLINT arg9 ;
    PLINT arg10 ;
    PLINT *arg11 = (PLINT *) 0 ;
    PLINT *arg12 = (PLINT *) 0 ;
    
    (void)jenv;
    (void)jcls;
    {
        jdouble *jxdata = (*jenv)->GetDoubleArrayElements( jenv, jarg1, 0 );
        Xlen = (*jenv)->GetArrayLength( jenv, jarg1);
        setup_array_1d_d( &arg1, jxdata, Xlen);
        (*jenv)->ReleaseDoubleArrayElements( jenv, jarg1, jxdata, 0 );
    }
    {
        jdouble *jydata = (*jenv)->GetDoubleArrayElements( jenv, jarg2, 0 );
        Ylen = (*jenv)->GetArrayLength( jenv, jarg2);
        setup_array_1d_d( &arg2, jydata, Ylen);
        (*jenv)->ReleaseDoubleArrayElements( jenv, jarg2, jydata, 0 );
    }
    {
        jdouble **adat;
        jobject *ai;
        int nx = (*jenv)->GetArrayLength( jenv, jarg3 );
        int ny = -1;
        int i, j;
        ai = (jobject *) malloc( nx * sizeof(jobject) );
        adat = (jdouble **) malloc( nx * sizeof(jdouble *) );
        
        for( i=0; i < nx; i++ )
        {
            ai[i] = (*jenv)->GetObjectArrayElement( jenv, jarg3, i );
            adat[i] = (*jenv)->GetDoubleArrayElements( jenv, ai[i], 0 );
            
            if (ny == -1)
            ny = (*jenv)->GetArrayLength( jenv, ai[i] );
            else if (ny != (*jenv)->GetArrayLength( jenv, ai[i] )) {
                printf( "Misshapen a array.\n" );
                for( j=0; j <= i; j++ )
                (*jenv)->ReleaseDoubleArrayElements( jenv, ai[j], adat[j], 0 );
                free(adat);
                free(ai);
                return;
            }
        }
        
        if( nx != Xlen || ny != Ylen ) {
            printf( "Vectors must match matrix.\n" );
            for( i=0; i < nx; i++ )
            (*jenv)->ReleaseDoubleArrayElements( jenv, ai[i], adat[i], 0 );
            free(adat);
            free(ai);
            return;
        }
        setup_array_2d_d( &arg3, adat, nx, ny );
        arg4 = nx;
        arg5 = ny;
        for( i=0; i < nx; i++ ) {
            (*jenv)->ReleaseDoubleArrayElements( jenv, ai[i], adat[i], 0 );
            (*jenv)->DeleteLocalRef(jenv, ai[i]);
        }
        
        
        free(adat);
        free(ai);
        
    }
    arg6 = (PLINT)jarg6; 
    {
        jdouble *jxdata = (*jenv)->GetDoubleArrayElements( jenv, jarg7, 0 );
        arg8 = (*jenv)->GetArrayLength( jenv, jarg7 );
        setup_array_1d_d( &arg7, jxdata, arg8);
        (*jenv)->ReleaseDoubleArrayElements( jenv, jarg7, jxdata, 0 );
    }
    arg9 = (PLINT)jarg9; 
    {
        jint *jxdata = (*jenv)->GetIntArrayElements( jenv, jarg10, 0 );
        arg10 = (*jenv)->GetArrayLength( jenv, jarg10);
        Alen = arg10;
        setup_array_1d_i( &arg11, jxdata, Alen);
        /* Could find no easy way to do this as part of freearg so I modified
            * the previous function so it ALWAYS mallocs and copies so that
            * the java array can be released immediately. */
        (*jenv)->ReleaseIntArrayElements( jenv, jarg10, jxdata, 0 );
    }
    {
        jint *jydata = (*jenv)->GetIntArrayElements( jenv, jarg12, 0 );
        if((*jenv)->GetArrayLength( jenv, jarg12 ) != Alen) {
            printf("Vectors must be same length.\n");
            return;
        }
        setup_array_1d_i( &arg12, jydata, Alen);
        (*jenv)->ReleaseIntArrayElements( jenv, jarg12, jydata, 0 );
    }
    plot3dcl(arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8,arg9,arg10,arg11,arg12);
    
    {
        free(arg1);
    }
    {
        free(arg2);
    }
    {
        free(arg3[0]);
        free(arg3);
    }
    {
        free(arg7);
    }
    {
        free(arg11);
    }
    {
        free(arg12);
    }
}


#define _doc_plsurf3d "Plot a 3-d contoured surface representation of the function z[x][y]." 
JNIEXPORT void JNICALL Java_plplot_core_plplotjavacJNI_plsurf3d(JNIEnv *jenv, jclass jcls, jdoubleArray jarg1, jdoubleArray jarg2, jobjectArray jarg3, jint jarg6, jdoubleArray jarg7) {
    PLFLT *arg1 = (PLFLT *) 0 ;
    PLFLT *arg2 = (PLFLT *) 0 ;
    PLFLT **arg3 = (PLFLT **) 0 ;
    PLINT arg4 ;
    PLINT arg5 ;
    PLINT arg6 ;
    PLFLT *arg7 = (PLFLT *) 0 ;
    PLINT arg8 ;
    
    (void)jenv;
    (void)jcls;
    {
        jdouble *jxdata = (*jenv)->GetDoubleArrayElements( jenv, jarg1, 0 );
        Xlen = (*jenv)->GetArrayLength( jenv, jarg1);
        setup_array_1d_d( &arg1, jxdata, Xlen);
        (*jenv)->ReleaseDoubleArrayElements( jenv, jarg1, jxdata, 0 );
    }
    {
        jdouble *jydata = (*jenv)->GetDoubleArrayElements( jenv, jarg2, 0 );
        Ylen = (*jenv)->GetArrayLength( jenv, jarg2);
        setup_array_1d_d( &arg2, jydata, Ylen);
        (*jenv)->ReleaseDoubleArrayElements( jenv, jarg2, jydata, 0 );
    }
    {
        jdouble **adat;
        jobject *ai;
        int nx = (*jenv)->GetArrayLength( jenv, jarg3 );
        int ny = -1;
        int i, j;
        ai = (jobject *) malloc( nx * sizeof(jobject) );
        adat = (jdouble **) malloc( nx * sizeof(jdouble *) );
        
        for( i=0; i < nx; i++ )
        {
            ai[i] = (*jenv)->GetObjectArrayElement( jenv, jarg3, i );
            adat[i] = (*jenv)->GetDoubleArrayElements( jenv, ai[i], 0 );
            
            if (ny == -1)
            ny = (*jenv)->GetArrayLength( jenv, ai[i] );
            else if (ny != (*jenv)->GetArrayLength( jenv, ai[i] )) {
                printf( "Misshapen a array.\n" );
                for( j=0; j <= i; j++ )
                (*jenv)->ReleaseDoubleArrayElements( jenv, ai[j], adat[j], 0 );
                free(adat);
                free(ai);
                return;
            }
        }
        
        if( nx != Xlen || ny != Ylen ) {
            printf( "Vectors must match matrix.\n" );
            for( i=0; i < nx; i++ )
            (*jenv)->ReleaseDoubleArrayElements( jenv, ai[i], adat[i], 0 );
            free(adat);
            free(ai);
            return;
        }
        setup_array_2d_d( &arg3, adat, nx, ny );
        arg4 = nx;
        arg5 = ny;
        for( i=0; i < nx; i++ ) {
            (*jenv)->ReleaseDoubleArrayElements( jenv, ai[i], adat[i], 0 );
            (*jenv)->DeleteLocalRef(jenv, ai[i]);
        }
        
        
        free(adat);
        free(ai);
        
    }
    arg6 = (PLINT)jarg6; 
    {
        jdouble *jxdata = (*jenv)->GetDoubleArrayElements( jenv, jarg7, 0 );
        arg8 = (*jenv)->GetArrayLength( jenv, jarg7 );
        setup_array_1d_d( &arg7, jxdata, arg8);
        (*jenv)->ReleaseDoubleArrayElements( jenv, jarg7, jxdata, 0 );
    }
    plsurf3d(arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8);
    
    {
        free(arg1);
    }
    {
        free(arg2);
    }
    {
        free(arg3[0]);
        free(arg3);
    }
    {
        free(arg7);
    }
}


#define _doc_plsurf3dl "Plot a 3-d contoured surface representation of the function z[x][y] with limits on the y index." 
JNIEXPORT void JNICALL Java_plplot_core_plplotjavacJNI_plsurf3dl(JNIEnv *jenv, jclass jcls, jdoubleArray jarg1, jdoubleArray jarg2, jobjectArray jarg3, jint jarg6, jdoubleArray jarg7, jint jarg9, jintArray jarg10, jintArray jarg12) {
    PLFLT *arg1 = (PLFLT *) 0 ;
    PLFLT *arg2 = (PLFLT *) 0 ;
    PLFLT **arg3 = (PLFLT **) 0 ;
    PLINT arg4 ;
    PLINT arg5 ;
    PLINT arg6 ;
    PLFLT *arg7 = (PLFLT *) 0 ;
    PLINT arg8 ;
    PLINT arg9 ;
    PLINT arg10 ;
    PLINT *arg11 = (PLINT *) 0 ;
    PLINT *arg12 = (PLINT *) 0 ;
    
    (void)jenv;
    (void)jcls;
    {
        jdouble *jxdata = (*jenv)->GetDoubleArrayElements( jenv, jarg1, 0 );
        Xlen = (*jenv)->GetArrayLength( jenv, jarg1);
        setup_array_1d_d( &arg1, jxdata, Xlen);
        (*jenv)->ReleaseDoubleArrayElements( jenv, jarg1, jxdata, 0 );
    }
    {
        jdouble *jydata = (*jenv)->GetDoubleArrayElements( jenv, jarg2, 0 );
        Ylen = (*jenv)->GetArrayLength( jenv, jarg2);
        setup_array_1d_d( &arg2, jydata, Ylen);
        (*jenv)->ReleaseDoubleArrayElements( jenv, jarg2, jydata, 0 );
    }
    {
        jdouble **adat;
        jobject *ai;
        int nx = (*jenv)->GetArrayLength( jenv, jarg3 );
        int ny = -1;
        int i, j;
        ai = (jobject *) malloc( nx * sizeof(jobject) );
        adat = (jdouble **) malloc( nx * sizeof(jdouble *) );
        
        for( i=0; i < nx; i++ )
        {
            ai[i] = (*jenv)->GetObjectArrayElement( jenv, jarg3, i );
            adat[i] = (*jenv)->GetDoubleArrayElements( jenv, ai[i], 0 );
            
            if (ny == -1)
            ny = (*jenv)->GetArrayLength( jenv, ai[i] );
            else if (ny != (*jenv)->GetArrayLength( jenv, ai[i] )) {
                printf( "Misshapen a array.\n" );
                for( j=0; j <= i; j++ )
                (*jenv)->ReleaseDoubleArrayElements( jenv, ai[j], adat[j], 0 );
                free(adat);
                free(ai);
                return;
            }
        }
        
        if( nx != Xlen || ny != Ylen ) {
            printf( "Vectors must match matrix.\n" );
            for( i=0; i < nx; i++ )
            (*jenv)->ReleaseDoubleArrayElements( jenv, ai[i], adat[i], 0 );
            free(adat);
            free(ai);
            return;
        }
        setup_array_2d_d( &arg3, adat, nx, ny );
        arg4 = nx;
        arg5 = ny;
        for( i=0; i < nx; i++ ) {
            (*jenv)->ReleaseDoubleArrayElements( jenv, ai[i], adat[i], 0 );
            (*jenv)->DeleteLocalRef(jenv, ai[i]);
        }
        
        
        free(adat);
        free(ai);
        
    }
    arg6 = (PLINT)jarg6; 
    {
        jdouble *jxdata = (*jenv)->GetDoubleArrayElements( jenv, jarg7, 0 );
        arg8 = (*jenv)->GetArrayLength( jenv, jarg7 );
        setup_array_1d_d( &arg7, jxdata, arg8);
        (*jenv)->ReleaseDoubleArrayElements( jenv, jarg7, jxdata, 0 );
    }
    arg9 = (PLINT)jarg9; 
    {
        jint *jxdata = (*jenv)->GetIntArrayElements( jenv, jarg10, 0 );
        arg10 = (*jenv)->GetArrayLength( jenv, jarg10);
        Alen = arg10;
        setup_array_1d_i( &arg11, jxdata, Alen);
        /* Could find no easy way to do this as part of freearg so I modified
            * the previous function so it ALWAYS mallocs and copies so that
            * the java array can be released immediately. */
        (*jenv)->ReleaseIntArrayElements( jenv, jarg10, jxdata, 0 );
    }
    {
        jint *jydata = (*jenv)->GetIntArrayElements( jenv, jarg12, 0 );
        if((*jenv)->GetArrayLength( jenv, jarg12 ) != Alen) {
            printf("Vectors must be same length.\n");
            return;
        }
        setup_array_1d_i( &arg12, jydata, Alen);
        (*jenv)->ReleaseIntArrayElements( jenv, jarg12, jydata, 0 );
    }
    plsurf3dl(arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8,arg9,arg10,arg11,arg12);
    
    {
        free(arg1);
    }
    {
        free(arg2);
    }
    {
        free(arg3[0]);
        free(arg3);
    }
    {
        free(arg7);
    }
    {
        free(arg11);
    }
    {
        free(arg12);
    }
}


#define _doc_plpat "Set fill pattern directly." 
JNIEXPORT void JNICALL Java_plplot_core_plplotjavacJNI_plpat(JNIEnv *jenv, jclass jcls, jintArray jarg1, jintArray jarg3) {
    PLINT arg1 ;
    PLINT *arg2 = (PLINT *) 0 ;
    PLINT *arg3 = (PLINT *) 0 ;
    
    (void)jenv;
    (void)jcls;
    {
        jint *jxdata = (*jenv)->GetIntArrayElements( jenv, jarg1, 0 );
        arg1 = (*jenv)->GetArrayLength( jenv, jarg1);
        Alen = arg1;
        setup_array_1d_i( &arg2, jxdata, Alen);
        /* Could find no easy way to do this as part of freearg so I modified
            * the previous function so it ALWAYS mallocs and copies so that
            * the java array can be released immediately. */
        (*jenv)->ReleaseIntArrayElements( jenv, jarg1, jxdata, 0 );
    }
    {
        jint *jydata = (*jenv)->GetIntArrayElements( jenv, jarg3, 0 );
        if((*jenv)->GetArrayLength( jenv, jarg3 ) != Alen) {
            printf("Vectors must be same length.\n");
            return;
        }
        setup_array_1d_i( &arg3, jydata, Alen);
        (*jenv)->ReleaseIntArrayElements( jenv, jarg3, jydata, 0 );
    }
    plpat(arg1,arg2,arg3);
    
    {
        free(arg2);
    }
    {
        free(arg3);
    }
}


#define _doc_plpoin "Plot array y against x for n points using ASCII code \"code\"." 
JNIEXPORT void JNICALL Java_plplot_core_plplotjavacJNI_plpoin(JNIEnv *jenv, jclass jcls, jdoubleArray jarg1, jdoubleArray jarg3, jint jarg4) {
    PLINT arg1 ;
    PLFLT *arg2 = (PLFLT *) 0 ;
    PLFLT *arg3 = (PLFLT *) 0 ;
    PLINT arg4 ;
    
    (void)jenv;
    (void)jcls;
    {
        jdouble *jxdata = (*jenv)->GetDoubleArrayElements( jenv, jarg1, 0 );
        arg1 = (*jenv)->GetArrayLength( jenv, jarg1);
        Alen = arg1;
        setup_array_1d_d( &arg2, jxdata, Alen );
        /* Could find no easy way to do this as part of freearg so I modified
            * the previous function so it ALWAYS mallocs and copies so that
            * the java array can be released immediately. */
        (*jenv)->ReleaseDoubleArrayElements( jenv, jarg1, jxdata, 0 );
    }
    {
        jdouble *jydata = (*jenv)->GetDoubleArrayElements( jenv, jarg3, 0 );
        if((*jenv)->GetArrayLength( jenv, jarg3 ) != Alen) {
            printf("Vectors must be same length.\n");
            return;
        }
        setup_array_1d_d( &arg3, jydata, Alen );
        (*jenv)->ReleaseDoubleArrayElements( jenv, jarg3, jydata, 0 );
    }
    arg4 = (PLINT)jarg4; 
    plpoin(arg1,arg2,arg3,arg4);
    
    {
        free(arg2);
    }
    {
        free(arg3);
    }
}


#define _doc_plpoin3 "Draw a series of points in 3 space." 
JNIEXPORT void JNICALL Java_plplot_core_plplotjavacJNI_plpoin3(JNIEnv *jenv, jclass jcls, jdoubleArray jarg1, jdoubleArray jarg3, jdoubleArray jarg4, jint jarg5) {
    PLINT arg1 ;
    PLFLT *arg2 = (PLFLT *) 0 ;
    PLFLT *arg3 = (PLFLT *) 0 ;
    PLFLT *arg4 = (PLFLT *) 0 ;
    PLINT arg5 ;
    
    (void)jenv;
    (void)jcls;
    {
        jdouble *jxdata = (*jenv)->GetDoubleArrayElements( jenv, jarg1, 0 );
        arg1 = (*jenv)->GetArrayLength( jenv, jarg1);
        Alen = arg1;
        setup_array_1d_d( &arg2, jxdata, Alen );
        /* Could find no easy way to do this as part of freearg so I modified
            * the previous function so it ALWAYS mallocs and copies so that
            * the java array can be released immediately. */
        (*jenv)->ReleaseDoubleArrayElements( jenv, jarg1, jxdata, 0 );
    }
    {
        jdouble *jydata = (*jenv)->GetDoubleArrayElements( jenv, jarg3, 0 );
        if((*jenv)->GetArrayLength( jenv, jarg3 ) != Alen) {
            printf("Vectors must be same length.\n");
            return;
        }
        setup_array_1d_d( &arg3, jydata, Alen );
        (*jenv)->ReleaseDoubleArrayElements( jenv, jarg3, jydata, 0 );
    }
    {
        jdouble *jydata = (*jenv)->GetDoubleArrayElements( jenv, jarg4, 0 );
        if((*jenv)->GetArrayLength( jenv, jarg4 ) != Alen) {
            printf("Vectors must be same length.\n");
            return;
        }
        setup_array_1d_d( &arg4, jydata, Alen );
        (*jenv)->ReleaseDoubleArrayElements( jenv, jarg4, jydata, 0 );
    }
    arg5 = (PLINT)jarg5; 
    plpoin3(arg1,arg2,arg3,arg4,arg5);
    
    {
        free(arg2);
    }
    {
        free(arg3);
    }
    {
        free(arg4);
    }
}


#define _doc_plpoly3 "Draw a polygon in 3 space. " 
JNIEXPORT void JNICALL Java_plplot_core_plplotjavacJNI_plpoly3(JNIEnv *jenv, jclass jcls, jdoubleArray jarg1, jdoubleArray jarg3, jdoubleArray jarg4, jintArray jarg5, jint jarg6) {
    PLINT arg1 ;
    PLFLT *arg2 = (PLFLT *) 0 ;
    PLFLT *arg3 = (PLFLT *) 0 ;
    PLFLT *arg4 = (PLFLT *) 0 ;
    PLINT *arg5 = (PLINT *) 0 ;
    PLINT arg6 ;
    
    (void)jenv;
    (void)jcls;
    {
        jdouble *jxdata = (*jenv)->GetDoubleArrayElements( jenv, jarg1, 0 );
        arg1 = (*jenv)->GetArrayLength( jenv, jarg1);
        Alen = arg1;
        setup_array_1d_d( &arg2, jxdata, Alen );
        /* Could find no easy way to do this as part of freearg so I modified
            * the previous function so it ALWAYS mallocs and copies so that
            * the java array can be released immediately. */
        (*jenv)->ReleaseDoubleArrayElements( jenv, jarg1, jxdata, 0 );
    }
    {
        jdouble *jydata = (*jenv)->GetDoubleArrayElements( jenv, jarg3, 0 );
        if((*jenv)->GetArrayLength( jenv, jarg3 ) != Alen) {
            printf("Vectors must be same length.\n");
            return;
        }
        setup_array_1d_d( &arg3, jydata, Alen );
        (*jenv)->ReleaseDoubleArrayElements( jenv, jarg3, jydata, 0 );
    }
    {
        jdouble *jydata = (*jenv)->GetDoubleArrayElements( jenv, jarg4, 0 );
        if((*jenv)->GetArrayLength( jenv, jarg4 ) != Alen) {
            printf("Vectors must be same length.\n");
            return;
        }
        setup_array_1d_d( &arg4, jydata, Alen );
        (*jenv)->ReleaseDoubleArrayElements( jenv, jarg4, jydata, 0 );
    }
    {
        jint *jydata = (*jenv)->GetIntArrayElements( jenv, jarg5, 0 );
        if((*jenv)->GetArrayLength( jenv, jarg5 ) < Alen-1) {
            printf("Vector must be at least length of others minus 1.\n");
            return;
        }
        setup_array_1d_i( &arg5, jydata, Alen);
        (*jenv)->ReleaseIntArrayElements( jenv, jarg5, jydata, 0 );
    }
    arg6 = (PLINT)jarg6; 
    plpoly3(arg1,arg2,arg3,arg4,arg5,arg6);
    
    {
        free(arg2);
    }
    {
        free(arg3);
    }
    {
        free(arg4);
    }
    {
        free(arg5);
    }
}


#define _doc_plprec "Set the floating point precision (in number of places) in numeric labels." 
JNIEXPORT void JNICALL Java_plplot_core_plplotjavacJNI_plprec(JNIEnv *jenv, jclass jcls, jint jarg1, jint jarg2) {
    PLINT arg1 ;
    PLINT arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = (PLINT)jarg1; 
    arg2 = (PLINT)jarg2; 
    plprec(arg1,arg2);
    
}


#define _doc_plpsty "Set fill pattern, using one of the predefined patterns." 
JNIEXPORT void JNICALL Java_plplot_core_plplotjavacJNI_plpsty(JNIEnv *jenv, jclass jcls, jint jarg1) {
    PLINT arg1 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = (PLINT)jarg1; 
    plpsty(arg1);
    
}


#define _doc_plptex "Print \"text\" at world cooordinate (x,y)." 
JNIEXPORT void JNICALL Java_plplot_core_plplotjavacJNI_plptex(JNIEnv *jenv, jclass jcls, jdouble jarg1, jdouble jarg2, jdouble jarg3, jdouble jarg4, jdouble jarg5, jstring jarg6) {
    PLFLT arg1 ;
    PLFLT arg2 ;
    PLFLT arg3 ;
    PLFLT arg4 ;
    PLFLT arg5 ;
    char *arg6 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = (PLFLT)jarg1; 
    arg2 = (PLFLT)jarg2; 
    arg3 = (PLFLT)jarg3; 
    arg4 = (PLFLT)jarg4; 
    arg5 = (PLFLT)jarg5; 
    {
        arg6 = 0;
        if (jarg6) {
            arg6 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg6, 0);
            if (!arg6) return ;
        }
    }
    plptex(arg1,arg2,arg3,arg4,arg5,(char const *)arg6);
    
    {
        if (arg6) (*jenv)->ReleaseStringUTFChars(jenv, jarg6, arg6); 
    }
}


#define _doc_plreplot "Replay contents of plot buffer to current device/file." 
JNIEXPORT void JNICALL Java_plplot_core_plplotjavacJNI_plreplot(JNIEnv *jenv, jclass jcls) {
    (void)jenv;
    (void)jcls;
    plreplot();
    
}


#define _doc_plschr "Set character height." 
JNIEXPORT void JNICALL Java_plplot_core_plplotjavacJNI_plschr(JNIEnv *jenv, jclass jcls, jdouble jarg1, jdouble jarg2) {
    PLFLT arg1 ;
    PLFLT arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = (PLFLT)jarg1; 
    arg2 = (PLFLT)jarg2; 
    plschr(arg1,arg2);
    
}


#define _doc_plscmap0 "Set color map 0 colors by 8 bit RGB values." 
JNIEXPORT void JNICALL Java_plplot_core_plplotjavacJNI_plscmap0(JNIEnv *jenv, jclass jcls, jintArray jarg1, jintArray jarg2, jintArray jarg3) {
    PLINT *arg1 = (PLINT *) 0 ;
    PLINT *arg2 = (PLINT *) 0 ;
    PLINT *arg3 = (PLINT *) 0 ;
    PLINT arg4 ;
    
    (void)jenv;
    (void)jcls;
    {
        jint *jydata = (*jenv)->GetIntArrayElements( jenv, jarg1, 0 );
        Alen = (*jenv)->GetArrayLength( jenv, jarg1);
        setup_array_1d_i( &arg1, jydata, Alen);
        (*jenv)->ReleaseIntArrayElements( jenv, jarg1, jydata, 0 );
    }
    {
        jint *jydata = (*jenv)->GetIntArrayElements( jenv, jarg2, 0 );
        if((*jenv)->GetArrayLength( jenv, jarg2 ) != Alen) {
            printf("Vectors must be same length.\n");
            return;
        }
        setup_array_1d_i( &arg2, jydata, Alen);
        (*jenv)->ReleaseIntArrayElements( jenv, jarg2, jydata, 0 );
    }
    {
        jint *jydata = (*jenv)->GetIntArrayElements( jenv, jarg3, 0 );
        if((*jenv)->GetArrayLength( jenv, jarg3 ) != Alen) {
            printf("Vectors must be same length.\n");
            return;
        }
        setup_array_1d_i( &arg3, jydata, Alen);
        (*jenv)->ReleaseIntArrayElements( jenv, jarg3, jydata, 0 );
    }
    plscmap0(arg1,arg2,arg3,arg4);
    
    {
        free(arg1);
    }
    {
        free(arg2);
    }
    {
        free(arg3);
    }
}


#define _doc_plscmap0n "Set number of colors in cmap 0." 
JNIEXPORT void JNICALL Java_plplot_core_plplotjavacJNI_plscmap0n(JNIEnv *jenv, jclass jcls, jint jarg1) {
    PLINT arg1 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = (PLINT)jarg1; 
    plscmap0n(arg1);
    
}


#define _doc_plscmap1 "Set color map 1 colors by 8 bit RGB values." 
JNIEXPORT void JNICALL Java_plplot_core_plplotjavacJNI_plscmap1(JNIEnv *jenv, jclass jcls, jintArray jarg1, jintArray jarg2, jintArray jarg3) {
    PLINT *arg1 = (PLINT *) 0 ;
    PLINT *arg2 = (PLINT *) 0 ;
    PLINT *arg3 = (PLINT *) 0 ;
    PLINT arg4 ;
    
    (void)jenv;
    (void)jcls;
    {
        jint *jydata = (*jenv)->GetIntArrayElements( jenv, jarg1, 0 );
        Alen = (*jenv)->GetArrayLength( jenv, jarg1);
        setup_array_1d_i( &arg1, jydata, Alen);
        (*jenv)->ReleaseIntArrayElements( jenv, jarg1, jydata, 0 );
    }
    {
        jint *jydata = (*jenv)->GetIntArrayElements( jenv, jarg2, 0 );
        if((*jenv)->GetArrayLength( jenv, jarg2 ) != Alen) {
            printf("Vectors must be same length.\n");
            return;
        }
        setup_array_1d_i( &arg2, jydata, Alen);
        (*jenv)->ReleaseIntArrayElements( jenv, jarg2, jydata, 0 );
    }
    {
        jint *jydata = (*jenv)->GetIntArrayElements( jenv, jarg3, 0 );
        if((*jenv)->GetArrayLength( jenv, jarg3 ) != Alen) {
            printf("Vectors must be same length.\n");
            return;
        }
        setup_array_1d_i( &arg3, jydata, Alen);
        (*jenv)->ReleaseIntArrayElements( jenv, jarg3, jydata, 0 );
    }
    plscmap1(arg1,arg2,arg3,arg4);
    
    {
        free(arg1);
    }
    {
        free(arg2);
    }
    {
        free(arg3);
    }
}


#define _doc_plscmap1l "Set color map 1 colors using a piece-wise linear relationship between intensity [0,1] (cmap 1 index) and position in HLS or RGB color space." 
JNIEXPORT void JNICALL Java_plplot_core_plplotjavacJNI_plscmap1l(JNIEnv *jenv, jclass jcls, jint jarg1, jdoubleArray jarg2, jdoubleArray jarg4, jdoubleArray jarg5, jdoubleArray jarg6, jintArray jarg7) {
    PLINT arg1 ;
    PLINT arg2 ;
    PLFLT *arg3 = (PLFLT *) 0 ;
    PLFLT *arg4 = (PLFLT *) 0 ;
    PLFLT *arg5 = (PLFLT *) 0 ;
    PLFLT *arg6 = (PLFLT *) 0 ;
    PLINT *arg7 = (PLINT *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = (PLINT)jarg1; 
    {
        jdouble *jxdata = (*jenv)->GetDoubleArrayElements( jenv, jarg2, 0 );
        arg2 = (*jenv)->GetArrayLength( jenv, jarg2);
        Alen = arg2;
        setup_array_1d_d( &arg3, jxdata, Alen );
        /* Could find no easy way to do this as part of freearg so I modified
            * the previous function so it ALWAYS mallocs and copies so that
            * the java array can be released immediately. */
        (*jenv)->ReleaseDoubleArrayElements( jenv, jarg2, jxdata, 0 );
    }
    {
        jdouble *jydata = (*jenv)->GetDoubleArrayElements( jenv, jarg4, 0 );
        if((*jenv)->GetArrayLength( jenv, jarg4 ) != Alen) {
            printf("Vectors must be same length.\n");
            return;
        }
        setup_array_1d_d( &arg4, jydata, Alen );
        (*jenv)->ReleaseDoubleArrayElements( jenv, jarg4, jydata, 0 );
    }
    {
        jdouble *jydata = (*jenv)->GetDoubleArrayElements( jenv, jarg5, 0 );
        if((*jenv)->GetArrayLength( jenv, jarg5 ) != Alen) {
            printf("Vectors must be same length.\n");
            return;
        }
        setup_array_1d_d( &arg5, jydata, Alen );
        (*jenv)->ReleaseDoubleArrayElements( jenv, jarg5, jydata, 0 );
    }
    {
        jdouble *jydata = (*jenv)->GetDoubleArrayElements( jenv, jarg6, 0 );
        if((*jenv)->GetArrayLength( jenv, jarg6 ) != Alen) {
            printf("Vectors must be same length.\n");
            return;
        }
        setup_array_1d_d( &arg6, jydata, Alen );
        (*jenv)->ReleaseDoubleArrayElements( jenv, jarg6, jydata, 0 );
    }
    {
        jint *jydata = (*jenv)->GetIntArrayElements( jenv, jarg7, 0 );
        if((*jenv)->GetArrayLength( jenv, jarg7 ) < Alen-1) {
            printf("Vector must be at least length of others minus 1.\n");
            return;
        }
        setup_array_1d_i( &arg7, jydata, Alen);
        (*jenv)->ReleaseIntArrayElements( jenv, jarg7, jydata, 0 );
    }
    plscmap1l(arg1,arg2,arg3,arg4,arg5,arg6,arg7);
    
    {
        free(arg3);
    }
    {
        free(arg4);
    }
    {
        free(arg5);
    }
    {
        free(arg6);
    }
    {
        free(arg7);
    }
}


#define _doc_plscmap1n "Set number of colors in cmap 1." 
JNIEXPORT void JNICALL Java_plplot_core_plplotjavacJNI_plscmap1n(JNIEnv *jenv, jclass jcls, jint jarg1) {
    PLINT arg1 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = (PLINT)jarg1; 
    plscmap1n(arg1);
    
}


#define _doc_plscol0 "Set 8-bit RGB value in cmap 0." 
JNIEXPORT void JNICALL Java_plplot_core_plplotjavacJNI_plscol0(JNIEnv *jenv, jclass jcls, jint jarg1, jint jarg2, jint jarg3, jint jarg4) {
    PLINT arg1 ;
    PLINT arg2 ;
    PLINT arg3 ;
    PLINT arg4 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = (PLINT)jarg1; 
    arg2 = (PLINT)jarg2; 
    arg3 = (PLINT)jarg3; 
    arg4 = (PLINT)jarg4; 
    plscol0(arg1,arg2,arg3,arg4);
    
}


#define _doc_plscolbg "Set the background color using 8-bit RGB value." 
JNIEXPORT void JNICALL Java_plplot_core_plplotjavacJNI_plscolbg(JNIEnv *jenv, jclass jcls, jint jarg1, jint jarg2, jint jarg3) {
    PLINT arg1 ;
    PLINT arg2 ;
    PLINT arg3 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = (PLINT)jarg1; 
    arg2 = (PLINT)jarg2; 
    arg3 = (PLINT)jarg3; 
    plscolbg(arg1,arg2,arg3);
    
}


#define _doc_plscolor "Globally turn color output on/off." 
JNIEXPORT void JNICALL Java_plplot_core_plplotjavacJNI_plscolor(JNIEnv *jenv, jclass jcls, jint jarg1) {
    PLINT arg1 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = (PLINT)jarg1; 
    plscolor(arg1);
    
}


#define _doc_plscompression "Set the compression level." 
JNIEXPORT void JNICALL Java_plplot_core_plplotjavacJNI_plscompression(JNIEnv *jenv, jclass jcls, jint jarg1) {
    PLINT arg1 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = (PLINT)jarg1; 
    plscompression(arg1);
    
}


#define _doc_plsdev "Set the device (keyword) name." 
JNIEXPORT void JNICALL Java_plplot_core_plplotjavacJNI_plsdev(JNIEnv *jenv, jclass jcls, jstring jarg1) {
    char *arg1 ;
    
    (void)jenv;
    (void)jcls;
    {
        arg1 = 0;
        if (jarg1) {
            arg1 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg1, 0);
            if (!arg1) return ;
        }
    }
    plsdev((char const *)arg1);
    
    {
        if (arg1) (*jenv)->ReleaseStringUTFChars(jenv, jarg1, arg1); 
    }
}


#define _doc_plsdidev "Set window into device space using margin, aspect ratio, and justification." 
JNIEXPORT void JNICALL Java_plplot_core_plplotjavacJNI_plsdidev(JNIEnv *jenv, jclass jcls, jdouble jarg1, jdouble jarg2, jdouble jarg3, jdouble jarg4) {
    PLFLT arg1 ;
    PLFLT arg2 ;
    PLFLT arg3 ;
    PLFLT arg4 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = (PLFLT)jarg1; 
    arg2 = (PLFLT)jarg2; 
    arg3 = (PLFLT)jarg3; 
    arg4 = (PLFLT)jarg4; 
    plsdidev(arg1,arg2,arg3,arg4);
    
}


#define _doc_plsdimap "Set up transformation from metafile coordinates." 
JNIEXPORT void JNICALL Java_plplot_core_plplotjavacJNI_plsdimap(JNIEnv *jenv, jclass jcls, jint jarg1, jint jarg2, jint jarg3, jint jarg4, jdouble jarg5, jdouble jarg6) {
    PLINT arg1 ;
    PLINT arg2 ;
    PLINT arg3 ;
    PLINT arg4 ;
    PLFLT arg5 ;
    PLFLT arg6 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = (PLINT)jarg1; 
    arg2 = (PLINT)jarg2; 
    arg3 = (PLINT)jarg3; 
    arg4 = (PLINT)jarg4; 
    arg5 = (PLFLT)jarg5; 
    arg6 = (PLFLT)jarg6; 
    plsdimap(arg1,arg2,arg3,arg4,arg5,arg6);
    
}


#define _doc_plsdiori "Set plot orientation, specifying rotation in units of pi/2." 
JNIEXPORT void JNICALL Java_plplot_core_plplotjavacJNI_plsdiori(JNIEnv *jenv, jclass jcls, jdouble jarg1) {
    PLFLT arg1 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = (PLFLT)jarg1; 
    plsdiori(arg1);
    
}


#define _doc_plsdiplt "Set window into plot space." 
JNIEXPORT void JNICALL Java_plplot_core_plplotjavacJNI_plsdiplt(JNIEnv *jenv, jclass jcls, jdouble jarg1, jdouble jarg2, jdouble jarg3, jdouble jarg4) {
    PLFLT arg1 ;
    PLFLT arg2 ;
    PLFLT arg3 ;
    PLFLT arg4 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = (PLFLT)jarg1; 
    arg2 = (PLFLT)jarg2; 
    arg3 = (PLFLT)jarg3; 
    arg4 = (PLFLT)jarg4; 
    plsdiplt(arg1,arg2,arg3,arg4);
    
}


#define _doc_plsdiplz "Set window into plot space incrementally (zoom)." 
JNIEXPORT void JNICALL Java_plplot_core_plplotjavacJNI_plsdiplz(JNIEnv *jenv, jclass jcls, jdouble jarg1, jdouble jarg2, jdouble jarg3, jdouble jarg4) {
    PLFLT arg1 ;
    PLFLT arg2 ;
    PLFLT arg3 ;
    PLFLT arg4 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = (PLFLT)jarg1; 
    arg2 = (PLFLT)jarg2; 
    arg3 = (PLFLT)jarg3; 
    arg4 = (PLFLT)jarg4; 
    plsdiplz(arg1,arg2,arg3,arg4);
    
}


#define _doc_plsesc "Set the escape character for text strings." 
JNIEXPORT void JNICALL Java_plplot_core_plplotjavacJNI_plsesc(JNIEnv *jenv, jclass jcls, jchar jarg1) {
    char arg1 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = (char)jarg1; 
    plsesc(arg1);
    
}


#define _doc_plsetopt "Process input strings, treating them as an option and argument pair. The first is for the external API, the second the work routine declared here for backward compatibilty." 
JNIEXPORT jint JNICALL Java_plplot_core_plplotjavacJNI_plsetopt(JNIEnv *jenv, jclass jcls, jstring jarg1, jstring jarg2) {
    jint jresult = 0 ;
    char *arg1 ;
    char *arg2 ;
    PLINT result;
    
    (void)jenv;
    (void)jcls;
    {
        arg1 = 0;
        if (jarg1) {
            arg1 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg1, 0);
            if (!arg1) return 0;
        }
    }
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
            if (!arg2) return 0;
        }
    }
    result = (PLINT)plsetopt(arg1,arg2);
    
    jresult = (jint)result; 
    {
        if (arg1) (*jenv)->ReleaseStringUTFChars(jenv, jarg1, arg1); 
    }
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
    return jresult;
}


#define _doc_plsfam "Set family file parameters." 
JNIEXPORT void JNICALL Java_plplot_core_plplotjavacJNI_plsfam(JNIEnv *jenv, jclass jcls, jint jarg1, jint jarg2, jint jarg3) {
    PLINT arg1 ;
    PLINT arg2 ;
    PLINT arg3 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = (PLINT)jarg1; 
    arg2 = (PLINT)jarg2; 
    arg3 = (PLINT)jarg3; 
    plsfam(arg1,arg2,arg3);
    
}


#define _doc_plsfnam "Set the output file name." 
JNIEXPORT void JNICALL Java_plplot_core_plplotjavacJNI_plsfnam(JNIEnv *jenv, jclass jcls, jstring jarg1) {
    char *arg1 ;
    
    (void)jenv;
    (void)jcls;
    {
        arg1 = 0;
        if (jarg1) {
            arg1 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg1, 0);
            if (!arg1) return ;
        }
    }
    plsfnam((char const *)arg1);
    
    {
        if (arg1) (*jenv)->ReleaseStringUTFChars(jenv, jarg1, arg1); 
    }
}


#define _doc_plshades "Shade regions with continuous range of colours." 
JNIEXPORT void JNICALL Java_plplot_core_plplotjavacJNI_plshades(JNIEnv *jenv, jclass jcls, jobjectArray jarg1, jdouble jarg5, jdouble jarg6, jdouble jarg7, jdouble jarg8, jdoubleArray jarg9, jint jarg11, jint jarg12, jint jarg13, jint jarg15, jobjectArray jarg16, jobjectArray jarg17) {
    PLFLT **arg1 = (PLFLT **) 0 ;
    PLINT arg2 ;
    PLINT arg3 ;
    defined_func arg4 ;
    PLFLT arg5 ;
    PLFLT arg6 ;
    PLFLT arg7 ;
    PLFLT arg8 ;
    PLFLT *arg9 = (PLFLT *) 0 ;
    PLINT arg10 ;
    PLINT arg11 ;
    PLINT arg12 ;
    PLINT arg13 ;
    fill_func arg14 ;
    PLINT arg15 ;
    pltr_func arg16 ;
    PLPointer arg17 = (PLPointer) 0 ;
    
    (void)jenv;
    (void)jcls;
    {
        arg4 = NULL;
    }
    {
        arg14 = plfill;
    }
    {
        jdouble **adat;
        jobject *ai;
        int nx = (*jenv)->GetArrayLength( jenv, jarg1 );
        int ny = -1;
        int i, j;
        ai = (jobject *) malloc( nx * sizeof(jobject) );
        adat = (jdouble **) malloc( nx * sizeof(jdouble *) );
        
        for( i=0; i < nx; i++ )
        {
            ai[i] = (*jenv)->GetObjectArrayElement( jenv, jarg1, i );
            adat[i] = (*jenv)->GetDoubleArrayElements( jenv, ai[i], 0 );
            
            if (ny == -1)
            ny = (*jenv)->GetArrayLength( jenv, ai[i] );
            else if (ny != (*jenv)->GetArrayLength( jenv, ai[i] )) {
                printf( "Misshapen a array.\n" );
                for( j=0; j <= i; j++ )
                (*jenv)->ReleaseDoubleArrayElements( jenv, ai[j], adat[j], 0 );
                free(adat);
                free(ai);
                return;
            }
        }
        
        Xlen = nx;
        Ylen = ny;
        setup_array_2d_d( &arg1, adat, nx, ny );
        arg2 = nx;
        arg3 = ny;
        for( i=0; i < nx; i++ ) {
            (*jenv)->ReleaseDoubleArrayElements( jenv, ai[i], adat[i], 0 );
            (*jenv)->DeleteLocalRef(jenv, ai[i]);
        }
        
        free(adat);
        free(ai);
        
    }
    arg5 = (PLFLT)jarg5; 
    arg6 = (PLFLT)jarg6; 
    arg7 = (PLFLT)jarg7; 
    arg8 = (PLFLT)jarg8; 
    {
        jdouble *jxdata = (*jenv)->GetDoubleArrayElements( jenv, jarg9, 0 );
        arg10 = (*jenv)->GetArrayLength( jenv, jarg9 );
        setup_array_1d_d( &arg9, jxdata, arg10);
        (*jenv)->ReleaseDoubleArrayElements( jenv, jarg9, jxdata, 0 );
    }
    arg11 = (PLINT)jarg11; 
    arg12 = (PLINT)jarg12; 
    arg13 = (PLINT)jarg13; 
    arg15 = (PLINT)jarg15; 
    {
        jdouble **adat;
        jobject *ai;
        int nx = (*jenv)->GetArrayLength( jenv, jarg16 );
        int ny = -1;
        int i, j;
        ai = (jobject *) malloc( nx * sizeof(jobject) );
        adat = (jdouble **) malloc( nx * sizeof(jdouble *) );
        
        for( i=0; i < nx; i++ )
        {
            ai[i] = (*jenv)->GetObjectArrayElement( jenv, jarg16, i );
            adat[i] = (*jenv)->GetDoubleArrayElements( jenv, ai[i], 0 );
            
            if (ny == -1)
            ny = (*jenv)->GetArrayLength( jenv, ai[i] );
            else if (ny != (*jenv)->GetArrayLength( jenv, ai[i] )) {
                printf( "Misshapen a array.\n" );
                for( j=0; j <= i; j++ )
                (*jenv)->ReleaseDoubleArrayElements( jenv, ai[j], adat[j], 0 );
                free(adat);
                free(ai);
                return;
            }
        }
        
        if( !((nx == Xlen && ny == Ylen) || (nx == Xlen && ny == 1))) {
            printf( "Xlen = %d, nx = %d, Ylen = %d, ny = %d\n", Xlen, nx, Ylen, ny );
            printf( "X vector or matrix must match matrix dimensions.\n" );
            for( i=0; i < nx; i++ )
            (*jenv)->ReleaseDoubleArrayElements( jenv, ai[i], adat[i], 0 );
            free(adat);
            free(ai);
            return;
        }
        /* Store whether second dimension is unity. */
        Alen = ny;
        setup_array_2d_d( &xg, adat, nx, ny );
        for( i=0; i < nx; i++ ) {
            (*jenv)->ReleaseDoubleArrayElements( jenv, ai[i], adat[i], 0 );
            (*jenv)->DeleteLocalRef(jenv, ai[i]);
        }
        
        free(adat);
        free(ai);
        arg16 = pltr2;
        
    }
    {
        jdouble **adat;
        jobject *ai;
        int nx = (*jenv)->GetArrayLength( jenv, jarg17 );
        int ny = -1;
        int i, j;
        PLcGrid2 cgrid;
        ai = (jobject *) malloc( nx * sizeof(jobject) );
        adat = (jdouble **) malloc( nx * sizeof(jdouble *) );
        
        for( i=0; i < nx; i++ )
        {
            ai[i] = (*jenv)->GetObjectArrayElement( jenv, jarg17, i );
            adat[i] = (*jenv)->GetDoubleArrayElements( jenv, ai[i], 0 );
            
            if (ny == -1)
            ny = (*jenv)->GetArrayLength( jenv, ai[i] );
            else if (ny != (*jenv)->GetArrayLength( jenv, ai[i] )) {
                printf( "Misshapen a array.\n" );
                for( j=0; j <= i; j++ )
                (*jenv)->ReleaseDoubleArrayElements( jenv, ai[j], adat[j], 0 );
                free(adat);
                free(ai);
                return;
            }
        }
        
        if( !((nx == Xlen && ny == Ylen) || (nx == Ylen && ny == 1 && ny == Alen))) {
            printf( "Xlen = %d, nx = %d, Ylen = %d, Alen = %d, ny = %d\n",
            Xlen, nx, Ylen, Alen, ny );
            printf( "Y vector or matrix must match matrix dimensions.\n" );
            for( i=0; i < nx; i++ )
            (*jenv)->ReleaseDoubleArrayElements( jenv, ai[i], adat[i], 0 );
            free(adat);
            free(ai);
            return;
        }
        setup_array_2d_d( &yg, adat, nx, ny );
        for( i=0; i < nx; i++ ) {
            (*jenv)->ReleaseDoubleArrayElements( jenv, ai[i], adat[i], 0 );
            (*jenv)->DeleteLocalRef(jenv, ai[i]);
        }
        
        free(adat);
        free(ai);
        cgrid.xg = xg;
        cgrid.yg = yg;
        cgrid.nx = nx;
        cgrid.ny = ny;
        arg17 = &cgrid;
        
    }
    plshades(arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8,arg9,arg10,arg11,arg12,arg13,arg14,arg15,arg16,arg17);
    
    {
        free(arg1[0]);
        free(arg1);
    }
    {
        free(arg9);
    }
    {
        free(xg[0]);
        free(xg);
    }
    {
        free(yg[0]);
        free(yg);
    }
}


#define _doc_plshade "Shade region with discrete colour, pattern fill." 
JNIEXPORT void JNICALL Java_plplot_core_plplotjavacJNI_plshade(JNIEnv *jenv, jclass jcls, jobjectArray jarg1, jdouble jarg5, jdouble jarg6, jdouble jarg7, jdouble jarg8, jdouble jarg9, jdouble jarg10, jint jarg11, jdouble jarg12, jint jarg13, jint jarg14, jint jarg15, jint jarg16, jint jarg17, jint jarg19, jobjectArray jarg20, jobjectArray jarg21) {
    PLFLT **arg1 = (PLFLT **) 0 ;
    PLINT arg2 ;
    PLINT arg3 ;
    defined_func arg4 ;
    PLFLT arg5 ;
    PLFLT arg6 ;
    PLFLT arg7 ;
    PLFLT arg8 ;
    PLFLT arg9 ;
    PLFLT arg10 ;
    PLINT arg11 ;
    PLFLT arg12 ;
    PLINT arg13 ;
    PLINT arg14 ;
    PLINT arg15 ;
    PLINT arg16 ;
    PLINT arg17 ;
    fill_func arg18 ;
    PLINT arg19 ;
    pltr_func arg20 ;
    PLPointer arg21 = (PLPointer) 0 ;
    
    (void)jenv;
    (void)jcls;
    {
        arg4 = NULL;
    }
    {
        arg18 = plfill;
    }
    {
        jdouble **adat;
        jobject *ai;
        int nx = (*jenv)->GetArrayLength( jenv, jarg1 );
        int ny = -1;
        int i, j;
        ai = (jobject *) malloc( nx * sizeof(jobject) );
        adat = (jdouble **) malloc( nx * sizeof(jdouble *) );
        
        for( i=0; i < nx; i++ )
        {
            ai[i] = (*jenv)->GetObjectArrayElement( jenv, jarg1, i );
            adat[i] = (*jenv)->GetDoubleArrayElements( jenv, ai[i], 0 );
            
            if (ny == -1)
            ny = (*jenv)->GetArrayLength( jenv, ai[i] );
            else if (ny != (*jenv)->GetArrayLength( jenv, ai[i] )) {
                printf( "Misshapen a array.\n" );
                for( j=0; j <= i; j++ )
                (*jenv)->ReleaseDoubleArrayElements( jenv, ai[j], adat[j], 0 );
                free(adat);
                free(ai);
                return;
            }
        }
        
        Xlen = nx;
        Ylen = ny;
        setup_array_2d_d( &arg1, adat, nx, ny );
        arg2 = nx;
        arg3 = ny;
        for( i=0; i < nx; i++ ) {
            (*jenv)->ReleaseDoubleArrayElements( jenv, ai[i], adat[i], 0 );
            (*jenv)->DeleteLocalRef(jenv, ai[i]);
        }
        
        free(adat);
        free(ai);
        
    }
    arg5 = (PLFLT)jarg5; 
    arg6 = (PLFLT)jarg6; 
    arg7 = (PLFLT)jarg7; 
    arg8 = (PLFLT)jarg8; 
    arg9 = (PLFLT)jarg9; 
    arg10 = (PLFLT)jarg10; 
    arg11 = (PLINT)jarg11; 
    arg12 = (PLFLT)jarg12; 
    arg13 = (PLINT)jarg13; 
    arg14 = (PLINT)jarg14; 
    arg15 = (PLINT)jarg15; 
    arg16 = (PLINT)jarg16; 
    arg17 = (PLINT)jarg17; 
    arg19 = (PLINT)jarg19; 
    {
        jdouble **adat;
        jobject *ai;
        int nx = (*jenv)->GetArrayLength( jenv, jarg20 );
        int ny = -1;
        int i, j;
        ai = (jobject *) malloc( nx * sizeof(jobject) );
        adat = (jdouble **) malloc( nx * sizeof(jdouble *) );
        
        for( i=0; i < nx; i++ )
        {
            ai[i] = (*jenv)->GetObjectArrayElement( jenv, jarg20, i );
            adat[i] = (*jenv)->GetDoubleArrayElements( jenv, ai[i], 0 );
            
            if (ny == -1)
            ny = (*jenv)->GetArrayLength( jenv, ai[i] );
            else if (ny != (*jenv)->GetArrayLength( jenv, ai[i] )) {
                printf( "Misshapen a array.\n" );
                for( j=0; j <= i; j++ )
                (*jenv)->ReleaseDoubleArrayElements( jenv, ai[j], adat[j], 0 );
                free(adat);
                free(ai);
                return;
            }
        }
        
        if( !((nx == Xlen && ny == Ylen) || (nx == Xlen && ny == 1))) {
            printf( "Xlen = %d, nx = %d, Ylen = %d, ny = %d\n", Xlen, nx, Ylen, ny );
            printf( "X vector or matrix must match matrix dimensions.\n" );
            for( i=0; i < nx; i++ )
            (*jenv)->ReleaseDoubleArrayElements( jenv, ai[i], adat[i], 0 );
            free(adat);
            free(ai);
            return;
        }
        /* Store whether second dimension is unity. */
        Alen = ny;
        setup_array_2d_d( &xg, adat, nx, ny );
        for( i=0; i < nx; i++ ) {
            (*jenv)->ReleaseDoubleArrayElements( jenv, ai[i], adat[i], 0 );
            (*jenv)->DeleteLocalRef(jenv, ai[i]);
        }
        
        free(adat);
        free(ai);
        arg20 = pltr2;
        
    }
    {
        jdouble **adat;
        jobject *ai;
        int nx = (*jenv)->GetArrayLength( jenv, jarg21 );
        int ny = -1;
        int i, j;
        PLcGrid2 cgrid;
        ai = (jobject *) malloc( nx * sizeof(jobject) );
        adat = (jdouble **) malloc( nx * sizeof(jdouble *) );
        
        for( i=0; i < nx; i++ )
        {
            ai[i] = (*jenv)->GetObjectArrayElement( jenv, jarg21, i );
            adat[i] = (*jenv)->GetDoubleArrayElements( jenv, ai[i], 0 );
            
            if (ny == -1)
            ny = (*jenv)->GetArrayLength( jenv, ai[i] );
            else if (ny != (*jenv)->GetArrayLength( jenv, ai[i] )) {
                printf( "Misshapen a array.\n" );
                for( j=0; j <= i; j++ )
                (*jenv)->ReleaseDoubleArrayElements( jenv, ai[j], adat[j], 0 );
                free(adat);
                free(ai);
                return;
            }
        }
        
        if( !((nx == Xlen && ny == Ylen) || (nx == Ylen && ny == 1 && ny == Alen))) {
            printf( "Xlen = %d, nx = %d, Ylen = %d, Alen = %d, ny = %d\n",
            Xlen, nx, Ylen, Alen, ny );
            printf( "Y vector or matrix must match matrix dimensions.\n" );
            for( i=0; i < nx; i++ )
            (*jenv)->ReleaseDoubleArrayElements( jenv, ai[i], adat[i], 0 );
            free(adat);
            free(ai);
            return;
        }
        setup_array_2d_d( &yg, adat, nx, ny );
        for( i=0; i < nx; i++ ) {
            (*jenv)->ReleaseDoubleArrayElements( jenv, ai[i], adat[i], 0 );
            (*jenv)->DeleteLocalRef(jenv, ai[i]);
        }
        
        free(adat);
        free(ai);
        cgrid.xg = xg;
        cgrid.yg = yg;
        cgrid.nx = nx;
        cgrid.ny = ny;
        arg21 = &cgrid;
        
    }
    plshade(arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8,arg9,arg10,arg11,arg12,arg13,arg14,arg15,arg16,arg17,arg18,arg19,arg20,arg21);
    
    {
        free(arg1[0]);
        free(arg1);
    }
    {
        free(xg[0]);
        free(xg);
    }
    {
        free(yg[0]);
        free(yg);
    }
}


#define _doc_plsmaj "Set up lengths of major tick marks." 
JNIEXPORT void JNICALL Java_plplot_core_plplotjavacJNI_plsmaj(JNIEnv *jenv, jclass jcls, jdouble jarg1, jdouble jarg2) {
    PLFLT arg1 ;
    PLFLT arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = (PLFLT)jarg1; 
    arg2 = (PLFLT)jarg2; 
    plsmaj(arg1,arg2);
    
}


#define _doc_plsmin "Set up lengths of minor tick marks." 
JNIEXPORT void JNICALL Java_plplot_core_plplotjavacJNI_plsmin(JNIEnv *jenv, jclass jcls, jdouble jarg1, jdouble jarg2) {
    PLFLT arg1 ;
    PLFLT arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = (PLFLT)jarg1; 
    arg2 = (PLFLT)jarg2; 
    plsmin(arg1,arg2);
    
}


#define _doc_plsori "Set orientation.  Must be done before calling plinit." 
JNIEXPORT void JNICALL Java_plplot_core_plplotjavacJNI_plsori(JNIEnv *jenv, jclass jcls, jint jarg1) {
    PLINT arg1 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = (PLINT)jarg1; 
    plsori(arg1);
    
}


#define _doc_plspage "Set output device parameters.  Usually ignored by the driver." 
JNIEXPORT void JNICALL Java_plplot_core_plplotjavacJNI_plspage(JNIEnv *jenv, jclass jcls, jdouble jarg1, jdouble jarg2, jint jarg3, jint jarg4, jint jarg5, jint jarg6) {
    PLFLT arg1 ;
    PLFLT arg2 ;
    PLINT arg3 ;
    PLINT arg4 ;
    PLINT arg5 ;
    PLINT arg6 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = (PLFLT)jarg1; 
    arg2 = (PLFLT)jarg2; 
    arg3 = (PLINT)jarg3; 
    arg4 = (PLINT)jarg4; 
    arg5 = (PLINT)jarg5; 
    arg6 = (PLINT)jarg6; 
    plspage(arg1,arg2,arg3,arg4,arg5,arg6);
    
}


#define _doc_plspause "Set the pause (on end-of-page) status." 
JNIEXPORT void JNICALL Java_plplot_core_plplotjavacJNI_plspause(JNIEnv *jenv, jclass jcls, jint jarg1) {
    PLINT arg1 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = (PLINT)jarg1; 
    plspause(arg1);
    
}


#define _doc_plsstrm "Set stream number." 
JNIEXPORT void JNICALL Java_plplot_core_plplotjavacJNI_plsstrm(JNIEnv *jenv, jclass jcls, jint jarg1) {
    PLINT arg1 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = (PLINT)jarg1; 
    plsstrm(arg1);
    
}


#define _doc_plssub "Set the number of subwindows in x and y." 
JNIEXPORT void JNICALL Java_plplot_core_plplotjavacJNI_plssub(JNIEnv *jenv, jclass jcls, jint jarg1, jint jarg2) {
    PLINT arg1 ;
    PLINT arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = (PLINT)jarg1; 
    arg2 = (PLINT)jarg2; 
    plssub(arg1,arg2);
    
}


#define _doc_plssym "Set symbol height." 
JNIEXPORT void JNICALL Java_plplot_core_plplotjavacJNI_plssym(JNIEnv *jenv, jclass jcls, jdouble jarg1, jdouble jarg2) {
    PLFLT arg1 ;
    PLFLT arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = (PLFLT)jarg1; 
    arg2 = (PLFLT)jarg2; 
    plssym(arg1,arg2);
    
}


#define _doc_plstar "Initialize PLplot, passing in the windows/page settings." 
JNIEXPORT void JNICALL Java_plplot_core_plplotjavacJNI_plstar(JNIEnv *jenv, jclass jcls, jint jarg1, jint jarg2) {
    PLINT arg1 ;
    PLINT arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = (PLINT)jarg1; 
    arg2 = (PLINT)jarg2; 
    plstar(arg1,arg2);
    
}


#define _doc_plstart "Initialize PLplot, passing the device name and windows/page settings." 
JNIEXPORT void JNICALL Java_plplot_core_plplotjavacJNI_plstart(JNIEnv *jenv, jclass jcls, jstring jarg1, jint jarg2, jint jarg3) {
    char *arg1 ;
    PLINT arg2 ;
    PLINT arg3 ;
    
    (void)jenv;
    (void)jcls;
    {
        arg1 = 0;
        if (jarg1) {
            arg1 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg1, 0);
            if (!arg1) return ;
        }
    }
    arg2 = (PLINT)jarg2; 
    arg3 = (PLINT)jarg3; 
    plstart((char const *)arg1,arg2,arg3);
    
    {
        if (arg1) (*jenv)->ReleaseStringUTFChars(jenv, jarg1, arg1); 
    }
}


#define _doc_plstripa "Add a point to a stripchart. " 
JNIEXPORT void JNICALL Java_plplot_core_plplotjavacJNI_plstripa(JNIEnv *jenv, jclass jcls, jint jarg1, jint jarg2, jdouble jarg3, jdouble jarg4) {
    PLINT arg1 ;
    PLINT arg2 ;
    PLFLT arg3 ;
    PLFLT arg4 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = (PLINT)jarg1; 
    arg2 = (PLINT)jarg2; 
    arg3 = (PLFLT)jarg3; 
    arg4 = (PLFLT)jarg4; 
    plstripa(arg1,arg2,arg3,arg4);
    
}


#define _doc_plstripc "Create 1d stripchart." 
JNIEXPORT void JNICALL Java_plplot_core_plplotjavacJNI_plstripc(JNIEnv *jenv, jclass jcls, jintArray jarg1, jstring jarg2, jstring jarg3, jdouble jarg4, jdouble jarg5, jdouble jarg6, jdouble jarg7, jdouble jarg8, jdouble jarg9, jdouble jarg10, jint jarg11, jint jarg12, jint jarg13, jint jarg14, jintArray jarg15, jintArray jarg16, jlong jarg17, jstring jarg18, jstring jarg19, jstring jarg20) {
    PLINT *arg1 = (PLINT *) 0 ;
    char *arg2 ;
    char *arg3 ;
    PLFLT arg4 ;
    PLFLT arg5 ;
    PLFLT arg6 ;
    PLFLT arg7 ;
    PLFLT arg8 ;
    PLFLT arg9 ;
    PLFLT arg10 ;
    PLINT arg11 ;
    PLINT arg12 ;
    PLINT arg13 ;
    PLINT arg14 ;
    PLINT *arg15 = (PLINT *) 0 ;
    PLINT *arg16 = (PLINT *) 0 ;
    char **arg17 ;
    char *arg18 ;
    char *arg19 ;
    char *arg20 ;
    PLINT temp1 ;
    
    (void)jenv;
    (void)jcls;
    {
        if (!jarg1) {
            SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "array null");
            return ;
        }
        if ((*jenv)->GetArrayLength(jenv, jarg1) == 0) {
            SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, "Array must contain at least 1 element");
            return ;
        }
        arg1 = &temp1; 
    }
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
            if (!arg2) return ;
        }
    }
    {
        arg3 = 0;
        if (jarg3) {
            arg3 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg3, 0);
            if (!arg3) return ;
        }
    }
    arg4 = (PLFLT)jarg4; 
    arg5 = (PLFLT)jarg5; 
    arg6 = (PLFLT)jarg6; 
    arg7 = (PLFLT)jarg7; 
    arg8 = (PLFLT)jarg8; 
    arg9 = (PLFLT)jarg9; 
    arg10 = (PLFLT)jarg10; 
    arg11 = (PLINT)jarg11; 
    arg12 = (PLINT)jarg12; 
    arg13 = (PLINT)jarg13; 
    arg14 = (PLINT)jarg14; 
    {
        jint *jydata = (*jenv)->GetIntArrayElements( jenv, jarg15, 0 );
        Alen = (*jenv)->GetArrayLength( jenv, jarg15);
        setup_array_1d_i( &arg15, jydata, Alen);
        (*jenv)->ReleaseIntArrayElements( jenv, jarg15, jydata, 0 );
    }
    {
        jint *jydata = (*jenv)->GetIntArrayElements( jenv, jarg16, 0 );
        if((*jenv)->GetArrayLength( jenv, jarg16 ) != Alen) {
            printf("Vectors must be same length.\n");
            return;
        }
        setup_array_1d_i( &arg16, jydata, Alen);
        (*jenv)->ReleaseIntArrayElements( jenv, jarg16, jydata, 0 );
    }
    arg17 = *(char ***)&jarg17; 
    {
        arg18 = 0;
        if (jarg18) {
            arg18 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg18, 0);
            if (!arg18) return ;
        }
    }
    {
        arg19 = 0;
        if (jarg19) {
            arg19 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg19, 0);
            if (!arg19) return ;
        }
    }
    {
        arg20 = 0;
        if (jarg20) {
            arg20 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg20, 0);
            if (!arg20) return ;
        }
    }
    plstripc(arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8,arg9,arg10,arg11,arg12,arg13,arg14,arg15,arg16,arg17,arg18,arg19,arg20);
    
    {
        jint jvalue = (jint)temp1;
        (*jenv)->SetIntArrayRegion(jenv, jarg1, 0, 1, &jvalue);
    }
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
    {
        if (arg3) (*jenv)->ReleaseStringUTFChars(jenv, jarg3, arg3); 
    }
    {
        free(arg15);
    }
    {
        free(arg16);
    }
    {
        if (arg18) (*jenv)->ReleaseStringUTFChars(jenv, jarg18, arg18); 
    }
    {
        if (arg19) (*jenv)->ReleaseStringUTFChars(jenv, jarg19, arg19); 
    }
    {
        if (arg20) (*jenv)->ReleaseStringUTFChars(jenv, jarg20, arg20); 
    }
}


#define _doc_plstripd "Deletes and releases memory used by a stripchart. " 
JNIEXPORT void JNICALL Java_plplot_core_plplotjavacJNI_plstripd(JNIEnv *jenv, jclass jcls, jint jarg1) {
    PLINT arg1 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = (PLINT)jarg1; 
    plstripd(arg1);
    
}


#define _doc_plstyl "Set up a new line style." 
JNIEXPORT void JNICALL Java_plplot_core_plplotjavacJNI_plstyl(JNIEnv *jenv, jclass jcls, jintArray jarg1, jintArray jarg3) {
    PLINT arg1 ;
    PLINT *arg2 = (PLINT *) 0 ;
    PLINT *arg3 = (PLINT *) 0 ;
    
    (void)jenv;
    (void)jcls;
    {
        jint *jxdata = (*jenv)->GetIntArrayElements( jenv, jarg1, 0 );
        arg1 = (*jenv)->GetArrayLength( jenv, jarg1);
        Alen = arg1;
        setup_array_1d_i( &arg2, jxdata, Alen);
        /* Could find no easy way to do this as part of freearg so I modified
            * the previous function so it ALWAYS mallocs and copies so that
            * the java array can be released immediately. */
        (*jenv)->ReleaseIntArrayElements( jenv, jarg1, jxdata, 0 );
    }
    {
        jint *jydata = (*jenv)->GetIntArrayElements( jenv, jarg3, 0 );
        if((*jenv)->GetArrayLength( jenv, jarg3 ) != Alen) {
            printf("Vectors must be same length.\n");
            return;
        }
        setup_array_1d_i( &arg3, jydata, Alen);
        (*jenv)->ReleaseIntArrayElements( jenv, jarg3, jydata, 0 );
    }
    plstyl(arg1,arg2,arg3);
    
    {
        free(arg2);
    }
    {
        free(arg3);
    }
}


#define _doc_plsvect "Set vector arrow style." 
JNIEXPORT void JNICALL Java_plplot_core_plplotjavacJNI_plsvect(JNIEnv *jenv, jclass jcls, jdoubleArray jarg1, jdoubleArray jarg2, jint jarg3, jint jarg4) {
    PLFLT *arg1 = (PLFLT *) 0 ;
    PLFLT *arg2 = (PLFLT *) 0 ;
    PLINT arg3 ;
    PLINT arg4 ;
    
    (void)jenv;
    (void)jcls;
    {
        jdouble *jxdata = (*jenv)->GetDoubleArrayElements( jenv, jarg1, 0 );
        Alen = (*jenv)->GetArrayLength( jenv, jarg1 );
        setup_array_1d_d( &arg1, jxdata, Alen);
        (*jenv)->ReleaseDoubleArrayElements( jenv, jarg1, jxdata, 0 );
    }
    {
        jdouble *jydata = (*jenv)->GetDoubleArrayElements( jenv, jarg2, 0 );
        if((*jenv)->GetArrayLength( jenv, jarg2 ) != Alen) {
            printf("Vectors must be same length.\n");
            return;
        }
        setup_array_1d_d( &arg2, jydata, Alen );
        (*jenv)->ReleaseDoubleArrayElements( jenv, jarg2, jydata, 0 );
    }
    arg3 = (PLINT)jarg3; 
    arg4 = (PLINT)jarg4; 
    plsvect(arg1,arg2,arg3,arg4);
    
    {
        free(arg1);
    }
    {
        free(arg2);
    }
}


#define _doc_plsvpa "Set the edges of the viewport to the specified absolute coordinates." 
JNIEXPORT void JNICALL Java_plplot_core_plplotjavacJNI_plsvpa(JNIEnv *jenv, jclass jcls, jdouble jarg1, jdouble jarg2, jdouble jarg3, jdouble jarg4) {
    PLFLT arg1 ;
    PLFLT arg2 ;
    PLFLT arg3 ;
    PLFLT arg4 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = (PLFLT)jarg1; 
    arg2 = (PLFLT)jarg2; 
    arg3 = (PLFLT)jarg3; 
    arg4 = (PLFLT)jarg4; 
    plsvpa(arg1,arg2,arg3,arg4);
    
}


#define _doc_plsxax "Set x axis labeling parameters." 
JNIEXPORT void JNICALL Java_plplot_core_plplotjavacJNI_plsxax(JNIEnv *jenv, jclass jcls, jint jarg1, jint jarg2) {
    PLINT arg1 ;
    PLINT arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = (PLINT)jarg1; 
    arg2 = (PLINT)jarg2; 
    plsxax(arg1,arg2);
    
}


#define _doc_plsyax "Set y axis labeling parameters." 
JNIEXPORT void JNICALL Java_plplot_core_plplotjavacJNI_plsyax(JNIEnv *jenv, jclass jcls, jint jarg1, jint jarg2) {
    PLINT arg1 ;
    PLINT arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = (PLINT)jarg1; 
    arg2 = (PLINT)jarg2; 
    plsyax(arg1,arg2);
    
}


#define _doc_plsym "Plot array y against x for n points using Hershey symbol \"code\"" 
JNIEXPORT void JNICALL Java_plplot_core_plplotjavacJNI_plsym(JNIEnv *jenv, jclass jcls, jdoubleArray jarg1, jdoubleArray jarg3, jint jarg4) {
    PLINT arg1 ;
    PLFLT *arg2 = (PLFLT *) 0 ;
    PLFLT *arg3 = (PLFLT *) 0 ;
    PLINT arg4 ;
    
    (void)jenv;
    (void)jcls;
    {
        jdouble *jxdata = (*jenv)->GetDoubleArrayElements( jenv, jarg1, 0 );
        arg1 = (*jenv)->GetArrayLength( jenv, jarg1);
        Alen = arg1;
        setup_array_1d_d( &arg2, jxdata, Alen );
        /* Could find no easy way to do this as part of freearg so I modified
            * the previous function so it ALWAYS mallocs and copies so that
            * the java array can be released immediately. */
        (*jenv)->ReleaseDoubleArrayElements( jenv, jarg1, jxdata, 0 );
    }
    {
        jdouble *jydata = (*jenv)->GetDoubleArrayElements( jenv, jarg3, 0 );
        if((*jenv)->GetArrayLength( jenv, jarg3 ) != Alen) {
            printf("Vectors must be same length.\n");
            return;
        }
        setup_array_1d_d( &arg3, jydata, Alen );
        (*jenv)->ReleaseDoubleArrayElements( jenv, jarg3, jydata, 0 );
    }
    arg4 = (PLINT)jarg4; 
    plsym(arg1,arg2,arg3,arg4);
    
    {
        free(arg2);
    }
    {
        free(arg3);
    }
}


#define _doc_plszax "Set z axis labeling parameters" 
JNIEXPORT void JNICALL Java_plplot_core_plplotjavacJNI_plszax(JNIEnv *jenv, jclass jcls, jint jarg1, jint jarg2) {
    PLINT arg1 ;
    PLINT arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = (PLINT)jarg1; 
    arg2 = (PLINT)jarg2; 
    plszax(arg1,arg2);
    
}


#define _doc_pltext "Switch to text screen." 
JNIEXPORT void JNICALL Java_plplot_core_plplotjavacJNI_pltext(JNIEnv *jenv, jclass jcls) {
    (void)jenv;
    (void)jcls;
    pltext();
    
}


#define _doc_plvasp "Sets the edges of the viewport with the given aspect ratio, leaving room for labels." 
JNIEXPORT void JNICALL Java_plplot_core_plplotjavacJNI_plvasp(JNIEnv *jenv, jclass jcls, jdouble jarg1) {
    PLFLT arg1 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = (PLFLT)jarg1; 
    plvasp(arg1);
    
}


#define _doc_plvect "Plot vectors." 
JNIEXPORT void JNICALL Java_plplot_core_plplotjavacJNI_plvect(JNIEnv *jenv, jclass jcls, jobjectArray jarg1, jobjectArray jarg2, jdouble jarg5, jobjectArray jarg6, jobjectArray jarg7) {
    PLFLT **arg1 = (PLFLT **) 0 ;
    PLFLT **arg2 = (PLFLT **) 0 ;
    PLINT arg3 ;
    PLINT arg4 ;
    PLFLT arg5 ;
    pltr_func arg6 ;
    PLPointer arg7 = (PLPointer) 0 ;
    
    (void)jenv;
    (void)jcls;
    {
        jdouble **adat;
        jobject *ai;
        int nx = (*jenv)->GetArrayLength( jenv, jarg1 );
        int ny = -1;
        int i, j;
        ai = (jobject *) malloc( nx * sizeof(jobject) );
        adat = (jdouble **) malloc( nx * sizeof(jdouble *) );
        
        for( i=0; i < nx; i++ )
        {
            ai[i] = (*jenv)->GetObjectArrayElement( jenv, jarg1, i );
            adat[i] = (*jenv)->GetDoubleArrayElements( jenv, ai[i], 0 );
            
            if (ny == -1)
            ny = (*jenv)->GetArrayLength( jenv, ai[i] );
            else if (ny != (*jenv)->GetArrayLength( jenv, ai[i] )) {
                printf( "Misshapen a array.\n" );
                for( j=0; j <= i; j++ )
                (*jenv)->ReleaseDoubleArrayElements( jenv, ai[j], adat[j], 0 );
                free(adat);
                free(ai);
                return;
            }
        }
        
        Xlen = nx;
        Ylen = ny;
        setup_array_2d_d( &arg1, adat, nx, ny );
        for( i=0; i < nx; i++ ) {
            (*jenv)->ReleaseDoubleArrayElements( jenv, ai[i], adat[i], 0 );
            (*jenv)->DeleteLocalRef(jenv, ai[i]);
        }
        
        free(adat);
        free(ai);
        
    }
    {
        jdouble **adat;
        jobject *ai;
        int nx = (*jenv)->GetArrayLength( jenv, jarg2 );
        int ny = -1;
        int i, j;
        ai = (jobject *) malloc( nx * sizeof(jobject) );
        adat = (jdouble **) malloc( nx * sizeof(jdouble *) );
        
        for( i=0; i < nx; i++ )
        {
            ai[i] = (*jenv)->GetObjectArrayElement( jenv, jarg2, i );
            adat[i] = (*jenv)->GetDoubleArrayElements( jenv, ai[i], 0 );
            
            if (ny == -1)
            ny = (*jenv)->GetArrayLength( jenv, ai[i] );
            else if (ny != (*jenv)->GetArrayLength( jenv, ai[i] )) {
                printf( "Misshapen a array.\n" );
                for( j=0; j <= i; j++ )
                (*jenv)->ReleaseDoubleArrayElements( jenv, ai[j], adat[j], 0 );
                free(adat);
                free(ai);
                return;
            }
        }
        
        if( nx != Xlen || ny != Ylen ) {
            printf( "Vectors must match matrix.\n" );
            for( i=0; i < nx; i++ )
            (*jenv)->ReleaseDoubleArrayElements( jenv, ai[i], adat[i], 0 );
            free(adat);
            free(ai);
            return;
        }
        setup_array_2d_d( &arg2, adat, nx, ny );
        arg3 = nx;
        arg4 = ny;
        for( i=0; i < nx; i++ ) {
            (*jenv)->ReleaseDoubleArrayElements( jenv, ai[i], adat[i], 0 );
            (*jenv)->DeleteLocalRef(jenv, ai[i]);
        }
        
        
        free(adat);
        free(ai);
        
    }
    arg5 = (PLFLT)jarg5; 
    {
        jdouble **adat;
        jobject *ai;
        int nx = (*jenv)->GetArrayLength( jenv, jarg6 );
        int ny = -1;
        int i, j;
        ai = (jobject *) malloc( nx * sizeof(jobject) );
        adat = (jdouble **) malloc( nx * sizeof(jdouble *) );
        
        for( i=0; i < nx; i++ )
        {
            ai[i] = (*jenv)->GetObjectArrayElement( jenv, jarg6, i );
            adat[i] = (*jenv)->GetDoubleArrayElements( jenv, ai[i], 0 );
            
            if (ny == -1)
            ny = (*jenv)->GetArrayLength( jenv, ai[i] );
            else if (ny != (*jenv)->GetArrayLength( jenv, ai[i] )) {
                printf( "Misshapen a array.\n" );
                for( j=0; j <= i; j++ )
                (*jenv)->ReleaseDoubleArrayElements( jenv, ai[j], adat[j], 0 );
                free(adat);
                free(ai);
                return;
            }
        }
        
        if( !((nx == Xlen && ny == Ylen) || (nx == Xlen && ny == 1))) {
            printf( "Xlen = %d, nx = %d, Ylen = %d, ny = %d\n", Xlen, nx, Ylen, ny );
            printf( "X vector or matrix must match matrix dimensions.\n" );
            for( i=0; i < nx; i++ )
            (*jenv)->ReleaseDoubleArrayElements( jenv, ai[i], adat[i], 0 );
            free(adat);
            free(ai);
            return;
        }
        /* Store whether second dimension is unity. */
        Alen = ny;
        setup_array_2d_d( &xg, adat, nx, ny );
        for( i=0; i < nx; i++ ) {
            (*jenv)->ReleaseDoubleArrayElements( jenv, ai[i], adat[i], 0 );
            (*jenv)->DeleteLocalRef(jenv, ai[i]);
        }
        
        free(adat);
        free(ai);
        arg6 = pltr2;
        
    }
    {
        jdouble **adat;
        jobject *ai;
        int nx = (*jenv)->GetArrayLength( jenv, jarg7 );
        int ny = -1;
        int i, j;
        PLcGrid2 cgrid;
        ai = (jobject *) malloc( nx * sizeof(jobject) );
        adat = (jdouble **) malloc( nx * sizeof(jdouble *) );
        
        for( i=0; i < nx; i++ )
        {
            ai[i] = (*jenv)->GetObjectArrayElement( jenv, jarg7, i );
            adat[i] = (*jenv)->GetDoubleArrayElements( jenv, ai[i], 0 );
            
            if (ny == -1)
            ny = (*jenv)->GetArrayLength( jenv, ai[i] );
            else if (ny != (*jenv)->GetArrayLength( jenv, ai[i] )) {
                printf( "Misshapen a array.\n" );
                for( j=0; j <= i; j++ )
                (*jenv)->ReleaseDoubleArrayElements( jenv, ai[j], adat[j], 0 );
                free(adat);
                free(ai);
                return;
            }
        }
        
        if( !((nx == Xlen && ny == Ylen) || (nx == Ylen && ny == 1 && ny == Alen))) {
            printf( "Xlen = %d, nx = %d, Ylen = %d, Alen = %d, ny = %d\n",
            Xlen, nx, Ylen, Alen, ny );
            printf( "Y vector or matrix must match matrix dimensions.\n" );
            for( i=0; i < nx; i++ )
            (*jenv)->ReleaseDoubleArrayElements( jenv, ai[i], adat[i], 0 );
            free(adat);
            free(ai);
            return;
        }
        setup_array_2d_d( &yg, adat, nx, ny );
        for( i=0; i < nx; i++ ) {
            (*jenv)->ReleaseDoubleArrayElements( jenv, ai[i], adat[i], 0 );
            (*jenv)->DeleteLocalRef(jenv, ai[i]);
        }
        
        free(adat);
        free(ai);
        cgrid.xg = xg;
        cgrid.yg = yg;
        cgrid.nx = nx;
        cgrid.ny = ny;
        arg7 = &cgrid;
        
    }
    plvect(arg1,arg2,arg3,arg4,arg5,arg6,arg7);
    
    {
        free(arg1[0]);
        free(arg1);
    }
    {
        free(arg2[0]);
        free(arg2);
    }
    {
        free(xg[0]);
        free(xg);
    }
    {
        free(yg[0]);
        free(yg);
    }
}


#define _doc_plvpas "Create the largest viewport of the specified aspect ratio that fits within the specified normalized subpage coordinates." 
JNIEXPORT void JNICALL Java_plplot_core_plplotjavacJNI_plvpas(JNIEnv *jenv, jclass jcls, jdouble jarg1, jdouble jarg2, jdouble jarg3, jdouble jarg4, jdouble jarg5) {
    PLFLT arg1 ;
    PLFLT arg2 ;
    PLFLT arg3 ;
    PLFLT arg4 ;
    PLFLT arg5 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = (PLFLT)jarg1; 
    arg2 = (PLFLT)jarg2; 
    arg3 = (PLFLT)jarg3; 
    arg4 = (PLFLT)jarg4; 
    arg5 = (PLFLT)jarg5; 
    plvpas(arg1,arg2,arg3,arg4,arg5);
    
}


#define _doc_plvpor "Create a viewport with the specified normalized subpage coordinates." 
JNIEXPORT void JNICALL Java_plplot_core_plplotjavacJNI_plvpor(JNIEnv *jenv, jclass jcls, jdouble jarg1, jdouble jarg2, jdouble jarg3, jdouble jarg4) {
    PLFLT arg1 ;
    PLFLT arg2 ;
    PLFLT arg3 ;
    PLFLT arg4 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = (PLFLT)jarg1; 
    arg2 = (PLFLT)jarg2; 
    arg3 = (PLFLT)jarg3; 
    arg4 = (PLFLT)jarg4; 
    plvpor(arg1,arg2,arg3,arg4);
    
}


#define _doc_plvsta "Define a \"standard\" viewport with seven character heights for the left margin and four character heights everywhere else." 
JNIEXPORT void JNICALL Java_plplot_core_plplotjavacJNI_plvsta(JNIEnv *jenv, jclass jcls) {
    (void)jenv;
    (void)jcls;
    plvsta();
    
}


#define _doc_plw3d "Set up a window for three-dimensional plotting." 
JNIEXPORT void JNICALL Java_plplot_core_plplotjavacJNI_plw3d(JNIEnv *jenv, jclass jcls, jdouble jarg1, jdouble jarg2, jdouble jarg3, jdouble jarg4, jdouble jarg5, jdouble jarg6, jdouble jarg7, jdouble jarg8, jdouble jarg9, jdouble jarg10, jdouble jarg11) {
    PLFLT arg1 ;
    PLFLT arg2 ;
    PLFLT arg3 ;
    PLFLT arg4 ;
    PLFLT arg5 ;
    PLFLT arg6 ;
    PLFLT arg7 ;
    PLFLT arg8 ;
    PLFLT arg9 ;
    PLFLT arg10 ;
    PLFLT arg11 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = (PLFLT)jarg1; 
    arg2 = (PLFLT)jarg2; 
    arg3 = (PLFLT)jarg3; 
    arg4 = (PLFLT)jarg4; 
    arg5 = (PLFLT)jarg5; 
    arg6 = (PLFLT)jarg6; 
    arg7 = (PLFLT)jarg7; 
    arg8 = (PLFLT)jarg8; 
    arg9 = (PLFLT)jarg9; 
    arg10 = (PLFLT)jarg10; 
    arg11 = (PLFLT)jarg11; 
    plw3d(arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8,arg9,arg10,arg11);
    
}


#define _doc_plwid "Set pen width." 
JNIEXPORT void JNICALL Java_plplot_core_plplotjavacJNI_plwid(JNIEnv *jenv, jclass jcls, jint jarg1) {
    PLINT arg1 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = (PLINT)jarg1; 
    plwid(arg1);
    
}


#define _doc_plwind "Set up world coordinates of the viewport boundaries (2d plots)." 
JNIEXPORT void JNICALL Java_plplot_core_plplotjavacJNI_plwind(JNIEnv *jenv, jclass jcls, jdouble jarg1, jdouble jarg2, jdouble jarg3, jdouble jarg4) {
    PLFLT arg1 ;
    PLFLT arg2 ;
    PLFLT arg3 ;
    PLFLT arg4 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = (PLFLT)jarg1; 
    arg2 = (PLFLT)jarg2; 
    arg3 = (PLFLT)jarg3; 
    arg4 = (PLFLT)jarg4; 
    plwind(arg1,arg2,arg3,arg4);
    
}


#define _doc_plxormod "Set xor mode; mode = 1-enter, 0-leave, status = 0 if not interactive device." 
JNIEXPORT void JNICALL Java_plplot_core_plplotjavacJNI_plxormod(JNIEnv *jenv, jclass jcls, jint jarg1, jintArray jarg2) {
    PLINT arg1 ;
    PLINT *arg2 = (PLINT *) 0 ;
    PLINT temp2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = (PLINT)jarg1; 
    {
        if (!jarg2) {
            SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "array null");
            return ;
        }
        if ((*jenv)->GetArrayLength(jenv, jarg2) == 0) {
            SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, "Array must contain at least 1 element");
            return ;
        }
        arg2 = &temp2; 
    }
    plxormod(arg1,arg2);
    
    {
        jint jvalue = (jint)temp2;
        (*jenv)->SetIntArrayRegion(jenv, jarg2, 0, 1, &jvalue);
    }
}


JNIEXPORT void JNICALL Java_plplot_core_plplotjavacJNI_plClearOpts(JNIEnv *jenv, jclass jcls) {
    (void)jenv;
    (void)jcls;
    plClearOpts();
    
}


JNIEXPORT void JNICALL Java_plplot_core_plplotjavacJNI_plResetOpts(JNIEnv *jenv, jclass jcls) {
    (void)jenv;
    (void)jcls;
    plResetOpts();
    
}


JNIEXPORT void JNICALL Java_plplot_core_plplotjavacJNI_plSetUsage(JNIEnv *jenv, jclass jcls, jstring jarg1, jstring jarg2) {
    char *arg1 ;
    char *arg2 ;
    
    (void)jenv;
    (void)jcls;
    {
        arg1 = 0;
        if (jarg1) {
            arg1 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg1, 0);
            if (!arg1) return ;
        }
    }
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
            if (!arg2) return ;
        }
    }
    plSetUsage(arg1,arg2);
    
    {
        if (arg1) (*jenv)->ReleaseStringUTFChars(jenv, jarg1, arg1); 
    }
    {
        if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2); 
    }
}


JNIEXPORT jint JNICALL Java_plplot_core_plplotjavacJNI_plParseOpts(JNIEnv *jenv, jclass jcls, jobjectArray jarg1, jint jarg3) {
    jint jresult = 0 ;
    PLINT *arg1 = (PLINT *) 0 ;
    char **arg2 = (char **) 0 ;
    PLINT arg3 ;
    PLINT result;
    jint size1 ;
    
    (void)jenv;
    (void)jcls;
    {
        int i = 0;
        size1 = (*jenv)->GetArrayLength(jenv, jarg1);
        arg1 = &size1;
        arg2 = (char **) malloc((size1+1)*sizeof(char *));
        /* make a copy of each string */
        for (i = 0; i<size1; i++) {
            jstring j_string = (jstring)(*jenv)->GetObjectArrayElement(jenv, jarg1, i);
            const char * c_string = (*jenv)->GetStringUTFChars(jenv, j_string, 0);
            /* Commented out version straight from swig documentation, but I think
             * it is wrong.
             *    arg2[i] = malloc(strlen((c_string)+1)*sizeof(const char *)); */
            arg2[i] = malloc((strlen(c_string)+1)*sizeof(const char *));
            strcpy(arg2[i], c_string);
            (*jenv)->ReleaseStringUTFChars(jenv, j_string, c_string);
            (*jenv)->DeleteLocalRef(jenv, j_string);
        }
        arg2[i] = 0;
    }
    arg3 = (PLINT)jarg3; 
    result = (PLINT)plParseOpts(arg1,arg2,arg3);
    
    jresult = (jint)result; 
    {
        int i;
        /* Commented out version straight from swig documentation, but I think
         * it is wrong.
         * for (i=0; i<size1-1; i++) */
        for (i=0; i<size1; i++)
        free(arg2[i]);
        free(arg2);
    }
    return jresult;
}


JNIEXPORT void JNICALL Java_plplot_core_plplotjavacJNI_plOptUsage(JNIEnv *jenv, jclass jcls) {
    (void)jenv;
    (void)jcls;
    plOptUsage();
    
}


#ifdef __cplusplus
}
#endif

