// stack.h

/******************************************************************************
 *
 *  MiXViews - an X window system based sound & data editor/processor
 *
 *  Copyright (c) 1993, 1994 Regents of the University of California
 *
 *  Author:     Douglas Scott
 *  Date:       December 13, 1994
 *
 *  Permission to use, copy and modify this software and its documentation
 *  for research and/or educational purposes and without fee is hereby granted,
 *  provided that the above copyright notice appear in all copies and that
 *  both that copyright notice and this permission notice appear in
 *  supporting documentation. The author reserves the right to distribute this
 *  software and its documentation.  The University of California and the author
 *  make no representations about the suitability of this software for any 
 *  purpose, and in no event shall University of California be liable for any
 *  damage, loss of data, or profits resulting from its use.
 *  It is provided "as is" without express or implied warranty.
 *
 ******************************************************************************/
 
#ifndef _MXV_STACK_H_
#define _MXV_STACK_H_

template <class Object>
class Stack {
public:
	Stack(int stackSize)
		: _top(0), _bottom(0), _size(stackSize), _currentSize(0) {}
	~Stack();
	inline void push(Object *obj);
	inline Object *pop();
	inline void setDepth(int stackSize);
	inline void clear();
	bool empty() const { return _currentSize == 0; }
private:
	struct Link {
		Link(Object *obj) : _object(obj), _prev(0), _next(0) {}
		Object *_object;
		struct Link *_prev, *_next;
	} *_top, *_bottom;
	int _size;
	int _currentSize;
};

template <class Object>
inline void Stack<Object>::push(Object *obj) {
	Link *link = new Link(obj);
	// Insert into top of linked list
	link->_next = _top;
	if (_top)
		_top->_prev = link;
	_top = link;
	// Set bottom of list if first
	if (!_bottom) {
		_bottom = link;
	}
	// If we have exceeded max size, snip bottom of list
	if (++_currentSize > _size) {
		Link *last = _bottom;
		Link *prev = (_bottom) ? _bottom->_prev : 0;
		if (prev)
			prev->_next = 0;
		_bottom = prev;
		if (_top = last)
			_top = 0;
		delete last;
		_currentSize = _size;
	}
}

template <class Object>
inline Object * Stack<Object>::pop() {
	Object *obj = nil;
	Link *top = _top;
	if (top) {
		_top = top->_next;
		if (_top)
			_top->_prev = 0;
		obj = top->_object;
		delete top;
		--_currentSize;
	}
	return obj;
}

template <class Object>
inline void Stack<Object>::setDepth(int stackSize) {
	while (_currentSize > stackSize) {
		Object *obj = pop();
		delete obj;
	}
	_size = stackSize;
}

template <class Object>
inline void Stack<Object>::clear() { 
	int savedDepth = _size; setDepth(0); _size = savedDepth;
}

template <class Object>
inline Stack<Object>::~Stack() { clear(); }

#endif	// _MXV_STACK_H_
