// comment.h

/******************************************************************************
 *
 *  MiXViews - an X window system based sound & data editor/processor
 *
 *  Copyright (c) 1993, 1994 Regents of the University of California
 *
 *  Author:     Douglas Scott
 *  Date:       December 13, 1994
 *
 *  Permission to use, copy and modify this software and its documentation
 *  for research and/or educational purposes and without fee is hereby granted,
 *  provided that the above copyright notice appear in all copies and that
 *  both that copyright notice and this permission notice appear in
 *  supporting documentation. The author reserves the right to distribute this
 *  software and its documentation.  The University of California and the author
 *  make no representations about the suitability of this software for any 
 *  purpose, and in no event shall University of California be liable for any
 *  damage, loss of data, or profits resulting from its use.
 *  It is provided "as is" without express or implied warranty.
 *
 ******************************************************************************/


// The Comment class is a very simple wrapper for a text string used to store
// a comment in several different data file types.  It is used as a member of
// the Header class and the Data class.

#ifndef COMMENT_H
#ifdef __GNUG__
#pragma interface
#endif
#define COMMENT_H

#include <InterViews/resource.h>

class Comment : public Resource {
	char *string;
	enum maxlen { MaxCommentLength = 512 };
public:
	Comment(const char *);
	virtual ~Comment();
	int len() { return strlen(string); }
	int maxLen() { return MaxCommentLength; }
	char* text() const { return string; }
	operator char *() const { return text(); }
};

#endif

