/*
 * Copyright (C) MX4J.
 * All rights reserved.
 *
 * This software is distributed under the terms of the MX4J License version 1.0.
 * See the terms of the MX4J License in the documentation provided with this software.
 */

package mx4j.tools.connector.rmi.jrmp;

import java.rmi.RemoteException;

import javax.management.NotificationFilter;
import javax.management.NotificationListener;

import mx4j.tools.adaptor.rmi.RemoteAdaptor;
import mx4j.tools.connector.rmi.RMIConnector;

/**
 *
 * @author <a href="mailto:biorn_steedom@users.sourceforge.net">Simone Bordet</a>
 * @version $Revision: 1.1 $
 */
public class JRMPConnector extends RMIConnector
{
	protected RemoteAdaptor narrow(Object object)
	{
		return (RemoteAdaptor)object;
	}

	protected NotificationListener createRemoteNotificationListener(NotificationListener listener) throws RemoteException
	{
		JRMPRemoteNotificationListenerSupport rnl = new JRMPRemoteNotificationListenerSupport(listener);
		rnl.export();
		return rnl;
	}

	protected NotificationFilter createRemoteNotificationFilter(NotificationFilter filter) throws RemoteException
	{
		JRMPRemoteNotificationFilterSupport rnf = new JRMPRemoteNotificationFilterSupport(filter);
		rnf.export();
		return rnf;
	}
}
