/*
 * linuxboot.h -- Header file for linuxboot.c
 *
 * Copyright (c) 1993-97 by
 *   Arjan Knor
 *   Robert de Vries
 *   Roman Hodek <Roman.Hodek@informatik.uni-erlangen.de>
 *   Andreas Schwab <schwab@issan.informatik.uni-dortmund.de>
 *
 * This file is subject to the terms and conditions of the GNU General Public
 * License.  See the file COPYING in the main directory of this archive
 * for more details.
 */
#ifndef _linuxboot_h
#define _linuxboot_h

#define __KERNEL__
#include <linux/types.h>
#undef __KERNEL__

/* linux specific include files */
#include <linux/a.out.h>
#include <linux/elf.h>
#include <asm/page.h>

#include <asm/bootinfo.h>
#define __KERNEL__
#include <asm/setup.h>
#undef __KERNEL__

/* _MCH cookie values */
#define MACH_ST  	0
#define MACH_STE 	1
#define MACH_TT  	2
#define MACH_FALCON 3

/* some constants for memory handling */
#define TT_RAM_BASE    (u_long)(0x01000000)
#define CT2_FAST_START (u_long)(0x04000000)
#define MB             (1024 * 1024)

/* global variables for communicating options */
extern int debugflag;
extern int ignore_ttram;
extern int load_to_stram;
extern int force_st_size;
extern int force_tt_size;
extern unsigned long extramem_start;
extern unsigned long extramem_size;
extern char *kernel_name;
extern char *ramdisk_name;
extern char command_line[];
#ifdef USE_BOOTP
/* defined in bootp_mod.c, not linuxboot.c */
extern int no_bootp;
#endif

/* Bootinfo */
struct atari_bootinfo {
    unsigned long machtype;		  /* machine type */
    unsigned long cputype;		  /* system CPU */
    unsigned long fputype;		  /* system FPU */
    unsigned long mmutype;		  /* system MMU */
    int num_memory;			  /* # of memory blocks found */
    struct mem_info memory[NUM_MEMINFO];  /* memory description */
    struct mem_info ramdisk;		  /* ramdisk description */
    char command_line[CL_SIZE];		  /* kernel command line parameters */
    unsigned long mch_cookie;		  /* _MCH cookie from TOS */
    unsigned long mch_type;		  /* special machine types */
};

void linux_boot( void ) __attribute__ ((noreturn));

#endif  /* _linuxboot_h */

