#
# Run this script to generated a changes.html output file
#
source common.tcl
header {SQLite changes}
puts {
<p>
This page provides a high-level summary of changes to SQLite.
For more detail, refer the the checkin logs generated by
CVS at
<a href="http://www.sqlite.org/cvstrac/timeline">
http://www.sqlite.org/cvstrac/timeline</a>.
</p>

<DL>
}


proc chng {date desc} {
  if {[regexp {\(([0-9.]+)\)} $date all vers]} {
    set label [string map {. _} $vers]
    puts "<A NAME=\"version_$label\">"
  }
  puts "<DT><B>$date</B></DT>"
  puts "<DD><P><UL>$desc</UL></P></DD>"
}

chng {2006 April 5 (3.3.5)} {
<li>CHECK constraints use conflict resolution algorithms correctly.</li>
<li>The SUM() function throws an error on integer overflow.</li>
<li>Choose the column names in a compound query from the left-most SELECT
    instead of the right-most.</li>
<li>The sqlite3_create_collation() function
    honors the SQLITE_UTF16_ALIGNED flag.</li>
<li>SQLITE_SECURE_DELETE compile-time option causes deletes to overwrite
    old data with zeros.</li>
<li>Detect integer overflow in abs().</li>
<li>The random() function provides 64 bits of randomness instead of
    only 32 bits.</li>
<li>Parser detects and reports automaton stack overflow.</li>
<li>Change the round() function to return REAL instead of TEXT.</li>
<li>Allow WHERE clause terms on the left table of a LEFT OUTER JOIN to
    contain aggregate subqueries.</li>
<li>Skip over leading spaces in text to numeric conversions.</li>
<li>Various minor bug and documentation typo fixes and
    performance enhancements.</li>
}

chng {2006 February 11 (3.3.4)} {
<li>Fix a blunder in the Unix mutex implementation that can lead to
deadlock on multithreaded systems.</li>
<li>Fix an alignment problem on 64-bit machines</li>
<li>Added the fullfsync pragma.</li>
<li>Fix an optimizer bug that could have caused some unusual LEFT OUTER JOINs
to give incorrect results.</li>
<li>The SUM function detects integer overflow and converts to accumulating
an approximate result using floating point numbers</li>
<li>Host parameter names can begin with '@' for compatibility with SQL Server.
</li>
<li>Other miscellaneous bug fixes</li>
}

chng {2006 January 31 (3.3.3)} {
<li>Removed support for an ON CONFLICT clause on CREATE INDEX - it never
worked correctly so this should not present any backward compatibility
problems.</li>
<li>Authorizer callback now notified of ALTER TABLE ADD COLUMN commands</li>
<li>After any changes to the TEMP database schema, all prepared statements
are invalidated and must be recreated using a new call to
sqlite3_prepare()</li>
<li>Other minor bug fixes in preparation for the first stable release
of version 3.3</li>
}

chng {2006 January 24 (3.3.2 beta)} {
<li>Bug fixes and speed improvements.  Improved test coverage.</li>
<li>Changes to the OS-layer interface: mutexes must now be recursive.</li>
<li>Discontinue the use of thread-specific data for out-of-memory
exception handling</li>
}

chng {2006 January 16 (3.3.1 alpha)} {
<li>Countless bug fixes</li>
<li>Speed improvements</li>
<li>Database connections can now be used by multiple threads, not just
the thread in which they were created.</li>
}

chng {2006 January 10 (3.3.0 alpha)} {
<li>CHECK constraints</li>
<li>IF EXISTS and IF NOT EXISTS clauses on CREATE/DROP TABLE/INDEX.</li>
<li>DESC indices</li>
<li>More efficient encoding of boolean values resulting in smaller database
files</li>
<li>More aggressive SQLITE_OMIT_FLOATING_POINT</li>
<li>Separate INTEGER and REAL affinity</li>
<li>Added a virtual function layer for the OS interface</li>
<li>"exists" method added to the TCL interface</li>
<li>Improved response to out-of-memory errors</li>
<li>Database cache can be optionally shared between connections
in the same thread</li>
<li>Optional READ UNCOMMITTED isolation (instead of the default
isolation level of SERIALIZABLE) and table level locking when
database connections share a common cache.</li>
}

chng {2005 December 19 (3.2.8)} {
<li>Fix an obscure bug that can cause database corruption under the
following unusual circumstances: A large INSERT or UPDATE statement which 
is part of an even larger transaction fails due to a uniqueness contraint
but the containing transaction commits.</li>
}

chng {2005 December 19 (2.8.17)} {
<li>Fix an obscure bug that can cause database corruption under the
following unusual circumstances: A large INSERT or UPDATE statement which 
is part of an even larger transaction fails due to a uniqueness contraint
but the containing transaction commits.</li>
}

chng {2005 September 24 (3.2.7)} {
<li>GROUP BY now considers NULLs to be equal again, as it should
</li>
<li>Now compiles on Solaris and OpenBSD and other Unix variants
that lack the fdatasync() function</li>
<li>Now compiles on MSVC++6 again</li>
<li>Fix uninitialized variables causing malfunctions for various obscure
queries</li>
<li>Correctly compute a LEFT OUTER JOINs that is constrained on the
left table only</li>
}

chng {2005 September 17 (3.2.6)} {
<li>Fix a bug that can cause database corruption if a VACUUM (or
    autovacuum) fails and is rolled back on a database that is
    larger than 1GiB</li>
<li>LIKE optiization now works for columns with COLLATE NOCASE</li>
<li>ORDER BY and GROUP BY now use bounded memory</li>
<li>Added support for COUNT(DISTINCT expr)</li>
<li>Change the way SUM() handles NULL values in order to comply with
    the SQL standard</li>
<li>Use fdatasync() instead of fsync() where possible in order to speed
    up commits slightly</li>
<li>Use of the CROSS keyword in a join turns off the table reordering
    optimization</li>
<li>Added the experimental and undocumented EXPLAIN QUERY PLAN capability</li>
<li>Use the unicode API in windows</li>
}

chng {2005 August 27 (3.2.5)} {
<li>Fix a bug effecting DELETE and UPDATE statements that changed
more than 40960 rows.</li>
<li>Change the makefile so that it no longer requires GNUmake extensions</li>
<li>Fix the --enable-threadsafe option on the configure script</li>
<li>Fix a code generator bug that occurs when the left-hand side of an IN
operator is constant and the right-hand side is a SELECT statement</li>
<li>The PRAGMA synchronous=off statement now disables syncing of the
master journal file in addition to the normal rollback journals</li>
}

chng {2005 August 24 (3.2.4)} {
<li>Fix a bug introduced in the previous release
that can cause a segfault while generating code
for complex WHERE clauses.</li>
<li>Allow floating point literals to begin or end with a decimal point.</li>
}

chng {2005 August 21 (3.2.3)} {
<li>Added support for the CAST operator</li>
<li>Tcl interface allows BLOB values to be transferred to user-defined
functions</li>
<li>Added the "transaction" method to the Tcl interface</li>
<li>Allow the DEFAULT value of a column to call functions that have constant
operands</li>
<li>Added the ANALYZE command for gathering statistics on indices and
using those statistics when picking an index in the optimizer</li>
<li>Remove the limit (formerly 100) on the number of terms in the
WHERE clause</li>
<li>The right-hand side of the IN operator can now be a list of expressions
instead of just a list of constants</li>
<li>Rework the optimizer so that it is able to make better use of indices</li>
<li>The order of tables in a join is adjusted automatically to make
better use of indices</li>
<li>The IN operator is now a candidate for optimization even if the left-hand
side is not the left-most term of the index.  Multiple IN operators can be
used with the same index.</li>
<li>WHERE clause expressions using BETWEEN and OR are now candidates
for optimization</li>
<li>Added the "case_sensitive_like" pragma and the SQLITE_CASE_SENSITIVE_LIKE
compile-time option to set its default value to "on".</li>
<li>Use indices to help with GLOB expressions and LIKE expressions too
when the case_sensitive_like pragma is enabled</li>
<li>Added support for grave-accent quoting for compatibility with MySQL</li>
<li>Improved test coverage</li>
<li>Dozens of minor bug fixes</li>
}

chng {2005 June 13 (3.2.2)} {
<li>Added the sqlite3_db_handle() API</li>
<li>Added the sqlite3_get_autocommit() API</li>
<li>Added a REGEXP operator to the parser.  There is no function to back
up this operator in the standard build but users can add their own using
sqlite3_create_function()</li>
<li>Speed improvements and library footprint reductions.</li>
<li>Fix byte alignment problems on 64-bit architectures.</li>
<li>Many, many minor bug fixes and documentation updates.</li>
}

chng {2005 March 29 (3.2.1)} {
<li>Fix a memory allocation error in the new ADD COLUMN comment.</li>
<li>Documentation updates</li>
}

chng {2005 March 21 (3.2.0)} {
<li>Added support for ALTER TABLE ADD COLUMN.</li>
<li>Added support for the "T" separator in ISO-8601 date/time strings.</li>
<li>Improved support for Cygwin.</li>
<li>Numerous bug fixes and documentation updates.</li>
}

chng {2005 March 16 (3.1.6)} {
<li>Fix a bug that could cause database corruption when inserting
    record into tables with around 125 columns.</li>
<li>sqlite3_step() is now much more likely to invoke the busy handler
    and less likely to return SQLITE_BUSY.</li>
<li>Fix memory leaks that used to occur after a malloc() failure.</li>
}

chng {2005 March 11 (3.1.5)} {
<li>The ioctl on OS-X to control syncing to disk is F_FULLFSYNC,
    not F_FULLSYNC.  The previous release had it wrong.</li>
}

chng {2005 March 10 (3.1.4)} {
<li>Fix a bug in autovacuum that could cause database corruption if
a CREATE UNIQUE INDEX fails because of a constraint violation.
This problem only occurs if the new autovacuum feature introduced in
version 3.1 is turned on.</li>
<li>The F_FULLSYNC ioctl (currently only supported on OS-X) is disabled
if the synchronous pragma is set to something other than "full".</li>
<li>Add additional forward compatibility to the future version 3.2 database 
file format.</li>
<li>Fix a bug in WHERE clauses of the form (rowid<'2')</li>
<li>New SQLITE_OMIT_... compile-time options added</li>
<li>Updates to the man page</li>
<li>Remove the use of strcasecmp() from the shell</li>
<li>Windows DLL exports symbols Tclsqlite_Init and Sqlite_Init</li>
}

chng {2005 February 19 (3.1.3)} {
<li>Fix a problem with VACUUM on databases from which tables containing
AUTOINCREMENT have been dropped.</li>
<li>Add forward compatibility to the future version 3.2 database file
format.</li>
<li>Documentation updates</li>
}

chng {2005 February 15 (3.1.2)} {
<li>Fix a bug that can lead to database corruption if there are two
open connections to the same database and one connection does a VACUUM
and the second makes some change to the database.</li>
<li>Allow "?" parameters in the LIMIT clause.</li>
<li>Fix VACUUM so that it works with AUTOINCREMENT.</li>
<li>Fix a race condition in AUTOVACUUM that can lead to corrupt databases</li>
<li>Add a numeric version number to the sqlite3.h include file.</li>
<li>Other minor bug fixes and performance enhancements.</li>
}

chng {2005 February 15 (2.8.16)} {
<li>Fix a bug that can lead to database corruption if there are two
open connections to the same database and one connection does a VACUUM
and the second makes some change to the database.</li>
<li>Correctly handle quoted names in CREATE INDEX statements.</li>
<li>Fix a naming conflict between sqlite.h and sqlite3.h.</li>
<li>Avoid excess heap usage when copying expressions.</li>
<li>Other minor bug fixes.</li>
}

chng {2005 February 1 (3.1.1 BETA)} {
<li>Automatic caching of prepared statements in the TCL interface</li>
<li>ATTACH and DETACH as well as some other operations cause existing
    prepared statements to expire.</li>
<li>Numerious minor bug fixes</li>
}

chng {2005 January 21 (3.1.0 ALPHA)} {
<li>Autovacuum support added</li>
<li>CURRENT_TIME, CURRENT_DATE, and CURRENT_TIMESTAMP added</li>
<li>Support for the EXISTS clause added.</li>
<li>Support for correlated subqueries added.</li>
<li>Added the ESCAPE clause on the LIKE operator.</li>
<li>Support for ALTER TABLE ... RENAME TABLE ... added</li>
<li>AUTOINCREMENT keyword supported on INTEGER PRIMARY KEY</li>
<li>Many SQLITE_OMIT_ macros inserts to omit features at compile-time
    and reduce the library footprint.</li>
<li>The REINDEX command was added.</li>
<li>The engine no longer consults the main table if it can get
    all the information it needs from an index.</li>
<li>Many nuisance bugs fixed.</li>
}

chng {2004 October 11 (3.0.8)} {
<li>Add support for DEFERRED, IMMEDIATE, and EXCLUSIVE transactions.</li>
<li>Allow new user-defined functions to be created when there are
already one or more precompiled SQL statements.<li>
<li>Fix portability problems for Mingw/MSYS.</li>
<li>Fix a byte alignment problem on 64-bit Sparc machines.</li>
<li>Fix the ".import" command of the shell so that it ignores \r
characters at the end of lines.</li>
<li>The "csv" mode option in the shell puts strings inside double-quotes.</li>
<li>Fix typos in documentation.</li>
<li>Convert array constants in the code to have type "const".</li>
<li>Numerous code optimizations, specially optimizations designed to
make the code footprint smaller.</li>
}

chng {2004 September 18 (3.0.7)} {
<li>The BTree module allocates large buffers using malloc() instead of
    off of the stack, in order to play better on machines with limited
    stack space.</li>
<li>Fixed naming conflicts so that versions 2.8 and 3.0 can be
    linked and used together in the same ANSI-C source file.</li>
<li>New interface: sqlite3_bind_parameter_index()</li>
<li>Add support for wildcard parameters of the form: "?nnn"</li>
<li>Fix problems found on 64-bit systems.</li>
<li>Removed encode.c file (containing unused routines) from the 
    version 3.0 source tree.</li>
<li>The sqlite3_trace() callbacks occur before each statement
    is executed, not when the statement is compiled.</li>
<li>Makefile updates and miscellaneous bug fixes.</li>
}

chng {2004 September 02 (3.0.6 beta)} {
<li>Better detection and handling of corrupt database files.</li>
<li>The sqlite3_step() interface returns SQLITE_BUSY if it is unable
    to commit a change because of a lock</li>
<li>Combine the implementations of LIKE and GLOB into a single
    pattern-matching subroutine.</li>
<li>Miscellaneous code size optimizations and bug fixes</li>
}

chng {2004 August 29 (3.0.5 beta)} {
<li>Support for ":AAA" style bind parameter names.</li>
<li>Added the new sqlite3_bind_parameter_name() interface.</li>
<li>Support for TCL variable names embedded in SQL statements in the
    TCL bindings.</li>
<li>The TCL bindings transfer data without necessarily doing a conversion
    to a string.</li>
<li>The database for TEMP tables is not created until it is needed.</li>
<li>Add the ability to specify an alternative temporary file directory
    using the "sqlite_temp_directory" global variable.</li>
<li>A compile-time option (SQLITE_BUSY_RESERVED_LOCK) causes the busy
    handler to be called when there is contention for a RESERVED lock.</li>
<li>Various bug fixes and optimizations</li>
}

chng {2004 August 8 (3.0.4 beta)} {
<li>CREATE TABLE and DROP TABLE now work correctly as prepared statements.</li>
<li>Fix a bug in VACUUM and UNIQUE indices.</li>
<li>Add the ".import" command to the command-line shell.</li>
<li>Fix a bug that could cause index corruption when an attempt to
    delete rows of a table is blocked by a pending query.</li>
<li>Library size optimizations.</li>
<li>Other minor bug fixes.</li>
}

chng {2004 July 22 (2.8.15)} {
<li>This is a maintenance release only.  Various minor bugs have been
fixed and some portability enhancements are added.</li>
}

chng {2004 July 22 (3.0.3 beta)} {
<li>The second beta release for SQLite 3.0.</li>
<li>Add support for "PRAGMA page_size" to adjust the page size of
the database.</li>
<li>Various bug fixes and documentation updates.</li>
}

chng {2004 June 30 (3.0.2 beta)} {
<li>The first beta release for SQLite 3.0.</li>
}

chng {2004 June 22 (3.0.1 alpha)} {
<li><font color="red"><b>
    *** Alpha Release - Research And Testing Use Only ***</b></font>
<li>Lots of bug fixes.</li>
}

chng {2004 June 18 (3.0.0 alpha)} {
<li><font color="red"><b>
    *** Alpha Release - Research And Testing Use Only ***</b></font>
<li>Support for internationalization including UTF-8, UTF-16, and
    user defined collating sequences.</li>
<li>New file format that is 25% to 35% smaller for typical use.</li>
<li>Improved concurrency.</li>
<li>Atomic commits for ATTACHed databases.</li>
<li>Remove cruft from the APIs.</li>
<li>BLOB support.</li>
<li>64-bit rowids.</li>
<li><a href="version3.html">More information</a>.
}

chng {2004 June 9 (2.8.14)} {
<li>Fix the min() and max() optimizer so that it works when the FROM
    clause consists of a subquery.</li>
<li>Ignore extra whitespace at the end of of "." commands in the shell.</li>
<li>Bundle sqlite_encode_binary() and sqlite_decode_binary() with the 
    library.</li>
<li>The TEMP_STORE and DEFAULT_TEMP_STORE pragmas now work.</li>
<li>Code changes to compile cleanly using OpenWatcom.</li>
<li>Fix VDBE stack overflow problems with INSTEAD OF triggers and
    NULLs in IN operators.</li>
<li>Add the global variable sqlite_temp_directory which if set defines the
    directory in which temporary files are stored.</li>
<li>sqlite_interrupt() plays well with VACUUM.</li>
<li>Other minor bug fixes.</li>
}

chng {2004 March 8 (2.8.13)} {
<li>Refactor parts of the code in order to make the code footprint
    smaller.  The code is now also a little bit faster.</li>
<li>sqlite_exec() is now implemented as a wrapper around sqlite_compile()
    and sqlite_step().</li>
<li>The built-in min() and max() functions now honor the difference between
    NUMERIC and TEXT datatypes.  Formerly, min() and max() always assumed
    their arguments were of type NUMERIC.</li>
<li>New HH:MM:SS modifier to the built-in date/time functions.</li>
<li>Experimental sqlite_last_statement_changes() API added.  Fixed the
    the last_insert_rowid() function so that it works correctly with
    triggers.</li>
<li>Add functions prototypes for the database encryption API.</li>
<li>Fix several nuisance bugs.</li>
}

chng {2004 February 8 (2.8.12)} {
<li>Fix a bug that will might corrupt the rollback journal if a power failure
    or external program halt occurs in the middle of a COMMIT.  The corrupt
    journal can lead to database corruption when it is rolled back.</li>
<li>Reduce the size and increase the speed of various modules, especially
    the virtual machine.</li>
<li>Allow "&lt;expr&gt; IN &lt;table&gt;" as a shorthand for
    "&lt;expr&gt; IN (SELECT * FROM &lt;table&gt;".</li>
<li>Optimizations to the sqlite_mprintf() routine.</li>
<li>Make sure the MIN() and MAX() optimizations work within subqueries.</li>
}

chng {2004 January 14 (2.8.11)} {
<li>Fix a bug in how the IN operator handles NULLs in subqueries.  The bug
    was introduced by the previous release.</li>
}

chng {2004 January 13 (2.8.10)} {
<li>Fix a potential database corruption problem on Unix caused by the fact
    that all posix advisory locks are cleared whenever you close() a file.
    The work around it to embargo all close() calls while locks are 
    outstanding.</li>
<li>Performance enhancements on some corner cases of COUNT(*).</li>
<li>Make sure the in-memory backend response sanely if malloc() fails.</li>
<li>Allow sqlite_exec() to be called from within user-defined SQL
    functions.</li>
<li>Improved accuracy of floating-point conversions using "long double".</li>
<li>Bug fixes in the experimental date/time functions.</li>
}

chng {2004 January 5 (2.8.9)} {
<li>Fix a 32-bit integer overflow problem that could result in corrupt
    indices in a database if large negative numbers (less than -2147483648)
    were inserted into a indexed numeric column.</li>
<li>Fix a locking problem on multi-threaded Linux implementations.</li>
<li>Always use "." instead of "," as the decimal point even if the locale
    requests ",".</li>
<li>Added UTC to localtime conversions to the experimental date/time
    functions.</li>
<li>Bug fixes to date/time functions.</li>
}

chng {2003 December 17 (2.8.8)} {
<li>Fix a critical bug introduced into 2.8.0 which could cause
    database corruption.</li>
<li>Fix a problem with 3-way joins that do not use indices</li>
<li>The VACUUM command now works with the non-callback API</li>
<li>Improvements to the "PRAGMA integrity_check" command</li>
}

chng {2003 December 4 (2.8.7)} {
<li>Added experimental sqlite_bind() and sqlite_reset() APIs.</li>
<li>If the name of the database is an empty string, open a new database
    in a temporary file that is automatically deleted when the database
    is closed.</li>
<li>Performance enhancements in the lemon-generated parser</li>
<li>Experimental date/time functions revised.</li>
<li>Disallow temporary indices on permanent tables.</li>
<li>Documentation updates and typo fixes</li>
<li>Added experimental sqlite_progress_handler() callback API</li>
<li>Removed support for the Oracle8 outer join syntax.</li>
<li>Allow GLOB and LIKE operators to work as functions.</li>
<li>Other minor documentation and makefile changes and bug fixes.</li>
}

chng {2003 August 21 (2.8.6)} {
<li>Moved the CVS repository to www.sqlite.org</li>
<li>Update the NULL-handling documentation.</li>
<li>Experimental date/time functions added.</li>
<li>Bug fix: correctly evaluate a view of a view without segfaulting.</li>
<li>Bug fix: prevent database corruption if you dropped a
    trigger that had the same name as a table.</li>
<li>Bug fix: allow a VACUUM (without segfaulting) on an empty
    database after setting the EMPTY_RESULT_CALLBACKS pragma.</li>
<li>Bug fix: if an integer value will not fit in a 32-bit int, store it in
    a double instead.</li>
<li>Bug fix: Make sure the journal file directory entry is committed to disk
    before writing the database file.</li>
}

chng {2003 July 22 (2.8.5)} {
<li>Make LIMIT work on a compound SELECT statement.</li>
<li>LIMIT 0 now shows no rows.  Use LIMIT -1 to see all rows.</li>
<li>Correctly handle comparisons between an INTEGER PRIMARY KEY and
    a floating point number.</li>
<li>Fix several important bugs in the new ATTACH and DETACH commands.</li>
<li>Updated the <a href="nulls.html">NULL-handling document</a>.</li> 
<li>Allow NULL arguments in sqlite_compile() and sqlite_step().</li>
<li>Many minor bug fixes</li>
}

chng {2003 June 29 (2.8.4)} {
<li>Enhanced the "PRAGMA integrity_check" command to verify indices.</li>
<li>Added authorization hooks for the new ATTACH and DETACH commands.</li>
<li>Many documentation updates</li>
<li>Many minor bug fixes</li>
}

chng {2003 June 4 (2.8.3)} {
<li>Fix a problem that will corrupt the indices on a table if you
    do an INSERT OR REPLACE or an UPDATE OR REPLACE on a table that
    contains an INTEGER PRIMARY KEY plus one or more indices.</li>
<li>Fix a bug in windows locking code so that locks work correctly
    when simultaneously accessed by Win95 and WinNT systems.</li>
<li>Add the ability for INSERT and UPDATE statements to refer to the
    "rowid" (or "_rowid_" or "oid") columns.</li>
<li>Other important bug fixes</li>
}

chng {2003 May 17 (2.8.2)} {
<li>Fix a problem that will corrupt the database file if you drop a
    table from the main database that has a TEMP index.</li>
}

chng {2003 May 16 (2.8.1)} {
<li>Reactivated the VACUUM command that reclaims unused disk space in 
    a database file.</li>
<li>Added the ATTACH and DETACH commands to allow interacting with multiple
    database files at the same time.</li>
<li>Added support for TEMP triggers and indices.</li>
<li>Added support for in-memory databases.</li>
<li>Removed the experimental sqlite_open_aux_file().  Its function is
    subsumed in the new ATTACH command.</li>
<li>The precedence order for ON CONFLICT clauses was changed so that
    ON CONFLICT clauses on BEGIN statements have a higher precedence than
    ON CONFLICT clauses on constraints.
<li>Many, many bug fixes and compatibility enhancements.</li>
}

chng {2003 Feb 16 (2.8.0)} {
<li>Modified the journal file format to make it more resistant to corruption
    that can occur after an OS crash or power failure.</li>
<li>Added a new C/C++ API that does not use callback for returning data.</li>
}

chng {2003 Jan 25 (2.7.6)} {
<li>Performance improvements.  The library is now much faster.</li>
<li>Added the <b>sqlite_set_authorizer()</b> API.  Formal documentation has
    not been written - see the source code comments for instructions on
    how to use this function.</li>
<li>Fix a bug in the GLOB operator that was preventing it from working
    with upper-case letters.</li>
<li>Various minor bug fixes.</li>
}

chng {2002 Dec 27 (2.7.5)} {
<li>Fix an uninitialized variable in pager.c which could (with a probability
    of about 1 in 4 billion) result in a corrupted database.</li>
}

chng {2002 Dec 17 (2.7.4)} {
<li>Database files can now grow to be up to 2^41 bytes.  The old limit
    was 2^31 bytes.</li>
<li>The optimizer will now scan tables in the reverse if doing so will
    satisfy an ORDER BY ... DESC clause.</li>
<li>The full pathname of the database file is now remembered even if
    a relative path is passed into sqlite_open().  This allows 
    the library to continue operating correctly after a chdir().</li>
<li>Speed improvements in the VDBE.</li>
<li>Lots of little bug fixes.</li>
}

chng {2002 Oct 30 (2.7.3)} {
<li>Various compiler compatibility fixes.</li>
<li>Fix a bug in the "expr IN ()" operator.</li>
<li>Accept column names in parentheses.</li>
<li>Fix a problem with string memory management in the VDBE</li>
<li>Fix a bug in the "table_info" pragma"</li>
<li>Export the sqlite_function_type() API function in the Windows DLL</li>
<li>Fix locking behavior under windows</li>
<li>Fix a bug in LEFT OUTER JOIN</li>
}

chng {2002 Sep 25 (2.7.2)} {
<li>Prevent journal file overflows on huge transactions.</li>
<li>Fix a memory leak that occurred when sqlite_open() failed.</li>
<li>Honor the ORDER BY and LIMIT clause of a SELECT even if the
    result set is used for an INSERT.</li>
<li>Do not put write locks on the file used to hold TEMP tables.</li>
<li>Added documentation on SELECT DISTINCT and on how SQLite handles NULLs.</li>
<li>Fix a problem that was causing poor performance when many thousands
    of SQL statements were executed by a single sqlite_exec() call.</li>
}

chng {2002 Aug 31 (2.7.1)} {
<li>Fix a bug in the ORDER BY logic that was introduced in version 2.7.0</li>
<li>C-style comments are now accepted by the tokenizer.</li>
<li>INSERT runs a little faster when the source is a SELECT statement.</li>
}

chng {2002 Aug 25 (2.7.0)} {
<li>Make a distinction between numeric and text values when sorting.
    Text values sort according to memcmp().  Numeric values sort in
    numeric order.</li>
<li>Allow multiple simultaneous readers under windows by simulating
    the reader/writers locks that are missing from Win95/98/ME.</li>
<li>An error is now returned when trying to start a transaction if
    another transaction is already active.</li>
}

chng {2002 Aug 12 (2.6.3)} {
<li>Add the ability to read both little-endian and big-endian databases.
    So database created under SunOS or MacOSX can be read and written
    under Linux or Windows and vice versa.</li>
<li>Convert to the new website: http://www.sqlite.org/</li>
<li>Allow transactions to span Linux Threads</li>
<li>Bug fix in the processing of the ORDER BY clause for GROUP BY queries</li>
}

chng {2002 Jly 30 (2.6.2)} {
<li>Text files read by the COPY command can now have line terminators
    of LF,  CRLF, or CR.</li>
<li>SQLITE_BUSY is handled correctly if encountered during database
    initialization.</li>
<li>Fix to UPDATE triggers on TEMP tables.</li>
<li>Documentation updates.</li>
}

chng {2002 Jly 19 (2.6.1)} {
<li>Include a static string in the library that responds to the RCS
    "ident" command and which contains the library version number.</li>
<li>Fix an assertion failure that occurred when deleting all rows of
    a table with the "count_changes" pragma turned on.</li>
<li>Better error reporting when problems occur during the automatic
    2.5.6 to 2.6.0 database format upgrade.</li>
}

chng {2002 Jly 17 (2.6.0)} {
<li>Change the format of indices to correct a design flaw the originated
    with version 2.1.0.  <font color="red">*** This is an incompatible
    file format change ***</font>  When version 2.6.0 or later of the
    library attempts to open a database file created by version 2.5.6 or
    earlier, it will automatically and irreversibly convert the file format.
    <b>Make backup copies of older database files before opening them with
    version 2.6.0 of the library.</b>
    </li>
}

chng {2002 Jly 7 (2.5.6)} {
<li>Fix more problems with rollback.  Enhance the test suite to exercise
    the rollback logic extensively in order to prevent any future problems.
    </li>
}

chng {2002 Jly 6 (2.5.5)} {
<li>Fix a bug which could cause database corruption during a rollback.
    This bugs was introduced in version 2.4.0 by the freelist
    optimization of checking [410].</li>
<li>Fix a bug in aggregate functions for VIEWs.</li>
<li>Other minor changes and enhancements.</li>
}

chng {2002 Jly 1 (2.5.4)} {
<li>Make the "AS" keyword optional again.</li>
<li>The datatype of columns now appear in the 4th argument to the
    callback.</li>
<li>Added the <b>sqlite_open_aux_file()</b> API, though it is still
    mostly undocumented and untested.</li>
<li>Added additional test cases and fixed a few bugs that those
    test cases found.</li>
}

chng {2002 Jun 24 (2.5.3)} {
<li>Bug fix:  Database corruption can occur due to the optimization
    that was introduced in version 2.4.0 (check-in [410]).  The problem
    should now be fixed.  The use of versions 2.4.0 through 2.5.2 is
    not recommended.</li>
}

chng {2002 Jun 24 (2.5.2)} {
<li>Added the new <b>SQLITE_TEMP_MASTER</b> table which records the schema
    for temporary tables in the same way that <b>SQLITE_MASTER</b> does for
    persistent tables.</li>
<li>Added an optimization to UNION ALL</li>
<li>Fixed a bug in the processing of LEFT OUTER JOIN</li>
<li>The LIMIT clause now works on subselects</li>
<li>ORDER BY works on subselects</li>
<li>There is a new TypeOf() function used to determine if an expression
    is numeric or text.</li>
<li>Autoincrement now works for INSERT from a SELECT.</li>
}

chng {2002 Jun 19 (2.5.1)} {
<li>The query optimizer now attempts to implement the ORDER BY clause
    using an index.  Sorting is still used if not suitable index is
    available.</li>
}

chng {2002 Jun 17 (2.5.0)} {
<li>Added support for row triggers.</li>
<li>Added SQL-92 compliant handling of NULLs.</li>
<li>Add support for the full SQL-92 join syntax and LEFT OUTER JOINs.</li>
<li>Double-quoted strings interpreted as column names not text literals.</li>
<li>Parse (but do not implement) foreign keys.</li>
<li>Performance improvements in the parser, pager, and WHERE clause code
    generator.</li>
<li>Make the LIMIT clause work on subqueries.  (ORDER BY still does not
    work, though.)</li>
<li>Added the "%Q" expansion to sqlite_*_printf().</li>
<li>Bug fixes too numerous to mention (see the change log).</li>
}

chng {2002 May 09 (2.4.12)} {
<li>Added logic to detect when the library API routines are called out
    of sequence.</li>
}

chng {2002 May 08 (2.4.11)} {
<li>Bug fix: Column names in the result set were not being generated
    correctly for some (rather complex) VIEWs.  This could cause a
    segfault under certain circumstances.</li>
}

chng {2002 May 02 (2.4.10)} {
<li>Bug fix: Generate correct column headers when a compound SELECT is used
    as a subquery.</li>
<li>Added the sqlite_encode_binary() and sqlite_decode_binary() functions to
    the source tree.  But they are not yet linked into the library.</li>
<li>Documentation updates.</li>
<li>Export the sqlite_changes() function from windows DLLs.</li>
<li>Bug fix: Do not attempt the subquery flattening optimization on queries
    that lack a FROM clause.  To do so causes a segfault.</li>
}

chng {2002 Apr 21 (2.4.9)} {
<li>Fix a bug that was causing the precompiled binary of SQLITE.EXE to
    report "out of memory" under Windows 98.</li>
}

chng {2002 Apr 20 (2.4.8)} {
<li>Make sure VIEWs are created after their corresponding TABLEs in the
    output of the <b>.dump</b> command in the shell.</li>
<li>Speed improvements: Do not do synchronous updates on TEMP tables.</li>
<li>Many improvements and enhancements to the shell.</li>
<li>Make the GLOB and LIKE operators functions that can be overridden
    by a programmer.  This allows, for example, the LIKE operator to
    be changed to be case sensitive.</li>
}

chng {2002 Apr 06 (2.4.7)} {
<li>Add the ability to put TABLE.* in the column list of a
    SELECT statement.</li>
<li>Permit SELECT statements without a FROM clause.</li>
<li>Added the <b>last_insert_rowid()</b> SQL function.</li>
<li>Do not count rows where the IGNORE conflict resolution occurs in
    the row count.</li>
<li>Make sure functions expressions in the VALUES clause of an INSERT
    are correct.</li>
<li>Added the <b>sqlite_changes()</b> API function to return the number
    of row that changed in the most recent operation.</li>
}

chng {2002 Apr 02 (2.4.6)} {
<li>Bug fix: Correctly handle terms in the WHERE clause of a join that
    do not contain a comparison operator.</li>
}

chng {2002 Apr 01 (2.4.5)} {
<li>Bug fix: Correctly handle functions that appear in the WHERE clause
    of a join.</li>
<li>When the PRAGMA vdbe_trace=ON is set, correctly print the P3 operand
    value when it is a pointer to a structure rather than a pointer to
    a string.</li>
<li>When inserting an explicit NULL into an INTEGER PRIMARY KEY, convert
    the NULL value into a unique key automatically.</li>
}

chng {2002 Mar 24 (2.4.4)} {
<li>Allow "VIEW" to be a column name</li>
<li>Added support for CASE expressions (patch from Dan Kennedy)</li>
<li>Added RPMS to the delivery (patches from Doug Henry)</li>
<li>Fix typos in the documentation</li>
<li>Cut over configuration management to a new CVS repository with
    its own CVSTrac bug tracking system.</li>
}

chng {2002 Mar 22 (2.4.3)} {
<li>Fix a bug in SELECT that occurs when a compound SELECT is used as a
    subquery in the FROM of a SELECT.</li>
<li>The <b>sqlite_get_table()</b> function now returns an error if you
    give it two or more SELECTs that return different numbers of columns.</li>
}

chng {2002 Mar 14 (2.4.2)} {
<li>Bug fix: Fix an assertion failure that occurred when ROWID was a column
    in a SELECT statement on a view.</li>
<li>Bug fix: Fix an uninitialized variable in the VDBE that would could an
    assert failure.</li>
<li>Make the os.h header file more robust in detecting when the compile is
    for windows and when it is for unix.</li>
}

chng {2002 Mar 13 (2.4.1)} {
<li>Using an unnamed subquery in a FROM clause would cause a segfault.</li>
<li>The parser now insists on seeing a semicolon or the end of input before
    executing a statement.  This avoids an accidental disaster if the
    WHERE keyword is misspelled in an UPDATE or DELETE statement.</li>
}


chng {2002 Mar 10 (2.4.0)} {
<li>Change the name of the sanity_check PRAGMA to <b>integrity_check</b>
    and make it available in all compiles.</li>
<li>SELECT min() or max() of an indexed column with no WHERE or GROUP BY
    clause is handled as a special case which avoids a complete table scan.</li>
<li>Automatically generated ROWIDs are now sequential.</li>
<li>Do not allow dot-commands of the command-line shell to occur in the
    middle of a real SQL command.</li>
<li>Modifications to the "lemon" parser generator so that the parser tables
    are 4 times smaller.</li>
<li>Added support for user-defined functions implemented in C.</li>
<li>Added support for new functions: <b>coalesce()</b>, <b>lower()</b>,
    <b>upper()</b>, and <b>random()</b>
<li>Added support for VIEWs.</li>
<li>Added the subquery flattening optimizer.</li>
<li>Modified the B-Tree and Pager modules so that disk pages that do not
    contain real data (free pages) are not journaled and are not
    written from memory back to the disk when they change.  This does not 
    impact database integrity, since the
    pages contain no real data, but it does make large INSERT operations
    about 2.5 times faster and large DELETEs about 5 times faster.</li>
<li>Made the CACHE_SIZE pragma persistent</li>
<li>Added the SYNCHRONOUS pragma</li>
<li>Fixed a bug that was causing updates to fail inside of transactions when
    the database contained a temporary table.</li>
}

chng {2002 Feb 18 (2.3.3)} {
<li>Allow identifiers to be quoted in square brackets, for compatibility
    with MS-Access.</li>
<li>Added support for sub-queries in the FROM clause of a SELECT.</li>
<li>More efficient implementation of sqliteFileExists() under Windows.
    (by Joel Luscy)</li>
<li>The VALUES clause of an INSERT can now contain expressions, including
    scalar SELECT clauses.</li>
<li>Added support for CREATE TABLE AS SELECT</li>
<li>Bug fix: Creating and dropping a table all within a single
    transaction was not working.</li>
}

chng {2002 Feb 14 (2.3.2)} {
<li>Bug fix: There was an incorrect assert() in pager.c.  The real code was
    all correct (as far as is known) so everything should work OK if you
    compile with -DNDEBUG=1.  When asserts are not disabled, there
    could be a fault.</li>
}

chng {2002 Feb 13 (2.3.1)} {
<li>Bug fix: An assertion was failing if "PRAGMA full_column_names=ON;" was
    set and you did a query that used a rowid, like this:  
    "SELECT rowid, * FROM ...".</li>
}

chng {2002 Jan 30 (2.3.0)} {
<li>Fix a serious bug in the INSERT command which was causing data to go
    into the wrong columns if the data source was a SELECT and the INSERT
    clauses specified its columns in some order other than the default.</li>
<li>Added the ability to resolve constraint conflicts is ways other than
    an abort and rollback.  See the documentation on the "ON CONFLICT"
    clause for details.</li>
<li>Temporary files are now automatically deleted by the operating system
    when closed.  There are no more dangling temporary files on a program
    crash.  (If the OS crashes, fsck will delete the file after reboot 
    under Unix.  I do not know what happens under Windows.)</li>
<li>NOT NULL constraints are honored.</li>
<li>The COPY command puts NULLs in columns whose data is '\N'.</li>
<li>In the COPY command, backslash can now be used to escape a newline.</li>
<li>Added the SANITY_CHECK pragma.</li>
}

chng {2002 Jan 28 (2.2.5)} {
<li>Important bug fix: the IN operator was not working if either the
    left-hand or right-hand side was derived from an INTEGER PRIMARY KEY.</li>
<li>Do not escape the backslash '\' character in the output of the
    <b>sqlite</b> command-line access program.</li>
}

chng {2002 Jan 22 (2.2.4)} {
<li>The label to the right of an AS in the column list of a SELECT can now
    be used as part of an expression in the WHERE, ORDER BY, GROUP BY, and/or
    HAVING clauses.</li>
<li>Fix a bug in the <b>-separator</b> command-line option to the <b>sqlite</b>
    command.</li>
<li>Fix a problem with the sort order when comparing upper-case strings against
    characters greater than 'Z' but less than 'a'.</li>
<li>Report an error if an ORDER BY or GROUP BY expression is constant.</li>
}

chng {2002 Jan 16 (2.2.3)} {
<li>Fix warning messages in VC++ 7.0.  (Patches from nicolas352001)</li>
<li>Make the library thread-safe.  (The code is there and appears to work
    but has not been stressed.)</li>
<li>Added the new <b>sqlite_last_insert_rowid()</b> API function.</li>
}

chng {2002 Jan 13 (2.2.2)} {
<li>Bug fix: An assertion was failing when a temporary table with an index
    had the same name as a permanent table created by a separate process.</li>
<li>Bug fix: Updates to tables containing an INTEGER PRIMARY KEY and an
    index could fail.</li>
}

chng {2002 Jan 9 (2.2.1)} {
<li>Bug fix: An attempt to delete a single row of a table with a WHERE
    clause of "ROWID=x" when no such rowid exists was causing an error.</li>
<li>Bug fix: Passing in a NULL as the 3rd parameter to <b>sqlite_open()</b>
    would sometimes cause a coredump.</li>
<li>Bug fix: DROP TABLE followed by a CREATE TABLE with the same name all
    within a single transaction was causing a coredump.</li>
<li>Makefile updates from A. Rottmann</li>
}

chng {2001 Dec 22 (2.2.0)} {
<li>Columns of type INTEGER PRIMARY KEY are actually used as the primary
    key in underlying B-Tree representation of the table.</li>
<li>Several obscure, unrelated bugs were found and fixed while 
    implemented the integer primary key change of the previous bullet.</li>
<li>Added the ability to specify "*" as part of a larger column list in
    the result section of a SELECT statement.  For example:
    <nobr>"<b>SELECT rowid, * FROM table1;</b>"</nobr>.</li>
<li>Updates to comments and documentation.</li>
}

chng {2001 Dec 14 (2.1.7)} {
<li>Fix a bug in <b>CREATE TEMPORARY TABLE</b> which was causing the
    table to be initially allocated in the main database file instead
    of in the separate temporary file.  This bug could cause the library
    to suffer an assertion failure and it could cause "page leaks" in the
    main database file.
<li>Fix a bug in the b-tree subsystem that could sometimes cause the first
    row of a table to be repeated during a database scan.</li>
}

chng {2001 Dec 14 (2.1.6)} {
<li>Fix the locking mechanism yet again to prevent
    <b>sqlite_exec()</b> from returning SQLITE_PROTOCOL
    unnecessarily.  This time the bug was a race condition in
    the locking code.  This change effects both POSIX and Windows users.</li>
}

chng {2001 Dec 6 (2.1.5)} {
<li>Fix for another problem (unrelated to the one fixed in 2.1.4) 
    that sometimes causes <b>sqlite_exec()</b> to return SQLITE_PROTOCOL
    unnecessarily.  This time the bug was
    in the POSIX locking code and should not effect windows users.</li>
}

chng {2001 Dec 4 (2.1.4)} {
<li>Sometimes <b>sqlite_exec()</b> would return SQLITE_PROTOCOL when it
    should have returned SQLITE_BUSY.</li>
<li>The fix to the previous bug uncovered a deadlock which was also
    fixed.</li>
<li>Add the ability to put a single .command in the second argument
    of the sqlite shell</li>
<li>Updates to the FAQ</li>
}

chng {2001 Nov 23 (2.1.3)} {
<li>Fix the behavior of comparison operators 
    (ex: "<b>&lt</b>", "<b>==</b>", etc.)
    so that they are consistent with the order of entries in an index.</li>
<li>Correct handling of integers in SQL expressions that are larger than
    what can be represented by the machine integer.</li>
}

chng {2001 Nov 22 (2.1.2)} {
<li>Changes to support 64-bit architectures.</li>
<li>Fix a bug in the locking protocol.</li>
<li>Fix a bug that could (rarely) cause the database to become 
    unreadable after a DROP TABLE due to corruption to the SQLITE_MASTER
    table.</li>
<li>Change the code so that version 2.1.1 databases that were rendered 
    unreadable by the above bug can be read by this version of
    the library even though the SQLITE_MASTER table is (slightly)
    corrupted.</li>
}

chng {2001 Nov 13 (2.1.1)} {
<li>Bug fix: Sometimes arbitrary strings were passed to the callback
    function when the actual value of a column was NULL.</li>
}

chng {2001 Nov 12 (2.1.0)} {
<li>Change the format of data records so that records up to 16MB in size
    can be stored.</li>
<li>Change the format of indices to allow for better query optimization.</li>
<li>Implement the "LIMIT ... OFFSET ..." clause on SELECT statements.</li>
}

chng {2001 Nov 3 (2.0.8)} {
<li>Made selected parameters in API functions <b>const</b>. This should
    be fully backwards compatible.</li>
<li>Documentation updates</li>
<li>Simplify the design of the VDBE by restricting the number of sorters
    and lists to 1.
    In practice, no more than one sorter and one list was ever used anyhow.
    </li>
}

chng {2001 Oct 21 (2.0.7)} {
<li>Any UTF-8 character or ISO8859 character can be used as part of
    an identifier.</li>
<li>Patches from Christian Werner to improve ODBC compatibility and to
    fix a bug in the round() function.</li>
<li>Plug some memory leaks that use to occur if malloc() failed.
    We have been and continue to be memory leak free as long as
    malloc() works.</li>
<li>Changes to some test scripts so that they work on Windows in
    addition to Unix.</li>
}

chng {2001 Oct 19 (2.0.6)} {
<li>Added the EMPTY_RESULT_CALLBACKS pragma</li>
<li>Support for UTF-8 and ISO8859 characters in column and table names.</li>
<li>Bug fix: Compute correct table names with the FULL_COLUMN_NAMES pragma
    is turned on.</li>
}

chng {2001 Oct 14 (2.0.5)} {
<li>Added the COUNT_CHANGES pragma.</li>
<li>Changes to the FULL_COLUMN_NAMES pragma to help out the ODBC driver.</li>
<li>Bug fix: "SELECT count(*)" was returning NULL for empty tables.
    Now it returns 0.</li>
}

chng {2001 Oct 13 (2.0.4)} {
<li>Bug fix: an obscure and relatively harmless bug was causing one of
    the tests to fail when gcc optimizations are turned on.  This release
    fixes the problem.</li>
}

chng {2001 Oct 13 (2.0.3)} {
<li>Bug fix: the <b>sqlite_busy_timeout()</b> function was delaying 1000
    times too long before failing.</li>
<li>Bug fix: an assertion was failing if the disk holding the database
    file became full or stopped accepting writes for some other reason.
    New tests were added to detect similar problems in the future.</li>
<li>Added new operators: <b>&amp;</b> (bitwise-and)
    <b>|</b> (bitwise-or), <b>~</b> (ones-complement),
    <b>&lt;&lt;</b> (shift left), <b>&gt;&gt;</b> (shift right).</li>
<li>Added new functions: <b>round()</b> and <b>abs()</b>.</li>
}

chng {2001 Oct 9 (2.0.2)} {
<li>Fix two bugs in the locking protocol.  (One was masking the other.)</li>
<li>Removed some unused "#include <unistd.h>" that were causing problems
    for VC++.</li>
<li>Fixed <b>sqlite.h</b> so that it is usable from C++</li>
<li>Added the FULL_COLUMN_NAMES pragma.  When set to "ON", the names of
    columns are reported back as TABLE.COLUMN instead of just COLUMN.</li>
<li>Added the TABLE_INFO() and INDEX_INFO() pragmas to help support the
    ODBC interface.</li>
<li>Added support for TEMPORARY tables and indices.</li>
}

chng {2001 Oct 2 (2.0.1)} {
<li>Remove some C++ style comments from btree.c so that it will compile
    using compilers other than gcc.</li>
<li>The ".dump" output from the shell does not work if there are embedded
    newlines anywhere in the data.  This is an old bug that was carried
    forward from version 1.0.  To fix it, the ".dump" output no longer
    uses the COPY command.  It instead generates INSERT statements.</li>
<li>Extend the expression syntax to support "expr NOT NULL" (with a
    space between the "NOT" and the "NULL") in addition to "expr NOTNULL"
    (with no space).</li>
}

chng {2001 Sep 28 (2.0.0)} {
<li>Automatically build binaries for Linux and Windows and put them on
    the website.</li>
}

chng {2001 Sep 28 (2.0-alpha-4)} {
<li>Incorporate makefile patches form A. Rottmann to use LIBTOOL</li>
}

chng {2001 Sep 27 (2.0-alpha-3)} {
<li>SQLite now honors the UNIQUE keyword in CREATE UNIQUE INDEX.  Primary
    keys are required to be unique.</li>
<li>File format changed back to what it was for alpha-1</li>
<li>Fixes to the rollback and locking behavior</li>
}

chng {2001 Sep 20 (2.0-alpha-2)} {
<li>Initial release of version 2.0.  The idea of renaming the library
    to "SQLus" was abandoned in favor of keeping the "SQLite" name and
    bumping the major version number.</li>
<li>The pager and btree subsystems added back. They are now the only
    available backend.</li>
<li>The Dbbe abstraction and the GDBM and memory drivers were removed.</li>
<li>Copyright on all code was disclaimed.  The library is now in the
    public domain.</li>
}

chng {2001 Jul 23 (1.0.32)} {
<li>Pager and btree subsystems removed.  These will be used in a follow-on
    SQL server library named "SQLus".</li>
<li>Add the ability to use quoted strings as table and column names in
    expressions.</li>
}

chng {2001 Apr 14 (1.0.31)} {
<li>Pager subsystem added but not yet used.</li>
<li>More robust handling of out-of-memory errors.</li>
<li>New tests added to the test suite.</li>
}

chng {2001 Apr 6 (1.0.30)} {
<li>Remove the <b>sqlite_encoding</b> TCL variable that was introduced
    in the previous version.</li>
<li>Add options <b>-encoding</b> and <b>-tcl-uses-utf</b> to the
    <b>sqlite</b> TCL command.</li>
<li>Add tests to make sure that tclsqlite was compiled using Tcl header
    files and libraries that match.</li>
}

chng {2001 Apr 5 (1.0.29)} {
<li>The library now assumes data is stored as UTF-8 if the --enable-utf8
    option is given to configure.  The default behavior is to assume
    iso8859-x, as it has always done.  This only makes a difference for
    LIKE and GLOB operators and the LENGTH and SUBSTR functions.</li>
<li>If the library is not configured for UTF-8 and the Tcl library
    is one of the newer ones that uses UTF-8 internally,
    then a conversion from UTF-8 to iso8859 and
    back again is done inside the TCL interface.</li>
}

chng {2001 Apr 4 (1.0.28)} {
<li>Added limited support for transactions.  At this point, transactions
    will do table locking on the GDBM backend.  There is no support (yet)
    for rollback or atomic commit.</li>
<li>Added special column names ROWID, OID, and _ROWID_ that refer to the
    unique random integer key associated with every row of every table.</li>
<li>Additional tests added to the regression suite to cover the new ROWID
    feature and the TCL interface bugs mentioned below.</li>
<li>Changes to the "lemon" parser generator to help it work better when
    compiled using MSVC.</li>
<li>Bug fixes in the TCL interface identified by Oleg Oleinick.</li>
}

chng {2001 Mar 20 (1.0.27)} {
<li>When doing DELETE and UPDATE, the library used to write the record
    numbers of records to be deleted or updated into a temporary file.
    This is changed so that the record numbers are held in memory.</li>
<li>The DELETE command without a WHILE clause just removes the database
    files from the disk, rather than going through and deleting record
    by record.</li>
}

chng {2001 Mar 20 (1.0.26)} {
<li>A serious bug fixed on Windows.  Windows users should upgrade.
    No impact to Unix.</li>
}

chng {2001 Mar 15 (1.0.25)} {
<li>Modify the test scripts to identify tests that depend on system
    load and processor speed and
    to warn the user that a failure of one of those (rare) tests does
    not necessarily mean the library is malfunctioning.  No changes to
    code.
    </li>
}

chng {2001 Mar 14 (1.0.24)} {
<li>Fix a bug which was causing
    the UPDATE command to fail on systems where "malloc(0)" returns
    NULL.  The problem does not appear Windows, Linux, or HPUX but does 
    cause the library to fail on QNX.
    </li>
}

chng {2001 Feb 19 (1.0.23)} {
<li>An unrelated (and minor) bug from Mark Muranwski fixed.  The algorithm
    for figuring out where to put temporary files for a "memory:" database
    was not working quite right.
    </li>
}

chng {2001 Feb 19 (1.0.22)} {
<li>The previous fix was not quite right.  This one seems to work better.
    </li>
}

chng {2001 Feb 19 (1.0.21)} {
<li>The UPDATE statement was not working when the WHERE clause contained
    some terms that could be satisfied using indices and other terms that
    could not.  Fixed.</li>
}

chng {2001 Feb 11 (1.0.20)} {
<li>Merge development changes into the main trunk.  Future work toward
    using a BTree file structure will use a separate CVS source tree.  This
    CVS tree will continue to support the GDBM version of SQLite only.</li>
}

chng {2001 Feb 6 (1.0.19)} {
<li>Fix a strange (but valid) C declaration that was causing problems
    for QNX.  No logical changes.</li>
}

chng {2001 Jan 4 (1.0.18)} {
<li>Print the offending SQL statement when an error occurs.</li>
<li>Do not require commas between constraints in CREATE TABLE statements.</li>
<li>Added the "-echo" option to the shell.</li>
<li>Changes to comments.</li>
}

chng {2000 Dec 10 (1.0.17)} {
<li>Rewrote <b>sqlite_complete()</b> to make it faster.</li>
<li>Minor tweaks to other code to make it run a little faster.</li>
<li>Added new tests for <b>sqlite_complete()</b> and for memory leaks.</li>
}

chng {2000 Dec 4 (1.0.16)} {
<li>Documentation updates.  Mostly fixing of typos and spelling errors.</li>
}

chng {2000 Oct 23 (1.0.15)} {
<li>Documentation updates</li>
<li>Some sanity checking code was removed from the inner loop of vdbe.c
    to help the library to run a little faster.  The code is only
    removed if you compile with -DNDEBUG.</li>
}

chng {2000 Oct 19 (1.0.14)} {
<li>Added a "memory:" backend driver that stores its database in an
    in-memory hash table.</li>
}

chng {2000 Oct 18 (1.0.13)} {
<li>Break out the GDBM driver into a separate file in anticipation
    to added new drivers.</li>
<li>Allow the name of a database to be prefixed by the driver type.
    For now, the only driver type is "gdbm:".</li>
}

chng {2000 Oct 16 (1.0.12)} {
<li>Fixed an off-by-one error that was causing a coredump in 
    the '%q' format directive of the new
    <b>sqlite_..._printf()</b> routines.</li>
<li>Added the <b>sqlite_interrupt()</b> interface.</li>
<li>In the shell, <b>sqlite_interrupt()</b> is invoked when the
    user presses Control-C</li>
<li>Fixed some instances where <b>sqlite_exec()</b> was
    returning the wrong error code.</li>
}

chng {2000 Oct 11 (1.0.10)} {
<li>Added notes on how to compile for Windows95/98.</li>
<li>Removed a few variables that were not being used.  Etc.</li>
}

chng {2000 Oct 8 (1.0.9)} {
<li>Added the <b>sqlite_..._printf()</b> interface routines.</li>
<li>Modified the <b>sqlite</b> shell program to use the new interface 
    routines.</li>
<li>Modified the <b>sqlite</b> shell program to print the schema for
    the built-in SQLITE_MASTER table, if explicitly requested.</li>
}

chng {2000 Sep 30 (1.0.8)} {
<li>Begin writing documentation on the TCL interface.</li>
}

chng {2000 Sep 29 (Not Released)} {
<li>Added the <b>sqlite_get_table()</b> API</li>
<li>Updated the documentation for due to the above change.</li>
<li>Modified the <b>sqlite</b> shell to make use of the new
    sqlite_get_table() API in order to print a list of tables
    in multiple columns, similar to the way "ls" prints filenames.</li>
<li>Modified the <b>sqlite</b> shell to print a semicolon at the
    end of each CREATE statement in the output of the ".schema" command.</li>
}

chng {2000 Sep 21 (Not Released)} {
<li>Change the tclsqlite "eval" method to return a list of results if
    no callback script is specified.</li>
<li>Change tclsqlite.c to use the Tcl_Obj interface</li>
<li>Add tclsqlite.c to the libsqlite.a library</li>
}

chng {2000 Sep 13 (Version 1.0.5)} {
<li>Changed the print format for floating point values from "%g" to "%.15g".
    </li>
<li>Changed the comparison function so that numbers in exponential notation
    (ex: 1.234e+05) sort in numerical order.</li>
}

chng {2000 Aug 28 (Version 1.0.4)} {
<li>Added functions <b>length()</b> and <b>substr()</b>.</li>
<li>Fix a bug in the <b>sqlite</b> shell program that was causing
    a coredump when the output mode was "column" and the first row
    of data contained a NULL.</li>
}

chng {2000 Aug 22 (Version 1.0.3)} {
<li>In the sqlite shell, print the "Database opened READ ONLY" message
    to stderr instead of stdout.</li>
<li>In the sqlite shell, now print the version number on initial startup.</li>
<li>Add the <b>sqlite_version[]</b> string constant to the library</li>
<li>Makefile updates</li>
<li>Bug fix: incorrect VDBE code was being generated for the following
    circumstance: a query on an indexed table containing a WHERE clause with
    an IN operator that had a subquery on its right-hand side.</li>
}

chng {2000 Aug 18 (Version 1.0.1)} {
<li>Fix a bug in the configure script.</li>
<li>Minor revisions to the website.</li>
}

chng {2000 Aug 17 (Version 1.0)} {
<li>Change the <b>sqlite</b> program so that it can read
    databases for which it lacks write permission.  (It used to
    refuse all access if it could not write.)</li>
}

chng {2000 Aug 9} {
<li>Treat carriage returns as white space.</li>
}

chng {2000 Aug 8} {
<li>Added pattern matching to the ".table" command in the "sqlite"
command shell.</li>
}

chng {2000 Aug 4} {
<li>Documentation updates</li>
<li>Added "busy" and "timeout" methods to the Tcl interface</li>
}

chng {2000 Aug 3} {
<li>File format version number was being stored in sqlite_master.tcl
    multiple times. This was harmless, but unnecessary. It is now fixed.</li>
}

chng {2000 Aug 2} {
<li>The file format for indices was changed slightly in order to work
    around an inefficiency that can sometimes come up with GDBM when
    there are large indices having many entries with the same key.
    <font color="red">** Incompatible Change **</font></li>
}

chng {2000 Aug 1} {
<li>The parser's stack was overflowing on a very long UPDATE statement.
    This is now fixed.</li>
}

chng {2000 July 31} {
<li>Finish the <a href="vdbe.html">VDBE tutorial</a>.</li>
<li>Added documentation on compiling to WindowsNT.</li>
<li>Fix a configuration program for WindowsNT.</li>
<li>Fix a configuration problem for HPUX.</li>
}

chng {2000 July 29} {
<li>Better labels on column names of the result.</li>
}

chng {2000 July 28} {
<li>Added the <b>sqlite_busy_handler()</b> 
    and <b>sqlite_busy_timeout()</b> interface.</li>
}

chng {2000 June 23} {
<li>Begin writing the <a href="vdbe.html">VDBE tutorial</a>.</li>
}

chng {2000 June 21} {
<li>Clean up comments and variable names.  Changes to documentation.
    No functional changes to the code.</li>
}

chng {2000 June 19} {
<li>Column names in UPDATE statements were case sensitive.
    This mistake has now been fixed.</li>
}

chng {2000 June 16} {
<li>Added the concatenate string operator (||)</li>
}

chng {2000 June 12} {
<li>Added the fcnt() function to the SQL interpreter.  The fcnt() function
    returns the number of database "Fetch" operations that have occurred.
    This function is designed for use in test scripts to verify that
    queries are efficient and appropriately optimized.  Fcnt() has no other
    useful purpose, as far as I know.</li>
<li>Added a bunch more tests that take advantage of the new fcnt() function.
    The new tests did not uncover any new problems.</li>
}

chng {2000 June 8} {
<li>Added lots of new test cases</li>
<li>Fix a few bugs discovered while adding test cases</li>
<li>Begin adding lots of new documentation</li>
}

chng {2000 June 6} {
<li>Added compound select operators: <B>UNION</b>, <b>UNION ALL</B>,
<b>INTERSECT</b>, and <b>EXCEPT</b></li>
<li>Added support for using <b>(SELECT ...)</b> within expressions</li>
<li>Added support for <b>IN</b> and <b>BETWEEN</b> operators</li>
<li>Added support for <b>GROUP BY</b> and <b>HAVING</b></li>
<li>NULL values are now reported to the callback as a NULL pointer
    rather than an empty string.</li>
}

chng {2000 June 3} {
<li>Added support for default values on columns of a table.</li>
<li>Improved test coverage.  Fixed a few obscure bugs found by the
improved tests.</li>
}

chng {2000 June 2} {
<li>All database files to be modified by an UPDATE, INSERT or DELETE are 
now locked before any changes are made to any files.  
This makes it safe (I think) to access
the same database simultaneously from multiple processes.</li>
<li>The code appears stable so we are now calling it "beta".</li>
}

chng {2000 June 1} {
<li>Better support for file locking so that two or more processes 
(or threads)
can access the same database simultaneously.  More work needed in
this area, though.</li>
}

chng {2000 May 31} {
<li>Added support for aggregate functions (Ex: <b>COUNT(*)</b>, <b>MIN(...)</b>)
to the SELECT statement.</li>
<li>Added support for <B>SELECT DISTINCT ...</B></li>
}

chng {2000 May 30} {
<li>Added the <b>LIKE</b> operator.</li>
<li>Added a <b>GLOB</b> operator: similar to <B>LIKE</B> 
but it uses Unix shell globbing wildcards instead of the '%' 
and '_' wildcards of SQL.</li>
<li>Added the <B>COPY</b> command patterned after 
<a href="http://www.postgresql.org/">PostgreSQL</a> so that SQLite
can now read the output of the <b>pg_dump</b> database dump utility
of PostgreSQL.</li>
<li>Added a <B>VACUUM</B> command that that calls the 
<b>gdbm_reorganize()</b> function on the underlying database
files.</li>
<li>And many, many bug fixes...</li>
}

chng {2000 May 29} {
<li>Initial Public Release of Alpha code</li>
}

puts {
</DL>
}
footer {$Id:}
