\name{CropImageFilter}
\alias{CropImageFilter}
\title{CropImageFilter}
\Rdversion{1.1}
\docType{class}
\description{
Decrease the image size by cropping the image by an itk::Size at both the upper and lower bounds of the largest possible region.
CropImageFilter}
\details{
CropImageFilter changes the image boundary of an image by removing pixels outside the
target region. The target region is not specified in advance, but
calculated in BeforeThreadedGenerateData() .
This filter uses ExtractImageFilter to perform the cropping.
See:
Crop for the procedural interface
itk::CropImageFilter for the Doxygen on the original ITK class.
CropImageFilter}
%C++ includes: sitkCropImageFilter.h
\section{Methods}{
\describe{
\item{ CropImageFilter():}{
Default Constructor that takes no arguments and initializes default
parameters
}
\item{Image Execute(const Image &image1):}{}
\item{Image Execute(Image &&image1):}{
Execute the filter on the input image
}
\item{std::vector< unsigned int > GetLowerBoundaryCropSize() const:}{
Set/Get the cropping sizes for the upper and lower boundaries.
}
\item{std::string GetName() const:}{
Name of this class
}
\item{std::vector< unsigned int > GetUpperBoundaryCropSize() const:}{
Set/Get the cropping sizes for the upper and lower boundaries.
}
\item{Self SetLowerBoundaryCropSize(std::vector< unsigned int > LowerBoundaryCropSize):}{
Set/Get the cropping sizes for the upper and lower boundaries.
}
\item{Self SetUpperBoundaryCropSize(std::vector< unsigned int > UpperBoundaryCropSize):}{
Set/Get the cropping sizes for the upper and lower boundaries.
}
\item{std::string ToString() const:}{
Print ourselves out
}
\item{ ~CropImageFilter():}{
Destructor
}
}
}
