/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.rules;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rel.rules.ConflictRule;
import org.apache.calcite.rel.rules.LongBitmap;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexNodeAndFieldIndex;
import org.apache.calcite.rex.RexShuttle;

public class HyperEdge {
    private final TotalEligibilitySet tes;
    private final ImmutableList<ConflictRule> conflictRules;
    private final long leftNodeUsedInPredicate;
    private final long rightNodeUsedInPredicate;
    private final long initialLeftNodeBits;
    private final long initialRightNodeBits;
    private final JoinRelType joinType;
    private final RexNode condition;

    public HyperEdge(TotalEligibilitySet tes, List<ConflictRule> conflictRules, long leftNodeUsedInPredicate, long rightNodeUsedInPredicate, long initialLeftNodeBits, long initialRightNodeBits, JoinRelType joinType, RexNode condition) {
        this.tes = tes;
        this.conflictRules = ImmutableList.copyOf(conflictRules);
        this.leftNodeUsedInPredicate = leftNodeUsedInPredicate;
        this.rightNodeUsedInPredicate = rightNodeUsedInPredicate;
        this.initialLeftNodeBits = initialLeftNodeBits;
        this.initialRightNodeBits = initialRightNodeBits;
        this.joinType = joinType;
        this.condition = condition;
    }

    public long getEndpoint() {
        return this.tes.totalSet;
    }

    public long getLeftEndpoint() {
        return this.tes.leftSet;
    }

    public long getRightEndpoint() {
        return this.tes.rightSet;
    }

    public long getLeftNodeUsedInPredicate() {
        return this.leftNodeUsedInPredicate;
    }

    public long getRightNodeUsedInPredicate() {
        return this.rightNodeUsedInPredicate;
    }

    public List<ConflictRule> getConflictRules() {
        return this.conflictRules;
    }

    public long getInitialLeftNodeBits() {
        return this.initialLeftNodeBits;
    }

    public long getInitialRightNodeBits() {
        return this.initialRightNodeBits;
    }

    public boolean isSimple() {
        return this.tes.isSimple();
    }

    public JoinRelType getJoinType() {
        return this.joinType;
    }

    public RexNode getCondition() {
        return this.condition;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(LongBitmap.printBitmap(this.getLeftEndpoint())).append("\u2014\u2014[").append((Object)this.joinType).append(", ").append(this.condition).append("]\u2014\u2014").append(LongBitmap.printBitmap(this.getRightEndpoint()));
        return sb.toString();
    }

    public HyperEdge accept(RexShuttle shuttle) {
        RexNode shuttleCondition = this.condition.accept(shuttle);
        return new HyperEdge(this.tes, (List<ConflictRule>)this.conflictRules, this.leftNodeUsedInPredicate, this.rightNodeUsedInPredicate, this.initialLeftNodeBits, this.initialRightNodeBits, this.joinType, shuttleCondition);
    }

    public HyperEdge adjustNodeBit(final int nodeOffset) {
        RexShuttle shiftNodeIndexShuttle = new RexShuttle(){

            @Override
            public RexNode visitNodeAndFieldIndex(RexNodeAndFieldIndex nodeAndFieldIndex) {
                return new RexNodeAndFieldIndex(nodeAndFieldIndex.getNodeIndex() + nodeOffset, nodeAndFieldIndex.getFieldIndex(), nodeAndFieldIndex.getName(), nodeAndFieldIndex.getType());
            }
        };
        RexNode shiftedCondition = this.condition.accept(shiftNodeIndexShuttle);
        ArrayList<ConflictRule> shiftedConflictRules = new ArrayList<ConflictRule>();
        for (ConflictRule conflictRule : this.conflictRules) {
            shiftedConflictRules.add(conflictRule.shift(nodeOffset));
        }
        return new HyperEdge(this.tes.shift(nodeOffset), shiftedConflictRules, this.leftNodeUsedInPredicate << nodeOffset, this.rightNodeUsedInPredicate << nodeOffset, this.initialLeftNodeBits << nodeOffset, this.initialRightNodeBits << nodeOffset, this.joinType, shiftedCondition);
    }

    public static List<HyperEdge> createHyperEdgesFromJoinConds(final Map<Integer, Integer> inputRefToNodeIndexMap, final Map<Integer, Integer> inputRefToFieldIndexMap, List<RexNode> joinConds, List<ConflictRule> conflictRules, JoinRelType joinType, final int leftNodeCount, int nodeCount) {
        long initialLeftNodeBits = LongBitmap.newBitmapBetween(0, leftNodeCount);
        long initialRightNodeBits = LongBitmap.newBitmapBetween(leftNodeCount, nodeCount);
        ArrayList<HyperEdge> edges = new ArrayList<HyperEdge>();
        for (RexNode joinCond : joinConds) {
            TotalEligibilitySet tes;
            final ArrayList<Integer> leftRefs = new ArrayList<Integer>();
            final ArrayList<Integer> rightRefs = new ArrayList<Integer>();
            RexShuttle inputRef2NodeAndFieldIndexShuttle = new RexShuttle(){

                @Override
                public RexNode visitInputRef(RexInputRef inputRef) {
                    Integer nodeIndex = (Integer)inputRefToNodeIndexMap.get(inputRef.getIndex());
                    assert (nodeIndex != null);
                    if (nodeIndex < leftNodeCount) {
                        leftRefs.add(nodeIndex);
                    } else {
                        rightRefs.add(nodeIndex);
                    }
                    Integer fieldIndex = (Integer)inputRefToFieldIndexMap.get(inputRef.getIndex());
                    assert (fieldIndex != null);
                    return new RexNodeAndFieldIndex(nodeIndex, fieldIndex, inputRef.getName(), inputRef.getType());
                }
            };
            RexNode hyperEdgeCondition = joinCond.accept(inputRef2NodeAndFieldIndexShuttle);
            long leftNodeUsedInPredicate = LongBitmap.newBitmapFromList(leftRefs);
            long rightNodeUsedInPredicate = LongBitmap.newBitmapFromList(rightRefs);
            ArrayList<ConflictRule> conflictRulesAfterAbsorb = new ArrayList<ConflictRule>();
            if (leftNodeUsedInPredicate == 0L || rightNodeUsedInPredicate == 0L) {
                tes = new TotalEligibilitySet(initialLeftNodeBits, initialRightNodeBits);
            } else {
                tes = new TotalEligibilitySet(leftNodeUsedInPredicate, rightNodeUsedInPredicate);
                tes = tes.absorbFromConflictRules(conflictRules, conflictRulesAfterAbsorb, initialLeftNodeBits, initialRightNodeBits);
            }
            edges.add(new HyperEdge(tes, conflictRulesAfterAbsorb, leftNodeUsedInPredicate, rightNodeUsedInPredicate, initialLeftNodeBits, initialRightNodeBits, joinType, hyperEdgeCondition));
        }
        return edges;
    }

    private static class TotalEligibilitySet {
        final long leftSet;
        final long rightSet;
        final long totalSet;
        final boolean isSimple;

        TotalEligibilitySet(long leftSet, long rightSet) {
            assert (!LongBitmap.isOverlap(leftSet, rightSet));
            this.leftSet = leftSet;
            this.rightSet = rightSet;
            this.totalSet = leftSet | rightSet;
            boolean leftSimple = (leftSet & leftSet - 1L) == 0L;
            boolean rightSimple = (rightSet & rightSet - 1L) == 0L;
            this.isSimple = leftSimple && rightSimple;
        }

        TotalEligibilitySet shift(int offset) {
            return new TotalEligibilitySet(this.leftSet << offset, this.rightSet << offset);
        }

        boolean isSimple() {
            return this.isSimple;
        }

        TotalEligibilitySet absorbFromConflictRules(List<ConflictRule> conflictRules, List<ConflictRule> conflictRulesAfterAbsorb, long initialLeftNodeBits, long initialRightNodeBits) {
            long totalSetAbsorb = this.totalSet;
            for (ConflictRule conflictRule : conflictRules) {
                if (LongBitmap.isOverlap(totalSetAbsorb, conflictRule.from)) {
                    totalSetAbsorb |= conflictRule.to;
                    continue;
                }
                conflictRulesAfterAbsorb.add(conflictRule);
            }
            assert (LongBitmap.isSubSet(totalSetAbsorb, initialLeftNodeBits | initialRightNodeBits));
            long rightSetAbsorb = totalSetAbsorb & initialRightNodeBits;
            long leftSetAbsorb = totalSetAbsorb & (rightSetAbsorb ^ 0xFFFFFFFFFFFFFFFFL);
            return new TotalEligibilitySet(leftSetAbsorb, rightSetAbsorb);
        }
    }
}

