/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.opensearch.data.value;

import java.util.Objects;
import lombok.Generated;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Point;
import org.opensearch.sql.data.model.AbstractExprValue;
import org.opensearch.sql.data.model.ExprValue;
import org.opensearch.sql.data.type.ExprType;
import org.opensearch.sql.opensearch.data.type.OpenSearchGeoPointType;
import org.opensearch.sql.opensearch.data.utils.GeometryUtils;

public class OpenSearchExprGeoPointValue
extends AbstractExprValue {
    private final GeoPoint geoPoint;

    public OpenSearchExprGeoPointValue(Double lat, Double lon) {
        this.geoPoint = new GeoPoint(lat, lon);
    }

    public Object value() {
        return this.geoPoint;
    }

    public Point valueForCalcite() {
        return GeometryUtils.defaultFactory.createPoint(new Coordinate(this.geoPoint.lon.doubleValue(), this.geoPoint.lat.doubleValue()));
    }

    public ExprType type() {
        return OpenSearchGeoPointType.of();
    }

    public int compare(ExprValue other) {
        return this.geoPoint.toString().compareTo(((OpenSearchExprGeoPointValue)other).geoPoint.toString());
    }

    public boolean equal(ExprValue other) {
        return this.geoPoint.equals(((OpenSearchExprGeoPointValue)other).geoPoint);
    }

    public int hashCode() {
        return Objects.hashCode(this.geoPoint);
    }

    public static class GeoPoint {
        private final Double lat;
        private final Double lon;

        @Generated
        public GeoPoint(Double lat, Double lon) {
            this.lat = lat;
            this.lon = lon;
        }

        @Generated
        public Double getLat() {
            return this.lat;
        }

        @Generated
        public Double getLon() {
            return this.lon;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof GeoPoint)) {
                return false;
            }
            GeoPoint other = (GeoPoint)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Double this$lat = this.getLat();
            Double other$lat = other.getLat();
            if (this$lat == null ? other$lat != null : !((Object)this$lat).equals(other$lat)) {
                return false;
            }
            Double this$lon = this.getLon();
            Double other$lon = other.getLon();
            return !(this$lon == null ? other$lon != null : !((Object)this$lon).equals(other$lon));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof GeoPoint;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Double $lat = this.getLat();
            result = result * 59 + ($lat == null ? 43 : ((Object)$lat).hashCode());
            Double $lon = this.getLon();
            result = result * 59 + ($lon == null ? 43 : ((Object)$lon).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "OpenSearchExprGeoPointValue.GeoPoint(lat=" + this.getLat() + ", lon=" + this.getLon() + ")";
        }
    }
}

