/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.runtime.jfr.impl;

import com.oracle.truffle.runtime.jfr.CompilationEvent;
import com.oracle.truffle.runtime.jfr.impl.CompilationFailureEventImpl;
import com.oracle.truffle.runtime.jfr.impl.RootFunctionEventImpl;
import jdk.jfr.BooleanFlag;
import jdk.jfr.Category;
import jdk.jfr.DataAmount;
import jdk.jfr.Description;
import jdk.jfr.Label;
import jdk.jfr.MemoryAddress;
import jdk.jfr.Name;
import jdk.jfr.StackTrace;
import jdk.jfr.Unsigned;

@Name(value="jdk.graal.compiler.truffle.Compilation")
@Category(value={"Truffle Compiler"})
@Label(value="Compilation")
@Description(value="Truffe Compilation")
@StackTrace(value=false)
class CompilationEventImpl
extends RootFunctionEventImpl
implements CompilationEvent {
    @Label(value="Succeeded")
    @Description(value="Compilation Status")
    @BooleanFlag
    public boolean success;
    @Label(value="Compiled Code Size")
    @Description(value="Compiled Code Size")
    @DataAmount
    @Unsigned
    public int compiledCodeSize;
    @Label(value="Compiled Code Address")
    @Description(value="Compiled Code Address")
    @MemoryAddress
    public long compiledCodeAddress;
    @Label(value="Inlined Calls")
    @Description(value="Inlined Calls")
    @Unsigned
    public int inlinedCalls;
    @Label(value="Dispatched Calls")
    @Description(value="Dispatched Calls")
    @Unsigned
    public int dispatchedCalls;
    @Label(value="Graal Nodes")
    @Description(value="Graal Node Count")
    @Unsigned
    public int graalNodeCount;
    @Label(value="Truffle Nodes")
    @Description(value="Truffle Node Count")
    @Unsigned
    public int peNodeCount;
    @Label(value="Partial Evaluation Time")
    @Description(value="Partial Evaluation Time in Milliseconds")
    @Unsigned
    public long peTime;
    private transient CompilationFailureEventImpl failure;

    CompilationEventImpl() {
    }

    @Override
    public void compilationStarted() {
        this.begin();
    }

    @Override
    public void succeeded() {
        this.end();
        this.success = true;
    }

    @Override
    public void failed(boolean permanent, CharSequence reason) {
        this.end();
        this.success = false;
        this.failure = new CompilationFailureEventImpl(this.source, this.language, this.rootFunction, permanent, reason);
    }

    @Override
    public void setCompiledCodeSize(int size) {
        this.compiledCodeSize = size;
    }

    @Override
    public void setCompiledCodeAddress(long addr) {
        this.compiledCodeAddress = addr;
    }

    @Override
    public void setInlinedCalls(int count) {
        this.inlinedCalls = count;
    }

    @Override
    public void setDispatchedCalls(int count) {
        this.dispatchedCalls = count;
    }

    @Override
    public void setGraalNodeCount(int count) {
        this.graalNodeCount = count;
    }

    @Override
    public void setPartialEvaluationNodeCount(int count) {
        this.peNodeCount = count;
    }

    @Override
    public void setPartialEvaluationTime(long time) {
        this.peTime = time;
    }

    @Override
    public void publish() {
        super.publish();
        if (this.failure != null) {
            this.failure.publish();
        }
    }
}

