/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jsf.wizards;

import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.modules.web.jsf.api.facesmodel.JsfVersionUtils;
import org.netbeans.modules.web.jsf.wizards.Bundle;
import org.netbeans.modules.web.jsf.wizards.FacesComponentPanelVisual;
import org.netbeans.modules.web.jsfapi.api.JsfVersion;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.util.ChangeSupport;
import org.openide.util.HelpCtx;

class FacesComponentPanel
implements WizardDescriptor.Panel<WizardDescriptor>,
ChangeListener {
    protected static final String PROP_TAG_NAME = "tagName";
    protected static final String PROP_TAG_NAMESPACE = "tagNamespace";
    protected static final String PROP_SAMPLE_CODE = "sampleCode";
    private final WizardDescriptor descriptor;
    private final ChangeSupport changeSupport = new ChangeSupport((Object)this);
    private FacesComponentPanelVisual gui;

    public FacesComponentPanel(WizardDescriptor descriptor) {
        this.descriptor = descriptor;
    }

    public FacesComponentPanelVisual getComponent() {
        if (this.gui == null) {
            this.gui = new FacesComponentPanelVisual();
        }
        return this.gui;
    }

    public HelpCtx getHelp() {
        return HelpCtx.DEFAULT_HELP;
    }

    public void readSettings(WizardDescriptor settings) {
        this.getComponent();
        this.gui.addChangeListener(this);
    }

    public void storeSettings(WizardDescriptor settings) {
        this.getComponent();
        this.gui.removeChangeListener(this);
        settings.putProperty(PROP_TAG_NAME, (Object)this.gui.getTagName());
        settings.putProperty(PROP_TAG_NAMESPACE, (Object)this.gui.getTagNamespace());
        settings.putProperty(PROP_SAMPLE_CODE, (Object)this.gui.isSampleCode());
    }

    public boolean isValid() {
        JsfVersion jsfVersion;
        this.getComponent();
        this.descriptor.putProperty("WizardPanel_errorMessage", (Object)" ");
        Project project = Templates.getProject((WizardDescriptor)this.descriptor);
        WebModule webModule = WebModule.getWebModule((FileObject)project.getProjectDirectory());
        if (webModule != null && (jsfVersion = JsfVersionUtils.forWebModule(webModule)) != null && !jsfVersion.isAtLeast(JsfVersion.JSF_2_2)) {
            this.descriptor.putProperty("WizardPanel_errorMessage", (Object)Bundle.FacesComponentPanel_err_jsf_version_not_suficient());
            return false;
        }
        return true;
    }

    public void addChangeListener(ChangeListener l) {
        this.changeSupport.addChangeListener(l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.changeSupport.removeChangeListener(l);
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.fireChangeEvent();
    }

    private void fireChangeEvent() {
        this.changeSupport.fireChange();
    }
}

