/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.html.knockout;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.html.editor.lib.api.HelpResolver;
import org.netbeans.modules.html.knockout.KOUtils;
import org.openide.util.Exceptions;

public class KOHelpResolver
implements HelpResolver {
    private static final Logger LOGGER = Logger.getLogger(KOHelpResolver.class.getSimpleName());
    private static KOHelpResolver INSTANCE;

    public static synchronized KOHelpResolver getDefault() {
        if (INSTANCE == null) {
            INSTANCE = new KOHelpResolver();
        }
        return INSTANCE;
    }

    public URL resolveLink(URL baseURL, String relativeLink) {
        LOGGER.log(Level.FINE, "relativeLink = ''{0}''", relativeLink);
        LOGGER.log(Level.FINE, "baseURL = ''{0}''", baseURL);
        try {
            URI u = new URI(relativeLink);
            if (u.isAbsolute()) {
                LOGGER.log(Level.FINE, "resolved to = ''{0}''", u.toURL());
                return u.toURL();
            }
        }
        catch (MalformedURLException | URISyntaxException ex) {
            LOGGER.log(Level.FINE, null, ex);
        }
        String link = null;
        if (relativeLink.startsWith("#")) {
            assert (baseURL != null) : "Base URL must be provided for local relative links (anchors).";
            String base = baseURL.toExternalForm();
            int hashIdx = base.indexOf(35);
            if (hashIdx != -1) {
                base = base.substring(0, hashIdx);
            }
            link = base + relativeLink;
        } else if (baseURL != null) {
            URL url = this.getRelativeURL(baseURL, relativeLink);
            LOGGER.log(Level.FINE, "resolved to = ''{0}''", url);
            return url;
        }
        if (link != null) {
            try {
                URL url = new URI(link).toURL();
                LOGGER.log(Level.FINE, "resolved to = ''{0}''", url);
                return url;
            }
            catch (MalformedURLException | URISyntaxException ex) {
                LOGGER.log(Level.FINE, null, ex);
            }
        }
        LOGGER.fine("cannot be resolved!");
        return null;
    }

    private URL getRelativeURL(URL baseurl, String link) {
        if (link.trim().isEmpty()) {
            return null;
        }
        if (link.startsWith("./")) {
            link = link.substring(2);
        }
        String url = baseurl.toString();
        if (link.trim().charAt(0) == '#') {
            int index = url.indexOf(35);
            if (index > -1) {
                url = url.substring(0, url.indexOf(35));
            }
            url = url + link;
        } else {
            int index = 0;
            url = url.substring(0, url.lastIndexOf(47));
            while ((index = link.indexOf("../", index)) > -1) {
                url = url.substring(0, url.lastIndexOf(47));
                link = link.substring(index + 3);
            }
            url = url + "/" + link;
        }
        try {
            return new URL(url);
        }
        catch (MalformedURLException e) {
            LOGGER.log(Level.FINE, null, e);
            return null;
        }
    }

    public String getHelpContent(URL url) {
        try {
            return KOUtils.getContentAsString(url, null);
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return null;
        }
    }
}

