/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.beans.beaninfo;

import java.awt.Dialog;
import java.awt.EventQueue;
import java.awt.event.ActionListener;
import javax.lang.model.element.TypeElement;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.modules.beans.PatternAnalyser;
import org.netbeans.modules.beans.beaninfo.BiAnalyser;
import org.netbeans.modules.beans.beaninfo.BiNode;
import org.netbeans.modules.beans.beaninfo.BiPanel;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Task;
import org.openide.util.TaskListener;
import org.openide.util.actions.NodeAction;

public final class GenerateBeanInfoAction
extends NodeAction
implements ActionListener {
    private Dialog biDialog;
    static final long serialVersionUID = -4937492476805017833L;

    public String getName() {
        return GenerateBeanInfoAction.getString("CTL_GENBI_MenuItem");
    }

    protected String iconResource() {
        return null;
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    protected boolean enable(Node[] activatedNodes) {
        if (activatedNodes.length != 1) {
            return false;
        }
        FileObject fo = GenerateBeanInfoAction.findFileObject(activatedNodes[0]);
        return fo != null && JavaSource.forFileObject((FileObject)fo) != null && !fo.getName().endsWith("BeanInfo");
    }

    public void performAction(Node[] nodes) {
        if (nodes.length != 1) {
            return;
        }
        BiPanel biPanel = new BiPanel();
        FileObject javaFile = GenerateBeanInfoAction.findFileObject(nodes[0]);
        final BeanInfoWorker performer = new BeanInfoWorker(javaFile, biPanel);
        class Task
        implements TaskListener,
        Runnable {
            final /* synthetic */ GenerateBeanInfoAction this$0;

            Task() {
                this.this$0 = this$0;
            }

            public void taskFinished(org.openide.util.Task task) {
                EventQueue.invokeLater(this);
            }

            @Override
            public void run() {
                if (performer.error != null) {
                    DialogDisplayer.getDefault().notify(performer.error);
                }
                if (performer.bia != null) {
                    performer.bia.openSource();
                }
            }
        }
        performer.analyzePatterns().addTaskListener((TaskListener)new Task());
    }

    protected boolean asynchronous() {
        return false;
    }

    private void initAccessibility() {
        this.biDialog.getAccessibleContext().setAccessibleDescription(GenerateBeanInfoAction.getString("ACSD_BeanInfoEditorDialog"));
    }

    private static FileObject findFileObject(Node n) {
        DataObject dobj = (DataObject)n.getCookie(DataObject.class);
        return dobj != null ? dobj.getPrimaryFile() : null;
    }

    static String getString(String key) {
        return NbBundle.getBundle((String)"org.netbeans.modules.beans.beaninfo.Bundle").getString(key);
    }

    static final class BeanInfoWorker
    implements Runnable,
    org.netbeans.api.java.source.Task<CompilationController> {
        private final BiPanel biPanel;
        private final FileObject javaFile;
        private boolean isCancelled = false;
        private Node biNode;
        private BiAnalyser bia;
        private RequestProcessor.Task task;
        private int state = 0;
        private NotifyDescriptor error;

        public BeanInfoWorker(FileObject javaFile, BiPanel biPanel) {
            this.javaFile = javaFile;
            this.biPanel = biPanel;
        }

        public RequestProcessor.Task analyzePatterns() {
            this.checkState(0);
            this.task = RequestProcessor.getDefault().post((Runnable)this);
            return this.task;
        }

        public void updateUI() {
            this.waitFinished();
            this.checkState(1);
            this.state = 2;
            EventQueue.invokeLater(this);
        }

        public void generateSources() {
            this.waitFinished();
            this.checkState(2);
            this.state = 3;
            try {
                this.run();
            }
            finally {
                this.state = 2;
            }
        }

        public boolean isCancelled() {
            return this.isCancelled;
        }

        public void waitFinished() {
            if (this.task == null) {
                throw new IllegalStateException();
            }
            this.task.waitFinished();
        }

        public boolean isModelModified() {
            this.waitFinished();
            return this.bia != null ? this.bia.isModified() : false;
        }

        @Override
        public void run() {
            if (this.isCancelled) {
                return;
            }
            switch (this.state) {
                case 0: {
                    this.analyzePatternsImpl();
                    break;
                }
                case 2: {
                    this.fillBiPanel();
                    break;
                }
                case 3: {
                    this.generateSourcesImpl();
                }
            }
        }

        public void run(CompilationController javac) throws Exception {
            if (this.isCancelled) {
                return;
            }
            javac.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
            switch (this.state) {
                case 1: {
                    this.analyzePatternsImpl((CompilationInfo)javac);
                }
            }
        }

        private void analyzePatternsImpl(CompilationInfo javac) {
            this.checkState(1);
            String clsname = this.javaFile.getName();
            TypeElement clselm = null;
            for (TypeElement top : javac.getTopLevelElements()) {
                if (!clsname.contentEquals(top.getSimpleName())) continue;
                clselm = top;
            }
            if (clselm == null) {
                this.isCancelled = true;
                this.error = new NotifyDescriptor.Message((Object)NbBundle.getMessage(GenerateBeanInfoAction.class, (String)"MSG_FileWitoutTopLevelClass", (Object)clsname, (Object)FileUtil.getFileDisplayName((FileObject)this.javaFile)), 0);
                return;
            }
            PatternAnalyser pa = new PatternAnalyser(this.javaFile, null, true);
            pa.analyzeAll(javac, clselm);
            try {
                this.bia = new BiAnalyser(pa, javac);
            }
            catch (Exception ex) {
                this.isCancelled = true;
                Exceptions.printStackTrace((Throwable)ex);
            }
        }

        private void analyzePatternsImpl() {
            if (this.javaFile == null) {
                this.isCancelled = true;
                return;
            }
            this.checkState(0);
            this.state = 1;
            try {
                JavaSource.forFileObject((FileObject)this.javaFile).runUserActionTask((org.netbeans.api.java.source.Task)this, true);
            }
            catch (Exception ex) {
                this.isCancelled = true;
                Exceptions.printStackTrace((Throwable)ex);
            }
        }

        private void fillBiPanel() {
            this.biNode = BiNode.createBiNode(this.bia, this.error);
            this.biPanel.setContext(this.biNode);
            this.biPanel.expandAll();
        }

        private void generateSourcesImpl() {
            if (!this.isCancelled() && this.bia != null && !this.bia.isBeanBroken()) {
                this.bia.regenerateSource();
            }
        }

        private void checkState(int expected) {
            if (this.state != expected) {
                throw new IllegalStateException();
            }
        }
    }
}

