/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.nette2.utils;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.util.EnumSet;
import java.util.Enumeration;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public final class FileUtils {
    private static final Logger LOGGER = Logger.getLogger(FileUtils.class.getName());
    private static final Set<PosixFilePermission> PERMISSIONS_777 = EnumSet.allOf(PosixFilePermission.class);

    private FileUtils() {
    }

    public static FileObject getFile(JTextComponent textComponent) {
        assert (textComponent != null);
        return NbEditorUtilities.getFileObject((Document)textComponent.getDocument());
    }

    public static void chmod777Recursively(FileObject fileObject) {
        assert (fileObject != null);
        File file = FileUtil.toFile((FileObject)fileObject);
        if (file != null) {
            FileUtils.chmod777(file);
            Enumeration allNestedChildren = fileObject.getChildren(true);
            while (allNestedChildren.hasMoreElements()) {
                File child = FileUtil.toFile((FileObject)((FileObject)allNestedChildren.nextElement()));
                if (child == null) continue;
                FileUtils.chmod777(child);
            }
        }
    }

    private static void chmod777(File file) {
        assert (file != null);
        try {
            Files.setPosixFilePermissions(file.toPath(), PERMISSIONS_777);
        }
        catch (IOException | UnsupportedOperationException ex) {
            LOGGER.log(Level.FINE, null, ex);
        }
    }

    public static void copyDirectory(File sourceDirectory, File destinationDirectory) {
        assert (sourceDirectory != null);
        assert (destinationDirectory != null);
        try {
            Files.walkFileTree(sourceDirectory.toPath(), new CopyDirectoryVisitor(sourceDirectory.toPath(), destinationDirectory.toPath()));
        }
        catch (IOException ex) {
            LOGGER.log(Level.FINE, null, ex);
        }
    }

    private static final class CopyDirectoryVisitor
    extends SimpleFileVisitor<Path> {
        private final Path source;
        private final Path destination;

        CopyDirectoryVisitor(Path source, Path destination) {
            this.source = source;
            this.destination = destination;
        }

        @Override
        public FileVisitResult preVisitDirectory(Path directory, BasicFileAttributes attributes) throws IOException {
            Path targetPath = this.destination.resolve(this.source.relativize(directory));
            if (!Files.exists(targetPath, new LinkOption[0])) {
                Files.createDirectory(targetPath, new FileAttribute[0]);
            }
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attributes) throws IOException {
            Files.copy(file, this.destination.resolve(this.source.relativize(file)), StandardCopyOption.REPLACE_EXISTING);
            return FileVisitResult.CONTINUE;
        }
    }
}

