/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript2.editor.hints;

import com.oracle.js.parser.Token;
import com.oracle.js.parser.TokenType;
import com.oracle.js.parser.ir.AccessNode;
import com.oracle.js.parser.ir.BinaryNode;
import com.oracle.js.parser.ir.FunctionNode;
import com.oracle.js.parser.ir.visitor.NodeVisitor;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.swing.text.BadLocationException;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.modules.csl.api.Hint;
import org.netbeans.modules.csl.api.HintsProvider;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.api.Rule;
import org.netbeans.modules.javascript2.editor.JsPreferences;
import org.netbeans.modules.javascript2.editor.JsVersion;
import org.netbeans.modules.javascript2.editor.hints.Bundle;
import org.netbeans.modules.javascript2.editor.hints.EcmaLevelRule;
import org.netbeans.modules.javascript2.editor.hints.JsHintsProvider;
import org.netbeans.modules.javascript2.editor.hints.SwitchToEcmaXFix;
import org.netbeans.modules.javascript2.model.api.ModelUtils;
import org.netbeans.modules.javascript2.model.spi.PathNodeVisitor;
import org.netbeans.modules.javascript2.types.spi.ParserResult;
import org.openide.filesystems.FileObject;

public class OperatorRule
extends EcmaLevelRule {
    @Override
    void computeHints(JsHintsProvider.JsRuleContext context, List<Hint> hints, int offset, HintsProvider.HintsManager manager) throws BadLocationException {
        JsVersion version = JsPreferences.getECMAScriptVersion(FileOwnerQuery.getOwner((FileObject)context.getJsParserResult().getSnapshot().getSource().getFileObject()));
        OperatorVisitor visitor = new OperatorVisitor(version);
        visitor.process(context, hints);
    }

    private void addHint(JsHintsProvider.JsRuleContext context, List<Hint> hints, OffsetRange range, JsVersion requiredVersion) {
        this.addDocumenHint(context, hints, ModelUtils.documentOffsetRange((ParserResult)context.getJsParserResult(), (int)range.getStart(), (int)range.getEnd()), requiredVersion);
    }

    private void addDocumenHint(JsHintsProvider.JsRuleContext context, List<Hint> hints, OffsetRange range, JsVersion requiredVersion) {
        String description;
        List<Object> fixes;
        if (requiredVersion != null) {
            fixes = Collections.singletonList(new SwitchToEcmaXFix(context.getJsParserResult().getSnapshot(), requiredVersion));
            description = Bundle.OperatorDescDetail((Object)requiredVersion);
        } else {
            fixes = Collections.emptyList();
            description = Bundle.OperatorDesc();
        }
        hints.add(new Hint((Rule)this, description, context.getJsParserResult().getSnapshot().getSource().getFileObject(), range, fixes, 600));
    }

    public Set<?> getKinds() {
        return Collections.singleton("js.other.hints");
    }

    public String getId() {
        return "operator.hint";
    }

    public String getDescription() {
        return Bundle.OperatorDesc();
    }

    public String getDisplayName() {
        return Bundle.OperatorDisplayName();
    }

    private class OperatorVisitor
    extends PathNodeVisitor {
        private final JsVersion targetVersion;
        private List<Hint> hints;
        private JsHintsProvider.JsRuleContext context;

        public OperatorVisitor(JsVersion targetVersion) {
            this.targetVersion = targetVersion;
        }

        public void process(JsHintsProvider.JsRuleContext context, List<Hint> hints) {
            this.hints = hints;
            this.context = context;
            FunctionNode root = context.getJsParserResult().getRoot();
            if (root != null) {
                context.getJsParserResult().getRoot().accept((NodeVisitor)this);
            }
        }

        public boolean enterBinaryNode(BinaryNode binaryNode) {
            if (!binaryNode.tokenType().isSupported(this.targetVersion.getEcmascriptEdition())) {
                JsVersion requiredVersion = JsVersion.fromEcmascriptEdition(binaryNode.tokenType().getEcmascriptEdition());
                OperatorRule.this.addHint(this.context, this.hints, new OffsetRange(binaryNode.getStart(), binaryNode.getFinish()), requiredVersion);
            }
            return super.enterBinaryNode(binaryNode);
        }

        public boolean enterAccessNode(AccessNode accessNode) {
            TokenType tt = Token.descType((long)accessNode.getToken());
            if (!tt.isSupported(this.targetVersion.getEcmascriptEdition())) {
                JsVersion requiredVersion = JsVersion.fromEcmascriptEdition(tt.getEcmascriptEdition());
                OperatorRule.this.addHint(this.context, this.hints, new OffsetRange(accessNode.getStart(), accessNode.getFinish()), requiredVersion);
            }
            return super.enterAccessNode(accessNode);
        }
    }
}

