/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.ui.logicalview;

import java.awt.Image;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Action;
import javax.swing.ImageIcon;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.php.project.PhpProject;
import org.netbeans.modules.php.project.ProjectPropertiesSupport;
import org.netbeans.modules.php.project.api.PhpSourcePath;
import org.netbeans.modules.php.project.ui.Utils;
import org.netbeans.modules.php.project.ui.logicalview.Nodes;
import org.netbeans.modules.php.project.ui.logicalview.PhpLogicalViewProvider;
import org.netbeans.spi.project.ui.support.NodeFactory;
import org.netbeans.spi.project.ui.support.NodeFactorySupport;
import org.netbeans.spi.project.ui.support.NodeList;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.ChildFactory;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.ImageUtilities;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;

public class IncludePathNodeFactory
implements NodeFactory {
    public NodeList<?> createNodes(Project p) {
        final PhpProject project = (PhpProject)p.getLookup().lookup(PhpProject.class);
        return NodeFactorySupport.fixedNodeList((Node[])new Node[]{new Nodes.DummyNode(this, (Node)new IncludePathRootNode(project, new IncludePathChildFactory(project))){
            final /* synthetic */ IncludePathNodeFactory this$0;
            {
                this.this$0 = this$0;
                super(original);
            }

            @Override
            public Action[] getActions(boolean context) {
                return new Action[]{new PhpLogicalViewProvider.CustomizeProjectAction(project, "PhpIncludePath")};
            }
        }});
    }

    private static class IncludePathRootNode
    extends AbstractNode
    implements PropertyChangeListener {
        private final PhpProject project;
        private final IncludePathChildFactory childFactory;

        public IncludePathRootNode(PhpProject project, IncludePathChildFactory childFactory) {
            super(Children.create((ChildFactory)childFactory, (boolean)true));
            this.project = project;
            this.childFactory = childFactory;
            ProjectPropertiesSupport.addWeakPropertyEvaluatorListener(project, this);
        }

        public String getDisplayName() {
            return NbBundle.getMessage(IncludePathNodeFactory.class, (String)"LBL_IncludePath");
        }

        public Image getIcon(int type) {
            return this.getIcon(true);
        }

        public Image getOpenedIcon(int type) {
            return this.getIcon(false);
        }

        private Image getIcon(boolean opened) {
            return Utils.getIncludePathIcon(opened);
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            this.childFactory.refresh();
        }
    }

    private static class IncludePathChildFactory
    extends Nodes.FileChildFactory {
        public IncludePathChildFactory(PhpProject project) {
            super(project);
        }

        @Override
        protected List<Node> getNodes() {
            ArrayList<Node> list = new ArrayList<Node>();
            List includePath = (List)ProjectManager.mutex().readAccess((Mutex.Action)new Mutex.Action<List<FileObject>>(){

                public List<FileObject> run() {
                    return PhpSourcePath.getIncludePath(project.getProjectDirectory());
                }
            });
            for (FileObject fileObject : includePath) {
                if (fileObject == null || !fileObject.isFolder()) continue;
                DataFolder df = DataFolder.findFolder((FileObject)fileObject);
                list.add((Node)new IncludePathNode((DataObject)df, this.project));
            }
            return list;
        }

        public void refresh() {
            this.refresh(false);
        }
    }

    private static class IncludePathNode
    extends Nodes.FileNode {
        private static final String ICON_PATH = "org/netbeans/modules/php/project/ui/resources/libraries.gif";
        private static final ImageIcon ICON = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/php/project/ui/resources/libraries.gif", (boolean)false);

        public IncludePathNode(DataObject dobj, PhpProject project) {
            super(dobj, project);
        }

        public Image getIcon(int type) {
            return ICON.getImage();
        }

        public Image getOpenedIcon(int type) {
            return this.getIcon(type);
        }
    }
}

