/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.wizards.targetpanel.providers;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.apache.xerces.util.XMLChar;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.target.iterator.api.BrowseFolders;
import org.netbeans.modules.target.iterator.api.TargetChooserPanel;
import org.netbeans.modules.target.iterator.api.TargetChooserPanelGUI;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.modules.web.core.Util;
import org.netbeans.modules.web.taglib.TLDDataObject;
import org.netbeans.modules.web.wizards.FileType;
import org.netbeans.modules.web.wizards.targetpanel.providers.TagTargetPanelProvider;
import org.netbeans.modules.web.wizards.targetpanel.providers.XmlOptionPanelManager;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.util.NbBundle;
import org.xml.sax.SAXException;

class TagUIManager
extends XmlOptionPanelManager {
    private static final String TAG_FILE_IN_JAVALIB_FOLDER = "META-INF/tags";
    private static final String TAG_FILE_FOLDER = "tags";
    private static final Logger LOG = Logger.getLogger(TagUIManager.class.getName());
    private JCheckBox myTldCheckBox;
    private JTextField myTldTextField;
    private JButton myBrowseButton;
    private JTextField myTagNameTextField;
    private String myTagName;
    private FileObject myTldFileObject;
    private Set<?> myTagValues;
    boolean isTagFileValid = true;

    TagUIManager() {
    }

    @Override
    public void initComponents(JPanel mainPanel, TargetChooserPanel<FileType> panel, final TargetChooserPanelGUI<FileType> uiPanel) {
        super.initComponents(mainPanel, panel, uiPanel);
        uiPanel.setNameLabel(NbBundle.getMessage(TagTargetPanelProvider.class, (String)"LBL_TagFileName"));
        this.getJspSyntaxButton().setText(NbBundle.getMessage(TagTargetPanelProvider.class, (String)"OPT_TagFileJsp"));
        this.getJspSyntaxButton().getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(TagTargetPanelProvider.class, (String)"DESC_TagFile"));
        this.getXmlSyntaxButton().setText(NbBundle.getMessage(TagTargetPanelProvider.class, (String)"OPT_TagFileXml"));
        this.getXmlSyntaxButton().getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(TagTargetPanelProvider.class, (String)"DESC_TagFileXml"));
        this.getSegmentBox().setText(NbBundle.getMessage(TagTargetPanelProvider.class, (String)"OPT_TagFileSegment"));
        this.getSegmentBox().getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(TagTargetPanelProvider.class, (String)"A11Y_DESC_TagFile_segment"));
        this.getDescription().setText(NbBundle.getMessage(TagTargetPanelProvider.class, (String)"DESC_TagFile"));
        uiPanel.addLocationListener(new ActionListener(){
            final /* synthetic */ TagUIManager this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                uiPanel.changedUpdate(null);
            }
        });
    }

    @Override
    protected int doInitComponents(JPanel mainPanel, final TargetChooserPanel<FileType> panel, final TargetChooserPanelGUI<FileType> uiPanel) {
        int gridy = super.doInitComponents(mainPanel, panel, uiPanel);
        this.myTldCheckBox = new JCheckBox();
        this.myTldCheckBox.setMnemonic(NbBundle.getMessage(TagTargetPanelProvider.class, (String)"A11Y_AddToTLD_mnem").charAt(0));
        this.myTldCheckBox.setText(NbBundle.getMessage(TagTargetPanelProvider.class, (String)"OPT_addTagFileToTLD"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 0, 2, 0);
        mainPanel.add((Component)this.myTldCheckBox, gridBagConstraints);
        this.myTldCheckBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(TagTargetPanelProvider.class, (String)"OPT_addToTLD"));
        JLabel tldFileLabel = new JLabel();
        tldFileLabel.setDisplayedMnemonic(NbBundle.getMessage(TagTargetPanelProvider.class, (String)"A11Y_TLDName_mnem").charAt(0));
        tldFileLabel.setText(NbBundle.getMessage(TagTargetPanelProvider.class, (String)"LBL_tldFile"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        mainPanel.add((Component)tldFileLabel, gridBagConstraints);
        this.myTldTextField = new JTextField();
        this.myTldTextField.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(0, 12, 0, 0);
        mainPanel.add((Component)this.myTldTextField, gridBagConstraints);
        this.myTldTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(TagTargetPanelProvider.class, (String)"A11Y_DESC_TLDFile"));
        tldFileLabel.setLabelFor(this.myTldTextField);
        this.myBrowseButton = new JButton();
        this.myBrowseButton.setMnemonic(NbBundle.getMessage(TagTargetPanelProvider.class, (String)"LBL_Browse1_Mnemonic").charAt(0));
        this.myBrowseButton.setText(NbBundle.getMessage(TagTargetPanelProvider.class, (String)"LBL_Browse"));
        this.myBrowseButton.addActionListener(new ActionListener(){
            final /* synthetic */ TagUIManager this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.browse(evt, (TargetChooserPanel<FileType>)panel, (TargetChooserPanelGUI<FileType>)uiPanel);
            }
        });
        this.myBrowseButton.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 6, 0, 0);
        mainPanel.add((Component)this.myBrowseButton, gridBagConstraints);
        this.myBrowseButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(TagTargetPanelProvider.class, (String)"LBL_Browse"));
        this.myTldCheckBox.addItemListener(new ItemListener(){
            final /* synthetic */ TagUIManager this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void itemStateChanged(ItemEvent evt) {
                String name;
                this.this$0.myTagNameTextField.setEditable(this.this$0.myTldCheckBox.isSelected());
                this.this$0.myBrowseButton.setEnabled(this.this$0.myTldCheckBox.isSelected());
                if (this.this$0.myTldCheckBox.isSelected() && this.this$0.myTagName == null && (name = uiPanel.getDocumentName()).length() > 0) {
                    this.this$0.myTagNameTextField.setText(name);
                    this.this$0.myTagName = name;
                }
                panel.fireChange();
            }
        });
        JLabel tagNameLabel = new JLabel();
        tagNameLabel.setDisplayedMnemonic(NbBundle.getMessage(TagTargetPanelProvider.class, (String)"A11Y_TagName_mnem").charAt(0));
        tagNameLabel.setText(NbBundle.getMessage(TagTargetPanelProvider.class, (String)"LBL_tagName"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        mainPanel.add((Component)tagNameLabel, gridBagConstraints);
        this.myTagNameTextField = new JTextField();
        this.myTagNameTextField.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(6, 12, 0, 0);
        mainPanel.add((Component)this.myTagNameTextField, gridBagConstraints);
        this.myTagNameTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(TagTargetPanelProvider.class, (String)"A11Y_DESC_TagName"));
        tagNameLabel.setLabelFor(this.myTagNameTextField);
        this.myTagNameTextField.addKeyListener(new KeyAdapter(this){
            final /* synthetic */ TagUIManager this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void keyReleased(KeyEvent evt) {
                this.this$0.myTagName = this.this$0.myTagNameTextField.getText().trim();
                panel.fireChange();
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        mainPanel.add((Component)new JPanel(), gridBagConstraints);
        return gridy;
    }

    @Override
    protected int initSyntaxButton(int grid, TargetChooserPanel<FileType> panel, TargetChooserPanelGUI<FileType> uiPanel) {
        int result = super.initSyntaxButton(grid, panel, uiPanel);
        this.getJspSyntaxButton().setMnemonic(NbBundle.getMessage(TagTargetPanelProvider.class, (String)"A11Y_TagStandard_mnem").charAt(0));
        return result;
    }

    public String getAccessibleDescription() {
        return "tag_file";
    }

    public String getErrorMessage(TargetChooserPanel<FileType> panel) {
        this.isTagFileValid = true;
        if (this.getWebModule() != null) {
            boolean isWebInfLocation = panel.getComponent().getSelectedFolder().equals("WEB-INF");
            if (!(panel.getComponent().getNormalizedFolder().startsWith("WEB-INF/tags") || panel.getComponent().getNormalizedFolder().startsWith(TAG_FILE_FOLDER) && isWebInfLocation)) {
                this.isTagFileValid = false;
                return NbBundle.getMessage(TagTargetPanelProvider.class, (String)"MSG_TagFile");
            }
        } else if (!panel.getComponent().getNormalizedFolder().startsWith(TAG_FILE_IN_JAVALIB_FOLDER)) {
            this.isTagFileValid = false;
            return NbBundle.getMessage(TagTargetPanelProvider.class, (String)"MSG_TagFileInJavalib");
        }
        return null;
    }

    @Override
    public void initFolderValue(TargetChooserPanel<FileType> panel, String target, JTextField field) {
        if (this.getWebModule() != null) {
            boolean isWebInfLocation = panel.getComponent().getSelectedFolder().equals("WEB-INF");
            String folder = "";
            if (!isWebInfLocation) {
                folder = "WEB-INF/";
            }
            if (target == null || !target.startsWith(folder + TAG_FILE_FOLDER)) {
                field.setText(folder + TAG_FILE_FOLDER + "/");
            } else {
                field.setText(target);
            }
        } else if (target == null || !target.startsWith(TAG_FILE_IN_JAVALIB_FOLDER)) {
            field.setText("META-INF/tags/");
        } else {
            field.setText(target);
        }
    }

    public boolean isPanelValid() {
        return this.isTagFileValid;
    }

    @Override
    protected void checkBoxChanged(ItemEvent evt, TargetChooserPanel<FileType> panel, TargetChooserPanelGUI<FileType> uiPanel) {
        if (this.isSegment()) {
            if (this.isXml()) {
                this.getDescription().setText(NbBundle.getMessage(TagTargetPanelProvider.class, (String)"DESC_TagFileSegmentXml"));
            } else {
                this.getDescription().setText(NbBundle.getMessage(TagTargetPanelProvider.class, (String)"DESC_TagFileSegment"));
            }
            String createdFile = uiPanel.getFile();
            if (createdFile.endsWith("tagx")) {
                uiPanel.setFile(createdFile.substring(0, createdFile.length() - 1) + "f");
            } else if (createdFile.endsWith("tag")) {
                uiPanel.setFile(createdFile + "f");
            }
        } else {
            String createdFile = uiPanel.getFile();
            if (this.isXml()) {
                this.getDescription().setText(NbBundle.getMessage(TagTargetPanelProvider.class, (String)"DESC_TagFileXml"));
                if (createdFile.endsWith("tagf")) {
                    uiPanel.setFile(createdFile.substring(0, createdFile.length() - 1) + "x");
                } else if (createdFile.endsWith("tag")) {
                    uiPanel.setFile(createdFile + "x");
                }
            } else {
                this.getDescription().setText(NbBundle.getMessage(TagTargetPanelProvider.class, (String)"DESC_TagFile"));
                if (createdFile.endsWith("tagf") || createdFile.endsWith("tagx")) {
                    uiPanel.setFile(createdFile.substring(0, createdFile.length() - 1));
                }
            }
        }
        panel.fireChange();
    }

    String getTagName() {
        return this.myTagName;
    }

    FileObject getTldFileObject() {
        return this.myTldFileObject;
    }

    boolean isTldCheckBoxSelected() {
        return this.myTldCheckBox.isSelected();
    }

    boolean tagNameExists(String name) {
        return this.myTagValues != null && this.myTagValues.contains(name);
    }

    boolean isValidTagName(String name) {
        if (name == null) {
            return false;
        }
        return XMLChar.isValidNCName((String)name);
    }

    boolean isTagNameEmpty(String name) {
        if (name == null) {
            return true;
        }
        return "".equals(name);
    }

    private void browse(ActionEvent evt, TargetChooserPanel<FileType> panel, TargetChooserPanelGUI<FileType> uiPanel) {
        FileObject fo = null;
        if (panel.getSourceGroups() != null) {
            fo = BrowseFolders.showDialog((SourceGroup[])panel.getSourceGroups(), TLDDataObject.class, (String)uiPanel.getFolder().replace(File.separatorChar, '/'));
        } else {
            Sources sources = ProjectUtils.getSources((Project)panel.getProject());
            fo = BrowseFolders.showDialog((SourceGroup[])sources.getSourceGroups("generic"), DataFolder.class, (String)uiPanel.getFolder().replace(File.separatorChar, '/'));
        }
        if (fo != null) {
            this.myTldFileObject = fo;
            FileObject targetFolder = Templates.getTargetFolder((WizardDescriptor)panel.getTemplateWizard());
            WebModule wm = targetFolder == null ? null : WebModule.getWebModule((FileObject)targetFolder);
            this.myTldTextField.setText(FileUtil.getRelativePath((FileObject)(wm == null ? panel.getProject().getProjectDirectory() : wm.getDocumentBase()), (FileObject)fo));
            try {
                InputStream is = this.myTldFileObject.getInputStream();
                this.myTagValues = Util.getTagValues(is, new String[]{"tag", "tag-file"}, "name");
                is.close();
            }
            catch (IOException ex) {
                LOG.log(Level.FINE, "error", ex);
            }
            catch (SAXException ex) {
                LOG.log(Level.FINE, "error", ex);
            }
            panel.fireChange();
        }
    }
}

