/*
 * Decompiled with CFR 0.152.
 */
package mediathek.gui.tabs.tab_film.filter.zeitraum;

import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import mediathek.gui.tabs.tab_film.filter.zeitraum.ZeitraumSpinnerFormatterFactory;
import mediathek.tool.FilterConfiguration;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class ZeitraumSpinner
extends JSpinner {
    private static Logger logger;

    private static Logger getLogger() {
        if (logger == null) {
            logger = LogManager.getLogger(ZeitraumSpinner.class);
        }
        return logger;
    }

    public ZeitraumSpinner() {
        super(new SpinnerNumberModel(0, 0, 365, 1));
        ((JSpinner.DefaultEditor)this.getEditor()).getTextField().setFormatterFactory(new ZeitraumSpinnerFormatterFactory());
    }

    public void restoreFilterConfig(@NotNull FilterConfiguration filterConfiguration) throws NumberFormatException {
        String zeitraumVal = filterConfiguration.getZeitraum();
        try {
            int zeitraumValInt = zeitraumVal.equals("\u221e") ? 0 : Integer.parseInt(zeitraumVal);
            this.setValue(zeitraumValInt);
        }
        catch (NumberFormatException ex) {
            ZeitraumSpinner.getLogger().error("Failed to parse zeitraum value: {}", (Object)zeitraumVal, (Object)ex);
            ZeitraumSpinner.getLogger().error("Using default value: {}", (Object)0);
            this.setValue(0);
            filterConfiguration.setZeitraum("\u221e");
        }
    }

    public void installFilterConfigurationChangeListener(@NotNull FilterConfiguration filterConfiguration) {
        this.addChangeListener(l -> {
            int val = (Integer)this.getValue();
            String strVal = val == 0 ? "\u221e" : String.valueOf(val);
            filterConfiguration.setZeitraum(strVal);
        });
    }
}

