/*++

Copyright (C) 2024 3MF Consortium (Original Author)

All rights reserved.

Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

1. Redistributions of source code must retain the above copyright notice, this
list of conditions and the following disclaimer.
2. Redistributions in binary form must reproduce the above copyright notice,
this list of conditions and the following disclaimer in the documentation
and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

This file has been generated by the Automatic Component Toolkit (ACT) version 1.8.1-develop.

Abstract: This is an autogenerated Java file in order to allow an easy
 use of the 3MF Library

Interface version: 2.5.0

*/

package lib3mf;

import com.sun.jna.Library;
import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import java.lang.ref.Cleaner;


import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;

public class ComponentsObject extends Object {

	public ComponentsObject(Lib3MFWrapper wrapper, Pointer handle) {
		super(wrapper, handle);
	}

	/**
	 * Adds a new component to a components object.
	 *
	 * @param objectResource object to add as component. Must not lead to circular references!
	 * @param transform optional transform matrix for the component.
	 * @return new component instance
	 * @throws Lib3MFException
	 */
	public Component addComponent(Object objectResource, Transform transform) throws Lib3MFException {
		Pointer objectResourceHandle = null;
		if (objectResource != null) {
			objectResourceHandle = objectResource.getHandle();
		} else {
			throw new Lib3MFException(Lib3MFException.LIB3MF_ERROR_INVALIDPARAM, "ObjectResource is a null value.");
		}
		Pointer bufferTransform = new Memory(Transform.SIZE);
		transform.writeToPointer(bufferTransform, 0);
		Pointer bufferComponentInstance = new Memory(8);
		mWrapper.checkError(this, mWrapper.lib3mf_componentsobject_addcomponent.invokeInt(new java.lang.Object[]{mHandle, objectResourceHandle, bufferTransform, bufferComponentInstance}));
		Pointer valueComponentInstance = bufferComponentInstance.getPointer(0);
		Component componentInstance = null;
		if (valueComponentInstance == Pointer.NULL) {
		  throw new Lib3MFException(Lib3MFException.LIB3MF_ERROR_INVALIDPARAM, "ComponentInstance was a null pointer");
		}
		componentInstance = mWrapper.PolymorphicFactory(valueComponentInstance, Component.class);
		return componentInstance;
	}

	/**
	 * Retrieves a component from a component object.
	 *
	 * @param index index of the component to retrieve (0 to componentcount - 1)
	 * @return component instance
	 * @throws Lib3MFException
	 */
	public Component getComponent(int index) throws Lib3MFException {
		Pointer bufferComponentInstance = new Memory(8);
		mWrapper.checkError(this, mWrapper.lib3mf_componentsobject_getcomponent.invokeInt(new java.lang.Object[]{mHandle, index, bufferComponentInstance}));
		Pointer valueComponentInstance = bufferComponentInstance.getPointer(0);
		Component componentInstance = null;
		if (valueComponentInstance == Pointer.NULL) {
		  throw new Lib3MFException(Lib3MFException.LIB3MF_ERROR_INVALIDPARAM, "ComponentInstance was a null pointer");
		}
		componentInstance = mWrapper.PolymorphicFactory(valueComponentInstance, Component.class);
		return componentInstance;
	}

	/**
	 * Retrieves a component count of a component object.
	 *
	 * @return returns the component count
	 * @throws Lib3MFException
	 */
	public int getComponentCount() throws Lib3MFException {
		Pointer bufferCount = new Memory(4);
		mWrapper.checkError(this, mWrapper.lib3mf_componentsobject_getcomponentcount.invokeInt(new java.lang.Object[]{mHandle, bufferCount}));
		return bufferCount.getInt(0);
	}


}

