/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.consumer;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.kafka.clients.consumer.ConsumerGroupMetadata;
import org.apache.kafka.common.Cluster;
import org.apache.kafka.common.Configurable;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.utils.Utils;

public interface ConsumerPartitionAssignor {
    default public ByteBuffer subscriptionUserData(Set<String> topics) {
        return null;
    }

    public GroupAssignment assign(Cluster var1, GroupSubscription var2);

    default public void onAssignment(Assignment assignment, ConsumerGroupMetadata metadata) {
    }

    default public List<RebalanceProtocol> supportedProtocols() {
        return Collections.singletonList(RebalanceProtocol.EAGER);
    }

    default public short version() {
        return 0;
    }

    public String name();

    /*
     * WARNING - void declaration
     */
    public static List<ConsumerPartitionAssignor> getAssignorInstances(List<String> assignorClasses, Map<String, Object> configs) {
        ArrayList<ConsumerPartitionAssignor> assignors = new ArrayList<ConsumerPartitionAssignor>();
        HashMap<String, String> assignorNameMap = new HashMap<String, String>();
        for (String string : assignorClasses) {
            void var5_5;
            if (string instanceof String) {
                try {
                    Class<Object> clazz = Utils.loadClass(string, Object.class);
                }
                catch (ClassNotFoundException classNotFound) {
                    throw new KafkaException(String.valueOf(string) + " ClassNotFoundException exception occurred", classNotFound);
                }
            }
            if (var5_5 instanceof Class) {
                Object assignor = Utils.newInstance((Class)var5_5);
                if (assignor instanceof Configurable) {
                    ((Configurable)assignor).configure(configs);
                }
                if (assignor instanceof ConsumerPartitionAssignor) {
                    String assignorName = ((ConsumerPartitionAssignor)assignor).name();
                    if (assignorNameMap.containsKey(assignorName)) {
                        throw new KafkaException("The assignor name: '" + assignorName + "' is used in more than one assignor: " + (String)assignorNameMap.get(assignorName) + ", " + assignor.getClass().getName());
                    }
                    assignorNameMap.put(assignorName, assignor.getClass().getName());
                    assignors.add((ConsumerPartitionAssignor)assignor);
                    continue;
                }
                throw new KafkaException(String.valueOf(var5_5) + " is not an instance of " + ConsumerPartitionAssignor.class.getName());
            }
            throw new KafkaException("List contains element of type " + var5_5.getClass().getName() + ", expected String or Class");
        }
        return assignors;
    }

    public static enum RebalanceProtocol {
        EAGER(0),
        COOPERATIVE(1);

        private final byte id;

        private RebalanceProtocol(byte id) {
            this.id = id;
        }

        public byte id() {
            return this.id;
        }

        public static RebalanceProtocol forId(byte id) {
            switch (id) {
                case 0: {
                    return EAGER;
                }
                case 1: {
                    return COOPERATIVE;
                }
            }
            throw new IllegalArgumentException("Unknown rebalance protocol id: " + id);
        }
    }

    public static final class GroupAssignment {
        private final Map<String, Assignment> assignments;

        public GroupAssignment(Map<String, Assignment> assignments) {
            this.assignments = assignments;
        }

        public Map<String, Assignment> groupAssignment() {
            return this.assignments;
        }

        public String toString() {
            return "GroupAssignment(assignments=" + String.valueOf(this.assignments) + ")";
        }
    }

    public static final class GroupSubscription {
        private final Map<String, Subscription> subscriptions;

        public GroupSubscription(Map<String, Subscription> subscriptions) {
            this.subscriptions = subscriptions;
        }

        public Map<String, Subscription> groupSubscription() {
            return this.subscriptions;
        }

        public String toString() {
            return "GroupSubscription(subscriptions=" + String.valueOf(this.subscriptions) + ")";
        }
    }

    public static final class Assignment {
        private final List<TopicPartition> partitions;
        private final ByteBuffer userData;

        public Assignment(List<TopicPartition> partitions, ByteBuffer userData) {
            this.partitions = partitions;
            this.userData = userData;
        }

        public Assignment(List<TopicPartition> partitions) {
            this(partitions, null);
        }

        public List<TopicPartition> partitions() {
            return this.partitions;
        }

        public ByteBuffer userData() {
            return this.userData;
        }

        public String toString() {
            return "Assignment(partitions=" + String.valueOf(this.partitions) + (String)(this.userData == null ? "" : ", userDataSize=" + this.userData.remaining()) + ")";
        }
    }

    public static final class Subscription {
        private final List<String> topics;
        private final ByteBuffer userData;
        private final List<TopicPartition> ownedPartitions;
        private final Optional<String> rackId;
        private Optional<String> groupInstanceId;
        private final Optional<Integer> generationId;

        public Subscription(List<String> topics, ByteBuffer userData, List<TopicPartition> ownedPartitions, int generationId, Optional<String> rackId) {
            this.topics = topics;
            this.userData = userData;
            this.ownedPartitions = ownedPartitions;
            this.groupInstanceId = Optional.empty();
            this.generationId = generationId < 0 ? Optional.empty() : Optional.of(generationId);
            this.rackId = rackId;
        }

        public Subscription(List<String> topics, ByteBuffer userData, List<TopicPartition> ownedPartitions) {
            this(topics, userData, ownedPartitions, -1, Optional.empty());
        }

        public Subscription(List<String> topics, ByteBuffer userData) {
            this(topics, userData, Collections.emptyList(), -1, Optional.empty());
        }

        public Subscription(List<String> topics) {
            this(topics, null, Collections.emptyList(), -1, Optional.empty());
        }

        public List<String> topics() {
            return this.topics;
        }

        public ByteBuffer userData() {
            return this.userData;
        }

        public List<TopicPartition> ownedPartitions() {
            return this.ownedPartitions;
        }

        public Optional<String> rackId() {
            return this.rackId;
        }

        public void setGroupInstanceId(Optional<String> groupInstanceId) {
            this.groupInstanceId = groupInstanceId;
        }

        public Optional<String> groupInstanceId() {
            return this.groupInstanceId;
        }

        public Optional<Integer> generationId() {
            return this.generationId;
        }

        public String toString() {
            return "Subscription(topics=" + String.valueOf(this.topics) + (String)(this.userData == null ? "" : ", userDataSize=" + this.userData.remaining()) + ", ownedPartitions=" + String.valueOf(this.ownedPartitions) + ", groupInstanceId=" + this.groupInstanceId.map(String::toString).orElse("null") + ", generationId=" + String.valueOf(this.generationId.orElse(-1)) + ", rackId=" + this.rackId.orElse("null") + ")";
        }
    }
}

