/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.runtime.rest.entities;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;

public class WorkerStatus {
    private static final WorkerStatus HEALTHY = new WorkerStatus("healthy", "Worker has completed startup and is ready to handle requests.");
    private final String status;
    private final String message;

    @JsonCreator
    private WorkerStatus(@JsonProperty(value="status") String status, @JsonProperty(value="message") String message) {
        this.status = status;
        this.message = message;
    }

    public static WorkerStatus healthy() {
        return HEALTHY;
    }

    public static WorkerStatus starting(String statusDetails) {
        Object message = "Worker is still starting up.";
        if (statusDetails != null) {
            message = (String)message + " " + statusDetails;
        }
        return new WorkerStatus("starting", (String)message);
    }

    public static WorkerStatus unhealthy(String statusDetails) {
        Object message = "Worker was unable to handle this request and may be unable to handle other requests.";
        if (statusDetails != null) {
            message = (String)message + " " + statusDetails;
        }
        return new WorkerStatus("unhealthy", (String)message);
    }

    @JsonProperty
    public String status() {
        return this.status;
    }

    @JsonProperty
    public String message() {
        return this.message;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WorkerStatus that = (WorkerStatus)o;
        return Objects.equals(this.status, that.status) && Objects.equals(this.message, that.message);
    }

    public int hashCode() {
        return Objects.hash(this.status, this.message);
    }

    public String toString() {
        return "WorkerStatus{status='" + this.status + "', message='" + this.message + "'}";
    }
}

