/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.undo;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import tim.prune.App;
import tim.prune.I18nManager;
import tim.prune.undo.UndoStack;

public abstract class UndoRedoManager {
    private final App _app;
    private final JFrame _parentFrame;
    private JDialog _dialog = null;
    private JList<String> _actionList = null;
    private final String _tokenPrefix;

    protected UndoRedoManager(App app, JFrame jFrame, boolean bl) {
        this._app = app;
        this._parentFrame = jFrame;
        this._tokenPrefix = "dialog." + (bl ? "undo" : "redo") + ".";
    }

    public void show(UndoStack undoStack) {
        this._dialog = new JDialog(this._parentFrame, this.getText("title"), true);
        this._dialog.setLocationRelativeTo(this._parentFrame);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(3, 3));
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        jPanel.add((Component)new JLabel(String.valueOf(this.getText("pretext")) + ":"), "North");
        String[] stringArray = undoStack.getDescriptions().toArray(new String[0]);
        this._actionList = new JList<String>(stringArray);
        this._actionList.setSelectionMode(1);
        this._actionList.setSelectedIndex(0);
        this._actionList.addListSelectionListener(listSelectionEvent -> {
            if (this._actionList.getMinSelectionIndex() > 0) {
                this._actionList.setSelectionInterval(0, this._actionList.getMaxSelectionIndex());
            }
        });
        this._actionList.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 27) {
                    UndoRedoManager.this._dialog.dispose();
                }
            }
        });
        jPanel.add((Component)new JScrollPane(this._actionList), "Center");
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new FlowLayout(2));
        JButton jButton = new JButton(I18nManager.getText("button.ok"));
        jButton.addActionListener(actionEvent -> {
            this.undoRedoActions(this._app, this._actionList.getMaxSelectionIndex() + 1);
            this._dialog.dispose();
        });
        jPanel2.add(jButton);
        JButton jButton2 = new JButton(I18nManager.getText("button.cancel"));
        jButton2.addActionListener(actionEvent -> this._dialog.dispose());
        jPanel2.add(jButton2);
        jPanel.add((Component)jPanel2, "South");
        this._dialog.getContentPane().add(jPanel);
        this._dialog.pack();
        this._dialog.setVisible(true);
    }

    protected abstract void undoRedoActions(App var1, int var2);

    private String getText(String string) {
        return I18nManager.getText(String.valueOf(this._tokenPrefix) + string);
    }
}

