---
stage: Create
group: Code Review
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
description: プロジェクトに対する変更について提案、レビュー、コラボレーションします。
title: マージリクエスト
description: コードレビュー、コラボレーション、ブランチのマージ、コミット。
---

{{< details >}}

- プラン: Free、Premium、Ultimate
- 提供形態: GitLab.com、GitLab Self-Managed、GitLab Dedicated

{{< /details >}}

{{< history >}}

- GitLab 16.0で、サイドバーアクションメニューが[変更](https://gitlab.com/gitlab-org/gitlab/-/issues/373757)され、イシュー、インシデント、エピックのアクションも移動しました。
- GitLab 16.9で[一般提供](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/127001)になりました。機能フラグ`moved_mr_sidebar`は削除されました。

{{< /history >}}

マージリクエストは、チームがコードをレビューし、ディスカッションを行い、コードの変更を追跡するための一元的な場所を提供します。変更を加えた理由を説明するには、マージリクエストをイシューにリンクし、マージリクエストのマージ時にイシューを自動的にクローズします。

マージリクエストは、特定分野の専門家が提案された変更をレビューし、組織のセキュリティ要件が満たされていることを保証するのに役立ちます。開発プロセスの早い段階でマージリクエストを作成すると、チームはバグやコード品質の問題を把握する時間を確保できます。

マージリクエストを表示すると、以下が表示されます:

- リクエストの説明
- コードの変更とインラインコードレビュー
- CI/CDパイプラインに関する情報
- マージ可能性レポート
- コメント
- コミットのリスト

## マージリクエストを作成する {#create-a-merge-request}

[マージリクエストを作成する](creating_merge_requests.md)さまざまな方法を参照してください。

### マージリクエストテンプレートを使用する {#use-merge-request-templates}

マージリクエストを作成すると、GitLabは[説明テンプレート](../description_templates.md)の存在を確認して、マージリクエストにデータを追加します。GitLabは、1から5の順にこれらの場所を確認し、最初に見つかったテンプレートをマージリクエストに適用します:

| 名前 | プロジェクトUI<br>設定 | グループ<br>`default.md` | インスタンス<br>`default.md` | プロジェクト<br>`default.md` | テンプレートなし |
|:-----|:---------------------:|:---------------------:|:------------------------:|:-----------------------:|:-----------:|
| 標準コミットメッセージ | 1  |           2           |            3             |            4            |      5      |
| `Closes #1234`のようなイシューのクローズパターンを含むコミットメッセージ | 1 | 2 | 3 | 4 | 5 \* |
| `1234-example`のような[イシューIDで始まる](../repository/branches/_index.md#prefix-branch-names-with-a-number)ブランチ名 | 1 \* | 2 \* | 3 \* | 4 \* | 5 \* |

{{< alert type="note" >}}

アスタリスク（\*）が付いた項目は、[イシューのクローズパターン](../issues/managing_issues.md#closing-issues-automatically)も付け加えます。

{{< /alert >}}

## マージリクエストを表示する {#view-merge-requests}

プロジェクト、グループ、または自分のマージリクエストを表示できます。

{{< tabs >}}

{{< tab title="参加中" >}}

ホームページにすべてのマージリクエストを表示するには、<kbd>Shift</kbd> + <kbd>m</kbd>のキーボードショートカットを使用するか、次の手順に従います:

1. 左側のサイドバーで、**マージリクエスト**アイコンをクリックします。

または:

1. 左側のサイドバーで、**検索または移動先**を選択します。
1. ドロップダウンリストから、**マージリクエスト**を選択します。

{{< /tab >}}

{{< tab title="プロジェクト" >}}

プロジェクトのすべてのマージリクエストを表示するには:

1. 左側のサイドバーで、**検索または移動先**を選択して、プロジェクトを見つけます。
1. **コード** > **マージリクエスト**を選択します。

または、<kbd>キーボードショートカット</kbd>を使用するには、<kbd>g</kbd> \+ mキーを押します。

{{< /tab >}}

{{< tab title="グループ内のすべてのプロジェクト" >}}

グループ内のすべてのプロジェクトのマージリクエストを表示するには:

1. 左側のサイドバーで、**検索または移動先**を選択して、グループを見つけます。
1. **コード** > **マージリクエスト**を選択します。

グループにサブグループが含まれている場合、このビューにはサブグループプロジェクトからのマージリクエストも表示されます。

{{< /tab >}}

{{< tab title="ファイルの場合" >}}

リポジトリ内のファイルを表示した場合、GitLabは、現在のブランチを対象にしてファイルを変更するオープンマージリクエストの数を示すバッジを表示します。これにより、保留中の変更があるファイルを特定できます。

この機能の利用可否は、機能フラグによって制御されます。詳細については、[ファイルに対するオープンマージリクエストの表示](../repository/files/_index.md#view-open-merge-requests-for-a-file)を参照してください。

ファイルに対するオープンマージリクエストを表示するには:

1. 左側のサイドバーで、**検索または移動先**を選択して、プロジェクトを見つけます。
1. 表示したいファイルに移動します。
1. 画面の右上にあるファイル名の横で、{{< icon name="merge-request-open" >}} **オープン**マージリクエストの数を示す緑色のバッジを探します。
1. バッジを選択すると、過去30日間に作成されたオープンマージリクエストの一覧が表示されます。
1. リスト内のマージリクエストを選択すると、そのマージリクエストに移動します。

{{< /tab >}}

{{< /tabs >}}

## マージリクエストのリストをフィルタリングする {#filter-the-list-of-merge-requests}

{{< history >}}

- `source branch`によるフィルタリングは、GitLab 16.6で[導入](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/134555)されました。
- `merged by`によるフィルタリングは、GitLab 16.9で[導入](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/140002)されました。機能フラグ`mr_merge_user_filter`が有効になっている場合にのみ使用できます。
- GitLab 17.0で、`merged by`によるフィルタリングが[一般提供](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/142666)になりました。機能フラグ`mr_merge_user_filter`は削除されました。

{{< /history >}}

マージリクエストのリストをフィルタリングするには:

1. 左側のサイドバーで、**検索または移動先**を選択して、プロジェクトを見つけます。
1. **コード** > **マージリクエスト**を選択します。
1. マージリクエストのリストの上にある**結果を検索またはフィルタリング**を選択します。
1. ドロップダウンリストから、フィルタリングする属性を選択します。次に例を示します:
   - **By environment or deployment date**（環境またはデプロイ日）。
   - **ID**: フィルター`#30`を入力して、マージリクエスト30のみを返します。
   - ユーザーフィルター: 次のいずれかのフィルターを入力（またはドロップダウンリストから選択）して、ユーザーのリストを表示します:
     - **承認したユーザー**: ユーザーがすでに承認したマージリクエスト。PremiumおよびUltimateのみ。
     - **承認者**: このユーザーが承認する資格のあるマージリクエスト（詳細については、[コードオーナー](../codeowners/_index.md)を参照してください）。PremiumおよびUltimateのみ。
     - **マージしたユーザー**: このユーザーがマージしたマージリクエスト。
     - **レビュアー**: このユーザーがレビューしたマージリクエスト。
1. 属性のフィルタリングに使用する演算子を選択または入力します。次の演算子を使用できます:
   - `=`: 等しい
   - `!=`: 等しくない
1. 属性をフィルタリングするテキストを入力します。一部の属性は、**なし**または**任意**でフィルタリングできます。
1. このプロセスを繰り返して、論理`AND`で結合された、より多くの属性でフィルタリングします。
1. **ソート順**（降順の場合は{{< icon name="sort-lowest" >}}、昇順の場合は{{< icon name="sort-highest" >}}）を選択します。

### 環境またはデプロイ日別 {#by-environment-or-deployment-date}

デプロイデータ（環境や日付など）でマージリクエストをフィルタリングするには、次のいずれかを入力（またはドロップダウンリストから選択）します:

- 環境
- デプロイ前
- デプロイ後

{{< alert type="note" >}}

[早送りのマージ方法](methods/_index.md#fast-forward-merge)ではマージコミットが作成されないため、この方法を使用するプロジェクトは結果を返しません。

{{< /alert >}}

環境でフィルタリングする場合、選択できるすべての環境がドロップダウンリストに表示されます。

`Deployed before`（デプロイ前）または`Deployed after`（デプロイ後）でフィルタリングする場合:

- 日付は、（マージコミットによってトリガーされた）環境へのデプロイが正常に完了した時点を指します。
- デプロイ日は手動で入力する必要があります。
- デプロイ日の形式は`YYYY-MM-DD`です。日付と時刻の両方を指定する場合は、二重引用符（`"`）で囲みます（`"YYYY-MM-DD HH:MM"`）。

## マージリクエストに変更を加える {#add-changes-to-a-merge-request}

マージリクエストに変更を加える権限がある場合は、いくつかの方法で既存のマージリクエストに変更を加えることができます。これらの方法は、変更の複雑さと、開発環境へのアクセス権が必要かどうかに応じて異なります:

- [Web IDE](../web_ide/_index.md)で変更を編集するには、ブラウザで<kbd>.</kbd>キーのキーボードショートカットを使用します。複数のファイルを編集する場合、またはGitコマンドに慣れていない場合は、このブラウザベースの方法を使用します。Web IDEからテストを実行することはできません。
- ファイルを編集し、その後のテストを実行するためのすべての機能を備えた環境が必要な場合は、[Gitpodで変更を編集](../../../integration/gitpod.md#launch-ona-in-gitlab)します。Gitpodは、GitLab Development Kit（GDK） の実行をサポートしています。Onaを使用するには、ユーザーアカウントでOnaを有効にする必要があります。
- Gitおよびコマンドラインに精通している場合は、[コマンドラインから変更をプッシュ](../../../topics/git/commands.md)します。

## ユーザーをマージリクエストに割り当てる {#assign-a-user-to-a-merge-request}

マージリクエストをユーザーに割り当てるには、マージリクエストのテキストエリアで`/assign @user`クイックアクションを使用するか、次の手順に従います:

1. 左側のサイドバーで、**検索または移動先**を選択して、プロジェクトを見つけます。
1. **コード** > **マージリクエスト**を選択し、マージリクエストを見つけます。
1. 右側のサイドバーで、右側のサイドバーを展開して、**担当者**セクションを見つけます。
1. **編集**を選択します。
1. 割り当てるユーザーを検索し、ユーザーを選択します。GitLab Freeでは、マージリクエストごとに1人の担当者を許可しますが、GitLab PremiumおよびGitLab Ultimateでは、複数の担当者を許可します:

   ![マージリクエストサイドバーに表示された2人の担当者](img/merge_request_assignees_v16_0.png)

GitLabは、ユーザーの**アサインされたマージリクエスト**ページにマージリクエストを追加します。

## マージリクエストをマージする {#merge-a-merge-request}

マージリクエストのレビュープロセス中に、レビュアーは変更に関するフィードバックを提供します。レビュアーが変更に満足している場合は、一部のマージチェックが失敗していても[自動マージ](auto_merge.md)を有効にすることができます。すべてのマージチェックに合格すると、マージリクエストは自動的にマージされ、それ以上の操作は必要ありません。

デフォルトのマージ権限:

- デフォルトブランチ（通常は`main`）は保護されています。
- メンテナー以上のロールのみがデフォルトブランチにマージできます。
- デベロッパーは、保護されていないブランチをターゲットとする任意のマージリクエストをマージできます。

特定のマージリクエストをマージする権限があるかどうかを判断するために、GitLabは以下を確認します:

- プロジェクトでのロール（デベロッパー、メンテナー、オーナーなど）
- ターゲットブランチのブランチ保護

## マージリクエストをクローズする {#close-a-merge-request}

マージリクエストでの作業を完全に停止する場合は、[削除する](manage.md#delete-a-merge-request)のではなく、クローズしてください。

前提要件:

- マージリクエストの作成者または担当者である必要があります。または
- プロジェクトのデベロッパー、メンテナー、またはオーナーのロールを持っている必要があります。

プロジェクトでマージリクエストをクローズするには:

1. 左側のサイドバーで、**検索または移動先**を選択して、プロジェクトを見つけます。
1. **コード** > **マージリクエスト**を選択し、マージリクエストを見つけます。
1. ページの下部にあるコメントボックスまでスクロールします。
1. コメントボックスの後の**マージリクエストをクローズ**を選択します。

GitLabはマージリクエストをクローズしますが、マージリクエスト、そのコメント、および関連するパイプラインのレコードを保持します。

### マージ時にソースブランチを削除する {#delete-the-source-branch-on-merge}

次のように、マージリクエストのソースブランチを削除できます:

- マージリクエストを作成するときに、**Delete source branch when merge request accepted**（マージリクエストが承認されたときにソースブランチを削除します。）を選択します。
- マージリクエストをマージするときに、メンテナーロールを持っている場合は、**ソースブランチを削除**を選択します。

管理者は、プロジェクトの設定でこのオプションをデフォルトにすることができます。

delete-branchアクションは、自動マージを設定するユーザーまたはマージリクエストをマージするユーザーによって実行されます。ユーザーに正しいロールがない場合（フォークされたプロジェクトなど）、ソースブランチの削除は失敗します。

### ターゲットブランチのマージ時にマージリクエストを更新する {#update-merge-requests-when-target-branch-merges}

{{< details >}}

- プラン: Free、Premium、Ultimate
- 提供形態: GitLab.com、GitLab Self-Managed、GitLab Dedicated

{{< /details >}}

マージリクエストは多くの場合連鎖しており、1つのマージリクエストは別のマージリクエストで追加または変更されたコードに依存しています。個々のマージリクエストを小さく保つことをサポートするために、GitLabは、ターゲットブランチが`main`にマージされるときに、最大4つのオープンマージリクエストを更新できます。次に例を示します:

- マージリクエスト1: `feature-alpha`を`main`にマージします。
- マージリクエスト2: `feature-beta`を`feature-alpha`にマージします。

これらのマージリクエストが同時にオープンになっていて、マージリクエスト1（`feature-alpha`）が`main`にマージされる場合、GitLabはマージリクエスト2の宛先を`feature-alpha`から`main`に更新します。

相互接続されたコンテンツ更新を含むマージリクエストは、通常、次のいずれかの方法で処理されます:

- 最初に、マージリクエスト1が`main`にマージされます。次に、マージリクエスト2のターゲットが`main`に変更されます。
- マージリクエスト2が`feature-alpha`にマージされます。更新されたマージリクエスト1は、`feature-alpha`と`feature-beta`の内容を含むようになり、`main`にマージされます。

この機能は、マージリクエストがマージされた場合にのみ機能します。マージ後に**Remove source branch**（ソースブランチを削除）を選択しても、オープンマージリクエストのターゲットは変更されません。この改善は、[フォローアップとして提案されています](https://gitlab.com/gitlab-org/gitlab/-/issues/321559)。

## マージリクエストのワークフロー {#merge-request-workflows}

チームで作業するソフトウェアデベロッパー向け:

1. 新しいブランチをチェックアウトし、マージリクエストを通じて変更を送信します。
1. チームからフィードバックを集めます。
1. [Code Qualityレポート](../../../ci/testing/code_quality.md)でコードを最適化する実装に取り組みます。
1. GitLab CI/CDの[単体テストレポート](../../../ci/testing/unit_test_reports.md)で変更を確認します。
1. [ライセンス承認ポリシー](../../compliance/license_approval_policies.md)を使用して、ライセンスがプロジェクトと互換性のない依存関係の使用を回避します。
1. マネージャーに[承認](approvals/_index.md)をリクエストします。
1. マネージャー:
   1. 最終レビューでコミットをプッシュします。
   1. マージリクエストを承認します。
   1. [自動マージ](auto_merge.md)（旧**パイプラインが成功したときにマージ**）に設定します。
1. GitLab CI/CDの[手動ジョブ](../../../ci/jobs/job_control.md#create-a-job-that-must-be-run-manually)で、変更が本番環境にデプロイされます。
1. 実装が顧客に正常に送信されました。

会社のWebサイト用のWebページを作成するWebデベロッパー向け:

1. 新しいブランチをチェックアウトし、マージリクエストを通じて新しいページを送信します。
1. レビュアーからフィードバックを集めます。
1. [レビューアプリ](../../../ci/review_apps/_index.md)で変更をプレビューします。
1. Webデザイナーに実装をリクエストします。
1. マネージャーに承認をリクエストします。
1. 承認後、GitLabは以下を実行します:
   - コミットを[スカッシュ](squash_and_merge.md)します。
   - コミットをマージします。
   - [GitLab Pages](https://about.gitlab.com/blog/2021/02/05/ci-deployment-and-environments/)を使用して、ステージングに変更をデプロイします。
1. 本番環境チームは、マージコミットを本番環境にチェリーピックします。

## マージリクエストのアクティビティーをフィルタリングする {#filter-activity-in-a-merge-request}

{{< history >}}

- GitLab 16.0のGitLab.comで機能フラグ`mr_activity_filters`が[有効化](https://gitlab.com/gitlab-org/gitlab/-/issues/387070)されました。
- デフォルトで、GitLab 16.3の[GitLab Self-Managedで有効化](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/126998)されました。
- GitLab 16.5で[一般提供](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/132355)になりました。機能フラグ`mr_activity_filters`は削除されました。
- ボットコメントのフィルタリングは、GitLab 16.9で[導入](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/128473)されました。

{{< /history >}}

マージリクエストの履歴を把握するには、アクティビティーフィードをフィルタリングして、自分に関係のある項目のみを表示します。

1. 左側のサイドバーで、**検索または移動先**を選択して、プロジェクトを見つけます。
1. **コード** > **マージリクエスト**を選択します。
1. マージリクエストを選択します。
1. **アクティビティー**までスクロールします。
1. ページの右側で、**Activity filter**（アクティビティーをフィルタリング）を選択して、フィルターオプションを表示します。すでにフィルターオプションを選択している場合、このフィールドには**Activity + 5 more**（アクティビティー + 他5件）のように、選択内容の概要が表示されます。
1. 表示するアクティビティーのタイプを選択します。オプションには以下が含まれます:

   - 担当者とレビュアー
   - 承認
   - ボットからのコメント
   - ユーザーからのコメント
   - コミットとブランチ
   - 編集
   - ラベル
   - ロック状態
   - メンション
   - マージリクエストのステータス
   - トラッキング

1. オプション。**Sort**（ソート）（{{< icon name="sort-lowest" >}}）を選択して、ソート順を逆にします。

選択内容は、すべてのマージリクエストで保持されます。右側のソートボタンをクリックして、ソート順を変更することもできます。

## コメントスレッドの管理 {#manage-comment-threads}

マージリクエストのディスカッションには、単一のコメントとコメントのスレッドが含まれます。未解決のスレッドはマージリクエストのマージをブロックしますが、単一のコメントはブロックしません。スレッドのディスカッションが終了したら、[スレッドを解決する](../../discussions/_index.md#resolve-a-thread)して表示を折りたたみます。コメントスレッドが重要だが、マージリクエストをブロックすべきでない場合は、イシューに移動してディスカッションを続けます。

### すべてのスレッドを展開する {#expand-all-threads}

GitLabは、マージリクエストの右上隅に開いているスレッドの数を表示します。このマージリクエストには、3つのオープンスレッドがあります:

![3つのオープンスレッドとスレッド管理オプションを備えたマージリクエスト。](img/open_threads_v18_5.png)

折りたたまれたスレッド内のすべてのコメントを表示するには、スレッドを展開します:

1. 左側のサイドバーで、**検索または移動先**を選択して、プロジェクトを見つけます。
1. **コード** > **マージリクエスト**を選択し、マージリクエストを見つけます。
1. マージリクエストの右上にある**Open threads**（未解決スレッド）ドロップダウンリストで、**スレッドオプション**（{{< icon name="ellipsis_v" >}}）を選択します。
1. **すべてのコメントを表示**を選択します。

### イシューに開いているスレッドを移動する {#move-open-threads-to-an-issue}

開いているスレッドを新しいイシューに移動し、マージリクエストのブロックを解除するには:

{{< tabs >}}

{{< tab title="1つのスレッドを移動する" >}}

マージリクエストに1つの特定の未解決スレッドがある場合は、イシューを作成して個別に解決できます:

1. 左側のサイドバーで、**検索または移動先**を選択して、プロジェクトを見つけます。
1. **コード** > **マージリクエスト**を選択し、マージリクエストを見つけます。
1. マージリクエストで、移動するスレッドを検索します。
1. スレッドへの最後の返信の下、**スレッドを解決にする**の横にある**スレッドを解決するためのイシューを作成**（{{< icon name="issue-new" >}}）を選択します。
1. 新しいイシューのフィールドに入力し、**イシューの作成**を選択します。

GitLabはスレッドを解決済みにし、マージリクエストから新しく作成されたイシューにリンクを追加します。

{{< /tab >}}

{{< tab title="すべてのオープンスレッドを移動する" >}}

マージリクエストに複数の未解決スレッドがある場合は、イシューを作成して個別に解決できます:

1. 左側のサイドバーで、**検索または移動先**を選択して、プロジェクトを見つけます。
1. **コード** > **マージリクエスト**を選択し、マージリクエストを見つけます。
1. マージリクエストの右上にある**Open threads**（未解決スレッド）ドロップダウンリストで、**スレッドオプション**（{{< icon name="ellipsis_v" >}}）を選択します。
1. **新しいイシューですべて解決する**を選択します。
1. 新しいイシューのフィールドに入力し、**イシューの作成**を選択します。

GitLabはすべてのスレッドを解決済みにし、マージリクエストから新しく作成されたイシューにリンクを追加します。

{{< /tab >}}

{{< /tabs >}}

### すべてのスレッドが解決されるまでマージを禁止する {#prevent-merge-unless-all-threads-are-resolved}

スレッドが未解決のままマージリクエストがマージされるのを防ぐことができます。この設定を有効にすると、少なくとも1つのスレッドが未解決のままである間、マージリクエストの**Open threads**（未解決スレッド）カウンターはオレンジ色で表示されます。

1. 左側のサイドバーで、**検索または移動先**を選択して、プロジェクトを見つけます。
1. **設定** > **マージリクエスト**を選択します。
1. **マージチェック**セクションで、**すべてのスレッドが解決している**チェックボックスをオンにします。
1. **変更を保存**を選択します。

### 期限切れになったときにマージリクエストのスレッドを自動的に解決する {#automatically-resolve-threads-in-a-merge-request-when-they-become-outdated}

記述されている行が新しいプッシュによって変更されたときに、スレッドを自動的に解決するようにマージリクエストを設定できます。

1. 左側のサイドバーで、**検索または移動先**を選択して、プロジェクトを見つけます。
1. **設定** > **マージリクエスト**を選択します。
1. **マージオプション**セクションで、**期限切れになったときにマージリクエストの差分スレッドを自動的に解決します。**を選択します。
1. **変更を保存**を選択します。

これで、プッシュによって差分セクションが古くなると、スレッドが解決されるようになります。変更されていない行のスレッドと、最上位の解決可能なスレッドは解決されません。

## 通知とTo Doを移動する {#move-notifications-and-to-dos}

{{< details >}}

- プラン: Free、Premium、Ultimate
- 提供形態: GitLab Self-Managed

{{< /details >}}

{{< history >}}

- GitLab 16.5で`notifications_todos_buttons`[フラグ](../../../administration/feature_flags/_index.md)とともに[導入](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/132678)されました。デフォルトでは無効になっています。
- [イシュー、インシデント](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/133474) 、[エピック](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/133881)も更新されました。

{{< /history >}}

{{< alert type="flag" >}}

この機能の利用可否は、機能フラグによって制御されます。詳細については、履歴を参照してください。

{{< /alert >}}

この機能フラグを有効にすると、通知ボタンとTo Doアイテムボタンがページ右上隅に移動します。

- マージリクエストでは、これらのボタンはタブの右端に表示されます。
- イシュー、インシデント、エピックでは、これらのボタンは右側のサイドバー上部に表示されます。

## 関連トピック {#related-topics}

- [リポジトリを保護する](../repository/protect.md)
- [マージリクエストをレビューする](reviews/_index.md)
- [マージリクエストを認証する](authorization_for_merge_requests.md)
- [テストとレポート](../../../ci/testing/_index.md)
- [コメントとスレッド](../../discussions/_index.md)
- [コード変更を提案する](reviews/suggestions.md)
- [CI/CDパイプライン](../../../ci/_index.md)
- マージリクエストの[プッシュオプション](../../../topics/git/commit.md)
