---
stage: Application Security Testing
group: Dynamic Analysis
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
title: 'Exposure of confidential secret or token GitLab SCIM OAuth token'
---

## Description

The response body contains content that matches the pattern of a GitLab SCIM token was identified. The SCIM token is used to configure third party Identity providers (IdP). A malicious actor with access to this token can configure an IdP and add users to gain access to the GitLab system..
Exposing this value could allow attackers to gain access to all resources granted by this token.

## Remediation

For general guidance on handling security incidents with regards to leaked keys, please see the GitLab documentation on [Credential exposure to the internet](../../../../../security/responding_to_security_incidents.md#credential-exposure-to-public-internet).

To rotate the SCIM token:

- Sign in to your GitLab account as an administrator
- On the left sidebar, at the bottom, select Admin
- Select "Settings" and then "General"
- Expand the SCIM Token section and select "Generate a SCIM token"
- Under "Your SCIM token" select "reset it" to generate a new token

For more information, please see [GitLabs documentation on SCIM configuration](../../../../../administration/settings/scim_setup.md#configure-gitlab).

## Details

| ID | Aggregated | CWE | Type | Risk |
|:---|:-----------|:----|:-----|:-----|
| 798.151 | false | 798 | Passive | High |

## Links

- [CWE](https://cwe.mitre.org/data/definitions/798.html)
