/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.commons.support.conversion;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.Currency;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.function.Function;
import org.junit.platform.commons.support.conversion.ConversionException;
import org.junit.platform.commons.support.conversion.StringToObjectConverter;

class StringToCommonJavaTypesConverter
implements StringToObjectConverter {
    private static final Map<Class<?>, Function<String, ?>> CONVERTERS;

    StringToCommonJavaTypesConverter() {
    }

    @Override
    public boolean canConvertTo(Class<?> targetType) {
        return CONVERTERS.containsKey(targetType);
    }

    @Override
    public Object convert(String source, Class<?> targetType) throws Exception {
        return CONVERTERS.get(targetType).apply(source);
    }

    private static URL toURL(String url) {
        try {
            return URI.create(url).toURL();
        }
        catch (MalformedURLException ex) {
            throw new ConversionException("Failed to convert String \"" + url + "\" to type java.net.URL", ex);
        }
    }

    static {
        HashMap<Class, Function<String, Object>> converters = new HashMap<Class, Function<String, Object>>();
        converters.put(File.class, File::new);
        converters.put(Charset.class, Charset::forName);
        converters.put(Path.class, x$0 -> Paths.get(x$0, new String[0]));
        converters.put(URI.class, URI::create);
        converters.put(URL.class, StringToCommonJavaTypesConverter::toURL);
        converters.put(Currency.class, Currency::getInstance);
        converters.put(Locale.class, Locale::new);
        converters.put(UUID.class, UUID::fromString);
        CONVERTERS = Collections.unmodifiableMap(converters);
    }
}

