/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.networking;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.common.io.FreeColXMLReader;
import net.sf.freecol.common.model.FreeColGameObject;
import net.sf.freecol.common.model.FreeColObject;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.networking.AttributeMessage;
import net.sf.freecol.common.networking.Message;
import net.sf.freecol.common.util.CollectionUtils;
import net.sf.freecol.server.FreeColServer;
import net.sf.freecol.server.ai.AIPlayer;

public class RemoveMessage
extends AttributeMessage {
    public static final String TAG = "remove";
    private static final String DIVERT_TAG = "divert";

    public RemoveMessage(String divertId, List<? extends FreeColGameObject> objects) {
        super(TAG, DIVERT_TAG, divertId);
        this.setArrayAttributes(CollectionUtils.transform(objects, CollectionUtils.alwaysTrue(), FreeColObject::getId));
    }

    public RemoveMessage(Game game, FreeColXMLReader xr) throws XMLStreamException {
        super(TAG, RemoveMessage.getAttributeMap(xr));
        xr.closeTag(TAG);
    }

    private static Map<String, String> getAttributeMap(FreeColXMLReader xr) {
        Map<String, String> ret = xr.getArrayAttributeMap();
        ret.put(DIVERT_TAG, xr.getAttribute(DIVERT_TAG, null));
        return ret;
    }

    @Override
    public Message.MessagePriority getPriority() {
        return Message.MessagePriority.REMOVE;
    }

    @Override
    public void aiHandler(FreeColServer freeColServer, AIPlayer aiPlayer) {
    }

    @Override
    public void clientHandler(FreeColClient freeColClient) {
        Game game = freeColClient.getGame();
        FreeColGameObject divert = this.getDivertObject(game);
        List<FreeColGameObject> objects = this.getRemovals(game);
        if (objects.isEmpty()) {
            return;
        }
        this.igc(freeColClient).removeHandler(objects, divert);
        this.clientGeneric(freeColClient);
    }

    public FreeColGameObject getDivertObject(Game game) {
        return game.getFreeColGameObject(this.getStringAttribute(DIVERT_TAG));
    }

    public List<FreeColGameObject> getRemovals(Game game) {
        ArrayList<FreeColGameObject> ret = new ArrayList<FreeColGameObject>();
        for (String id : this.getArrayAttributes()) {
            FreeColGameObject fcgo = game.getFreeColGameObject(id);
            if (fcgo == null) continue;
            ret.add(fcgo);
        }
        return ret;
    }
}

