/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.i18n;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import net.sf.freecol.common.i18n.Relation;
import net.sf.freecol.common.util.CollectionUtils;
import net.sf.freecol.common.util.StringUtils;

public class Rule {
    private final List<List<Relation>> conditions = new ArrayList<List<Relation>>();

    public Rule(String input) {
        this.parse(input);
    }

    public void add(List<Relation> condition) {
        this.conditions.add(condition);
    }

    public boolean matches(double number) {
        return CollectionUtils.any(this.conditions, andConditions -> CollectionUtils.all(andConditions, r -> r.matches(number)));
    }

    private final void parse(String input) {
        StringTokenizer st = new StringTokenizer(StringUtils.downCase(input), " .");
        ArrayList<String> tokens = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if ("or".equals(token)) {
                this.conditions.add(this.parseCondition(tokens));
                tokens.clear();
                continue;
            }
            tokens.add(token);
        }
        this.conditions.add(this.parseCondition(tokens));
    }

    private List<Relation> parseCondition(List<String> input) {
        ArrayList<String> tokens = new ArrayList<String>();
        ArrayList<Relation> result = new ArrayList<Relation>();
        for (String token : input) {
            if ("and".equals(token)) {
                result.add(new Relation(tokens));
                tokens.clear();
                continue;
            }
            tokens.add(token);
        }
        result.add(new Relation(tokens));
        return result;
    }

    public String toString() {
        String andString = " and ";
        String orString = " or ";
        StringBuilder sb = new StringBuilder(32);
        for (List<Relation> andCondition : this.conditions) {
            for (Relation relation : andCondition) {
                sb.append(relation).append(" and ");
            }
            sb.setLength(sb.length() - " and ".length());
            sb.insert(0, " or ");
        }
        sb.delete(0, " or ".length());
        return sb.toString();
    }
}

