/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.impl.jdbc.cache;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBDatabaseException;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCStatement;
import org.jkiss.dbeaver.model.messages.ModelMessages;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.cache.AbstractObjectCache;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.utils.CommonUtils;

public abstract class JDBCObjectCache<OWNER extends DBSObject, OBJECT extends DBSObject>
extends AbstractObjectCache<OWNER, OBJECT> {
    private static final int DEFAULT_MAX_CACHE_SIZE = 1000000;
    private static final Log log = Log.getLog(JDBCObjectCache.class);
    private int maximumCacheSize = 1000000;

    protected JDBCObjectCache() {
    }

    public void setMaximumCacheSize(int maximumCacheSize) {
        this.maximumCacheSize = maximumCacheSize;
    }

    @NotNull
    protected abstract JDBCStatement prepareObjectsStatement(@NotNull JDBCSession var1, @NotNull OWNER var2) throws SQLException;

    @Nullable
    protected abstract OBJECT fetchObject(@NotNull JDBCSession var1, @NotNull OWNER var2, @NotNull JDBCResultSet var3) throws SQLException, DBException;

    @NotNull
    public List<OBJECT> getAllObjects(@NotNull DBRProgressMonitor monitor, @Nullable OWNER owner) throws DBException {
        if (!this.isFullyCached() && !monitor.isForceCacheUsage()) {
            this.loadObjects(monitor, owner);
        }
        return this.getCachedObjects();
    }

    public OBJECT getObject(@NotNull DBRProgressMonitor monitor, @NotNull OWNER owner, @NotNull String name) throws DBException {
        if (!this.isFullyCached() && !monitor.isForceCacheUsage()) {
            this.loadObjects(monitor, owner);
        }
        return (OBJECT)this.getCachedObject(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected synchronized void loadObjects(DBRProgressMonitor monitor, OWNER owner) throws DBException {
        ArrayList<OBJECT> tmpObjectList;
        block35: {
            if (this.isFullyCached()) return;
            if (monitor.isForceCacheUsage()) return;
            if (monitor.isCanceled()) {
                return;
            }
            if (DBWorkbench.getPlatform().isUnitTestMode()) {
                log.debug((Object)"[TEST] Skip cache read in test mode");
                return;
            }
            tmpObjectList = new ArrayList<OBJECT>();
            DBPDataSource dataSource = owner.getDataSource();
            if (dataSource == null) {
                throw new DBException(ModelMessages.error_not_connected_to_database);
            }
            if (owner.isPersisted()) {
                try {
                    try (JDBCSession session = (JDBCSession)DBUtils.openMetaSession((DBRProgressMonitor)monitor, owner, (String)("Load objects from " + DBUtils.getObjectTypeName(owner) + " '" + owner.getName() + "'"));){
                        this.beforeCacheLoading(session, owner);
                        try (JDBCStatement dbStat = this.prepareObjectsStatement(session, owner);){
                            monitor.subTask("Load " + this.getCacheName());
                            dbStat.setFetchSize(1000);
                            dbStat.executeStatement();
                            JDBCResultSet dbResult = dbStat.getResultSet();
                            if (dbResult == null) break block35;
                            try {
                                while (dbResult.next()) {
                                    if (monitor.isCanceled()) {
                                        return;
                                    }
                                    OBJECT object = this.fetchObject(session, owner, dbResult);
                                    if (object == null || !this.isValidObject(monitor, (DBSObject)owner, (DBSObject)object)) continue;
                                    tmpObjectList.add(object);
                                    if (tmpObjectList.size() != this.maximumCacheSize) continue;
                                    log.warn((Object)("Maximum cache size exceeded (" + this.maximumCacheSize + ") in " + String.valueOf((Object)this)));
                                    break;
                                }
                            }
                            finally {
                                dbResult.close();
                            }
                        }
                        finally {
                            this.afterCacheLoading(session, owner);
                        }
                    }
                    catch (SQLException ex) {
                        throw new DBDatabaseException((Throwable)ex, dataSource);
                    }
                    catch (DBException ex) {
                        throw ex;
                    }
                    catch (Exception ex) {
                        throw new DBException("Internal driver error", (Throwable)ex);
                    }
                }
                catch (Exception e) {
                    if (this.handleCacheReadError(e)) break block35;
                    throw e;
                }
            }
        }
        this.addCustomObjects(monitor, (DBSObject)owner, tmpObjectList);
        Comparator comparator = this.getListOrderComparator();
        if (comparator != null && !CommonUtils.isEmpty(tmpObjectList)) {
            tmpObjectList.sort(comparator);
        }
        this.detectCaseSensitivity((DBSObject)owner);
        this.mergeCache(tmpObjectList);
        this.invalidateObjects(monitor, (DBSObject)owner, (Iterator)new AbstractObjectCache.CacheIterator((AbstractObjectCache)this));
    }

    public void beforeCacheLoading(@NotNull JDBCSession session, OWNER owner) throws DBException {
    }

    public void afterCacheLoading(@NotNull JDBCSession session, OWNER owner) throws DBException {
    }

    @NotNull
    protected String getCacheName() {
        return ((Object)((Object)this)).getClass().getSimpleName();
    }

    protected boolean handleCacheReadError(@NotNull Exception error) {
        return false;
    }
}

